/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.util.ITrendLine;
import quadbase.util.Point_2D;
import quadbase.util.Position;

public abstract class TrendLine
extends DataLine
implements ITrendLine {
    private static final Logger LOGGER = Logger.getLogger(TrendLine.class.getName());
    protected int chartMaxX;
    protected int chartMaxY;
    protected int absPosX = 0;
    protected int absPosY = 0;
    protected transient boolean calculatemode = false;
    public static int[] lineTypeMap = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17};
    public static final String[] defaultNames = new String[]{"Polynomial", "Exponential", "Logarithmic", "Power", "Simple Moving Average", "Exponential Moving Average", "Triangular Moving Average", "Horizontal line", "Vertical line", "Cubic B-Spline", "Normal Curve"};
    protected static final String[] shortName = new String[]{"Poly", "Exp", "Log", "Pow", "Avg", "Exp-Avg", "Tri-Avg", "Horz", "Vert", "B-Spline", "Norm"};

    public static boolean isTrendLine(int lineType) {
        boolean result = false;
        for (int element : lineTypeMap) {
            if (element != lineType) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected String getShortName(int linetype) {
        String result = "";
        for (int i = 0; i < lineTypeMap.length; ++i) {
            if (lineTypeMap[i] != linetype) continue;
            result = shortName[i];
            break;
        }
        return result;
    }

    public TrendLine(Chart chart) {
        this.chart = chart;
    }

    protected TrendLine(Chart newChart, TrendLine tline) {
        int nAnno;
        this.chart = newChart;
        this.linetype = tline.linetype;
        this.title = tline.title;
        this.setCoeff(tline.coeff);
        this.thickness = tline.thickness;
        this.hlco_value = tline.hlco_value;
        this.positive_line = tline.positive_line;
        this.series = tline.series;
        this.color = tline.color;
        this.hideTitle = tline.hideTitle;
        this.useSubvalue = tline.useSubvalue;
        this.useAxis = tline.useAxis;
        this.line_value = tline.line_value;
        this.showValue = tline.showValue;
        this.valueHint = tline.valueHint;
        this.lineStyle = tline.lineStyle;
        Vector targetVector = tline.annoVector;
        int n = nAnno = targetVector == null ? 0 : targetVector.size();
        if (nAnno > 0) {
            this.annoVector = new Vector();
            for (int i = 0; i < nAnno; ++i) {
                CAnnotation tempAnno = ((CAnnotation)targetVector.elementAt(i)).copy(newChart);
                tempAnno.setReferenceObject(this);
                this.annoVector.addElement(tempAnno);
            }
        }
    }

    @Override
    public Object clone() {
        TrendLine newLine = this.chart.dataLineSet.newTrendLine(this);
        if (newLine.annoVector != null) {
            int nAnno = newLine.annoVector.size();
            for (int i = 0; i < nAnno; ++i) {
                ((CAnnotation)newLine.annoVector.elementAt(i)).setReferenceObject(newLine);
            }
        }
        return newLine;
    }

    public TrendLine(Chart chart, int linetype, int coeff, String title) {
        this.chart = chart;
        this.linetype = linetype;
        this.title = title;
        this.setCoeff(coeff);
    }

    @Override
    public final void setCoeff(int coeff) {
        this.coeff = this.linetype >= 1 && this.linetype <= 3 ? 1 : (this.linetype >= 4 ? (coeff <= 1 ? 1 : coeff) : (coeff < 0 ? 0 : coeff));
    }

    @Override
    public final void setLineType(int dtype) {
        this.linetype = dtype >= 0 && dtype <= 17 ? dtype : 0;
        this.setCoeff(this.coeff);
    }

    @Override
    public double getMean() {
        return 0.0;
    }

    @Override
    public double getStandardDev() {
        return 0.0;
    }

    @Override
    public void drawStandardDevLine(Color color, double mDev, String label) {
        LOGGER.warning("Standard Deviation Line is not supported!");
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 0.0;
    }

    @Override
    public double getProbability(double z) {
        double[] a = new double[]{0.5, 0.398942280444, 0.399903438504, 5.75885480458, 29.8213557808, 2.62433121679, 48.6959930692, 5.92885724438};
        double[] b = new double[]{0.398942280385, 3.8052E-8, 1.00000615302, 3.98064794E-4, 1.98615381364, 0.151679116635, 5.29330324926, 4.8385912808, 15.1508972451, 0.742380924027, 30.789933034, 3.99019417011};
        double absZ = Math.abs(z);
        double y = a[0] * z * z;
        double pd = Math.exp(-y) * b[0];
        if (absZ > 12.7) {
            if (z > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        if (absZ > 1.28) {
            double q = pd / (absZ - b[1] + b[2] / (absZ + b[3] + b[4] / (absZ - b[5] + b[6] / (absZ + b[7] - b[8] / (absZ + b[9] + b[10] / (absZ + b[11]))))));
            if (z > 0.0) {
                return 1.0 - q;
            }
            return q;
        }
        double q = a[0] - absZ * (a[1] - a[2] * y / (y + a[3] - a[4] / (y + a[5] + a[6] / (y + a[7]))));
        if (z > 0.0) {
            return 1.0 - q;
        }
        return q;
    }

    @Override
    public double getInverseNorm(double p) {
        if (p <= 0.0 || p >= 1.0) {
            LOGGER.warning(p + " is not a valid probability value!");
            LOGGER.warning("Value needs to be between 0 and 1, exclusive.");
            return 0.0;
        }
        double[] a = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
        double[] b = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
        double[] c = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
        double[] d = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
        double low = 0.02425;
        double high = 1.0 - low;
        if (p < low) {
            double d3 = Math.sqrt(-2.0 * Math.log(p));
            return (((((c[0] * d3 + c[1]) * d3 + c[2]) * d3 + c[3]) * d3 + c[4]) * d3 + c[5]) / ((((d[0] * d3 + d[1]) * d3 + d[2]) * d3 + d[3]) * d3 + 1.0);
        }
        if (p > high) {
            double d4 = Math.sqrt(-2.0 * Math.log(1.0 - p));
            return -(((((c[0] * d4 + c[1]) * d4 + c[2]) * d4 + c[3]) * d4 + c[4]) * d4 + c[5]) / ((((d[0] * d4 + d[1]) * d4 + d[2]) * d4 + d[3]) * d4 + 1.0);
        }
        double d5 = p - 0.5;
        double d6 = d5 * d5;
        return (((((a[0] * d6 + a[1]) * d6 + a[2]) * d6 + a[3]) * d6 + a[4]) * d6 + a[5]) * d5 / (((((b[0] * d6 + b[1]) * d6 + b[2]) * d6 + b[3]) * d6 + b[4]) * d6 + 1.0);
    }

    @Override
    public boolean invalidchart() {
        return !this.chart.is2DChart && !TrendLine.horzVertType(this.linetype) || this.chart.isCircularChart() || this.chart.chartType == 16 || this.chart.chartType == 17 || this.chart.chartType == 19 || this.chart.chartType == 15 || this.chart.chartType == 3 && this.chart.getLayout() == 1;
    }

    public static boolean invalidchart(Chart chart) {
        return !chart.is2DChart || chart.isCircularChart() || chart.chartType == 15 || chart.chartType == 16 || chart.chartType == 19 || chart.chartType == 17 || chart.chartType == 18 || chart.chartType == 11 || chart.chartType == 3 && chart.getLayout() == 1;
    }

    @Override
    protected void fillLine(CGraphics g, int x1, int y1, int x2, int y2, int thickness) {
        g.fillLine(x1, y1, x2, y2, thickness, this.lineStyle);
    }

    protected static boolean averageType(int tp) {
        return tp >= 4 && tp <= 6;
    }

    protected static boolean horzVertType(int dline) {
        return dline == 7 || dline == 8;
    }

    protected void setAbsPosition(int x, int y) {
        if (x <= this.chartMaxX && y <= this.chartMaxY) {
            this.absPosX = x;
            this.absPosY = y;
        }
    }

    protected abstract Point_2D getAbsPosition();

    @Override
    public Position getReferencePosition() {
        if (this.linetype == 7 || this.linetype == 8) {
            if (this.chart.cgraphics == null) {
                this.chart.cgraphics = new CGraphics(null, this.chart.component, this.chart.winHeight, this.chart.winWidth, this.chart);
            }
            this.chart.computeCoord(this.chart.cgraphics, this.chart.chartxorigin, this.chart.chartxorigin + this.chart.chartwidth, this.chart.chartyorigin, this.chart.chartheight + this.chart.chartyorigin);
        }
        int x = 0;
        int y = 0;
        this.calculatemode = true;
        this.drawLine(null);
        this.calculatemode = false;
        Point_2D absPos = this.getAbsPosition();
        x = (int)absPos.getX();
        y = (int)absPos.getY();
        float refPosX = (float)x / (float)this.chart.winWidth;
        float refPosY = (float)y / (float)this.chart.winHeight;
        if (refPosX < 0.0f) {
            refPosX = 0.0f;
        } else if (refPosX > 1.0f) {
            refPosX = 1.0f;
        }
        if (refPosY < 0.0f) {
            refPosY = 0.0f;
        } else if (refPosY > 1.0f) {
            refPosY = 1.0f;
        }
        return new Position(refPosX, refPosY);
    }

    @Override
    protected GeneralPath drawLimitPath(CGraphics g, int miny, int maxy, int x1, int y1, int x2, int y2, GeneralPath path) {
        if (this.calculatemode) {
            return path;
        }
        return super.drawLimitPath(g, miny, maxy, x1, y1, x2, y2, path);
    }

    @Override
    protected void write(DataOutput dout) throws IOException {
    }

    @Override
    protected void read(DataInput din, int version) throws IOException {
    }
}

