/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.util.Point_2D;

public class ControlLine2D
extends ControlLine {
    public ControlLine2D(Chart chart) {
        super(chart);
    }

    public ControlLine2D(Chart newChart, ControlLine tline) {
        super(newChart, tline);
    }

    public ControlLine2D(Chart chart, int linetype, String title) {
        super(chart, linetype, title);
    }

    public ControlLine2D(Chart chart, int linetype, String title, int level) {
        super(chart, linetype, title, level);
    }

    @Override
    public final void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void prepare3DLine() {
    }

    @Override
    protected void drawLine(CGraphics g) {
        if (this.chart.mData2 == null) {
            this.useSubvalue = false;
        }
        if (this.chart.getChartType() == 16) {
            this.drawRadarLine(g);
            return;
        }
        g.g.setColor(this.color);
        int pixelValue = this.getPixelValue();
        GeneralPath path = null;
        if (this.showHorzLine()) {
            int x1 = this.chart.chartxorigin;
            int x2 = this.chart.chartxorigin + this.chart.chartwidth;
            path = this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, x1, pixelValue, x2, pixelValue, path);
        } else if (this.showVertLine()) {
            int y1 = this.chart.chartyorigin;
            int y2 = this.chart.chartyorigin + this.chart.chartheight;
            path = this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, pixelValue, y1, pixelValue, y2, path);
        }
        if (path != null) {
            g.drawLine(path, this.thickness);
        }
    }

    private void drawRadarLine(CGraphics g) {
        g.g.setColor(this.color);
        int centerX = this.chart.a_y.startp.x;
        int centerY = this.chart.a_y.startp.y;
        if (this.chart.isSynchronizeRadarAxis() && this.getLineType() >= 100) {
            int pixelValue = this.getHortLineYPixel();
            if (!this.selectmode) {
                int width = (pixelValue - centerY) * 2 - (int)Math.ceil((double)this.thickness / 2.0);
                for (int j = 0; j < this.thickness; ++j) {
                    g.drawArc(centerX, centerY, width + j, width + j, 0, 360);
                }
            } else {
                int thick;
                int width;
                int dist = (int)Math.rint(Math.sqrt(Math.pow(centerY - this.ypick, 2.0) + Math.pow(centerX - this.xpick, 2.0)));
                if (dist >= (width = pixelValue - centerY) - (thick = 1 + (int)Math.ceil((double)this.thickness / 2.0)) && dist <= width + thick) {
                    this.isObjSelect = true;
                }
            }
        } else {
            int curX = -1;
            int curY = -1;
            int lastX = -1;
            int lastY = -1;
            int nAxis = this.chart.mDataLen[this.chart.dataDim - 1];
            double sector = Math.PI * 2 / (double)nAxis;
            int width = 0;
            if (this.chart.isSynchronizeRadarAxis()) {
                int pixelValue = this.getHortLineYPixel();
                width = pixelValue - centerY;
            }
            GeneralPath path = null;
            for (int j = 0; j <= nAxis; ++j) {
                double angle = sector * (double)j;
                if (!this.chart.isSynchronizeRadarAxis()) {
                    width = this.chart.colDataAxis[j % nAxis].stepsize.interpolatePixel2(this.calculatedValue) - centerY;
                }
                curX = centerX + (int)(Math.sin(angle) * (double)width);
                curY = centerY + (int)(Math.cos(angle) * (double)width);
                if (lastX != -1) {
                    this.drawLimitPath(g, Integer.MIN_VALUE, Integer.MAX_VALUE, lastX, lastY, curX, curY, path);
                }
                lastX = curX;
                lastY = curY;
            }
            if (path != null) {
                g.drawLine(path, this.thickness);
            }
        }
    }

    @Override
    protected Point_2D getAbsPosition() {
        int x = 0;
        int y = 0;
        int pixelValue = this.getPixelValue();
        if (this.showHorzLine()) {
            x = this.chart.chartxorigin + this.chart.chartwidth;
            y = pixelValue;
        } else if (this.showVertLine()) {
            x = pixelValue;
            y = this.chart.chartyorigin + this.chart.chartheight;
        }
        return new Point_2D(x, y);
    }
}

