/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.DataLineSet;
import quadbase.chart.FunctionLine;
import quadbase.chart.HorzVertLine;
import quadbase.chart.TrendLine;
import quadbase.chart.chart2d.ControlLine2D;
import quadbase.chart.chart2d.FunctionLine2D;
import quadbase.chart.chart2d.HorzVertLine2D;
import quadbase.chart.chart2d.TrendLine2D;
import quadbase.util.IDataLine;
import quadbase.util.IFunction;

public class DataLineSet2D
extends DataLineSet {
    private static final Logger LOGGER = Logger.getLogger(DataLineSet2D.class.getName());

    public DataLineSet2D(Chart chart) {
        super(chart);
    }

    public DataLineSet2D(Chart chart, DataLineSet set) {
        super(chart);
        Vector<DataLine> oldList = set.getDataLineList();
        int nLine = oldList.size();
        for (int i = 0; i < nLine; ++i) {
            DataLine target = oldList.elementAt(i);
            DataLine tempLine = null;
            if (target instanceof TrendLine) {
                tempLine = new TrendLine2D(chart, (TrendLine)target);
            } else if (target instanceof ControlLine) {
                tempLine = new ControlLine2D(chart, (ControlLine)target);
            } else if (target instanceof HorzVertLine) {
                tempLine = new HorzVertLine2D(chart, (HorzVertLine)target);
            } else if (target instanceof FunctionLine) {
                tempLine = new FunctionLine2D(chart, (FunctionLine)target);
            } else {
                LOGGER.warning("DataLineSet2D: Should not happen");
            }
            tempLine.setChart(chart);
            this.dataLineList.addElement(tempLine);
        }
    }

    @Override
    public final void updateDataLine(IDataLine dline) {
        super.updateDataLine(dline);
        ((DataLine)dline).compute();
    }

    public final void setdataLineList(Vector vec) {
        super.setdataLineList(vec);
        this.computeDataLines(false);
    }

    @Override
    public void computeDataLines(boolean prepareLine) {
        for (int i = 0; i < this.dataLineList.size(); ++i) {
            DataLine dl = (DataLine)this.dataLineList.elementAt(i);
            dl.compute();
        }
    }

    @Override
    public TrendLine newTrendLine(Chart chart) {
        return new TrendLine2D(chart);
    }

    @Override
    public TrendLine newTrendLine(int linetype, int coeff, String title) {
        return new TrendLine2D(this.chart, linetype, coeff, title);
    }

    @Override
    public TrendLine newTrendLine(TrendLine tline) {
        return new TrendLine2D(this.chart, tline);
    }

    @Override
    public HorzVertLine newHorzVertLine(int lineType, String title) {
        return new HorzVertLine2D(this.chart, lineType, title);
    }

    @Override
    protected HorzVertLine newHorzVertLine(HorzVertLine hline) {
        return new HorzVertLine2D(this.chart, hline);
    }

    @Override
    public ControlLine newControlLine(int lineType, String title) {
        return new ControlLine2D(this.chart, lineType, title);
    }

    @Override
    public ControlLine newControlLine(int lineType, String title, int level) {
        return new ControlLine2D(this.chart, lineType, title, level);
    }

    @Override
    protected ControlLine newControlLine(ControlLine hline) {
        return new ControlLine2D(this.chart, hline);
    }

    @Override
    public FunctionLine newFunctionLine(IFunction function, String title) {
        return new FunctionLine2D(this.chart, function, title);
    }

    @Override
    protected FunctionLine newFunctionLine(FunctionLine fline) {
        return new FunctionLine2D(this.chart, fline);
    }
}

