/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.geom.GeneralPath;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.FunctionLine;
import quadbase.chart.StepSize;
import quadbase.util.IFunction;
import quadbase.util.Point_2D;
import quadbase.util.Position;

public class FunctionLine2D
extends FunctionLine {
    private static final Logger LOGGER = Logger.getLogger(FunctionLine2D.class.getName());
    protected transient int chartMaxX;
    protected transient int chartMaxY;
    protected transient boolean calculatemode = false;
    protected transient int absPosX = 0;
    protected transient int absPosY = 0;

    public FunctionLine2D(Chart chart, IFunction function, String title) {
        super(chart, function, title);
    }

    protected FunctionLine2D(Chart newChart, FunctionLine tline) {
        super(newChart, tline);
    }

    @Override
    public void compute() {
    }

    protected void setAbsPosition(int x, int y) {
        if (x <= this.chartMaxX && y <= this.chartMaxY) {
            this.absPosX = x;
            this.absPosY = y;
        }
    }

    @Override
    protected Point_2D getAbsPosition() {
        return new Point_2D(this.absPosX, this.absPosY);
    }

    @Override
    protected void drawLine(CGraphics g) {
        this.chartMaxX = this.chart.chartxorigin + this.chart.chartwidth;
        this.chartMaxY = this.chart.chartyorigin + this.chart.chartheight;
        if (!this.calculatemode) {
            g.g.setColor(this.color);
        }
        StepSize sz_x = this.chart.a_x.stepsize;
        StepSize sz_y = this.chart.a_y.stepsize;
        int x1 = this.chart.chartxorigin;
        int x2 = this.chart.chartxorigin + this.chart.chartwidth;
        int y1 = this.chart.chartyorigin;
        int y2 = this.chart.chartyorigin + this.chart.chartheight;
        double initx = sz_x.minvalue;
        double t = (initx - sz_x.maxvalue) / (double)this.chart.chartwidth;
        boolean skipSegmentHead = false;
        boolean skipSegmentTail = false;
        int oldpixel = 0;
        try {
            oldpixel = sz_y.interpolatePixel(this.function.getY(initx));
            this.setAbsPosition(x1, oldpixel);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error getting line starting point", ex);
            skipSegmentHead = true;
            this.setAbsPosition(x1, y1);
        }
        int incsize = 6;
        int p1 = x1;
        int newpixel = 0;
        GeneralPath path = null;
        while (p1 < x2) {
            int p2 = p1 + incsize;
            if (p2 > x2) {
                p2 = x2;
            }
            try {
                newpixel = sz_y.interpolatePixel(this.function.getY(initx + t * (double)(x1 - p2)));
                this.setAbsPosition(p2, newpixel);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Error getting line point, skipping segment", ex);
                skipSegmentTail = true;
            }
            if (!skipSegmentHead && !skipSegmentTail) {
                path = this.drawLimitPath(g, y1, y2, p1, oldpixel, p2, newpixel, path);
            }
            skipSegmentHead = skipSegmentTail;
            skipSegmentTail = false;
            p1 = p2;
            oldpixel = newpixel;
        }
        if (path != null) {
            g.drawLine(path, this.thickness);
        }
    }

    @Override
    protected void fillLine(CGraphics g, int x1, int y1, int x2, int y2, int thickness) {
        g.fillLine(x1, y1, x2, y2, thickness);
    }

    @Override
    public Position getReferencePosition() {
        int x = 0;
        int y = 0;
        this.calculatemode = true;
        this.drawLine(null);
        this.calculatemode = false;
        Point_2D absPos = this.getAbsPosition();
        x = (int)absPos.getX();
        y = (int)absPos.getY();
        float refPosX = (float)x / (float)this.chart.winWidth;
        float refPosY = (float)y / (float)this.chart.winHeight;
        if (refPosX < 0.0f) {
            refPosX = 0.0f;
        } else if (refPosX > 1.0f) {
            refPosX = 1.0f;
        }
        if (refPosY < 0.0f) {
            refPosY = 0.0f;
        } else if (refPosY > 1.0f) {
            refPosY = 1.0f;
        }
        return new Position(refPosX, refPosY);
    }

    @Override
    protected GeneralPath drawLimitPath(CGraphics g, int miny, int maxy, int x1, int y1, int x2, int y2, GeneralPath path) {
        if (this.calculatemode) {
            return path;
        }
        return super.drawLimitPath(g, miny, maxy, x1, y1, x2, y2, path);
    }
}

