/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d;

import java.awt.Color;
import java.util.Date;
import quadbase.chart.CGraphics;
import quadbase.chart.Grid;
import quadbase.chart.Line;
import quadbase.chart.Point3D;
import quadbase.util.internal.DateTime;

public class Grid2D
extends Grid {
    public Grid2D(int direction, boolean showgrid) {
        super(direction, showgrid);
    }

    @Override
    public boolean select(CGraphics g, int x, int y) {
        if (!this.bshow) {
            return false;
        }
        if (this.coord == null) {
            return false;
        }
        y = g.height - y;
        if (this.orient == 1) {
            for (Point3D element : this.coord) {
                if (!Line.pickLine(this.min, element.y, this.max, element.y, x, y)) continue;
                return true;
            }
        } else {
            for (Point3D element : this.coord) {
                if (!Line.pickLine(element.x, this.min, element.x, this.max, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void set(Object sp, Point3D[] p, int xymax, int zmax) {
    }

    @Override
    public void draw(CGraphics g, boolean odd, boolean skipGridOffset, int sep) {
    }

    @Override
    public void draw(CGraphics g, int thick, boolean skipGridOffset, int step) {
        this.draw(g, thick, skipGridOffset, step, 0);
    }

    @Override
    public void draw(CGraphics g, int thick, boolean skipGridOffset, int step, int lineStyle) {
        this.draw(g, thick, skipGridOffset, step, lineStyle, false);
    }

    @Override
    public void draw(CGraphics g, int thick, int inc, int sepUnit, boolean isAscending, Date startPt, int dataType, Object[] name) {
        this.draw(g, thick, 0, inc, sepUnit, isAscending, startPt, dataType, name);
    }

    @Override
    public void draw(CGraphics g, int thick, int lineStyle, int inc, int sepUnit, boolean isAscending, Date startPt, int dataType, Object[] name) {
        if (!this.bshow) {
            return;
        }
        g.setColor(this.color);
        if (!isAscending) {
            inc *= -1;
        }
        for (int i = 0; i < this.coord.length; ++i) {
            int value = -1;
            value = DateTime.compare(sepUnit, (Date)name[i], startPt, dataType);
            if (isAscending) {
                while (value > 0) {
                    startPt = DateTime.increment(sepUnit, inc, startPt);
                    value = DateTime.compare(sepUnit, (Date)name[i], startPt, dataType);
                }
            } else {
                while (value < 0) {
                    startPt = DateTime.increment(sepUnit, inc, startPt);
                    value = DateTime.compare(sepUnit, (Date)name[i], startPt, dataType);
                }
            }
            if (value != 0) continue;
            if (this.orient == 1) {
                g.fillLine(this.min, this.coord[i].y, this.max, this.coord[i].y, thick, null, lineStyle, false);
            } else {
                g.fillLine(this.coord[i].x, this.min, this.coord[i].x, this.max, thick, null, lineStyle, false);
            }
            startPt = DateTime.increment(sepUnit, inc, startPt);
        }
    }

    @Override
    public void draw(CGraphics g, int thick, boolean skipGridOffset, int step, int lineStyle, boolean useLineStyle) {
        block6: {
            block5: {
                if (!this.bshow) {
                    return;
                }
                g.setColor(this.color);
                if (this.orient != 1) break block5;
                int i = 0;
                if (skipGridOffset && step > 1) {
                    i = step - 1;
                }
                while (i < this.coord.length) {
                    g.fillLine(this.min, this.coord[i].y, (int)((double)(this.max - this.min) * this.getGridLine2DRatio()) + this.min, this.coord[i].y, thick, null, lineStyle, false, true, Color.BLACK, useLineStyle);
                    i += step;
                }
                break block6;
            }
            if (this.orient != 0) break block6;
            int i = 0;
            if (skipGridOffset && step > 1) {
                i = step - 1;
            }
            while (i < this.coord.length) {
                g.fillLine(this.coord[i].x, this.min, this.coord[i].x, (int)((double)(this.max - this.min) * this.getGridLine2DRatio()) + this.min, thick, null, lineStyle, false, true, Color.BLACK, useLineStyle);
                i += step;
            }
        }
    }
}

