/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Area2D;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.RenderingChart;

public class BoxChart2D
extends Chart2D {
    public BoxChart2D(Component component, ColData[] colData) {
        super(component, 15, colData);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            this.dataDim = 1;
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
    }

    public BoxChart2D(Chart _chart) {
        super(15, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.dataDim = 1;
        } else {
            this.dataDim = 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        int cMax;
        int cMin;
        int vMax;
        int vMin;
        Axis vAxis;
        if (this.notEnoughData()) {
            return;
        }
        if (this.getLayout() == 0) {
            vAxis = this.a_x;
            vMin = xmin;
            vMax = xmax;
            cMin = ymin;
            cMax = ymax;
        } else {
            vAxis = this.a_y;
            vMin = ymin;
            vMax = ymax;
            cMin = xmin;
            cMax = xmax;
        }
        StepSize[] step = this.getStepSize(vAxis, g, vMin, vMax, cMin, cMax);
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        boolean zoomYDir = this.isYZoomed && (this.getZoomOption() == 1 || this.getZoomOption() == 2) && this.getLayout() == 0;
        boolean zoomXDir = this.isXZoomed && (this.getZoomOption() == 0 || this.getZoomOption() == 2) && this.getLayout() == 1;
        double maxColWidth = (double)(xmax - xmin) * this.getMaxBarWidthRatioToPlotArea();
        if (this.dataDim == 1) {
            double delta = (double)(cMax - cMin) / ((double)noCategory * (1.0 + this.barwidthRatio));
            double delta2 = delta * this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += delta - maxColWidth;
                delta = maxColWidth;
            }
            double lastc = (double)cMin + delta2 / 2.0;
            int m = -1;
            int[] tmpArr = new int[]{-1, -1};
            boolean zoomed = false;
            for (int i = 0; i < noCategory; ++i) {
                double nextc = lastc + delta;
                loc[0] = i;
                if (zoomXDir) {
                    zoomed = true;
                    tmpArr = this.calcZoomCat((int)lastc, (int)nextc, true);
                } else if (zoomYDir) {
                    zoomed = true;
                    tmpArr = this.calcZoomCat((int)lastc, (int)nextc, false);
                }
                this.setAreaCoord(this.mData, this.getPos(this.mData, loc, step[0], 1), this.getPos(this.mData, loc, step[0], 2), zoomed ? tmpArr[0] : (int)lastc, zoomed ? tmpArr[1] : (int)nextc, this.getPos(this.mData, loc, step[0], 3), this.getPos(this.mData, loc, step[0], 4), this.getPos(this.mData, loc, step[0], 5), loc, this.getOutilerPos(this.mData, loc, step[0]));
                m = zoomed ? (tmpArr[0] + tmpArr[1]) / 2 : (int)((lastc + nextc) / 2.0);
                coord[i] = this.getLayout() == 0 ? new Point3D(step[0].zeroAxis, m, 0) : new Point3D(m, step[0].zeroAxis, 0);
                if (step[1] != null) {
                    double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) : this.mData2.getValue(loc);
                    if (this.getLayout() == 0) {
                        this.mData2.setPointCoord(step[1].interpolatePixel(value), m, loc);
                    } else {
                        this.mData2.setPointCoord(m, step[1].interpolatePixel(value), loc);
                    }
                }
                lastc = nextc + delta2;
            }
        }
        this.setAutomatic(step[1] != null);
        int colfield = this.mDataMap[this.dataDim - 1];
        if (this.getLayout() == 0) {
            this.a_y.set(step[0].zeroAxis, ymin, step[0].zeroAxis, ymax, this.axisThickness, this.colData[colfield].getFieldName(), coord, step[0].zeroAxis == xmax, this.colData[colfield]);
            if (this.isGridAlignedWithTicker()) {
                Point3D[] coord2 = new Point3D[noCategory];
                for (int i = 0; i < coord2.length; ++i) {
                    coord2[i] = new Point3D(xmin, coord[i].y, 0);
                }
                this.a_y.grid.set(coord2, xmin, xmax);
            } else {
                Point3D[] coord2 = new Point3D[noCategory - 1];
                for (int i = 0; i < coord2.length; ++i) {
                    coord2[i] = new Point3D(xmin, (coord[i].y + coord[i + 1].y) / 2, 0);
                }
                this.a_y.grid.set(coord2, xmin, xmax);
            }
        } else {
            this.a_x.set(xmin, step[0].zeroAxis, xmax, step[0].zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, step[0].zeroAxis == ymax, this.colData[colfield]);
            if (this.isGridAlignedWithTicker()) {
                Point3D[] coord2 = new Point3D[noCategory];
                for (int i = 0; i < coord2.length; ++i) {
                    coord2[i] = new Point3D(coord[i].x, ymin, 0);
                }
                this.a_x.grid.set(coord2, ymin, ymax);
            } else {
                Point3D[] coord2 = new Point3D[noCategory - 1];
                for (int i = 0; i < coord2.length; ++i) {
                    coord2[i] = new Point3D((coord[i].x + coord[i + 1].x) / 2, ymin, 0);
                }
                this.a_x.grid.set(coord2, ymin, ymax);
            }
        }
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    private StepSize[] getStepSize(Axis vAxis, CGraphics g, int vMin, int vMax, int cMin, int cMax) {
        boolean doSwapAxis;
        StepSize[] step = new StepSize[2];
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(vAxis.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(vMax - vMin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxVal();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            step[0] = new StepSize(vAxis, vMax, vMin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.setAxisGrid(vAxis, step[0], cMin, cMin, cMax, this.colData[this.valueCol], this.axisThickness);
            step[1] = new StepSize(this.a_s, vMax, vMin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.setAxisGrid(this.a_s, step[1], cMax, cMin, cMax, this.colData[this.subvalueCol], this.axisThickness);
        } else if (doSwapAxis) {
            this.findMinMaxVal();
            step[0] = new StepSize(vAxis, vMax, vMin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.setAxisGrid(vAxis, step[0], cMax, cMin, cMax, this.colData[this.valueCol], this.axisThickness);
            this.findMinMaxVal2();
            step[1] = new StepSize(this.a_s, vMax, vMin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.setAxisGrid(this.a_s, step[1], cMin, cMin, cMax, this.colData[this.subvalueCol], this.axisThickness);
        } else {
            this.findMinMaxVal();
            step[0] = new StepSize(vAxis, vMax, vMin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.setAxisGrid(vAxis, step[0], cMin, cMin, cMax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                step[1] = new StepSize(this.a_s, vMax, vMin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.setAxisGrid(this.a_s, step[1], cMax, cMin, cMax, this.colData[this.subvalueCol], this.axisThickness);
            }
        }
        return step;
    }

    private void setAxisGrid(Axis axis, StepSize step, int origin, int min, int max, ColData colField, int width) {
        if (this.getLayout() == 0) {
            axis.setAxisGridX(step, origin, min, max, colField, width);
        } else {
            axis.setAxisGridY(step, origin, min, max, colField, width);
        }
    }

    private int getPos(MultiDimData data, int[] loc, StepSize step, int type) {
        PlotData plotData = data.getPlotData(loc);
        double tmp = plotData.getValue(type) * this.flashRatio;
        if (!this.isDataLimitAtAxisScale()) {
            return step.interpolatePixel(tmp);
        }
        if (tmp > step.maxvalue) {
            return step.interpolatePixel(step.maxvalue);
        }
        if (tmp < step.minvalue) {
            return step.interpolatePixel(step.minvalue);
        }
        return step.interpolatePixel(tmp);
    }

    private int[] getOutilerPos(MultiDimData data, int[] loc, StepSize step) {
        double[] outiler = data.getPlotData(loc).getOutiler();
        if (outiler == null) {
            return null;
        }
        int[] position = new int[outiler.length];
        if (!this.isDataLimitAtAxisScale()) {
            for (int i = 0; i < outiler.length; ++i) {
                position[i] = step.interpolatePixel(outiler[i]);
            }
            return position;
        }
        int count = 0;
        for (double element : outiler) {
            if (!(element <= step.maxvalue) || !(element >= step.minvalue)) continue;
            position[count] = step.interpolatePixel(element);
            ++count;
        }
        if (count == 0) {
            return null;
        }
        int[] position2 = new int[count];
        for (int i = 0; i < count; ++i) {
            position2[i] = position[i];
        }
        return position2;
    }

    private void setAreaCoord(MultiDimData data, int vMin, int vMax, int cMin, int cMax, int v25, int v50, int v75, int[] loc, int[] outiler) {
        if (data.level < this.dataDim) {
            this.setAreaCoord(data.multiData[loc[data.level]], vMin, vMax, cMin, cMax, v25, v50, v75, loc, outiler);
            return;
        }
        int tmp = (cMax - cMin) / 4;
        if (this.getLayout() == 0) {
            data.area.setpos(vMin, cMin + tmp, v50, vMax, cMax - tmp, vMax);
            data.point.x = vMin;
            data.point.y = (cMin + cMax) / 2;
            data.area2 = this.copyArea(data.area);
            data.area2.setpos(v25, cMin, v50, v75, cMax, v75);
        } else {
            data.area.setpos(cMin + tmp, vMin, v50, cMax - tmp, vMax, vMax);
            data.point.x = (cMin + cMax) / 2;
            data.point.y = vMin;
            data.area2 = this.copyArea(data.area);
            data.area2.setpos(cMin, v25, v50, cMax, v75, v75);
        }
        data.setOutilerPosition(outiler);
        data.point.color = data.area.areaColor;
    }

    private void drawLine(CGraphics g, int x1, int y1, int x2, int y2, int thick, Color color, MultiDimData data) {
        int yorigin = g.height - this.chartyorigin;
        int xtop = this.chartxorigin + this.chartwidth;
        int ytop = yorigin - this.chartheight;
        if (x1 > xtop && x2 > xtop) {
            return;
        }
        if (x1 < this.chartxorigin && x2 < this.chartxorigin) {
            return;
        }
        if (y1 < ytop && y2 < ytop) {
            return;
        }
        if (y1 > yorigin && y2 > yorigin) {
            return;
        }
        if (x1 > xtop) {
            x1 = xtop;
        }
        if (x1 < this.chartxorigin) {
            x1 = this.chartxorigin;
        }
        if (x2 > xtop) {
            x2 = xtop;
        }
        if (x2 < this.chartxorigin) {
            x2 = this.chartxorigin;
        }
        if (y1 < ytop) {
            y1 = ytop;
        }
        if (y1 > yorigin) {
            y1 = yorigin;
        }
        if (y2 < ytop) {
            y2 = ytop;
        }
        if (y2 > yorigin) {
            y2 = yorigin;
        }
        Line.drawLine(g, x1, y1, x2, y2, thick, color, data);
    }

    private void drawArea(CGraphics g, Area oArea, MultiDimData data) {
        Area2D area = new Area2D();
        oArea.copyArea(area);
        int xtop = this.chartxorigin + this.chartwidth;
        int ytop = this.chartyorigin + this.chartheight;
        if (area.p1.x > xtop && area.p2.x > xtop) {
            return;
        }
        if (area.p1.x < this.chartxorigin && area.p2.x < this.chartxorigin) {
            return;
        }
        if (area.p1.y > ytop && area.p2.y > ytop) {
            return;
        }
        if (area.p1.y < this.chartyorigin && area.p2.y < this.chartyorigin) {
            return;
        }
        if (area.p1.x > xtop) {
            area.p1.x = xtop;
        }
        if (area.p1.x < this.chartxorigin) {
            area.p1.x = this.chartxorigin;
        }
        if (area.p2.x > xtop) {
            area.p2.x = xtop;
        }
        if (area.p2.x < this.chartxorigin) {
            area.p2.x = this.chartxorigin;
        }
        if (area.p1.y > ytop) {
            area.p1.y = ytop;
        }
        if (area.p1.y < this.chartyorigin) {
            area.p1.y = this.chartyorigin;
        }
        if (area.p2.y > ytop) {
            area.p2.y = ytop;
        }
        if (area.p2.y < this.chartyorigin) {
            area.p2.y = this.chartyorigin;
        }
        area.draw(g, area, data);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawArea(CGraphics g, MultiDimData data) {
        boolean setToolTipsForFlash;
        block7: {
            int ytop;
            int element;
            int n;
            int[] nArray;
            block9: {
                int xtop;
                int element2;
                int n2;
                int[] nArray2;
                block8: {
                    int[] outiler;
                    Color lineColor;
                    block6: {
                        if (data.level < this.dataDim) {
                            for (MultiDimData element3 : data.multiData) {
                                this.drawArea(g, element3);
                            }
                            return;
                        }
                        this.drawArea(g, data.area, data);
                        data.area2.setColor(data.area.areaColor);
                        this.drawArea(g, data.area2, data);
                        lineColor = data.area.areaColor.darker();
                        outiler = data.getOutilerPosition();
                        setToolTipsForFlash = false;
                        if (g.g instanceof IFlashGraphics) {
                            ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(data);
                            setToolTipsForFlash = true;
                        }
                        if (this.getLayout() != 0) break block6;
                        int minY = g.height - data.area2.p2.y;
                        int maxY = g.height - data.area2.p1.y;
                        int dy = (int)((double)(maxY - minY) * 0.1);
                        this.drawLine(g, data.area.p1.x, maxY += dy, data.area.p1.x, minY -= dy, data.getLineThickness(), lineColor, data);
                        this.drawLine(g, data.area2.p1.x, maxY, data.area2.p1.x, minY, data.getLineThickness(), lineColor, data);
                        this.drawLine(g, data.area.p1.z, maxY, data.area.p1.z, minY, data.getLineThickness(), lineColor, data);
                        this.drawLine(g, data.area2.p2.x, maxY, data.area2.p2.x, minY, data.getLineThickness(), lineColor, data);
                        this.drawLine(g, data.area.p2.x, maxY, data.area.p2.x, minY, data.getLineThickness(), lineColor, data);
                        if (outiler == null) break block7;
                        nArray2 = outiler;
                        n2 = nArray2.length;
                        break block8;
                    }
                    int minX = data.area2.p1.x;
                    int maxX = data.area2.p2.x;
                    int dx = (int)((double)(maxX - minX) * 0.1);
                    int tmp = g.height - data.area.p1.y;
                    this.drawLine(g, minX -= dx, tmp, maxX += dx, tmp, data.getLineThickness(), lineColor, data);
                    tmp = g.height - data.area2.p1.y;
                    this.drawLine(g, minX, tmp, maxX, tmp, data.getLineThickness(), lineColor, data);
                    tmp = g.height - data.area.p1.z;
                    this.drawLine(g, minX, tmp, maxX, tmp, data.getLineThickness(), lineColor, data);
                    tmp = g.height - data.area2.p2.y;
                    this.drawLine(g, minX, tmp, maxX, tmp, data.getLineThickness(), lineColor, data);
                    tmp = g.height - data.area.p2.y;
                    this.drawLine(g, minX, tmp, maxX, tmp, data.getLineThickness(), lineColor, data);
                    if (outiler == null) break block7;
                    nArray = outiler;
                    n = nArray.length;
                    break block9;
                }
                for (int i = 0; i < n2 && (element2 = nArray2[i]) <= (xtop = this.chartxorigin + this.chartwidth) && element2 >= this.chartxorigin; ++i) {
                    Point3D point = new Point3D(element2, data.point.y, data.point.color, data.point.shape, data.point.size);
                    point.drawPt(g, point, this.getPrimaryDataGradientSupport());
                }
                break block7;
            }
            for (int i = 0; i < n && (element = nArray[i]) <= (ytop = this.chartyorigin + this.chartheight) && element >= this.chartyorigin; ++i) {
                Point3D point = new Point3D(data.point.x, element, data.point.color, data.point.shape, data.point.size);
                point.drawPt(g, point, this.getPrimaryDataGradientSupport());
            }
        }
        if (!setToolTipsForFlash) return;
        ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
    }

    @Override
    public void draw(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.draw_INTERNAL(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.draw_INTERNAL(g);
        }
    }

    private void draw_INTERNAL(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        this.drawControlRange(g, 0);
        if (!this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        this.border.draw(g);
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawArea(g, this.mData);
            this.drawControlRange(g, 1);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        } else {
            this.drawArea(g, this.mData);
        }
        this.dataLineSet.drawDataLineList();
        if (this.showLegend2()) {
            if (this.showLine2) {
                this.mData2.drawLine(g);
            }
            if (this.showPoint2) {
                this.mData2.drawPoint(g);
            }
        }
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        this.a_x.draw(g);
        this.a_y.draw(g);
        if (this.showLegend2()) {
            this.a_s.draw(g);
        }
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawPoints(g);
            this.drawControlRange(g, 2);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.checkZoomStatus() && this.getZoomOption() != -1) {
            this.drawScrollBars(g);
        }
    }

    private int[] calcZoomCat(int lastx, int nextx, boolean isXCat) {
        if (isXCat) {
            lastx = this.calculateZoomedX(lastx);
            nextx = this.calculateZoomedX(nextx);
        } else {
            lastx = this.calculateZoomedY(lastx);
            nextx = this.calculateZoomedY(nextx);
        }
        if (lastx > nextx) {
            int tmp = lastx;
            lastx = nextx;
            nextx = tmp;
        }
        return new int[]{lastx, nextx};
    }
}

