/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Coordinate;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;

public class BubbleChart2D
extends Chart2D {
    public BubbleChart2D(Component component, ColData[] colData) {
        super(component, 13, colData);
        this.showPoint = true;
        this.mDataMap[0] = this.nCol;
        if (this.nint + this.nreal + this.ntime < 1) {
            throw nonumericError;
        }
        int[] coordColOrder = new int[]{0, 1, 2};
        int mapIndex = 0;
        for (int i = 0; i < this.nCol; ++i) {
            if (!DataType.isNumeric(colData[i].dataType)) continue;
            this.coordCol[coordColOrder[mapIndex++]] = i;
            if (mapIndex == 3) break;
        }
        if (mapIndex == 1) {
            this.coordCol[coordColOrder[mapIndex++]] = this.coordCol[coordColOrder[0]];
        }
        if (mapIndex == 2) {
            this.coordCol[coordColOrder[mapIndex++]] = this.coordCol[coordColOrder[0]];
        }
        this.dataDim = 1;
        this.bcoordCol[2] = true;
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        this.makeTable();
        this.enableTypeMenu = false;
        this.enableDimMenu = false;
    }

    public BubbleChart2D(Chart _chart) {
        super(13, _chart);
        if (!this.bcoordCol[0]) {
            this.coordCol[0] = this.valueCol;
            if (this.nreal + this.nint < 2) {
                this.coordCol[1] = this.coordCol[2] = this.valueCol;
            } else if (this.nreal + this.nint < 3) {
                this.coordCol[1] = this.valueCol;
                this.addNewColumnFromDataMapping = true;
                this.coordCol[2] = this.nreal > 0 ? (this.nrealcol[0] != this.valueCol ? this.nrealcol[0] : this.nintcol[0]) : (this.nintcol[0] != this.valueCol ? this.nintcol[0] : this.nintcol[1]);
            } else {
                int mapIndex = 1;
                this.addNewColumnFromDataMapping = true;
                for (int i = 0; i < this.nCol; ++i) {
                    if (!DataType.isNumeric(this.colData[i].dataType)) continue;
                    this.coordCol[mapIndex++] = i;
                    if (mapIndex == 3) break;
                }
            }
            this.bcoordCol[2] = true;
            this.bcoordCol[1] = true;
            this.bcoordCol[0] = true;
            this.dataDim = 1;
            this.mDataMap[0] = this.nCol;
        } else if (_chart.chartType == 2 || _chart.chartType == 13) {
            this.dataDim = _chart.dataDim;
        } else {
            this.dataDim = 1;
            this.mDataMap[0] = this.nCol;
        }
        if (!this.bcoordCol[2] || !_chart.bcoordCol[2]) {
            this.bcoordCol[2] = true;
            this.coordCol[2] = this.coordCol[1];
        }
        this.copyTable(_chart);
        this.enableTypeMenu = false;
        this.enableDimMenu = false;
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        this.findMinMaxCoord();
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        StepSize ystep = new StepSize(this.a_y, ymax, ymin, this.maxCoord.y, this.minCoord.y, (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent()))), this.getCoorddec(this.coordCol[1]));
        fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_x.font, this.mData.chart.isAdjustFont()));
        StepSize xstep = new StepSize(this.a_x, xmax, xmin, this.maxCoord.x, this.minCoord.x, (int)((double)(xmax - xmin) / (5.0 * (double)fm.charWidth('8'))), this.getCoorddec(this.coordCol[0]));
        this.a_y.setAxisGridY(ystep, xstep.zeroAxis, xmin, xmax, this.colData[this.coordCol[1]], this.axisThickness);
        this.a_x.setAxisGridX(xstep, ystep.zeroAxis, ymin, ymax, this.colData[this.coordCol[0]], this.axisThickness);
        if (xstep.zeroAxis != xmin && xstep.zeroAxis != xmax) {
            CString s;
            s.setPlacement((s = this.a_y.ticker.label[ystep.stepBelow]).getPlacement() == 2 ? 5 : 8);
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        if (this.dataDim == 1) {
            for (int i = 0; i < noCategory; ++i) {
                loc[0] = i;
                this.setPointCoord(xstep, ystep, loc);
                this.mData.multiData[i].point.automatic = true;
            }
        } else {
            int noSeries = this.mDataLen[0];
            for (int i = 0; i < noSeries; ++i) {
                loc[0] = i;
                this.mData.multiData[i].point.automatic = false;
                for (int j = 0; j < noCategory; ++j) {
                    loc[1] = j;
                    this.setPointCoord(xstep, ystep, loc);
                    this.mData.multiData[i].multiData[j].point.automatic = true;
                }
            }
        }
        this.setAutomatic(false);
        this.mData.sortPoint();
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw2D(g, 2);
    }

    private void setPointCoord(StepSize xstep, StepSize ystep, int[] loc) {
        Coordinate coord = (Coordinate)this.mData.getElement(loc);
        if (coord == null) {
            return;
        }
        this.mData.setPointCoord(xstep.interpolatePixel(coord.x), ystep.interpolatePixel(coord.y), loc);
    }
}

