/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.HiLowData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.IOUtil;

public class GanttChart2D
extends Chart2D {
    public GanttChart2D(Component component, ColData[] colData) {
        super(component, 18, colData);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.hilowCol.low = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
            this.hilowCol.hi = this.hilowCol.low;
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nint + this.nreal + this.ndatetime < 2) {
                throw nonumericError;
            }
            this.hilowCol.low = this.nint + this.nreal < 1 ? this.ndatetimecol[0] : (this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0]);
            this.hilowCol.hi = this.hilowCol.low;
        }
        this.valueCol = this.hilowCol.hi;
        this.coordCol[0] = this.hilowCol.hi;
        this.coordCol[1] = this.hilowCol.low;
        this.coordCol[2] = -1;
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        this.bcoordCol[2] = false;
        this.dataDim = 1;
        this.makeTable();
        this.setLabelDateTimeDisplay(0, true);
        this.setDateTimeAxes();
    }

    public GanttChart2D(Chart _chart) {
        super(18, _chart);
        if (_chart instanceof GanttChart2D) {
            this.hilowCol.copy(_chart.hilowCol);
        } else {
            if (this.hilowCol.hi == -1) {
                int n = this.hilowCol.hi = this.bvalueCol ? this.valueCol : _chart.coordCol[0];
            }
            if (this.hilowCol.low == -1) {
                int n = this.hilowCol.low = this.bvalueCol ? this.valueCol : _chart.coordCol[1];
            }
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
        this.setDateTimeAxes();
    }

    private void setDateTimeAxes() {
        this.a_x.displayLabelAsDate = this.isLabelDateTimeDisplay(0);
        this.a_x.setTimeChart(true);
    }

    private HiLowData interpolateHiLow(StepSize step, HiLowData hilow) {
        double hi = hilow.vhi;
        double low = hilow.vlow;
        double open = hilow.vopen;
        double close = hilow.vclose;
        double min = step.minvalue;
        double max = step.maxvalue;
        hi = this.scaleCheck(hi, min, max);
        low = this.scaleCheck(low, min, max);
        if (hilow.vopen != -1.7976931348623157E308) {
            open = this.scaleCheck(open, min, max);
        }
        if (hilow.vclose != -1.7976931348623157E308) {
            close = this.scaleCheck(close, min, max);
        }
        hi = step.interpolatePixel((hi - step.minvalue) * this.flashRatio + step.minvalue);
        low = step.interpolatePixel((low - step.minvalue) * this.flashRatio + step.minvalue);
        open = hilow.vopen == -1.7976931348623157E308 ? -1.7976931348623157E308 : (double)step.interpolatePixel((open - step.minvalue) * this.flashRatio + step.minvalue);
        close = hilow.vclose == -1.7976931348623157E308 ? -1.7976931348623157E308 : (double)step.interpolatePixel((close - step.minvalue) * this.flashRatio + step.minvalue);
        return new HiLowData(hi, low, open, close);
    }

    private double scaleCheck(double val, double min, double max) {
        if (val > max) {
            return max;
        }
        if (val < min) {
            return min;
        }
        return val;
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        Point3D[] coord2;
        HiLowData hilow;
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(xmax - xmin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize xstep = null;
        StepSize xstep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxVal();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec(), true);
            this.a_x.setAxisGridX(xstep, ymin, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec(), true);
            this.a_s.setAxisGridX(xstep2, ymax, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
        } else if (doSwapAxis) {
            this.findMinMaxVal();
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec(), true);
            this.a_x.setAxisGridX(xstep, ymax, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            this.findMinMaxVal2();
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec(), true);
            this.a_s.setAxisGridX(xstep2, ymin, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
        } else {
            this.findMinMaxVal();
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec(), true);
            this.a_x.setAxisGridX(xstep, ymin, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec(), true);
                this.a_s.setAxisGridX(xstep2, ymax, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        if (this.dataDim == 1) {
            double delta = (double)(ymax - ymin) / ((double)noCategory * (this.barwidthRatio + 1.0));
            double delta2 = delta * this.barwidthRatio;
            double lasty = (double)ymin + delta2 / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                double nexty = lasty + delta;
                loc[0] = i;
                hilow = (HiLowData)this.mData.getElement(loc);
                if (hilow != null) {
                    this.mData.setAreaCoord(this.interpolateHiLow(xstep, hilow), (int)lasty, (int)nexty, loc);
                }
                if (xstep2 != null && this.getComboType() != 3) {
                    this.mData2.setAreaCoord(xstep2.interpolatePixel((this.mData2.getValue(loc) - xstep2.minvalue) * this.flashRatio + xstep2.minvalue), xstep2.zeroAxis, (int)lasty, (int)nexty, loc);
                }
                coord[i] = new Point3D(xstep.zeroAxis, (int)((lasty + nexty) / 2.0), 0);
                lasty = nexty + delta2;
            }
        } else {
            int noSeries = this.mDataLen[0];
            double delta = (double)(ymax - ymin) / ((double)noCategory * (this.barwidthRatio + 1.0));
            double delta2 = delta * this.barwidthRatio;
            double lasty = (double)ymin + delta2 / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                loc[1] = i;
                double nexty = lasty + delta;
                for (int j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    hilow = (HiLowData)this.mData.getElement(loc);
                    if (hilow == null) continue;
                    this.mData.setAreaCoord(this.interpolateHiLow(xstep, hilow), (int)lasty, (int)nexty, loc);
                }
                coord[i] = new Point3D(xstep.zeroAxis, (int)((lasty + nexty) / 2.0), 0);
                lasty = nexty + delta2;
            }
        }
        this.setAutomatic(xstep2 != null);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_y.set(xstep.zeroAxis, ymin, xstep.zeroAxis, ymax, this.axisThickness, this.colData[colfield].getFieldName(), coord, xstep.zeroAxis == xmax, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, coord[i].y, 0);
            }
            this.a_y.grid.set(coord2, xmin, xmax);
        } else {
            coord2 = new Point3D[noCategory - 1];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, (coord[i].y + coord[i + 1].y) / 2, 0);
            }
            this.a_y.grid.set(coord2, xmin, xmax);
        }
        if (this.axis[0].autoscale && (this.axis[0].columnField.axisType == 8 || this.axis[0].columnField.axisType == 10)) {
            long min = (long)this.axis[0].minScale;
            Date minDate = new Date(min);
            GregorianCalendar gCal = new GregorianCalendar();
            gCal.setTime(minDate);
            if (IOUtil.isJava2D()) {
                gCal.set(11, 0);
            } else {
                gCal.set(11, TimeZone.getDefault().getRawOffset() / 3600000 + 24);
            }
            gCal.set(12, 0);
            gCal.set(13, 0);
            minDate = gCal.getTime();
            min = minDate.getTime();
            long max = (long)this.axis[0].maxScale;
            long range = max - min;
            long step = range / 4L;
            step -= step % 86400000L;
            if (this.axis[0].stepScale == 8.64E7) {
                step = 86400000L;
            }
            this.setAxisScale(0, min, max, step);
            this.setUserOriginX(min);
            this.axis[0].autoscale = true;
        }
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw2D(g, 1);
    }
}

