/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import quadbase.chart.Area;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Area2D;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.flash.FlashGraphics;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.RenderingChart;

public class LineChart2D
extends Chart2D {
    private Area[] dropBar;
    public static boolean USE_YAXIS_FOR_SINGLE_POINT_LINECHART = false;

    public LineChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 3, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.showLine = true;
        this.bvalueCol = true;
        this.makeTable();
    }

    public LineChart2D(Chart _chart) {
        super(3, _chart);
        if (!(_chart instanceof LineChart2D)) {
            this.showLine = true;
        }
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize ystep = null;
        StepSize ystep2 = null;
        StepSize xstep = null;
        StepSize xstep2 = null;
        boolean Y_int = false;
        if (this.a_y.columnField != null && this.a_y.columnField.getName().startsWith("count_")) {
            Y_int = true;
        }
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.flashRatio == 1.0) {
            double[] avgValues = this.mData.getAvgVal(this, 0.0, 0);
            this.avgvalue = avgValues[0] / avgValues[1];
        }
        if (this.isJoinAxis()) {
            this.findMinMaxVal();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            if (this.getLayout() == 0) {
                ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, Y_int);
                this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.lineData(this.dataDim, xmin + this.x_shift, xmax, ystep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            } else {
                xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec());
                this.a_x.setAxisGridX(xstep, ymax, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
                xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridX(xstep2, ymin, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.getYLineData(this.dataDim, ymin + this.x_shift, ymax, xstep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            }
        } else if (doSwapAxis) {
            if (this.getLayout() == 0) {
                this.findMinMaxVal();
                ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, Y_int);
                this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
                this.findMinMaxVal2();
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridY(ystep2, xmin, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.lineData(this.dataDim, xmin + this.x_shift, xmax, ystep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            } else {
                this.findMinMaxVal();
                xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec());
                this.a_x.setAxisGridX(xstep, ymin, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
                this.findMinMaxVal2();
                xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridX(xstep2, ymax, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.getYLineData(this.dataDim, ymin + this.x_shift, ymax, xstep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            }
        } else if (this.getLayout() == 0) {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, Y_int);
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.lineData(this.dataDim, xmin + this.x_shift, xmax, ystep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            }
        } else {
            this.findMinMaxVal();
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.a_x.setAxisGridX(xstep, ymax, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridX(xstep2, ymin, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.getYLineData(this.dataDim, ymin + this.x_shift, ymax, xstep2, this.mData2, this.mDataLen, this.showOffsetTicker());
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        if (this.getLayout() == 0) {
            Point3D[] coord = LineChart2D.lineData(this.dataDim, xmin + this.x_shift, xmax, ystep, this.mData, this.mDataLen, this.showOffsetTicker());
            int colfield = this.mDataMap[this.dataDim - 1];
            this.a_x.set(xmin, ystep.zeroAxis, xmax, ystep.zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, ystep.zeroAxis == ymax, this.colData[colfield]);
            Point3D[] coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(coord[i].x, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        } else {
            Point3D[] coord = LineChart2D.getYLineData(this.dataDim, ymin + this.x_shift, ymax, xstep, this.mData, this.mDataLen, this.showOffsetTicker());
            int colfield = this.mDataMap[this.dataDim - 1];
            this.a_y.set(xstep.zeroAxis, ymax, xstep.zeroAxis, ymin, this.axisThickness, this.colData[colfield].getFieldName(), coord, xstep.zeroAxis == xmax, this.colData[colfield]);
            Point3D[] coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, coord[i].y, 0);
            }
            this.a_y.grid.set(coord2, xmin, xmax);
        }
        this.prepareLabel();
        this.setAutomatic(ystep2 != null);
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    public static Point3D[] lineData(int dataDim, int xmin, int xmax, StepSize ystep, MultiDimData data, int[] mDataLen, boolean showOffsetTicker) {
        boolean zoomXDir;
        int[] loc = new int[dataDim];
        int noCategory = mDataLen[dataDim - 1];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)(xmax - xmin) / ((double)noCategory - 1.0);
        double nextx = xmin;
        double lastx = xmax;
        if (showOffsetTicker) {
            delta = (double)(xmax - xmin) / (double)noCategory;
            nextx = (double)xmin + delta / 2.0;
            lastx = (double)xmax - delta / 2.0;
        }
        boolean bl = zoomXDir = data.chart.isXZoomed && (data.chart.getZoomOption() == 0 || data.chart.getZoomOption() == 2);
        if (dataDim == 1) {
            for (int i = 0; i < noCategory; ++i) {
                if (!USE_YAXIS_FOR_SINGLE_POINT_LINECHART && i == noCategory - 1) {
                    nextx = lastx;
                }
                loc[0] = i;
                double value = data.chart.isDataLimitAtAxisScale() ? data.getValue(loc, ystep) : data.getValue(loc);
                if (data.chart.flashRatio != 1.0) {
                    value = (value - data.chart.avgvalue) * data.chart.flashRatio + data.chart.avgvalue;
                }
                int m = (int)nextx;
                if (zoomXDir && ((m = data.chart.calculateZoomedX(m)) < data.chart.chartxorigin || m > data.chart.chartxorigin + data.chart.chartwidth)) {
                    m = -100;
                }
                data.setPointCoord((int)nextx, ystep.interpolatePixel(value), loc);
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                nextx += delta;
                data.multiData[i].area.automatic = data.chart.isSyncPointColorForLine();
                data.multiData[i].point.automatic = data.chart.isSyncPointColorForLine();
            }
        } else {
            int j;
            int i;
            double delta2 = (delta - delta * data.chart.barwidthRatio / 10.0) / 2.0;
            if (data.chart.isShowDropBarForLine()) {
                ((LineChart2D)data.chart).dropBar = new Area[noCategory];
            }
            for (i = 0; i < noCategory; ++i) {
                if (!USE_YAXIS_FOR_SINGLE_POINT_LINECHART && i == noCategory - 1) {
                    nextx = lastx;
                }
                loc[1] = i;
                int series1 = -1;
                int series2 = -1;
                int m = (int)nextx;
                if (zoomXDir && ((m = data.chart.calculateZoomedX((int)nextx)) < data.chart.chartxorigin || m > data.chart.chartxorigin + data.chart.chartwidth)) {
                    m = -100;
                }
                for (j = 0; j < mDataLen[0]; ++j) {
                    loc[0] = j;
                    double value = data.chart.isDataLimitAtAxisScale() ? data.getValue(loc, ystep) : data.getValue(loc);
                    if (data.chart.flashRatio != 1.0) {
                        value = (value - data.chart.avgvalue) * data.chart.flashRatio + data.chart.avgvalue;
                    }
                    int yPixel = ystep.interpolatePixel(value);
                    if (data.chart.isShowDropBarForLine() && !data.getPlotData(loc).isEmpty()) {
                        if (j == data.chart.getDropBarSeries1()) {
                            series1 = yPixel;
                        } else if (j == data.chart.getDropBarSeries2()) {
                            series2 = yPixel;
                        }
                    }
                    data.setPointCoord((int)nextx, yPixel, loc);
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                if (data.chart.isShowDropBarForLine() && series1 >= 0 && series2 >= 0) {
                    ((LineChart2D)data.chart).dropBar[i] = new Area2D();
                    int tmpX = data.chart.calculateZoomedX((int)(nextx - delta2));
                    int tmpX2 = data.chart.calculateZoomedX((int)(nextx + delta2));
                    ((LineChart2D)data.chart).dropBar[i].setpos(tmpX, series1, i, tmpX2, series2, i);
                    ((LineChart2D)data.chart).dropBar[i].automatic = series1 >= series2;
                }
                nextx += delta;
            }
            for (i = 0; i < mDataLen[0]; ++i) {
                data.multiData[i].point.automatic = false;
                for (j = 0; j < mDataLen[1]; ++j) {
                    data.multiData[i].multiData[j].point.automatic = true;
                }
            }
        }
        return coord;
    }

    public static Point3D[] getYLineData(int dataDim, int ymin, int ymax, StepSize xstep, MultiDimData data, int[] mDataLen, boolean showOffsetTicker) {
        boolean zoomYDir;
        int[] loc = new int[dataDim];
        int noCategory = mDataLen[dataDim - 1];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)(ymax - ymin) / ((double)noCategory - 1.0);
        double nexty = ymax;
        if (showOffsetTicker) {
            delta = (double)(ymax - ymin) / (double)noCategory;
            nexty = (double)ymax - delta / 2.0;
        }
        boolean bl = zoomYDir = data.chart.isYZoomed && (data.chart.getZoomOption() == 1 || data.chart.getZoomOption() == 2);
        if (dataDim == 1) {
            for (int i = 0; i < noCategory; ++i) {
                loc[0] = i;
                double value = data.chart.isDataLimitAtAxisScale() ? data.getValue(loc, xstep) : data.getValue(loc);
                if (data.chart.flashRatio != 1.0) {
                    value = (value - data.chart.avgvalue) * data.chart.flashRatio + data.chart.avgvalue;
                }
                int m = (int)nexty;
                if (zoomYDir && ((m = data.chart.calculateZoomedY(m)) < data.chart.chartxorigin || m > data.chart.chartxorigin + data.chart.chartwidth)) {
                    m = -100;
                }
                data.setPointCoord(xstep.interpolatePixel(value), (int)nexty, loc);
                coord[i] = new Point3D(xstep.zeroAxis, m, 0);
                nexty -= delta;
                data.multiData[i].area.automatic = data.chart.isSyncPointColorForLine();
                data.multiData[i].point.automatic = data.chart.isSyncPointColorForLine();
            }
        } else {
            int j;
            int i;
            double delta2 = (delta - delta * data.chart.barwidthRatio / 10.0) / 2.0;
            if (data.chart.isShowDropBarForLine()) {
                ((LineChart2D)data.chart).dropBar = new Area[noCategory];
            }
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                int series1 = -1;
                int series2 = -1;
                int m = (int)nexty;
                if (zoomYDir && ((m = data.chart.calculateZoomedY(m)) < data.chart.chartxorigin || m > data.chart.chartxorigin + data.chart.chartwidth)) {
                    m = -100;
                }
                for (j = 0; j < mDataLen[0]; ++j) {
                    loc[0] = j;
                    double value = data.chart.isDataLimitAtAxisScale() ? data.getValue(loc, xstep) : data.getValue(loc);
                    if (data.chart.flashRatio != 1.0) {
                        value = (value - data.chart.avgvalue) * data.chart.flashRatio + data.chart.avgvalue;
                    }
                    int xPixel = xstep.interpolatePixel(value);
                    if (data.chart.isShowDropBarForLine() && !data.getPlotData(loc).isEmpty()) {
                        if (j == data.chart.getDropBarSeries1()) {
                            series1 = xPixel;
                        } else if (j == data.chart.getDropBarSeries2()) {
                            series2 = xPixel;
                        }
                    }
                    data.setPointCoord(xPixel, (int)nexty, loc);
                }
                coord[i] = new Point3D(xstep.zeroAxis, m, 0);
                if (data.chart.isShowDropBarForLine() && series1 >= 0 && series2 >= 0) {
                    ((LineChart2D)data.chart).dropBar[i] = new Area2D();
                    ((LineChart2D)data.chart).dropBar[i].setpos(series1, (int)(nexty - delta2), i, series2, (int)(nexty + delta2), i);
                    ((LineChart2D)data.chart).dropBar[i].automatic = series1 >= series2;
                }
                nexty -= delta;
            }
            for (i = 0; i < mDataLen[0]; ++i) {
                data.multiData[i].point.automatic = false;
                for (j = 0; j < mDataLen[1]; ++j) {
                    data.multiData[i].multiData[j].point.automatic = true;
                }
            }
        }
        return coord;
    }

    @Override
    public void draw(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        if (IOUtil.isJava2D()) {
            this.drawControlRange(g, 0);
        }
        if (!this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        this.border.draw(g);
        if (this.dataDrawnOnTop || this.isDrawAreaUnderLine()) {
            this.dataLineSet.drawDataLineList();
        }
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawChart(g);
            this.drawControlRange(g, 1);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        } else {
            this.drawChart(g);
        }
        if (!this.dataDrawnOnTop) {
            this.dataLineSet.drawDataLineList();
        }
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        this.a_x.draw(g);
        this.a_y.draw(g);
        if (this.showLegend2() && !this.isShowDoubleValueForLine()) {
            this.a_s.draw(g);
        }
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawPoints(g);
            this.drawControlRange(g, 2);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.checkZoomStatus() && this.getZoomOption() != -1) {
            this.drawScrollBars(g);
        }
    }

    @Override
    public Object selectDropBar(CGraphics g, int x, int y) {
        if (this.isShowDropBarForLine() && this.dropBar != null) {
            for (Area element : this.dropBar) {
                if (element == null || !element.select(g, x, y)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public void drawChart(CGraphics g) {
        if (this.isTranslucentSupport()) {
            Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
        }
        if (g.g instanceof IFlashGraphics) {
            ((FlashGraphics)g.g).initFrameSet(this.flashFrameCount);
            int k = 0;
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(k++);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.drawChart_INTERNAL(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.drawChart_INTERNAL(g);
        }
        if (this.isTranslucentSupport()) {
            Composite.setOriginalComposite(g.g);
        }
    }

    private void drawChart_INTERNAL(CGraphics g) {
        if (this.isShowDropBarForLine() && this.dropBar != null) {
            for (int i = 0; i < this.dropBar.length; ++i) {
                if (this.dropBar[i] == null) continue;
                this.dropBar[i].drawBlackBorder = this.getDropBarBorderState();
                this.dropBar[i].areaColor = this.dropBar[i].automatic ? this.getDropBarColor() : this.getDropBarColor2();
                this.dropBar[i].draw(g, this.dropBar[i], null);
            }
        }
        if (this.showLegend2()) {
            if (this.showLine2) {
                if (this.isShowDoubleValueForLine()) {
                    this.mData2.drawLine(g, this.mData);
                } else {
                    this.mData2.drawLine(g);
                }
            }
            if (this.showPoint2) {
                this.mData2.drawPoint(g);
            }
        }
        if (this.showLine) {
            this.mData.drawLine(g);
        }
        if (this.showPoint) {
            this.mData.drawPoint(g);
        }
    }

    @Override
    public boolean notEnoughData() {
        return this.nRow < 1;
    }
}

