/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.IPieChart;
import quadbase.chart.PieChart;
import quadbase.chart.Point3D;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.IFlashGraphics;

public class PieChart2D
extends Chart2D
implements IPieChart {
    private static final Logger LOGGER = Logger.getLogger(PieChart2D.class.getName());
    PieChart pieChart;

    public PieChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        this(component, 6, colData, usedColumns);
    }

    public PieChart2D(Chart _chart) {
        this(6, _chart);
    }

    PieChart2D(Component component, int type, ColData[] colData, boolean[] usedColumns) {
        super(component, type, colData, usedColumns);
        this.pieChart = new PieChart(this);
        this.setDataBorder(true);
    }

    PieChart2D(int type, Chart _chart) {
        super(type, _chart);
        this.pieChart = new PieChart(this, _chart);
    }

    @Override
    public PieChart getPieChart() {
        return this.pieChart;
    }

    @Override
    public void copyAttributes(IPieChart iPieChart) {
        this.pieChart.copyAttributes(iPieChart.getPieChart());
    }

    @Override
    public void transformPoint(Point3D point) {
        LOGGER.warning("PieChart2D: should not happen 1");
    }

    @Override
    public void resetHiddenSurface() {
        LOGGER.warning("PieChart2D: should not happen 2");
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        if (this.chartType == 20 && this.pieChart.concentricDoughnut) {
            int pieCount = 0;
            pieCount = this.dataDim == 1 ? 1 : this.mDataLen[1];
            this.pieChart.pieheight = new int[pieCount];
            this.pieChart.piewidth = new int[pieCount];
            this.pieChart.pieThickness = new int[pieCount];
            this.pieChart.pieThickness[0] = 50;
            if (this.pieChart.center == null || pieCount != this.pieChart.center.length) {
                this.pieChart.allocateLabel(pieCount, this.mDataLen[0]);
            }
            int xwidth = xmax - xmin;
            int ywidth = ymax - ymin;
            if (xwidth != 0 && ywidth != 0) {
                int maxChartHeight = xwidth < ywidth ? xwidth : ywidth;
                this.pieChart.pieheight[0] = this.pieChart.piewidth[0] = 2 * maxChartHeight / (2 + pieCount);
                this.pieChart.center[0].x = (xmin + xmax) / 2;
                this.pieChart.center[0].y = (ymin + ymax) / 2;
                for (int i = 1; i < pieCount; ++i) {
                    this.pieChart.center[i].y = this.pieChart.center[0].y;
                    this.pieChart.center[i].x = this.pieChart.center[0].x;
                    this.pieChart.pieheight[i] = this.pieChart.piewidth[i] = this.pieChart.pieheight[i - 1] + this.pieChart.pieheight[0] * this.pieChart.pieThickness[0] / 100;
                    this.pieChart.pieThickness[i] = this.pieChart.pieheight[0] * this.pieChart.pieThickness[0] / this.pieChart.pieheight[i];
                }
                this.pieChart.assignCoordinates();
            }
            super.computeCoord(g, xmin, xmax, ymin, ymax);
            return;
        }
        double gapRatio = this.pieChart.getGapRatioBetweenPies();
        int pieCount = 0;
        pieCount = this.dataDim == 1 ? 1 : this.mDataLen[1];
        this.pieChart.pieheight = new int[pieCount];
        this.pieChart.piewidth = new int[pieCount];
        this.pieChart.pieThickness = new int[pieCount];
        this.pieChart.pieThickness[0] = 50;
        if (this.pieChart.center == null || pieCount != this.pieChart.center.length) {
            this.pieChart.allocateLabel(pieCount, this.mDataLen[0]);
        }
        int xwidth = xmax - xmin;
        int ywidth = ymax - ymin;
        if (pieCount == 1) {
            this.pieChart.piewidth[0] = xwidth < ywidth ? xwidth : ywidth;
            this.pieChart.pieheight[0] = this.pieChart.piewidth[0];
            this.pieChart.center[0].x = (xmin + xmax) / 2;
            this.pieChart.center[0].y = (ymin + ymax) / 2;
        } else {
            int yOffset;
            int col = 1;
            int row = 1;
            if (this.pieChart.isBestFit()) {
                double d;
                double a;
                double b;
                if (this.pieChart.isExploded()) {
                    gapRatio += this.pieChart.sliceDistance / 2.0;
                }
                if ((col = (int)Math.rint((-(b = gapRatio * (double)(xwidth - ywidth)) + Math.sqrt(b * b + 4.0 * (a = (double)ywidth * (gapRatio + 1.0)) * (d = (double)(pieCount * xwidth) * (1.0 + gapRatio)))) / (2.0 * a))) <= 0) {
                    col = 1;
                }
                row = (int)Math.ceil((double)pieCount / (double)col);
            } else if (this.pieChart.isDrawLinearly()) {
                col = pieCount;
                row = 1;
            } else {
                int n = col = this.pieChart.piePerRow > pieCount ? pieCount : this.pieChart.piePerRow;
                if (col <= 0) {
                    col = 1;
                }
                row = (int)Math.ceil((double)pieCount / (double)col);
            }
            int d1 = (int)Math.floor((double)xwidth / ((double)col + (double)col * gapRatio - gapRatio));
            int d2 = (int)Math.floor((double)ywidth / ((double)row + (double)row * gapRatio - gapRatio));
            this.pieChart.piewidth[0] = d1 < d2 ? d1 : d2;
            this.pieChart.pieheight[0] = this.pieChart.piewidth[0];
            int xOffset = (int)Math.floor(((double)xwidth - (double)this.pieChart.pieheight[0] * ((double)col + gapRatio * (double)col - gapRatio)) / 2.0);
            if (xOffset < 0) {
                xOffset = 0;
            }
            if ((yOffset = (int)Math.floor(((double)ywidth - (double)this.pieChart.pieheight[0] * ((double)row + gapRatio * (double)row - gapRatio)) / 2.0)) < 0) {
                yOffset = 0;
            }
            for (int i = 0; i < pieCount; ++i) {
                if (row == 1) {
                    this.pieChart.center[i].y = (ymin + ymax) / 2;
                } else {
                    int cRow = (int)Math.floor((double)i / (double)col);
                    this.pieChart.center[i].y = ymax - (int)Math.rint((double)this.pieChart.pieheight[0] * ((double)cRow * gapRatio + (double)(cRow + 1) / 2.0 + (double)cRow / 2.0)) - yOffset;
                }
                if (col == 1) {
                    this.pieChart.center[i].x = (xmin + xmax) / 2;
                } else {
                    int cCol = i % col;
                    this.pieChart.center[i].x = xmin + (int)Math.rint((double)this.pieChart.pieheight[0] * ((double)cCol * gapRatio + (double)(cCol + 1) / 2.0 + (double)cCol / 2.0)) + xOffset;
                }
                this.pieChart.pieheight[i] = this.pieChart.piewidth[i] = this.pieChart.pieheight[0];
                this.pieChart.pieThickness[i] = this.pieChart.pieThickness[0];
            }
        }
        this.pieChart.assignCoordinates();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    @Override
    public void drawLabel(CGraphics g) {
        this.pieChart.drawLabel(g);
    }

    @Override
    public void draw(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            int k = 0;
            int loopCt = 1;
            boolean isExploded = false;
            double sliceDistance = this.pieChart.getSliceDistance();
            if (this.flashFrameCount > 1) {
                isExploded = this.pieChart.isExploded();
                loopCt = 2;
                if (isExploded) {
                    loopCt = 3;
                    if (this.flashFrameCount == 2) {
                        loopCt = 2;
                    }
                    this.pieChart.setSliceDistance(0.0);
                }
            }
            int framePerLoop = this.flashFrameCount / loopCt;
            int lastFramePerLoop = this.flashFrameCount - loopCt * framePerLoop + framePerLoop;
            if (isExploded && this.flashFrameCount == 2) {
                framePerLoop = 1;
                lastFramePerLoop = 1;
            }
            for (int i = 0; i < (isExploded ? loopCt - 1 : loopCt); ++i) {
                if (i == 0) {
                    this.flashIsFirstLoopForPie = true;
                }
                boolean isLastLoop = i + 1 >= (isExploded ? loopCt - 1 : loopCt);
                for (int j = 1; j <= (!isExploded && isLastLoop ? lastFramePerLoop : framePerLoop); ++j) {
                    ((IFlashGraphics)((Object)g.g)).setFrame(k);
                    this.flashRatio = (double)j / (double)framePerLoop;
                    this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                    this.mData.drawArea(g);
                    ++k;
                }
                this.flashIsFirstLoopForPie = false;
            }
            if (isExploded) {
                for (int j = 1; j <= lastFramePerLoop; ++j) {
                    ((IFlashGraphics)((Object)g.g)).setFrame(k);
                    this.pieChart.setSliceDistance((double)j / (double)lastFramePerLoop * sliceDistance);
                    this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                    this.mData.drawArea(g);
                    ++k;
                }
            }
            ((IFlashGraphics)((Object)g.g)).setTopLabels();
            this.drawLabel(g);
            ((IFlashGraphics)((Object)g.g)).resetTopLabels();
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
            this.mainTitle.draw(g);
        } else {
            this.mData.drawArea(g);
            this.drawLabel(g);
            this.mainTitle.draw(g);
        }
    }

    @Override
    public boolean notEnoughData() {
        return this.nRow <= 0;
    }
}

