/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Coordinate;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.Composite;
import quadbase.util.internal.RenderingChart;

public class PolarChart2D
extends Chart2D {
    private double fontDistance;
    private Dimension[] labelOffset;

    public PolarChart2D(Component component, ColData[] colData) {
        block6: {
            block4: {
                block5: {
                    super(component, 19, colData);
                    this.fontDistance = 1.1;
                    this.showPoint = true;
                    this.showArea = false;
                    this.mDataMap[0] = this.nCol;
                    if (this.nint + this.nreal < 1) {
                        throw nonumericError;
                    }
                    this.dataDim = 1;
                    if (this.nint + this.nreal != 1) break block4;
                    if (this.nint <= 0) break block5;
                    this.mDataMap[0] = this.mDataMap[1] = this.nintcol[0];
                    this.coordCol[0] = this.coordCol[1] = this.nintcol[0];
                    break block6;
                }
                if (this.nreal <= 0) break block6;
                this.mDataMap[0] = this.mDataMap[1] = this.nrealcol[0];
                this.coordCol[0] = this.coordCol[1] = this.nrealcol[0];
                break block6;
            }
            int nrealCt = 0;
            int nintCt = 0;
            int coordCt = 2;
            for (int i = 0; i < coordCt; ++i) {
                if (this.nreal > nrealCt) {
                    this.coordCol[i] = this.nrealcol[nrealCt++];
                    continue;
                }
                if (this.nint <= nintCt) continue;
                this.coordCol[i] = this.nintcol[nintCt++];
            }
        }
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        if (!this.is2DChart) {
            this.bcoordCol[2] = false;
        }
        this.makeTable();
        this.setDateTimeAxes();
        this.allocateLabelOffset();
    }

    public PolarChart2D(Chart _chart) {
        super(19, _chart);
        this.fontDistance = 1.1;
        if (_chart.chartType != 19) {
            this.showPoint = true;
            this.showArea = false;
        }
        if (!this.bcoordCol[0]) {
            this.coordCol[0] = this.valueCol;
            if (this.nreal + this.nint < 2) {
                this.coordCol[1] = this.valueCol;
            } else {
                this.coordCol[1] = this.valueCol;
                this.addNewColumnFromDataMapping = true;
                this.coordCol[1] = this.nreal > 0 ? (this.nrealcol[0] != this.valueCol ? this.nrealcol[0] : (this.nreal > 1 ? this.nrealcol[1] : this.nintcol[0])) : (this.nintcol[0] != this.valueCol ? this.nintcol[0] : this.nintcol[1]);
            }
            this.bcoordCol[1] = true;
            this.bcoordCol[0] = true;
            this.bcoordCol[2] = false;
            this.dataDim = 1;
            this.mDataMap[0] = this.nCol;
        } else {
            this.bcoordCol[2] = false;
            if (_chart.chartType == 19 || _chart.chartType == 2 && _chart.dataDim < 3) {
                this.dataDim = _chart.dataDim;
                this.mDataMap[0] = _chart.mDataMap[0];
            } else {
                this.dataDim = 1;
                this.mDataMap[0] = this.nCol;
            }
        }
        this.copyTable(_chart);
        this.setDateTimeAxes();
        this.allocateLabelOffset();
    }

    private void setDateTimeAxes() {
        this.labelDateTime[0] = false;
        this.labelDateTime[1] = false;
        this.a_y.displayLabelAsDate = this.labelDateTime[1];
        this.a_y.setTimeChart(true);
    }

    private void allocateLabelOffset() {
        this.labelOffset = new Dimension[this.noSectionForPolar];
        for (int i = 0; i < this.noSectionForPolar; ++i) {
            this.labelOffset[i] = new Dimension(0, 0);
        }
    }

    private String[] getSectorLabel() {
        String[] ticketLabel = new String[this.noSectionForPolar];
        double sep = 360 / this.noSectionForPolar;
        double val = 0.0;
        for (int i = 0; i < this.noSectionForPolar; ++i) {
            ticketLabel[i] = this.a_x.formating(val);
            val += sep;
        }
        return ticketLabel;
    }

    @Override
    public Dimension getLabelOffset(int secIndex) {
        if (this.labelOffset == null) {
            this.allocateLabelOffset();
        }
        return this.labelOffset[secIndex];
    }

    @Override
    public void setLabelOffset(int secIndex, Dimension newOffset) {
        if (this.labelOffset == null) {
            this.allocateLabelOffset();
        }
        if (secIndex >= this.labelOffset.length) {
            return;
        }
        this.labelOffset[secIndex].width = newOffset.width;
        this.labelOffset[secIndex].height = newOffset.height;
    }

    @Override
    public int countLabelOffset() {
        if (this.labelOffset == null) {
            this.allocateLabelOffset();
        }
        return this.noSectionForPolar;
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        this.findMinMaxRadial();
        int centerX = (xmin + xmax) / 2;
        int centerY = (ymin + ymax) / 2;
        int axisWidth = (xmax - xmin) / 2;
        if (axisWidth > (ymax - ymin) / 2) {
            axisWidth = (ymax - ymin) / 2;
        }
        if (this.labelOffset == null || this.labelOffset.length != this.noSectionForPolar) {
            this.allocateLabelOffset();
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize xstep = new StepSize(this.a_x, centerX, centerX + axisWidth, this.maxCoord.x, this.minCoord.x, fstep, this.getCoorddec(this.coordCol[0]), false);
        this.a_x.setAxisGridX(xstep, centerX, ymin, ymax, this.colData[this.coordCol[0]], this.axisThickness);
        StepSize ystep = new StepSize(this.a_y, centerY + axisWidth, centerY, this.maxCoord.y, this.minCoord.y, fstep, this.getCoorddec(this.coordCol[1]), false);
        this.a_y.setAxisGridY(ystep, centerX, xmin, xmax, this.colData[this.coordCol[1]], this.axisThickness);
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        if (this.dataDim == 1) {
            for (int i = 0; i < noCategory; ++i) {
                loc[0] = i;
                this.setPointCoord(ystep, loc, centerX, centerY);
                this.mData.multiData[i].point.automatic = true;
            }
        } else {
            int noSeries = this.mDataLen[0];
            for (int i = 0; i < noSeries; ++i) {
                loc[0] = i;
                this.mData.multiData[i].point.automatic = false;
                for (int j = 0; j < noCategory; ++j) {
                    loc[1] = j;
                    this.setPointCoord(ystep, loc, centerX, centerY);
                    this.mData.multiData[i].multiData[j].point.automatic = true;
                }
            }
        }
        Point3D[] coord = new Point3D[this.noSectionForPolar];
        double sector = Math.PI * 2 / (double)this.noSectionForPolar;
        int direction = 1;
        if (!this.clockWiseForPolar) {
            direction = -1;
        }
        for (int i = 0; i < this.noSectionForPolar; ++i) {
            double angle = sector * (double)i + this.startAngleForPolar;
            int x = (int)((double)centerX + this.fontDistance * (double)axisWidth * Math.sin(angle) * (double)direction);
            int y = (int)((double)centerY + this.fontDistance * (double)axisWidth * Math.cos(angle));
            coord[i] = new Point3D(x, y, 0);
        }
        this.setAutomatic(false);
        this.mData.sortPoint();
        this.prepareLabel();
        this.a_x.set(xmin, xmax, xmin, xmax, this.axisThickness, this.getSectorLabel(), coord, false, this.colData[this.coordCol[0]]);
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    @Override
    public void draw(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.draw_INTERNAL(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.draw_INTERNAL(g);
        }
    }

    public void draw_INTERNAL(CGraphics g) {
        int i;
        this.background.draw(g, this.background, null, true, this.background);
        this.border.draw(g);
        if (this.showArea) {
            boolean isTranslucent;
            boolean bl = isTranslucent = this.isTranslucentSupport() && this.dataDim > 1;
            if (isTranslucent) {
                Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
            }
            this.drawArea(this.mData, g, this.mData.point);
            if (isTranslucent) {
                Composite.setOriginalComposite(g.g);
            }
        }
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        for (i = 0; i < this.noSectionForPolar; ++i) {
            this.drawAxis(g, this.a_y, i);
            this.drawGrid(g, this.a_y);
        }
        for (i = 0; i < this.noSectionForPolar; ++i) {
            this.drawTicker(g, this.a_y, i);
        }
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.showLine) {
            this.mData.drawLine(g);
        }
        if (this.showPoint) {
            this.mData.drawPoint(g);
        }
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
    }

    @Override
    public void drawAxis(CGraphics g, Axis axis) {
        for (int i = 0; i < this.noSectionForPolar; ++i) {
            this.drawAxis(g, axis, i);
        }
    }

    public void drawAxis(CGraphics g, Axis axis, int i) {
        if (axis.bshow) {
            double sector = Math.PI * 2 / (double)this.noSectionForPolar;
            int centerX = axis.startp.x;
            int centerY = g.height - axis.startp.y;
            int width = axis.endp.y - axis.startp.y;
            double angle = sector * (double)i;
            int maxX = centerX + (int)(Math.sin(angle) * (double)width);
            int maxY = centerY - (int)(Math.cos(angle) * (double)width);
            Line.drawLine(g, centerX, centerY, maxX, maxY, Math.abs(axis.thickness), axis.color);
        }
        if (this.a_x.showTicker && i % this.a_x.columnField.sepSize == 0) {
            Dimension dim = this.getLabelOffset(i);
            Point3D pt = new Point3D(this.a_x.ticker.point[i].x + dim.width, this.a_x.ticker.point[i].y - dim.height, 0);
            this.a_x.ticker.label[i].setpos(pt);
            this.a_x.ticker.drawLabel(g, i, this.a_x.ticker.maxp, this.a_x.ticker.minp);
        }
        if (axis.bshow && this.showArrow) {
            this.drawArrow(g, axis, i);
        }
    }

    private void drawArrow(CGraphics g, Axis axis, int j) {
        int thick = Math.abs(axis.thickness);
        int arrh = (int)((double)(thick * 8) / 3.0);
        int arrw = thick * 5;
        int arrd = (int)((double)(thick * 10) / 3.0);
        int y = g.height - (axis.endp.y + thick / 2);
        int[] yp = new int[]{y, y + arrw, y + arrd, y + arrw};
        int[] xp = new int[]{axis.endp.x, axis.endp.x + arrh, axis.endp.x, axis.endp.x - arrh};
        double sector = Math.PI * 2 / (double)this.noSectionForPolar;
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        g.setColor(axis.color);
        Polygon polygon = new Polygon();
        for (int i = 0; i < 4; ++i) {
            double width = xp[i] - centerX;
            double height = yp[i] - centerY;
            double len = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
            double angle = sector * (double)j + Math.atan(width / height);
            int ptX = centerX + (int)(Math.sin(angle) * len);
            int ptY = centerY - (int)(Math.cos(angle) * len);
            polygon.addPoint(ptX, ptY);
        }
        g.g.fillPolygon(polygon);
    }

    private void drawTicker(CGraphics g, Axis axis, int idx) {
        int i;
        boolean showText = axis.ticker.showText;
        axis.ticker.showText = false;
        boolean showLine = axis.ticker.showline;
        axis.ticker.showline = false;
        boolean automaticAngle = axis.ticker.automatic;
        axis.ticker.automatic = false;
        axis.drawTicker(g);
        axis.ticker.showText = showText;
        axis.ticker.showline = showLine;
        axis.ticker.automatic = automaticAngle;
        double sector = Math.PI * 2 / (double)this.noSectionForPolar;
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        double twidth = 4 + axis.thickness / 2;
        if (axis.grid == null || !axis.grid.bshow) {
            for (i = axis.columnField.tickerSepSize; i < axis.ticker.point.length; i += axis.columnField.tickerSepSize) {
                double height = axis.ticker.point[i].y - centerY;
                double len = Math.sqrt(Math.pow(twidth, 2.0) + Math.pow(height, 2.0));
                double angle1 = sector * (double)idx - Math.atan(twidth / height);
                int pt1X = centerX + (int)Math.rint(Math.sin(angle1) * len);
                int pt1Y = centerY + (int)Math.rint(Math.cos(angle1) * len);
                double angle2 = sector * (double)idx;
                int pt2X = centerX + (int)Math.rint(Math.sin(angle2) * height);
                int pt2Y = centerY + (int)Math.rint(Math.cos(angle2) * height);
                axis.ticker.drawLine(g, pt1X, pt1Y, pt2X, pt2Y);
            }
        }
        if (idx != 0) {
            return;
        }
        axis.ticker.drawLabel(g, 0, 0.0, centerX, centerY);
        for (i = axis.columnField.sepSize; i < axis.ticker.point.length; i += axis.columnField.sepSize) {
            double angle = sector * (double)idx;
            axis.ticker.drawLabel(g, i, angle, centerX, centerY);
        }
    }

    private void drawArea(MultiDimData mdata, CGraphics g, Point3D p) {
        if (mdata.level < this.dataDim - 1) {
            for (MultiDimData element : mdata.multiData) {
                this.drawArea(element, g, mdata.point.automatic ? p : mdata.point);
            }
        } else {
            MultiDimData data1 = null;
            MultiDimData firstData = null;
            Color areaColor = mdata.point.automatic ? p.color : mdata.point.color;
            Polygon polygon = new Polygon();
            MultiDimData[] multiDimDataArray = mdata.multiData;
            int n = multiDimDataArray.length;
            for (int i = 0; i < n; ++i) {
                MultiDimData element;
                data1 = element = multiDimDataArray[i];
                if (data1.plotData.isEmpty()) continue;
                if (firstData == null) {
                    firstData = data1;
                }
                polygon.addPoint(data1.point.x, data1.point.y);
            }
            if (firstData != null && polygon.npoints > 2) {
                polygon.addPoint(firstData.point.x, firstData.point.y);
            }
            Color orgColor = areaColor;
            Color newColor = areaColor;
            if (g.chart.flashRatio != 1.0) {
                newColor = new Color(orgColor.getRed(), orgColor.getGreen(), orgColor.getBlue(), (int)Math.rint(255.0 * g.chart.flashRatio));
            }
            g.setColor(newColor);
            g.fillPolygon(polygon, mdata);
            if (this.drawDataBorder) {
                g.drawLineForArea(polygon, false, false, newColor.darker());
            }
            areaColor = orgColor;
        }
    }

    private void drawGrid(CGraphics g, Axis axis) {
        if (axis.grid == null || !axis.grid.bshow) {
            return;
        }
        int step = axis.columnField != null ? axis.columnField.tickerSepSize : 1;
        g.setColor(axis.grid.color);
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        for (int i = 0; i < axis.grid.coord.length; i += step) {
            int width = (axis.grid.coord[i].y - centerY) * 2;
            if (axis.gridThickness <= 1) {
                g.drawArc(centerX, centerY, width, width, 0, 360);
                continue;
            }
            int thick = axis.gridThickness / 2;
            for (int j = -thick; j < thick * 2; ++j) {
                g.drawArc(centerX, centerY, width - j, width - j, 0, 360);
            }
        }
    }

    private void setPointCoord(StepSize ystep, int[] loc, int centerX, int centerY) {
        Coordinate coord = (Coordinate)this.mData.getElement(loc);
        if (coord == null) {
            return;
        }
        int radial = ystep.interpolatePixel(Math.abs(coord.y)) - centerY;
        double radian = coord.x;
        if (!this.isRadianForPolar) {
            radian = radian * Math.PI / 180.0;
        }
        if (coord.y < 0.0) {
            radian += Math.PI;
        }
        radian += this.startAngleForPolar;
        int direction = 1;
        if (!this.clockWiseForPolar) {
            direction = -1;
        }
        int ptX = centerX + (int)(Math.sin(radian) * (double)radial * (double)direction);
        int ptY = centerY + (int)(Math.cos(radian) * (double)radial);
        this.mData.setPointCoord(ptX, ptY, loc);
    }

    @Override
    public Object insideSelect(CGraphics g, int x, int y, Object target, int i, String[] stable) {
        target = this.mData.select(g, x, y);
        if (target != null || this.showArea && (target = this.selectArea(this.mData, g, x, y)) != null) {
            this.targetName = this.getInformation((MultiDimData)target);
            if (((MultiDimData)target).plotData != null) {
                target = ((MultiDimData)target).parent;
            }
            return target;
        }
        for (int j = 0; j < this.noSectionForPolar; ++j) {
            if (this.axis[1].ticker != null && this.selectTicker(this.axis[1], g, x, y, j)) {
                this.targetName = stable[1] + " ticker";
                return this.axis[1].ticker;
            }
            if (this.selectAxis(this.axis[1], g, x, y, j)) {
                this.targetName = stable[1] + " axis";
                return this.axis[1];
            }
            if (!this.selectGrid(this.axis[1], g, x, y)) continue;
            this.targetName = stable[1] + " grid";
            return this.axis[1].grid;
        }
        if (this.border.drawBorder && this.border.borderSelect(g, x, y)) {
            this.targetName = "chart border";
            return this.border;
        }
        if (this.background.drawArea && this.background.select(g, x, y)) {
            this.targetName = "chart background";
            return this.background;
        }
        return null;
    }

    private MultiDimData selectArea(MultiDimData mdata, CGraphics g, int x, int y) {
        MultiDimData data1 = null;
        MultiDimData firstData = null;
        if (mdata.level < this.dataDim - 1) {
            for (int i = mdata.multiData.length - 1; i >= 0; --i) {
                data1 = this.selectArea(mdata.multiData[i], g, x, y);
                if (data1 == null) continue;
                return data1;
            }
        } else {
            Polygon polygon = new Polygon();
            MultiDimData[] multiDimDataArray = mdata.multiData;
            int n = multiDimDataArray.length;
            for (int i = 0; i < n; ++i) {
                MultiDimData element;
                data1 = element = multiDimDataArray[i];
                if (data1.plotData.isEmpty()) continue;
                if (firstData == null) {
                    firstData = data1;
                }
                polygon.addPoint(data1.point.x, g.height - data1.point.y);
            }
            if (firstData != null && polygon.npoints > 2) {
                polygon.addPoint(firstData.point.x, g.height - firstData.point.y);
            }
            if (polygon.contains(x, y)) {
                return firstData;
            }
        }
        return null;
    }

    private boolean selectAxis(Axis axis, CGraphics g, int x, int y, int i) {
        int maxY;
        if (!axis.bshow) {
            return false;
        }
        double sector = Math.PI * 2 / (double)this.noSectionForPolar;
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        int width = axis.endp.y - axis.startp.y;
        double angle = sector * (double)i;
        int maxX = centerX + (int)(Math.sin(angle) * (double)width);
        return Line.pickLine(centerX, centerY, maxX, maxY = centerY - (int)(Math.cos(angle) * (double)width), x, y);
    }

    private boolean selectTicker(Axis axis, CGraphics g, int x, int y, int j) {
        if (axis.ticker.label == null || axis.ticker.point == null || !axis.showTitleTicker || !axis.showTicker && !axis.ticker.showline) {
            return false;
        }
        double sector = Math.PI * 2 / (double)this.noSectionForPolar;
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        double twidth = 4 + axis.thickness / 2;
        for (int i = axis.columnField.tickerSepSize; i < axis.ticker.point.length; i += axis.columnField.tickerSepSize) {
            int pt2Y;
            double angle2;
            int pt2X;
            int pt1Y;
            double height = axis.ticker.point[i].y - centerY;
            double len = Math.sqrt(Math.pow(twidth, 2.0) + Math.pow(height, 2.0));
            double angle1 = sector * (double)j - Math.atan(twidth / height);
            int pt1X = centerX + (int)(Math.sin(angle1) * len);
            if (!Line.pickLine(pt1X, pt1Y = centerY + (int)(Math.cos(angle1) * len), pt2X = centerX + (int)(Math.sin(angle2 = sector * (double)j) * height), pt2Y = centerY + (int)(Math.cos(angle2) * height), x, g.height - y)) continue;
            return true;
        }
        return false;
    }

    private boolean selectGrid(Axis axis, CGraphics g, int x, int y) {
        if (axis.grid == null || !axis.grid.bshow) {
            return false;
        }
        int step = axis.columnField != null ? axis.columnField.tickerSepSize : 1;
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        int offset = 2;
        for (int i = 0; i < axis.grid.coord.length; i += step) {
            int width = axis.grid.coord[i].y - axis.startp.y;
            Ellipse2D.Double big_Circle = new Ellipse2D.Double(centerX - (width + offset), centerY - (width + offset), (width + offset) * 2, (width + offset) * 2);
            Ellipse2D.Double small_Circle = new Ellipse2D.Double(centerX - (width - offset), centerY - (width - offset), (width - offset) * 2, (width - offset) * 2);
            if (!big_Circle.contains(x, y) || small_Circle.contains(x, y)) continue;
            return true;
        }
        return false;
    }
}

