/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.Shape;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.HorzVertLine;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Axis2D;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.Composite;
import quadbase.util.internal.Graphics2DTool;
import quadbase.util.internal.RenderingChart;

public class RadarChart2D
extends Chart2D {
    static final int PRIMARY_AXIS = -1;
    private double fontDistance = 1.1;
    private Dimension[] labelOffset;
    double[] minvalueA;
    double[] maxvalueA;

    public RadarChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 16, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
        this.doTypeMapping();
        this.allocateLabelOffset(this.mDataLen[this.dataDim - 1]);
    }

    public RadarChart2D(Chart _chart) {
        super(16, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            int n = this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        if (_chart.chartType == 2 || _chart.chartType == 19) {
            this.showArea = true;
        }
        if (!_chart.getLineState() || !this.showLine) {
            this.showArea = true;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
        this.doTypeMapping();
        this.allocateLabelOffset(this.mDataLen[this.dataDim - 1]);
    }

    @Override
    public void doTypeMapping() {
        int ct = this.mDataLen[this.dataDim - 1];
        int[] axisType = new int[ct];
        for (int i = 0; i < ct; ++i) {
            axisType[i] = this.isSynchronizeRadarAxis() ? -1 : i;
        }
        this.setAxisPosition(axisType);
        if (this.axisData == null || this.axisData.length != ct || this.colDataAxis.length != ct) {
            this.axisData = new ColData[ct];
            this.colDataAxis = new Axis2D[ct];
        }
        Font f = new Font("Courier", 1, 12);
        for (int i = 0; i < ct; ++i) {
            if (this.colDataAxis[i] != null) continue;
            this.colDataAxis[i] = this.setAxis(1, new CString("", f, 4), false);
        }
    }

    private void allocateLabelOffset(int len) {
        this.labelOffset = new Dimension[len];
        for (int i = 0; i < len; ++i) {
            this.labelOffset[i] = new Dimension(0, 0);
        }
    }

    @Override
    public Dimension getLabelOffset(int categoryIndex) {
        if (this.labelOffset == null) {
            this.allocateLabelOffset(this.mDataLen[this.dataDim - 1]);
        }
        return this.labelOffset[categoryIndex];
    }

    @Override
    public void setLabelOffset(int categoryIndex, Dimension newOffset) {
        if (this.labelOffset == null) {
            this.allocateLabelOffset(this.mDataLen[this.dataDim - 1]);
        }
        if (categoryIndex >= this.labelOffset.length) {
            return;
        }
        this.labelOffset[categoryIndex] = newOffset;
    }

    @Override
    public void setLabelOffset(Dimension[] newOffset) {
        if (newOffset == null) {
            return;
        }
        this.labelOffset = newOffset;
    }

    @Override
    public int countLabelOffset() {
        if (this.labelOffset == null) {
            this.allocateLabelOffset(this.mDataLen[this.dataDim - 1]);
        }
        return this.labelOffset.length;
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        this.doTypeMapping();
        int centerX = (xmin + xmax) / 2;
        int centerY = ymin;
        int noCategory = this.mDataLen[this.dataDim - 1];
        StepSize[] stepAxis = new StepSize[noCategory];
        int axisWidth = xmax - xmin;
        Dimension[] backupLabelOffset = this.labelOffset;
        if (this.labelOffset != null && this.labelOffset.length != noCategory) {
            this.allocateLabelOffset(noCategory);
            if (this.labelOffset != null) {
                for (int i = 0; i < backupLabelOffset.length && i < this.labelOffset.length; ++i) {
                    this.labelOffset[i] = backupLabelOffset[i];
                }
            }
        }
        if (xmax - xmin > ymax - ymin) {
            axisWidth = ymax - ymin;
        }
        if (noCategory > 1) {
            axisWidth /= 2;
            centerY = (ymin + ymax) / 2;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        this.findMinMaxVal();
        StepSize step = new StepSize(this.a_y, centerY + axisWidth, centerY, this.maxvalue, this.minvalue, fstep, this.getVdec());
        this.a_y.setAxisGridY(step, centerX, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
        if (!this.isSynchronizeRadarAxis()) {
            if (this.axisData == null || this.axisData.length != stepAxis.length || this.colDataAxis.length != stepAxis.length) {
                this.axisData = new ColData[stepAxis.length];
                this.colDataAxis = new Axis2D[stepAxis.length];
            }
            Font f = new Font("Courier", 1, 12);
            for (int i = 0; i < stepAxis.length; ++i) {
                if (!this.drawAxis(i)) {
                    this.colDataAxis[i] = null;
                    this.axisData[i] = null;
                    continue;
                }
                if (this.colDataAxis[i] == null) {
                    this.colDataAxis[i] = this.setAxis(1, new CString("", f, 4), false);
                }
                stepAxis[i] = new StepSize(this.colDataAxis[i], centerY + axisWidth, centerY, this.maxvalueA[i], this.minvalueA[i], fstep, this.getVdec());
                this.colDataAxis[i].setAxisGridY(stepAxis[i], centerX, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
                if (this.axisData[i] == null || this.axisData[i].getName() != this.colData[this.valueCol].getName() || this.axisData[i].getOriginalDataType() != this.colData[this.valueCol].getOriginalDataType()) {
                    this.axisData[i] = new ColData(this.colData[this.valueCol].getName(), "", this.colData[this.valueCol].getOriginalDataType(), -1, this.colData[this.valueCol].getStringDisplaySize(), this.colData.length);
                    this.axisData[i].copyAttributes(this.colData[this.valueCol]);
                }
                this.colDataAxis[i].setAxisShift(stepAxis[i].minvalue);
                stepAxis[i].zeroAxis = ymin;
                this.colDataAxis[i].setAxisGridY(stepAxis[i], centerX, xmin, xmax, this.axisData[i], this.axisThickness);
            }
        } else {
            this.axisData = null;
            this.colDataAxis = null;
        }
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        double sector = Math.PI * 2 / (double)noCategory;
        if (this.dataDim == 1) {
            for (int i = 0; i < noCategory; ++i) {
                double angle = sector * (double)i;
                loc[0] = i;
                if (this.isSynchronizeRadarAxis()) {
                    this.setPointCoord(step, centerX, centerY, loc, i);
                } else {
                    this.setPointCoord(stepAxis[i], centerX, centerY, loc, i);
                }
                this.mData.multiData[i].point.automatic = true;
                int x = (int)((double)centerX + this.fontDistance * (double)axisWidth * Math.sin(angle));
                int y = (int)((double)centerY + this.fontDistance * (double)axisWidth * Math.cos(angle));
                coord[i] = new Point3D(x, y, 0);
            }
        } else {
            int noSeries = this.mDataLen[0];
            for (int i = 0; i < noSeries; ++i) {
                loc[0] = i;
                this.mData.multiData[i].point.automatic = false;
                for (int j = 0; j < noCategory; ++j) {
                    double angle = sector * (double)j;
                    loc[1] = j;
                    if (this.isSynchronizeRadarAxis()) {
                        this.setPointCoord(step, centerX, centerY, loc, j);
                    } else {
                        this.setPointCoord(stepAxis[j], centerX, centerY, loc, j);
                    }
                    this.mData.multiData[i].multiData[j].point.automatic = true;
                    int x = (int)((double)centerX + this.fontDistance * (double)axisWidth * Math.sin(angle));
                    int y = (int)((double)centerY + this.fontDistance * (double)axisWidth * Math.cos(angle));
                    coord[j] = new Point3D(x, y, 0);
                }
            }
        }
        this.prepareLabel();
        this.setAutomatic(false);
        int colField = this.mDataMap[this.dataDim - 1];
        this.a_x.set(xmin, xmax, xmin, xmax, this.axisThickness, this.colData[colField].getFieldName(), coord, false, this.colData[colField]);
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    private void setPointCoord(StepSize step, int centerX, int centerY, int[] loc, int axisNo) {
        int nAxis = this.mDataLen[this.dataDim - 1];
        double angle = Math.PI * 2 / (double)nAxis * (double)axisNo;
        int width = step.interpolatePixel(this.mData.getValue(loc) * this.flashRatio) - centerY;
        int ptX = centerX + (int)(Math.sin(angle) * (double)width);
        int ptY = centerY + (int)(Math.cos(angle) * (double)width);
        this.mData.setPointCoord(ptX, ptY, loc);
    }

    @Override
    public Object insideSelect(CGraphics g, int x, int y, Object target, int i, String[] stable) {
        target = this.mData.select(g, x, y);
        if (target != null || this.showArea && (target = this.selectArea(this.mData, g, x, y)) != null) {
            this.targetName = this.getInformation((MultiDimData)target);
            if (((MultiDimData)target).plotData != null) {
                target = ((MultiDimData)target).parent;
            }
            return target;
        }
        int nAxis = this.mDataLen[this.dataDim - 1];
        Object[] fieldName = null;
        if (!this.isSynchronizeRadarAxis()) {
            fieldName = this.colData[this.mDataMap[this.dataDim - 1]].getFieldName();
        }
        for (int j = 0; j < nAxis; ++j) {
            if (this.isSynchronizeRadarAxis()) {
                if (this.axis[1].ticker != null && this.selectTicker(this.axis[1], g, x, y, j)) {
                    this.targetName = stable[1] + " ticker";
                    return this.axis[1].ticker;
                }
                if (this.selectAxis(this.axis[1], g, x, y, j)) {
                    this.targetName = stable[1] + " axis";
                    return this.axis[1];
                }
                if (!this.selectGrid(this.axis[1], g, x, y)) continue;
                this.targetName = stable[1] + " grid";
                return this.axis[1].grid;
            }
            if (this.colDataAxis[j].ticker != null && this.selectTicker(this.colDataAxis[j], g, x, y, j)) {
                this.targetName = fieldName[j].toString() + " ticker";
                return this.colDataAxis[j].ticker;
            }
            if (this.selectAxis(this.colDataAxis[j], g, x, y, j)) {
                this.targetName = fieldName[j].toString() + " axis";
                return this.colDataAxis[j];
            }
            if (!this.selectGrid(this.colDataAxis[j], g, x, y)) continue;
            this.targetName = fieldName[j].toString() + " grid";
            return this.colDataAxis[j].grid;
        }
        target = this.selectDataLine(g, x, y);
        if (target != null) {
            this.targetName = ((DataLine)target).getTitle();
            if (target instanceof ControlLine) {
                this.targetName = this.targetName + " " + ((ControlLine)target).getCalculatedValue();
            } else if (target instanceof HorzVertLine) {
                this.targetName = this.targetName + " " + ((HorzVertLine)target).getLineValue();
            }
            return target;
        }
        if (this.border.drawBorder && this.border.borderSelect(g, x, y)) {
            this.targetName = "chart border";
            return this.border;
        }
        if (this.background.drawArea && this.background.select(g, x, y)) {
            this.targetName = "chart background";
            return this.background;
        }
        return null;
    }

    private MultiDimData selectArea(MultiDimData mdata, CGraphics g, int x, int y) {
        MultiDimData data1 = null;
        if (mdata.level < this.dataDim - 1) {
            for (int i = mdata.multiData.length - 1; i >= 0; --i) {
                data1 = this.selectArea(mdata.multiData[i], g, x, y);
                if (data1 == null) continue;
                return data1;
            }
        } else {
            for (int i = 0; i < mdata.multiData.length; ++i) {
                Polygon polygon = new Polygon();
                data1 = mdata.multiData[mdata.order[i]];
                MultiDimData data2 = i == mdata.multiData.length - 1 ? mdata.multiData[mdata.order[0]] : mdata.multiData[mdata.order[i + 1]];
                if (data1.plotData.isEmpty() || data2.plotData.isEmpty()) continue;
                polygon.addPoint(data1.point.x, g.height - data1.point.y);
                polygon.addPoint(data2.point.x, g.height - data2.point.y);
                polygon.addPoint(this.a_y.startp.x, g.height - this.a_y.startp.y);
                if (!polygon.contains(x, y)) continue;
                return data1;
            }
        }
        return null;
    }

    private boolean selectAxis(Axis axis, CGraphics g, int x, int y, int i) {
        int maxY;
        if (!axis.bshow) {
            return false;
        }
        int nAxis = this.mDataLen[this.dataDim - 1];
        double sector = Math.PI * 2 / (double)nAxis;
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        int width = axis.endp.y - axis.startp.y;
        double angle = sector * (double)i;
        int maxX = centerX + (int)(Math.sin(angle) * (double)width);
        return Line.pickLine(centerX, centerY, maxX, maxY = centerY - (int)(Math.cos(angle) * (double)width), x, y);
    }

    private boolean selectTicker(Axis axis, CGraphics g, int x, int y, int j) {
        if (axis.ticker.label == null || axis.ticker.point == null || !axis.showTitleTicker || !axis.showTicker && !axis.ticker.showline) {
            return false;
        }
        int nAxis = this.mDataLen[this.dataDim - 1];
        double sector = Math.PI * 2 / (double)nAxis;
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        double twidth = 4 + axis.thickness / 2;
        for (int i = axis.columnField.tickerSepSize; i < axis.ticker.point.length; i += axis.columnField.tickerSepSize) {
            int pt2Y;
            double angle2;
            int pt2X;
            int pt1Y;
            double height = axis.ticker.point[i].y - centerY;
            double len = Math.sqrt(Math.pow(twidth, 2.0) + Math.pow(height, 2.0));
            double angle1 = sector * (double)j - Math.atan(twidth / height);
            int pt1X = centerX + (int)(Math.sin(angle1) * len);
            if (!Line.pickLine(pt1X, pt1Y = centerY + (int)(Math.cos(angle1) * len), pt2X = centerX + (int)(Math.sin(angle2 = sector * (double)j) * height), pt2Y = centerY + (int)(Math.cos(angle2) * height), x, g.height - y)) continue;
            return true;
        }
        return false;
    }

    private boolean selectGrid(Axis axis, CGraphics g, int x, int y) {
        if (axis.grid == null || !axis.grid.bshow) {
            return false;
        }
        int step = axis.columnField != null ? axis.columnField.tickerSepSize : 1;
        int nAxis = this.mDataLen[this.dataDim - 1];
        double sector = Math.PI * 2 / (double)nAxis;
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        y = g.height - y;
        int dist = (int)Math.rint(Math.sqrt(Math.pow(centerY - y, 2.0) + Math.pow(centerX - x, 2.0)));
        for (int i = 0; i < axis.grid.coord.length; i += step) {
            int width = axis.grid.coord[i].y - centerY;
            if (this.isSynchronizeRadarAxis() && this.isDrawCircularGrid()) {
                int thick = 1 + (int)Math.ceil((double)axis.gridThickness / 2.0);
                if (dist < width - thick || dist > width + thick) continue;
                return true;
            }
            int curX = -1;
            int curY = -1;
            int lastX = -1;
            int lastY = -1;
            for (int j = 0; j <= nAxis; ++j) {
                double angle = sector * (double)j;
                curX = centerX + (int)(Math.sin(angle) * (double)width);
                curY = centerY + (int)(Math.cos(angle) * (double)width);
                if (lastX != -1 && Line.pickLine(lastX, lastY, curX, curY, x, y)) {
                    return true;
                }
                lastX = curX;
                lastY = curY;
            }
        }
        return false;
    }

    @Override
    public void draw(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.draw_INTERNAL(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
            int nAxis = this.mDataLen[this.dataDim - 1];
            for (int i = 0; i < nAxis; ++i) {
                if (this.isSynchronizeRadarAxis()) {
                    this.drawAxis(g, this.a_y, i);
                    this.drawTicker(g, this.a_y, i);
                    this.drawGrid(g, this.a_y);
                    continue;
                }
                this.drawAxis(g, this.a_y, i);
                this.drawTicker(g, this.a_y, i);
                this.drawGrid(g, this.colDataAxis[i]);
            }
        } else {
            this.draw_INTERNAL(g);
        }
    }

    private void draw_INTERNAL(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        this.border.draw(g);
        if (this.showArea) {
            boolean isTranslucent;
            boolean bl = isTranslucent = this.isTranslucentSupport() && this.dataDim > 1;
            if (isTranslucent) {
                Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
            }
            this.drawArea(this.mData, g, this.mData.point);
            if (isTranslucent) {
                Composite.setOriginalComposite(g.g);
            }
        }
        int nAxis = this.mDataLen[this.dataDim - 1];
        for (int i = 0; i < nAxis; ++i) {
            if (this.isSynchronizeRadarAxis()) {
                this.drawAxis(g, this.a_y, i);
                this.drawTicker(g, this.a_y, i);
                this.drawGrid(g, this.a_y);
                continue;
            }
            this.drawAxis(g, this.colDataAxis[i], i);
            this.drawTicker(g, this.colDataAxis[i], i);
            this.drawGrid(g, this.colDataAxis[i]);
        }
        if (this.showLine) {
            if (this.isAreaCutOffSupport()) {
                this.drawCutOffLine(this.mData, g, this.mData.point);
            } else {
                this.mData.drawLine(g);
            }
        }
        boolean forceShowPoint = false;
        if (this.dataDim > 1) {
            forceShowPoint = this.mDataLen[1] <= 2;
        } else {
            boolean bl = forceShowPoint = this.mDataLen[0] <= 2;
        }
        if (this.showPoint || forceShowPoint) {
            this.mData.drawPoint(g);
        }
        this.dataLineSet.drawDataLineList();
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
    }

    @Override
    public void drawAxis(CGraphics g, Axis axis) {
        int nAxis = this.mDataLen[this.dataDim - 1];
        for (int i = 0; i < nAxis; ++i) {
            if (this.isSynchronizeRadarAxis()) {
                this.drawAxis(g, this.a_y, i);
                continue;
            }
            this.drawAxis(g, this.colDataAxis[i], i);
        }
    }

    @Override
    public void drawTickerForRadar(CGraphics g, Axis axis) {
        for (int i = 0; i < this.colDataAxis.length; ++i) {
            if (this.colDataAxis[i] != axis) continue;
            this.drawTicker(g, axis, i);
            return;
        }
    }

    private void drawAxis(CGraphics g, Axis axis, int i) {
        if (axis.bshow) {
            int nAxis = this.mDataLen[this.dataDim - 1];
            double sector = Math.PI * 2 / (double)nAxis;
            int centerX = axis.startp.x;
            int centerY = g.height - axis.startp.y;
            int width = axis.endp.y - axis.startp.y;
            double angle = sector * (double)i;
            int maxX = centerX + (int)(Math.sin(angle) * (double)width);
            int maxY = centerY - (int)(Math.cos(angle) * (double)width);
            Line.drawLine(g, centerX, centerY, maxX, maxY, Math.abs(axis.thickness), axis.color);
        }
        if (this.a_x.showTicker && i % this.a_x.columnField.sepSize == 0) {
            Dimension dim = this.getLabelOffset(i);
            Point3D pt = new Point3D(this.a_x.ticker.point[i].x + dim.width, this.a_x.ticker.point[i].y - dim.height, 0);
            this.a_x.ticker.label[i].setpos(pt);
            this.a_x.ticker.drawLabel(g, i, this.a_x.ticker.maxp, this.a_x.ticker.minp);
        }
        if (axis.bshow && this.showArrow) {
            this.drawArrow(g, axis, i);
        }
    }

    private void drawArrow(CGraphics g, Axis axis, int j) {
        int thick = Math.abs(axis.thickness);
        int arrh = (int)((double)(thick * 8) / 3.0);
        int arrw = thick * 5;
        int arrd = (int)((double)(thick * 10) / 3.0);
        int y = g.height - (axis.endp.y + thick / 2);
        int[] yp = new int[]{y, y + arrw, y + arrd, y + arrw};
        int[] xp = new int[]{axis.endp.x, axis.endp.x + arrh, axis.endp.x, axis.endp.x - arrh};
        int nAxis = this.mDataLen[this.dataDim - 1];
        double sector = Math.PI * 2 / (double)nAxis;
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        g.setColor(axis.color);
        Polygon polygon = new Polygon();
        for (int i = 0; i < 4; ++i) {
            double width = xp[i] - centerX;
            double height = yp[i] - centerY;
            double len = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
            double angle = sector * (double)j + Math.atan(width / height);
            int ptX = centerX + (int)(Math.sin(angle) * len);
            int ptY = centerY - (int)(Math.cos(angle) * len);
            polygon.addPoint(ptX, ptY);
        }
        g.g.fillPolygon(polygon);
    }

    private void drawTicker(CGraphics g, Axis axis, int idx) {
        int i;
        boolean showText = axis.ticker.showText;
        axis.ticker.showText = false;
        boolean showLine = axis.ticker.showline;
        axis.ticker.showline = false;
        axis.drawTicker(g);
        axis.ticker.showText = showText;
        axis.ticker.showline = showLine;
        int nAxis = this.mDataLen[this.dataDim - 1];
        double sector = Math.PI * 2 / (double)nAxis;
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        double twidth = 4 + axis.thickness / 2;
        for (i = axis.columnField.tickerSepSize; i < axis.ticker.point.length; i += axis.columnField.tickerSepSize) {
            double height = axis.ticker.point[i].y - centerY;
            double len = Math.sqrt(Math.pow(twidth, 2.0) + Math.pow(height, 2.0));
            double angle1 = sector * (double)idx - Math.atan(twidth / height);
            int pt1X = centerX + (int)(Math.sin(angle1) * len);
            int pt1Y = centerY + (int)(Math.cos(angle1) * len);
            double angle2 = sector * (double)idx;
            int pt2X = centerX + (int)(Math.sin(angle2) * height);
            int pt2Y = centerY + (int)(Math.cos(angle2) * height);
            axis.ticker.drawLine(g, pt1X, pt1Y, pt2X, pt2Y);
        }
        if (this.isSynchronizeRadarAxis() && idx != 0) {
            return;
        }
        if (idx == 0) {
            axis.ticker.drawLabel(g, 0, 0.0, centerX, centerY);
        }
        for (i = axis.columnField.sepSize; i < axis.ticker.point.length; i += axis.columnField.sepSize) {
            double angle = sector * (double)idx;
            axis.ticker.drawLabel(g, i, angle, centerX, centerY);
        }
    }

    private void drawArea(MultiDimData mdata, CGraphics g, Point3D p) {
        if (this.isAreaCutOffSupport()) {
            this.drawCutOffArea(mdata, g, p);
            return;
        }
        if (mdata.level < this.dataDim - 1) {
            for (MultiDimData element : mdata.multiData) {
                this.drawArea(element, g, mdata.point.automatic ? p : mdata.point);
            }
        } else {
            Color areaColor = mdata.point.automatic ? p.color : mdata.point.color;
            for (int i = 0; i < mdata.multiData.length; ++i) {
                Polygon polygon = new Polygon();
                MultiDimData data1 = mdata.multiData[mdata.order[i]];
                MultiDimData data2 = i == mdata.multiData.length - 1 ? mdata.multiData[mdata.order[0]] : mdata.multiData[mdata.order[i + 1]];
                if (data1.plotData.isEmpty() || data2.plotData.isEmpty()) continue;
                polygon.addPoint(data1.point.x, data1.point.y);
                polygon.addPoint(data2.point.x, data2.point.y);
                polygon.addPoint(this.a_y.startp.x, this.a_y.startp.y);
                polygon.addPoint(this.a_y.startp.x, this.a_y.startp.y);
                g.setColor(areaColor);
                g.fillPolygon(polygon, data1);
                if (!this.drawDataBorder) continue;
                g.drawLineForArea(polygon, false, false, areaColor.darker());
            }
        }
    }

    private void drawCutOffArea(MultiDimData mdata, CGraphics g, Point3D p) {
        if (mdata.level < this.dataDim - 1) {
            for (MultiDimData element : mdata.multiData) {
                this.drawCutOffArea(element, g, mdata.point.automatic ? p : mdata.point);
            }
        } else {
            Color areaColor = mdata.point.automatic ? p.color : mdata.point.color;
            int centerX = this.a_y.startp.x;
            int centerY = g.height - this.a_y.startp.y;
            int pixelPt = this.a_y.stepsize.interpolatePixel2(this.getAreaCutOffPoint());
            double w = (pixelPt - this.a_y.startp.y) * 2;
            Shape circle = Graphics2DTool.drawCircle(centerX, centerY, w);
            for (int i = 0; i < mdata.multiData.length; ++i) {
                Polygon polygon = new Polygon();
                MultiDimData data1 = mdata.multiData[mdata.order[i]];
                MultiDimData data2 = i == mdata.multiData.length - 1 ? mdata.multiData[mdata.order[0]] : mdata.multiData[mdata.order[i + 1]];
                if (data1.plotData.isEmpty() || data2.plotData.isEmpty()) continue;
                polygon.addPoint(data1.point.x, g.height - data1.point.y);
                polygon.addPoint(data2.point.x, g.height - data2.point.y);
                polygon.addPoint(this.a_y.startp.x, g.height - this.a_y.startp.y);
                polygon.addPoint(this.a_y.startp.x, g.height - this.a_y.startp.y);
                g.g.setColor(areaColor);
                boolean setToolTipsForFlash = g.setPolygonLink(polygon, data1);
                Graphics2DTool.fillIntersect(g.g, polygon, circle);
                if (!setToolTipsForFlash) continue;
                g.resetPolygonLink();
            }
        }
    }

    private void drawCutOffLine(MultiDimData mdata, CGraphics g, Point3D p) {
        if (mdata.level < this.dataDim - 1) {
            for (MultiDimData element : mdata.multiData) {
                this.drawCutOffLine(element, g, mdata.point.automatic ? p : mdata.point);
            }
        } else {
            Color areaColor = mdata.point.automatic ? p.color : mdata.point.color;
            int centerX = this.a_y.startp.x;
            int centerY = g.height - this.a_y.startp.y;
            int pixelPt = this.a_y.stepsize.interpolatePixel2(this.getAreaCutOffPoint());
            double w = (pixelPt - this.a_y.startp.y) * 2;
            Shape circle = Graphics2DTool.drawCircle(centerX, centerY, w);
            Polygon polygon = new Polygon();
            for (int i = 0; i < mdata.multiData.length; ++i) {
                MultiDimData data1 = mdata.multiData[mdata.order[i]];
                if (data1.plotData.isEmpty()) {
                    polygon.addPoint(this.a_y.startp.x, g.height - this.a_y.startp.y);
                    continue;
                }
                polygon.addPoint(data1.point.x, g.height - data1.point.y);
            }
            g.g.setColor(areaColor);
            Graphics2DTool.drawIntersect(g.g, polygon, circle, mdata.getLineThickness());
        }
    }

    private void drawGrid(CGraphics g, Axis axis) {
        if (axis.grid == null || !axis.grid.bshow) {
            return;
        }
        int step = axis.columnField != null ? axis.columnField.tickerSepSize : 1;
        g.setColor(axis.grid.color);
        int nAxis = this.mDataLen[this.dataDim - 1];
        double sector = Math.PI * 2 / (double)nAxis;
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        for (int i = 0; i < axis.grid.coord.length; i += step) {
            int width = axis.grid.coord[i].y - centerY;
            if (this.isSynchronizeRadarAxis() && this.isDrawCircularGrid()) {
                width = width * 2 - (int)Math.ceil((double)axis.gridThickness / 2.0);
                for (int j = 0; j < axis.gridThickness; ++j) {
                    g.drawArc(centerX, centerY, width + j, width + j, 0, 360);
                }
                continue;
            }
            int curX = -1;
            int curY = -1;
            int lastX = -1;
            int lastY = -1;
            for (int j = 0; j <= nAxis; ++j) {
                double angle = sector * (double)j;
                curX = centerX + (int)(Math.sin(angle) * (double)width);
                curY = centerY + (int)(Math.cos(angle) * (double)width);
                if (lastX != -1) {
                    g.fillLine(lastX, lastY, curX, curY, axis.gridThickness);
                }
                lastX = curX;
                lastY = curY;
            }
        }
    }

    @Override
    public void findMinMaxVal() {
        this.setDefaultMinMaxValue(true);
        this.findData(this.mData, -1);
        this.checkMinMaxValue(true);
        this.findMinMaxValColAxis();
    }

    private void findMinMaxValColAxis() {
        this.minvalueA = new double[this.mDataLen[this.dataDim - 1]];
        this.maxvalueA = new double[this.mDataLen[this.dataDim - 1]];
        for (int i = 0; i < this.minvalueA.length; ++i) {
            this.maxvalueA[i] = -1.7976931348623157E308;
            this.minvalueA[i] = Double.MAX_VALUE;
            this.findData(this.mData, i);
        }
    }

    private boolean drawAxis(int axisIdx) {
        return this.maxvalueA[axisIdx] != -1.7976931348623157E308;
    }

    private void findData(MultiDimData data, int findAxis) {
        int noSeries = this.mDataLen[0];
        if (this.dataDim == 1) {
            noSeries = 1;
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        int[] axisPos = this.getAxisPosition();
        for (int i = 0; i < noSeries; ++i) {
            if (this.dataDim == 2) {
                loc[0] = i;
            }
            for (int j = 0; j < noCategory; ++j) {
                double d;
                double val;
                loc[this.dataDim - 1] = j;
                PlotData plotData = data.getPlotData(loc);
                if (plotData.isEmpty()) continue;
                if (findAxis == -1) {
                    double d2;
                    val = plotData.getValue();
                    if (d2 > this.maxvalue) {
                        this.maxvalue = val;
                    }
                    if (!(val < this.minvalue)) continue;
                    this.minvalue = val;
                    continue;
                }
                if (findAxis != axisPos[j]) continue;
                val = plotData.getValue();
                if (d > this.maxvalueA[findAxis]) {
                    this.maxvalueA[findAxis] = val;
                }
                if (!(val < this.minvalueA[findAxis])) continue;
                this.minvalueA[findAxis] = val;
            }
        }
    }

    public Dimension[] getLabelOffset() {
        return this.labelOffset;
    }

    @Override
    protected void copyChartAttributes(Chart _chart) {
        Dimension[] oldLabelOffset;
        super.copyChartAttributes(_chart);
        if (_chart instanceof RadarChart2D && (oldLabelOffset = ((RadarChart2D)_chart).getLabelOffset()) != null) {
            this.setLabelOffset(oldLabelOffset);
        }
    }
}

