/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.stack2d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Overlay2D;
import quadbase.chart.chart2d.types2d.stack2d.StackChart2D;
import quadbase.common.util.internal.QbUtil;

public class PercentColChart2D
extends StackChart2D {
    public PercentColChart2D(Component component, ColData[] colData) {
        super(component, 11, colData);
    }

    public PercentColChart2D(Chart _chart) {
        super(11, _chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        int currenty;
        int m;
        double t;
        int j;
        int lasty1;
        double sum1;
        double totalsum;
        int i;
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        this.minvalue = 0.0;
        this.maxvalue = 100.0;
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize ystep = null;
        StepSize ystep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (doSwapAxis) {
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getCoorddec(this.nCol), false, true);
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                ystep.zeroAxis = ystep.interpolatePixel(0.0);
            }
            this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.nCol], this.axisThickness);
            this.findMinMaxVal2();
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec(), false, true);
            this.a_s.setAxisGridY(ystep2, xmin, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
        } else {
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getCoorddec(this.nCol), false, true);
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                ystep.zeroAxis = ystep.interpolatePixel(0.0);
            }
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.nCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec(), false, true);
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 2];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        boolean zoomXDir = this.isXZoomed && (this.getZoomOption() == 0 || this.getZoomOption() == 2);
        double maxColWidth = (double)(xmax - xmin) * this.getMaxBarWidthRatioToPlotArea();
        if (this.dataDim == 2) {
            double delta = (double)(xmax - xmin) / ((double)noCategory * 2.0);
            double lastx = (double)xmin + delta / 2.0;
            if (delta > maxColWidth) {
                lastx = (double)xmin + (maxColWidth + (delta - maxColWidth) * 2.0 * (double)noCategory) / 2.0;
                delta = maxColWidth;
            }
            for (i = 0; i < noCategory; ++i) {
                double nextx = lastx + delta;
                loc[0] = i;
                totalsum = 0.0;
                sum1 = 0.0;
                lasty1 = ystep.zeroAxis;
                for (j = 0; j < this.mDataLen[1]; ++j) {
                    double d;
                    loc[1] = j;
                    t = this.mData.getValue(loc);
                    if (d < 0.0) {
                        t = -t;
                    }
                    totalsum += t;
                }
                m = (int)((lastx + nextx) / 2.0);
                for (j = 0; j < this.mDataLen[1]; ++j) {
                    double d;
                    loc[1] = j;
                    t = this.mData.getValue(loc);
                    if (d < 0.0) {
                        t = -t;
                    }
                    currenty = ystep.interpolatePixel(totalsum != 0.0 ? (sum1 += t) * 100.0 / totalsum * this.flashRatio : 0.0);
                    this.mData.setPercentage(loc, (float)(totalsum != 0.0 ? t * 100.0 / totalsum : 0.0));
                    this.mData.setAreaCoord((int)lastx, (int)nextx, currenty, lasty1, loc);
                    if (ystep2 != null && this.getComboType() != 3) {
                        this.mData2.setPointCoord(m, ystep2.interpolatePixel(this.mData2.getValue(loc) * this.flashRatio), loc);
                    }
                    lasty1 = currenty;
                }
                if (ystep2 != null && this.getComboType() != 3) {
                    this.mData2.multiData[i].point.automatic = true;
                }
                if (zoomXDir && ((m = this.calculateZoomedX(m)) < this.chartxorigin || m > this.chartxorigin + this.chartwidth)) {
                    m = -100;
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                lastx = nextx + delta;
            }
        } else {
            int noSeries = this.mDataLen[0];
            double delta = (double)(xmax - xmin) / ((double)noCategory * (double)(1 + noSeries));
            double lastx = (double)xmin + delta / 2.0;
            if (delta > maxColWidth) {
                lastx = (double)xmin + (maxColWidth + (delta - maxColWidth) * (double)(1 + noSeries) * (double)noCategory) / 2.0;
                delta = maxColWidth;
            }
            double a = (double)(1 + noSeries) * delta;
            double b = (double)xmin + a / 2.0;
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                for (j = 0; j < noSeries; ++j) {
                    int k;
                    loc[0] = j;
                    double nextx = lastx + delta;
                    lasty1 = ystep.zeroAxis;
                    totalsum = 0.0;
                    sum1 = 0.0;
                    m = (int)(lastx + nextx) / 2;
                    for (k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d < 0.0) {
                            t = -t;
                        }
                        totalsum += t;
                    }
                    for (k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d < 0.0) {
                            t = -t;
                        }
                        this.mData.setPercentage(loc, (float)(totalsum != 0.0 ? t * 100.0 / totalsum : 0.0));
                        currenty = ystep.interpolatePixel(totalsum != 0.0 ? (sum1 += t) * 100.0 / totalsum * this.flashRatio : 0.0);
                        this.mData.setAreaCoord((int)lastx, (int)nextx, currenty, lasty1, loc);
                        if (ystep2 != null && this.getComboType() != 3) {
                            this.mData2.setPointCoord(m, ystep2.interpolatePixel(this.mData2.getValue(loc) * this.flashRatio), loc);
                        }
                        lasty1 = currenty;
                    }
                    lastx = nextx;
                }
                lastx += delta;
                int mm = (int)(a * (double)i + b);
                if (zoomXDir && ((mm = this.calculateZoomedX(mm)) < this.chartxorigin || mm > this.chartxorigin + this.chartwidth)) {
                    mm = -100;
                }
                coord[i] = new Point3D(mm, ystep.zeroAxis, 0);
            }
        }
        if (ystep2 != null && this.getComboType() == 3 && this.getComboSeries() >= 0) {
            Overlay2D.computeChart(this, this.mData2.chart.dataDim, this.mData2.chart.mDataLen, this.mData2, ystep, ystep2, xmin, xmax);
        }
        int colfield = this.mDataMap[this.dataDim - 2];
        this.a_x.set(xmin, ystep.zeroAxis, xmax, ystep.zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, ystep.zeroAxis == ymax, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            Point3D[] coord2 = new Point3D[noCategory];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(coord[i].x, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        } else {
            Point3D[] coord2 = new Point3D[noCategory - 1];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D((coord[i].x + coord[i + 1].x) / 2, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        }
        this.syncColor();
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }
}

