/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.stack2d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Overlay2D;
import quadbase.chart.chart2d.types2d.stack2d.StackChart2D;
import quadbase.common.util.internal.QbUtil;

public class StackColChart2D
extends StackChart2D {
    public StackColChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 4, colData, usedColumns);
    }

    public StackColChart2D(Chart _chart) {
        super(4, _chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        int currenty;
        double t;
        int lasty1;
        int lasty2;
        double sum1;
        double sum2;
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize ystep = null;
        StepSize ystep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxSum();
            if (this.comboType == 0 || this.comboType == 3) {
                this.findMinMaxVal2();
            } else {
                this.findMinMaxCumSum2();
            }
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                ystep.zeroAxis = ystep.interpolatePixel(0.0);
            }
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.yAxisCenter = ystep2.zeroAxis;
            this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
        } else if (doSwapAxis) {
            this.findMinMaxSum();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                ystep.zeroAxis = ystep.interpolatePixel(0.0);
            }
            this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.comboType == 0 || this.comboType == 3) {
                this.findMinMaxVal2();
            } else {
                this.findMinMaxCumSum2();
            }
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.yAxisCenter = ystep2.zeroAxis;
            this.a_s.setAxisGridY(ystep2, xmin, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
        } else {
            this.findMinMaxSum();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                ystep.zeroAxis = ystep.interpolatePixel(0.0);
            }
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                if (this.comboType == 0 || this.comboType == 3) {
                    this.findMinMaxVal2();
                } else {
                    this.findMinMaxCumSum2();
                }
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.yAxisCenter = ystep2.zeroAxis;
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 2];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        boolean zoomXDir = this.isXZoomed && (this.getZoomOption() == 0 || this.getZoomOption() == 2);
        double maxColWidth = (double)(xmax - xmin) * this.getMaxBarWidthRatioToPlotArea();
        if (this.dataDim == 2) {
            double delta = (double)(xmax - xmin) / ((double)noCategory * (1.0 + this.barwidthRatio));
            double delta2 = delta * this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += delta - maxColWidth;
                delta = maxColWidth;
            }
            double lastx = (double)xmin + delta2 / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                double nextx = lastx + delta;
                loc[0] = i;
                double sum = 0.0;
                sum2 = 0.0;
                sum1 = 0.0;
                lasty1 = lasty2 = ystep.zeroAxis;
                int m = (int)(lastx + nextx) / 2;
                if (zoomXDir && ((m = this.calculateZoomedX(m)) < this.chartxorigin || m > this.chartxorigin + this.chartwidth)) {
                    m = -100;
                }
                for (int j = 0; j < this.mDataLen[1]; ++j) {
                    double d;
                    loc[1] = j;
                    t = this.mData.getValue(loc) * this.flashRatio;
                    if (d >= 0.0) {
                        sum1 += t;
                        if (this.isDataLimitAtAxisScale() && sum1 > this.a_y.maxScale) {
                            sum1 = this.a_y.maxScale;
                        }
                        currenty = ystep.interpolatePixel(sum1);
                        this.mData.setAreaCoord((int)lastx, (int)nextx, currenty, lasty1, loc, zoomXDir);
                        lasty1 = currenty;
                    } else {
                        sum2 += t;
                        if (this.isDataLimitAtAxisScale() && sum2 < this.a_y.minScale) {
                            sum2 = this.a_y.minScale;
                        }
                        currenty = ystep.interpolatePixel(sum2);
                        this.mData.setAreaCoord((int)lastx, (int)nextx, currenty, lasty2, loc, zoomXDir);
                        lasty2 = currenty;
                    }
                    if (ystep2 == null || this.isOverlayCombo() || this.mData2 == null) continue;
                    sum = this.comboType == 0 ? this.mData2.getValue(loc) * this.flashRatio : (sum += this.mData2.getValue(loc) * this.flashRatio);
                    if (this.isDataLimitAtAxisScale()) {
                        if (sum > this.a_s.maxScale) {
                            sum = this.a_s.maxScale;
                        } else if (sum < this.a_s.minScale) {
                            sum = this.a_s.minScale;
                        }
                    }
                    this.mData2.setPointCoord(m, ystep2.interpolatePixel(sum), loc);
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                lastx = nextx + delta2;
            }
        } else {
            int noSeries = this.mDataLen[0];
            double delta = (double)(xmax - xmin) / ((double)noCategory * (this.barwidthRatio + (double)noSeries));
            double delta2 = delta * this.barwidthRatio;
            double newBarWidthRatio = this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += (delta - maxColWidth) * (double)noSeries;
                delta = maxColWidth;
                newBarWidthRatio = delta2 / delta;
            }
            double lastx = (double)xmin + delta2 / 2.0;
            double a = (newBarWidthRatio + (double)noSeries) * delta;
            double b = lastx + (double)noSeries * delta / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                loc[1] = i;
                for (int j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nextx = lastx + delta;
                    lasty1 = lasty2 = ystep.zeroAxis;
                    sum2 = 0.0;
                    sum1 = 0.0;
                    int m = (int)((lastx + nextx) / 2.0);
                    if (zoomXDir && ((m = this.calculateZoomedX(m)) < this.chartxorigin || m > this.chartxorigin + this.chartwidth)) {
                        m = -100;
                    }
                    for (int k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d >= 0.0) {
                            sum1 += t;
                            if (this.isDataLimitAtAxisScale() && sum1 > this.a_y.maxScale) {
                                sum1 = this.a_y.maxScale;
                            }
                            currenty = ystep.interpolatePixel(sum1);
                            this.mData.setAreaCoord((int)lastx, (int)nextx, currenty, lasty1, loc, zoomXDir);
                            lasty1 = currenty;
                        } else {
                            sum2 += t;
                            if (this.isDataLimitAtAxisScale() && sum2 < this.a_y.minScale) {
                                sum2 = this.a_y.minScale;
                            }
                            currenty = ystep.interpolatePixel(sum2);
                            this.mData.setAreaCoord((int)lastx, (int)nextx, currenty, lasty2, loc, zoomXDir);
                            lasty2 = currenty;
                        }
                        if (ystep2 == null || this.isOverlayCombo()) continue;
                        double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(m, ystep2.interpolatePixel(value), loc);
                    }
                    lastx = nextx;
                }
                lastx += delta2;
                int tt = (int)(a * (double)i + b);
                if (zoomXDir && ((tt = this.calculateZoomedX(tt)) < this.chartxorigin || tt > this.chartxorigin + this.chartwidth)) {
                    tt = -100;
                }
                coord[i] = new Point3D(tt, ystep.zeroAxis, 0);
            }
        }
        if (ystep2 != null && this.isOverlayCombo()) {
            Overlay2D.computeChart(this, this.mData2.chart.dataDim, this.mData2.chart.mDataLen, this.mData2, ystep, ystep2, xmin, xmax);
        }
        int colfield = this.mDataMap[this.dataDim - 2];
        this.a_x.set(xmin, ystep.zeroAxis, xmax, ystep.zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, ystep.zeroAxis == ymax, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            Point3D[] coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(coord[i].x, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        } else {
            Point3D[] coord2 = new Point3D[noCategory - 1];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D((coord[i].x + coord[i + 1].x) / 2, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        }
        this.syncColor();
        if (this.cgraphics == null) {
            this.cgraphics = g;
        }
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }
}

