/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.DataLineSet;
import quadbase.chart.ExportChart;
import quadbase.chart.FaceData;
import quadbase.chart.HorzVertLine;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.chart3d.Area3D;
import quadbase.chart.chart3d.Axis3D;
import quadbase.chart.chart3d.DataLineSet3D;
import quadbase.chart.chart3d.ExportChart3D;
import quadbase.chart.chart3d.Grid3D;
import quadbase.chart.chart3d.MultiDimData3D;
import quadbase.chart.chart3d.Ticker3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.HiddenSurface;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.Point_2D;
import quadbase.util.Point_3D;
import quadbase.util.PolyLine;
import quadbase.util.internal.Composite;
import quadbase.util.internal.RenderingChart;

public abstract class Chart3D
extends Chart {
    static final float DELTA = 0.1f;
    public HiddenSurface hiddenSurface;
    public Space space;
    public int drawType = 1;
    public float lookfrom_x = 1000.0f;
    public float lookfrom_y = 1000.0f;
    public float lookfrom_z = 2000.0f;
    public float lookto_x = 500.0f;
    public float lookto_y = 500.0f;
    public float lookto_z = 500.0f;
    public float xscale = 1.0f;
    public float yscale = 1.0f;
    public float zscale = 1.0f;
    public float zoomfactor = 1000.0f;
    public float space_ratio;
    public float spaceTranslate_x = 0.0f;
    public float spaceTranslate_y = 0.0f;
    public float spaceTranslate_z = 0.0f;
    public float lightpos_x = 400.0f;
    public float lightpos_y = 1200.0f;
    public float lightpos_z = 800.0f;
    public float intensity_r = 1.5f;
    public float intensity_g = 1.5f;
    public float intensity_b = 1.5f;
    public float ambient_r = 0.0f;
    public float ambient_g = 0.0f;
    public float ambient_b = 0.0f;
    public double animateSpeed = 0.05235987755982988;
    public int wall_xlength;
    public int wall_ylength;
    public int wall_zlength;

    public Chart3D(int _chartType, Chart _chart) {
        super(_chartType, false, _chart);
        this.setDataBorder(this.getDataBorder());
        this.newSurface();
    }

    public Chart3D(Component component, int _chartType, ColData[] _colData) {
        super(component, _chartType, false, _colData);
        this.newSurface();
    }

    public Chart3D(Component component, int _chartType, ColData[] _colData, boolean[] usedColumnsList) {
        super(component, _chartType, false, _colData, usedColumnsList);
        this.newSurface();
    }

    @Override
    public ExportChart createExportChart() {
        return new ExportChart3D(this);
    }

    @Override
    public Image exportImageObject(int w, int h) {
        ExportChart3D exportchart = new ExportChart3D(this);
        return exportchart.createChartImage(w, h, this.component, false, false);
    }

    @Override
    public float getlookfrom_x() {
        return this.lookfrom_x;
    }

    @Override
    public float getlookto_x() {
        return this.lookto_x;
    }

    @Override
    public float getlightpos_x() {
        return this.lightpos_x;
    }

    @Override
    public float getlookfrom_y() {
        return this.lookfrom_y;
    }

    @Override
    public float getlookto_y() {
        return this.lookto_y;
    }

    @Override
    public float getlightpos_y() {
        return this.lightpos_y;
    }

    @Override
    public float getlookfrom_z() {
        return this.lookfrom_z;
    }

    @Override
    public float getlookto_z() {
        return this.lookto_z;
    }

    @Override
    public float getlightpos_z() {
        return this.lightpos_z;
    }

    @Override
    public void setlookfrom_x(float x) {
        this.lookfrom_x = x;
    }

    @Override
    public void setlookfrom_y(float y) {
        this.lookfrom_y = y;
    }

    @Override
    public void setlookfrom_z(float z) {
        this.lookfrom_z = z;
    }

    @Override
    public Object getSpace() {
        return this.space;
    }

    @Override
    public Object gethiddenSurface() {
        return this.hiddenSurface;
    }

    @Override
    public Area newArea() {
        Area3D newAr = new Area3D();
        return newAr;
    }

    @Override
    public Area newArea(Color c) {
        Area3D newAr = new Area3D(c);
        return newAr;
    }

    @Override
    public Area copyArea(Area ar) {
        Area3D newArea = new Area3D();
        Area newAr = ar.copyArea(newArea);
        return newAr;
    }

    @Override
    public Axis copyAxis(Axis ax) {
        Axis3D newAxis = new Axis3D(ax.orient, ax.title.copy(), ax.bshow);
        Grid3D newGrid = new Grid3D(ax.grid.orient, ax.grid.bshow);
        Ticker3D newTicker = new Ticker3D(newAxis);
        Axis newAx = ax.copy(newAxis, newGrid, newTicker);
        return newAx;
    }

    @Override
    protected DataLineSet newDataLineSet() {
        return new DataLineSet3D(this);
    }

    @Override
    protected DataLineSet newDataLineSet(DataLineSet oldSet) {
        return new DataLineSet3D(this, oldSet);
    }

    @Override
    public void copyChartAttributes3D(Chart _chart) {
        if (_chart instanceof Chart3D) {
            this.drawType = ((Chart3D)_chart).drawType;
            this.lookfrom_x = ((Chart3D)_chart).lookfrom_x;
            this.lookfrom_y = ((Chart3D)_chart).lookfrom_y;
            this.lookfrom_z = ((Chart3D)_chart).lookfrom_z;
            this.lookto_x = ((Chart3D)_chart).lookto_x;
            this.lookto_y = ((Chart3D)_chart).lookto_y;
            this.lookto_z = ((Chart3D)_chart).lookto_z;
            this.xscale = ((Chart3D)_chart).xscale;
            this.yscale = ((Chart3D)_chart).yscale;
            this.zscale = ((Chart3D)_chart).zscale;
            this.spaceTranslate_x = ((Chart3D)_chart).spaceTranslate_x;
            this.spaceTranslate_y = ((Chart3D)_chart).spaceTranslate_y;
            this.spaceTranslate_z = ((Chart3D)_chart).spaceTranslate_z;
            this.lightpos_x = ((Chart3D)_chart).lightpos_x;
            this.lightpos_y = ((Chart3D)_chart).lightpos_y;
            this.lightpos_z = ((Chart3D)_chart).lightpos_z;
            this.intensity_r = ((Chart3D)_chart).intensity_r;
            this.intensity_g = ((Chart3D)_chart).intensity_g;
            this.intensity_b = ((Chart3D)_chart).intensity_b;
            this.ambient_r = ((Chart3D)_chart).ambient_r;
            this.ambient_g = ((Chart3D)_chart).ambient_g;
            this.ambient_b = ((Chart3D)_chart).ambient_b;
            this.zoomfactor = ((Chart3D)_chart).zoomfactor;
            this.animateSpeed = ((Chart3D)_chart).animateSpeed;
            this.colorSpectrum = ((Chart3D)_chart).colorSpectrum;
        }
    }

    @Override
    public MultiDimData setMultiDimData(int lv, Chart _chart, MultiDimData p) {
        MultiDimData3D newMDD = new MultiDimData3D(lv, _chart, p);
        return newMDD;
    }

    @Override
    public Axis setAxis(int direction, CString name, boolean showgrid) {
        Axis3D newAxis = new Axis3D(direction, name, showgrid);
        return newAxis;
    }

    @Override
    public void reCreateTable() {
        this.makeTable(this.mData, this.mData2, false);
        this.remakeTable = false;
        if (this.hiddenSurface != null) {
            this.hiddenSurface.reset();
        }
    }

    @Override
    public void setFieldOrder(int dimension, int[] order, boolean reorderColData) {
        if (reorderColData) {
            this.colData[this.mDataMap[dimension]].setFieldOrder(order);
        }
        this.mData.reorder(order, dimension);
        if (this.showLegend2()) {
            this.mData2.reorder(order, dimension);
        }
        if (this.legend != null) {
            this.legend.init = false;
        }
        if (this.legend2 != null) {
            this.legend2.init = false;
        }
        if (this.hiddenSurface != null) {
            this.hiddenSurface.reset();
        }
    }

    @Override
    public void setRandomColor3D(Color random1) {
        if (this.space != null && !this.is2DChart && !Chart3D.isCircularChart(this.chartType)) {
            this.set3DSurfaceColor(random1);
            this.mData.randomColor(this.mData.point);
            if (this.showLegend2()) {
                this.mData2.randomColor(this.mData2.point);
            }
        }
    }

    @Override
    public void mddSetColor(MultiDimData a, MultiDimData b) {
        a.area.setColor(this.space, b.area.areaColor);
    }

    @Override
    public void prepareLabel(boolean bcreate) {
        if (bcreate) {
            this.topLabels.removeAllElements();
        } else {
            this.toplabel_count = 0;
        }
        if (bcreate) {
            this.topLabels2.removeAllElements();
        } else {
            this.toplabel2_count = 0;
        }
        if (!this.is2DChart) {
            Face f;
            Vertex v4;
            Vertex v3;
            Vertex v2;
            Vertex v1;
            CString s;
            int i;
            if (this.chartType == 11 || !this.isStackType()) {
                this.mData.prepare_label3D(bcreate);
            } else {
                this.mData.prepare_stacklabel3D(bcreate);
            }
            if (this.showLegend2()) {
                this.mData2.prepare_secondary_label3D(bcreate);
            }
            if (this.hiddenSurface.treeRoot == null) {
                for (i = 0; i < this.topLabels.size(); ++i) {
                    s = (CString)this.topLabels.elementAt(i);
                    v1 = new Vertex((float)s.pos.x - 0.1f, (float)s.pos.y + 0.1f, s.pos.z, this.space);
                    v2 = new Vertex((float)s.pos.x + 0.1f, (float)s.pos.y + 0.1f, s.pos.z, this.space);
                    v3 = new Vertex((float)s.pos.x + 0.1f, (float)s.pos.y - 0.1f, s.pos.z, this.space);
                    v4 = new Vertex((float)s.pos.x - 0.1f, (float)s.pos.y - 0.1f, s.pos.z, this.space);
                    f = new Face(v1, v2, v3, v4, Color.black, this.space, s);
                    f.bshow = false;
                    f = new Face(v4, v3, v2, v1, Color.black, this.space, s);
                    f.bshow = false;
                }
            }
            if (this.showLegend2()) {
                this.mData2.prepare_secondary_label3D(bcreate);
                if (this.hiddenSurface.treeRoot == null) {
                    for (i = 0; i < this.topLabels2.size(); ++i) {
                        s = (CString)this.topLabels2.elementAt(i);
                        v1 = new Vertex((float)s.pos.x - 0.1f, (float)s.pos.y + 0.1f, s.pos.z, this.space);
                        v2 = new Vertex((float)s.pos.x + 0.1f, (float)s.pos.y + 0.1f, s.pos.z, this.space);
                        v3 = new Vertex((float)s.pos.x + 0.1f, (float)s.pos.y - 0.1f, s.pos.z, this.space);
                        v4 = new Vertex((float)s.pos.x - 0.1f, (float)s.pos.y - 0.1f, s.pos.z, this.space);
                        f = new Face(v1, v2, v3, v4, Color.black, this.space, s);
                        f.bshow = false;
                        f = new Face(v4, v3, v2, v1, Color.black, this.space, s);
                        f.bshow = false;
                    }
                }
            }
        }
    }

    @Override
    public void setAxisColor(Color color) {
        if (!this.is2DChart) {
            this.wallbackground.setColor(color);
            for (int i = 0; i < 3; ++i) {
                this.axis[i].setWallColor(this.space, color);
            }
        }
    }

    @Override
    public void setAxisState(int _axis, boolean state) {
        this.axis[_axis].bshow = state;
        if (!this.is2DChart && this.axis[_axis].getFaceList() != null && this.axis[_axis].getFaceList(0) != null) {
            for (int i = 0; i < 6; ++i) {
                Face tempFace = (Face)this.axis[_axis].getFaceList(i);
                tempFace.bshow = state;
            }
        }
    }

    @Override
    public boolean inside(int x, int y) {
        if (!this.isChartVisible()) {
            return false;
        }
        this.computeBoundingBox();
        return x >= this.xboundmin && x <= this.xboundmax && y >= this.yboundmin && y <= this.yboundmax;
    }

    private String getInformation(FaceData faceData) {
        this.pickdata.clear();
        this.pickdata.faceData = faceData;
        return "chart surface";
    }

    @Override
    public Object insideSelect(CGraphics g, int x, int y, Object target, int i, String[] stable) {
        if (!this.is2DChart) {
            Object oldtarget = null;
            if (!Chart3D.isCircularChart(this.chartType)) {
                for (i = 0; i < 3; ++i) {
                    if (!this.axis[i].grid.select(g, x, y)) continue;
                    this.targetName = stable[i] + " grid";
                    oldtarget = this.axis[i].grid;
                    break;
                }
                for (i = 0; i < 4; ++i) {
                    if (this.axis[i].ticker == null || !this.axis[i].ticker.showText || !this.axis[i].ticker.select(g, x, y)) continue;
                    this.targetName = stable[i] + " ticker";
                    oldtarget = this.axis[i].ticker;
                    break;
                }
            }
            if (this.drawType != 0 && (target = this.hiddenSurface.select(this, x, y)) != null) {
                if (!(target instanceof Axis)) {
                    if (target instanceof MultiDimData) {
                        this.targetName = this.getInformation((MultiDimData)target);
                        return target;
                    }
                    if (target instanceof DataLine) {
                        this.targetName = ((DataLine)target).getTitle();
                        if (target instanceof ControlLine) {
                            this.targetName = this.targetName + " " + ((ControlLine)target).getCalculatedValue();
                        } else if (target instanceof HorzVertLine) {
                            this.targetName = this.targetName + " " + ((HorzVertLine)target).getLineValue();
                        }
                        return target;
                    }
                    if (target instanceof FaceData && this.chartType == 12) {
                        this.targetName = this.getInformation((FaceData)target);
                        return target;
                    }
                } else {
                    if (oldtarget == null) {
                        switch (((Axis)target).orient) {
                            case 0: {
                                this.targetName = "XY wall";
                                break;
                            }
                            case 1: {
                                this.targetName = "YZ wall";
                                break;
                            }
                            default: {
                                this.targetName = "XZ wall";
                            }
                        }
                        return target;
                    }
                    return oldtarget;
                }
            }
            if (oldtarget != null) {
                return oldtarget;
            }
        }
        return null;
    }

    @Override
    public CString selectTopLabel(CGraphics g, int x, int y) {
        if (this.showTopValue && !this.is2DChart) {
            Vertex v = new Vertex();
            for (int i = 0; i < this.topLabels.size(); ++i) {
                CString s = (CString)this.topLabels.elementAt(i);
                int oldx = s.pos.x;
                v.x = oldx;
                int oldy = s.pos.y;
                v.y = oldy;
                int oldz = s.pos.z;
                v.z = oldz;
                this.space.transform(v);
                s.pos.x = v.screen_x;
                s.pos.y = g.height - v.screen_y;
                boolean b = s.select(g, x, y);
                s.pos.x = oldx;
                s.pos.y = oldy;
                s.pos.z = oldz;
                if (!b) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public CString selectTopLabel2(CGraphics g, int x, int y) {
        if (this.getTopValueState2() && !this.is2DChart) {
            Vertex v = new Vertex();
            for (int i = 0; i < this.topLabels2.size(); ++i) {
                CString s = (CString)this.topLabels2.elementAt(i);
                int oldx = s.pos.x;
                v.x = oldx;
                int oldy = s.pos.y;
                v.y = oldy;
                int oldz = s.pos.z;
                v.z = oldz;
                this.space.transform(v);
                s.pos.x = v.screen_x;
                s.pos.y = g.height - v.screen_y;
                boolean b = s.select(g, x, y);
                s.pos.x = oldx;
                s.pos.y = oldy;
                s.pos.z = oldz;
                if (!b) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public void calcForDraw(int height) {
        this.chartwidth = this.chartheight = Math.min(this.chartheight, this.chartwidth);
    }

    @Override
    public void doNewSurface() {
        if (this.hiddenSurface != null && this.hiddenSurface.treeRoot == null) {
            this.newSurface();
        }
    }

    @Override
    public void doComputeDataLines() {
        this.dataLineSet.computeDataLines(!this.is2DChart && this.hiddenSurface.treeRoot == null);
    }

    @Override
    public void drawLabel3D(CGraphics g) {
        int oldz;
        int oldy;
        int oldx;
        CString s;
        int i;
        Vertex v;
        if (this.showTopValue) {
            v = new Vertex();
            for (i = 0; i < this.topLabels.size(); ++i) {
                s = (CString)this.topLabels.elementAt(i);
                oldx = s.pos.x;
                v.x = oldx;
                oldy = s.pos.y;
                v.y = oldy;
                oldz = s.pos.z;
                v.z = oldz;
                this.space.transform(v);
                s.pos.x = v.screen_x;
                s.pos.y = g.height - v.screen_y;
                if (g.g instanceof IFlashGraphics) {
                    ((IFlashGraphics)((Object)g.g)).setTopLabels();
                    s.draw(g);
                    ((IFlashGraphics)((Object)g.g)).resetTopLabels();
                } else {
                    s.draw(g);
                }
                s.pos.x = oldx;
                s.pos.y = oldy;
                s.pos.z = oldz;
            }
        }
        if (this.getTopValueState2()) {
            v = new Vertex();
            for (i = 0; i < this.topLabels2.size(); ++i) {
                s = (CString)this.topLabels2.elementAt(i);
                oldx = s.pos.x;
                v.x = oldx;
                oldy = s.pos.y;
                v.y = oldy;
                oldz = s.pos.z;
                v.z = oldz;
                this.space.transform(v);
                s.pos.x = v.screen_x;
                s.pos.y = g.height - v.screen_y;
                if (g.g instanceof IFlashGraphics) {
                    ((IFlashGraphics)((Object)g.g)).setTopLabels();
                    s.draw(g);
                    ((IFlashGraphics)((Object)g.g)).resetTopLabels();
                } else {
                    s.draw(g);
                }
                s.pos.x = oldx;
                s.pos.y = oldy;
                s.pos.z = oldz;
            }
        }
    }

    public void drawLabel3D(CGraphics g, CString s) {
        Vertex v = new Vertex();
        int oldx = s.pos.x;
        v.x = oldx;
        int oldy = s.pos.y;
        v.y = oldy;
        int oldz = s.pos.z;
        v.z = oldz;
        this.space.transform(v);
        s.pos.x = v.screen_x;
        s.pos.y = g.height - v.screen_y;
        if (g.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g.g)).setTopLabels();
            s.draw(g);
            ((IFlashGraphics)((Object)g.g)).resetTopLabels();
        } else {
            s.draw(g);
        }
        s.pos.x = oldx;
        s.pos.y = oldy;
        s.pos.z = oldz;
    }

    @Override
    public void drawLineList(CGraphics cgraphics) {
        Graphics g = cgraphics.g;
        for (int i = 0; i < this.lineList.size(); ++i) {
            Vertex currv;
            int j;
            PolyLine line = (PolyLine)this.lineList.elementAt(i);
            int len = line.getPoints().size();
            if (len < 2) continue;
            g.setColor(line.getColor());
            if (line.getPoints().elementAt(0) instanceof Point_2D) {
                Point currp;
                if (line.isFillArea()) {
                    Polygon polygon = new Polygon();
                    for (j = 0; j < len; ++j) {
                        currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j));
                        polygon.addPoint(currp.x, currp.y);
                    }
                    cgraphics.fillPolygon(polygon, null);
                    continue;
                }
                Point lastp = this.transformCoord((Point_2D)line.getPoints().firstElement());
                for (int j2 = 1; j2 < len; ++j2) {
                    currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j2));
                    cgraphics.fillLine(lastp.x, lastp.y, currp.x, currp.y, line.getThickness(), line.getLineStyle());
                    if (line.isArrowAtStartPointVisible() && j2 == 1) {
                        cgraphics.drawArrow(currp.x, currp.y, lastp.x, lastp.y, line.getThickness());
                    }
                    if (line.isArrowAtEndPointVisible() && j2 == len - 1) {
                        cgraphics.drawArrow(lastp.x, lastp.y, currp.x, currp.y, line.getThickness());
                    }
                    lastp = currp;
                }
                continue;
            }
            if (line.isFillArea()) {
                Polygon polygon = new Polygon();
                for (j = 0; j < len; ++j) {
                    currv = new Vertex((Point_3D)line.getPoints().elementAt(j));
                    this.space.transform(currv);
                    polygon.addPoint(currv.screen_x, this.winHeight - currv.screen_y);
                }
                cgraphics.fillPolygon(polygon, null);
                continue;
            }
            Vertex lastv = new Vertex((Point_3D)line.getPoints().firstElement());
            this.space.transform(lastv);
            for (int j3 = 1; j3 < len; ++j3) {
                currv = new Vertex((Point_3D)line.getPoints().elementAt(j3));
                this.space.transform(currv);
                cgraphics.fillLine(lastv.screen_x, this.winHeight - lastv.screen_y, currv.screen_x, this.winHeight - currv.screen_y, line.getThickness(), line.getLineStyle());
                if (line.isArrowAtStartPointVisible() && j3 == 1) {
                    cgraphics.drawArrow(currv.screen_x, this.winHeight - currv.screen_y, lastv.screen_x, this.winHeight - lastv.screen_y, line.getThickness());
                }
                if (line.isArrowAtEndPointVisible() && j3 == len - 1) {
                    cgraphics.drawArrow(lastv.screen_x, this.winHeight - lastv.screen_y, currv.screen_x, this.winHeight - currv.screen_y, line.getThickness());
                }
                lastv = currv;
            }
        }
    }

    @Override
    protected PolyLine selectLineList(int x, int y) {
        for (int i = 0; i < this.lineList.size(); ++i) {
            Vertex currv;
            int j;
            PolyLine line = (PolyLine)this.lineList.elementAt(i);
            if (line.getPoints().size() < 2) continue;
            if (line.getPoints().elementAt(0) instanceof Point_2D) {
                Point currp;
                if (line.isFillArea()) {
                    Polygon polygon = new Polygon();
                    for (j = 0; j < line.getPoints().size(); ++j) {
                        currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j));
                        polygon.addPoint(currp.x, this.winHeight - currp.y);
                    }
                    if (!polygon.contains(x, y)) continue;
                    return line;
                }
                Point lastp = this.transformCoord((Point_2D)line.getPoints().firstElement());
                lastp.y = this.winHeight - lastp.y;
                for (int j2 = 1; j2 < line.getPoints().size(); ++j2) {
                    currp = this.transformCoord((Point_2D)line.getPoints().elementAt(j2));
                    currp.y = this.winHeight - currp.y;
                    if (Line.pickLine(currp.x, currp.y, lastp.x, lastp.y, x, y)) {
                        return line;
                    }
                    lastp = currp;
                }
                continue;
            }
            if (line.isFillArea()) {
                Polygon polygon = new Polygon();
                for (j = 0; j < line.getPoints().size(); ++j) {
                    currv = new Vertex((Point_3D)line.getPoints().elementAt(j));
                    this.space.transform(currv);
                    polygon.addPoint(currv.screen_x, currv.screen_y);
                }
                if (!polygon.contains(x, y)) continue;
                return line;
            }
            Vertex lastv = new Vertex((Point_3D)line.getPoints().firstElement());
            this.space.transform(lastv);
            for (int j3 = 1; j3 < line.getPoints().size(); ++j3) {
                currv = new Vertex((Point_3D)line.getPoints().elementAt(j3));
                this.space.transform(currv);
                if (Line.pickLine(currv.screen_x, currv.screen_y, lastv.screen_x, lastv.screen_y, x, y)) {
                    return line;
                }
                lastv = currv;
            }
        }
        return null;
    }

    @Override
    public void draw3D(CGraphics g, int ctype) {
        if (g.g instanceof IFlashGraphics) {
            switch (this.chartType) {
                case 6: {
                    this.draw_3D(g, ctype);
                    break;
                }
                default: {
                    for (int i = 0; i < this.flashFrameCount; ++i) {
                        ((IFlashGraphics)((Object)g.g)).setFrame(i);
                        this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                        this.hiddenSurface.reset();
                        this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                        this.updateBackground();
                        this.doComputeDataLines();
                        this.draw_3D(g, ctype);
                    }
                    ((IFlashGraphics)((Object)g.g)).setFrame(-1);
                    break;
                }
            }
        } else {
            this.draw_3D(g, ctype);
        }
    }

    public void draw_3D(CGraphics g, int ctype) {
        g.chart = this;
        if (this.drawType != 0 || this.hiddenSurface.treeRoot != null) {
            if (this.space == null) {
                this.calculatePosition(g.g, g.component, this.winWidth, this.winHeight);
            }
            boolean isTransparent = this.isTranslucentSupport();
            this.hiddenSurface.draw(g, this.space);
            if (isTransparent) {
                Composite.setOriginalComposite(g.g);
            }
        } else {
            this.space.transform();
            if (this.drawType == 0) {
                this.hiddenSurface.draw(g, this.space);
            }
            if (!this.isStackType() && this.showLegend2()) {
                if (this.comboType == 0) {
                    this.mData2.drawLine(g);
                } else {
                    this.mData2.drawArea(g);
                }
            }
            switch (ctype) {
                case 1: {
                    this.mData.drawArea(g);
                    if (this.isStackType() && this.showLegend2()) {
                        this.mData2.drawFace(g);
                    }
                    this.drawAllAxis(g);
                    break;
                }
                case 2: {
                    this.mData.drawFace(g);
                    this.drawAllAxis(g);
                    break;
                }
                case 3: {
                    this.mData.drawFace(g);
                    break;
                }
                case 4: {
                    this.mData.drawLine(g);
                    this.drawAllAxis(g);
                }
            }
        }
        this.dataLineSet.drawDataLineList();
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (ctype == 3 || ctype == 1 || this.chartType == 8) {
            this.drawLabel(g);
        }
        boolean isOutsidePlotAreaText = CString.isOutsidePlotAreaText();
        CString.setOutsidePlotAreaText(true);
        this.mainTitle.draw(g);
        CString.setOutsidePlotAreaText(isOutsidePlotAreaText);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
    }

    @Override
    public void drawAllAxis(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g.g)).setAxes();
        }
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        for (int i = 0; i < 3; ++i) {
            if (this.showWallFrame) {
                this.axis[i].drawFrameWall(g);
            }
            this.axis[i].draw(g, true);
            this.axis[i].grid.draw(g, false, this.axis[i].skipGridOffset, this.axis[i].columnField != null ? this.axis[i].columnField.tickerSepSize : 1);
        }
        if (this.showLegend2()) {
            this.a_s.draw(g, true);
        }
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (g.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g.g)).resetAxes();
        }
    }

    @Override
    public void draw2D(CGraphics g, int ctype) {
    }

    @Override
    public double getAnimateSpeed() {
        return this.animateSpeed;
    }

    @Override
    public void setAnimateSpeed(double speed) {
        this.animateSpeed = speed;
    }

    @Override
    public void setDataBorder(boolean needBorder) {
        super.setDataBorder(needBorder);
        if (needBorder) {
            if (this.drawType == 1) {
                this.drawType = 2;
            }
            if (this.drawType == 3) {
                this.drawType = 4;
            }
        } else {
            if (this.drawType == 2) {
                this.drawType = 1;
            }
            if (this.drawType == 4) {
                this.drawType = 3;
            }
        }
    }

    @Override
    public int get3DDrawType() {
        return this.drawType;
    }

    @Override
    public void set3DDrawType(int drawType) {
        if (this.chartType == 12 && drawType == 0 && this.hiddenSurface != null) {
            this.hiddenSurface.reset();
        }
        this.drawType = drawType;
    }

    @Override
    public float[] getViewPoint() {
        float[] view = new float[]{this.lookfrom_x, this.lookfrom_y, this.lookfrom_z, this.lookto_x, this.lookto_y, this.lookto_z};
        return view;
    }

    @Override
    public void setViewPoint(float[] view) {
        this.lookfrom_x = view[0];
        this.lookfrom_y = view[1];
        this.lookfrom_z = view[2];
        this.lookto_x = view[3];
        this.lookto_y = view[4];
        this.lookto_z = view[5];
    }

    @Override
    public Point_3D[] getViewDirection() {
        Point_3D p1 = new Point_3D(this.lookfrom_x / 1000.0f, this.lookfrom_y / 1000.0f, this.lookfrom_z / 1000.0f);
        Point_3D p2 = new Point_3D(this.lookto_x / 1000.0f, this.lookto_y / 1000.0f, this.lookto_z / 1000.0f);
        return new Point_3D[]{p1, p2};
    }

    @Override
    public void setViewDirection(Point_3D[] view) {
        if (view.length != 2) {
            throw new IllegalArgumentException("Invalid view direction array size");
        }
        this.lookfrom_x = view[0].getX() * 1000.0f;
        this.lookfrom_y = view[0].getY() * 1000.0f;
        this.lookfrom_z = view[0].getZ() * 1000.0f;
        this.lookto_x = view[1].getX() * 1000.0f;
        this.lookto_y = view[1].getY() * 1000.0f;
        this.lookto_z = view[1].getZ() * 1000.0f;
        if (this.space != null) {
            this.space.lookat(this.lookfrom_x, this.lookfrom_y, this.lookfrom_z, this.getlookto_x(), this.getlookto_y(), this.getlookto_z());
        }
    }

    @Override
    public float[] getViewTranslate() {
        float[] farray = new float[]{this.spaceTranslate_x, this.spaceTranslate_y, this.spaceTranslate_z};
        return farray;
    }

    @Override
    public void setViewTranslate(float[] trans) {
        this.spaceTranslate_x = trans[0];
        this.spaceTranslate_y = trans[1];
        this.spaceTranslate_z = trans[2];
    }

    @Override
    public Point_3D getViewTranslation() {
        return new Point_3D(this.spaceTranslate_x / 1000.0f, this.spaceTranslate_y / 1000.0f, this.spaceTranslate_z / 1000.0f);
    }

    @Override
    public void setViewTranslation(Point_3D p) {
        this.spaceTranslate_x = p.getX() * 1000.0f;
        this.spaceTranslate_y = p.getY() * 1000.0f;
        this.spaceTranslate_z = p.getZ() * 1000.0f;
    }

    @Override
    public float[] getLightPos() {
        float[] light = new float[]{this.lightpos_x, this.lightpos_y, this.lightpos_z};
        return light;
    }

    @Override
    public void setLightPos(float[] light) {
        this.lightpos_x = light[0];
        this.lightpos_y = light[1];
        this.lightpos_z = light[2];
        this.setLighting();
    }

    @Override
    public Point_3D getLightPosition() {
        return new Point_3D(this.lightpos_x / 1000.0f, this.lightpos_y / 1000.0f, this.lightpos_z / 1000.0f);
    }

    @Override
    public void setLightPosition(Point_3D p) {
        this.lightpos_x = p.getX() * 1000.0f;
        this.lightpos_y = p.getY() * 1000.0f;
        this.lightpos_z = p.getZ() * 1000.0f;
        this.setLighting();
    }

    @Override
    public Color getAmbientLight() {
        return new Color((int)this.ambient_r, (int)this.ambient_g, (int)this.ambient_b);
    }

    @Override
    public void setAmbientLight(Color c) {
        this.ambient_r = c.getRed();
        this.ambient_g = c.getGreen();
        this.ambient_b = c.getBlue();
        this.setLighting();
    }

    @Override
    public float[] getAmbient() {
        float[] ambient = new float[]{this.ambient_r, this.ambient_g, this.ambient_b};
        return ambient;
    }

    @Override
    public void setAmbient(float[] ambient) {
        this.ambient_r = ambient[0];
        this.ambient_g = ambient[1];
        this.ambient_b = ambient[2];
        this.setLighting();
    }

    @Override
    public float[] getIntensity() {
        float[] intensity = new float[]{this.intensity_r, this.intensity_g, this.intensity_b};
        return intensity;
    }

    @Override
    public void setIntensity(float[] intensity) {
        this.intensity_r = intensity[0];
        this.intensity_g = intensity[1];
        this.intensity_b = intensity[2];
        this.setLighting();
    }

    @Override
    public Color getLightIntensity() {
        return new Color((int)(this.intensity_r * 100.0f), (int)(this.intensity_g * 100.0f), (int)(this.intensity_b * 100.0f));
    }

    @Override
    public void setLightIntensity(Color c) {
        this.intensity_r = (float)((double)c.getRed() / 100.0);
        this.intensity_g = (float)((double)c.getGreen() / 100.0);
        this.intensity_b = (float)((double)c.getBlue() / 100.0);
        this.setLighting();
    }

    @Override
    public float getZoomfactor() {
        return this.zoomfactor;
    }

    @Override
    public void setZoomfactor(float zoomfactor) {
        this.zoomSpace(zoomfactor);
    }

    @Override
    public float getX_scale() {
        return this.xscale;
    }

    @Override
    public float getY_scale() {
        return this.yscale;
    }

    @Override
    public float getZ_scale() {
        return this.zscale;
    }

    @Override
    public void setSwapAxis(boolean state) {
    }

    @Override
    public boolean isSwapAxis() {
        return false;
    }

    @Override
    public void computeBoundingBox() {
        if (this.space == null) {
            this.validatePosition();
        }
        if (this.space == null) {
            return;
        }
        this.chartxorigin = (int)((float)this.winWidth * this.chart_XProp);
        this.chartyorigin = (int)((float)this.winHeight * this.chart_YProp);
        this.chartwidth = (int)((float)this.winWidth * this.chart_widthProp);
        this.chartheight = (int)((float)this.winHeight * this.chart_heightProp);
        this.chartwidth = this.chartheight = Math.min(this.chartheight, this.chartwidth);
        this.space.resize(this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
        Vertex[] v = new Vertex[]{new Vertex(0.0f, 0.0f, 0.0f), new Vertex(this.wall_xlength, 0.0f, 0.0f), new Vertex(0.0f, this.wall_ylength, 0.0f), new Vertex(this.wall_xlength, this.wall_ylength, 0.0f), new Vertex(0.0f, 0.0f, this.wall_zlength), new Vertex(this.wall_xlength, 0.0f, this.wall_zlength), new Vertex(0.0f, this.wall_ylength, this.wall_zlength), new Vertex(this.wall_xlength, this.wall_ylength, this.wall_zlength)};
        this.space.transform(v[0]);
        this.xboundmin = this.xboundmax = v[0].screen_x;
        this.yboundmin = this.yboundmax = v[0].screen_y;
        for (int i = 1; i < 8; ++i) {
            this.space.transform(v[i]);
            int t = v[i].screen_x;
            if (t > this.xboundmax) {
                this.xboundmax = t;
            } else if (t < this.xboundmin) {
                this.xboundmin = t;
            }
            t = v[i].screen_y;
            if (t > this.yboundmax) {
                this.yboundmax = t;
                continue;
            }
            if (t >= this.yboundmin) continue;
            this.yboundmin = t;
        }
    }

    @Override
    public void createSpace(int xmin, int xmax, int ymin, int ymax, float ratio) {
        this.space = new Space(xmin, xmax, ymin, ymax);
        this.space.hiddenSurface = this.hiddenSurface;
        this.space.perspective(0.0f, ratio, this.zoomfactor);
        this.space.setTranslate(this.spaceTranslate_x, this.spaceTranslate_y, this.spaceTranslate_z);
        this.space.lookat(this.lookfrom_x, this.lookfrom_y, this.lookfrom_z, this.lookto_x, this.lookto_y, this.lookto_z);
        this.space.scale(this.xscale, this.yscale, this.zscale);
        this.space.setLight(new Vertex(this.lightpos_x, this.lightpos_y, this.lightpos_z), this.intensity_r, this.intensity_g, this.intensity_b, this.ambient_r, this.ambient_g, this.ambient_b);
        this.space_ratio = ratio;
        this.hiddenSurface.reset();
        int dataCount = this.mData.count();
        if (this.mData2 != null) {
            dataCount += this.mData2.count();
        }
        this.space.is3DApproximationUsed = this.is3DApproximationUsed && (this.chartType == 12 || this.chartType == 2 || this.subvalueCol >= 0) && dataCount > this.approximationThreshold;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void adjustSpaceView() {
        float zscale;
        float yscale;
        float xscale;
        float lookto_z;
        float lookto_y;
        float lookto_x;
        float lookfrom_z;
        float lookfrom_y;
        float lookfrom_x;
        block15: {
            block17: {
                block16: {
                    if (!this.adjust3DView) {
                        return;
                    }
                    lookfrom_x = 1000.0f;
                    lookfrom_y = 1000.0f;
                    lookfrom_z = 2000.0f;
                    lookto_x = 500.0f;
                    lookto_y = 500.0f;
                    lookto_z = 500.0f;
                    xscale = 1.0f;
                    yscale = 1.0f;
                    zscale = 1.0f;
                    if (this.space == null) {
                        return;
                    }
                    if (this.dataDim >= 2) break block16;
                    if ((this.chartType == 0 || this.chartType == 1) && this.mDataLen[0] < 3) {
                        zscale = 0.5f;
                        break block15;
                    } else if (this.chartType != 3 || this.mDataLen[0] != 0) {
                        if (this.chartType == 3 && this.mDataLen[0] < 4) {
                            zscale = 0.25f;
                            break block15;
                        } else {
                            this.adjust3DView = false;
                            return;
                        }
                    }
                    break block15;
                }
                if (this.chartType != 0) break block17;
                if (this.adjustScaleOnly) {
                    this.adjust3DView = false;
                    return;
                }
                if (this.mDataLen[0] > this.mDataLen[1] * 3) {
                    lookfrom_x = 1300.0f;
                    lookfrom_y = 800.0f;
                    lookfrom_z = 900.0f;
                    xscale = 2.0f;
                    break block15;
                } else if (this.mDataLen[1] > this.mDataLen[0] * 3) {
                    zscale = 2.0f;
                }
                break block15;
            }
            if (this.chartType == 1) {
                if (this.adjustScaleOnly) {
                    this.adjust3DView = false;
                    return;
                }
                if (this.mDataLen[0] > this.mDataLen[1] * 3) {
                    lookfrom_x = 1100.0f;
                    lookfrom_y = 900.0f;
                    lookfrom_z = 1200.0f;
                    yscale = 2.0f;
                }
            }
        }
        if (!this.adjustScaleOnly) {
            this.space.lookat(lookfrom_x, lookfrom_y, lookfrom_z, lookto_x, lookto_y, lookto_z);
        }
        this.zscale = zscale;
        this.space.scale(xscale, yscale, zscale);
        this.adjust3DView = false;
        this.newSurface();
    }

    public void adjustInitScale(float orgW, float orgH) {
        if (!this.isChanging3DChartType()) {
            this.space.recomputeColor();
            return;
        }
        if (orgW == 0.0f || orgH == 0.0f) {
            return;
        }
        boolean showTable = this.showTable();
        if (showTable) {
            this.gt.setVisible(this, false);
        }
        this.computeBoundingBox();
        this.setChanging3DChartType(false);
        this.computeBoundingBox();
        float chartWidth = (float)this.winWidth * this.chart_widthProp;
        float chartHeight = (float)this.winHeight * this.chart_heightProp;
        if (!this.isCircularChart()) {
            this.xscale = chartWidth / (float)(this.xboundmax - this.xboundmin) * this.space.xscale;
            this.yscale = chartHeight / (float)(this.yboundmax - this.yboundmin) * this.space.yscale;
            this.space.scale(this.xscale, this.yscale, this.space.zscale);
        } else {
            this.space.scale(1.0f, 1.0f, 1.0f);
        }
        this.computeBoundingBox();
        float gapH = (float)(this.winHeight - (this.yboundmax - this.yboundmin)) / 2.0f;
        this.chart_YProp -= (gapH - (float)(this.winHeight - this.yboundmax)) / (float)this.winHeight;
        float gapW = (float)(this.winWidth - (this.xboundmax - this.xboundmin)) / 2.0f;
        this.chart_XProp += (gapW - (float)this.xboundmin) / (float)this.winWidth;
        CString.resetShiftValue();
        Image bImage = Composite.getBufferedImage(this.cgraphics.g, this.winWidth, this.winHeight);
        this.draw(Composite.createGraphics(this.cgraphics.g, bImage));
        this.computeBoundingBox();
        this.chart_XProp -= (float)CString.shiftLEFT / (float)this.winWidth;
        this.xscale = ((float)(this.xboundmax - this.xboundmin) + (float)CString.shiftLEFT) / (float)(this.xboundmax - this.xboundmin) * this.space.xscale;
        this.chart_YProp += (float)CString.shiftUP / (float)this.winHeight;
        this.space.scale(this.xscale, this.yscale, this.space.zscale);
        this.computeBoundingBox();
        if (showTable) {
            this.gt.setVisible(this, true);
        }
    }

    @Override
    public void newSurface() {
        if (this.hiddenSurface == null) {
            this.hiddenSurface = new HiddenSurface();
        } else {
            this.hiddenSurface.reset();
        }
    }

    @Override
    public void zoomSpace(float factor) {
        this.zoomfactor = factor;
        if (this.space != null) {
            this.space.perspective(0.0f, this.space_ratio, this.zoomfactor);
        }
    }

    @Override
    public void translateSpace(float x, float y, float z) {
        this.space.addTranslate(x, y, z);
        this.spaceTranslate_x += x;
        this.spaceTranslate_y += y;
        this.spaceTranslate_z += z;
    }

    @Override
    public void scaleSpace(float x, float y, float z) {
        this.xscale = x;
        this.yscale = y;
        this.zscale = z;
        if (this.space != null) {
            this.space.scale(x, y, z);
        }
    }

    @Override
    public void setLighting() {
        if (this.space != null) {
            this.space.setLight(new Vertex(this.lightpos_x, this.lightpos_y, this.lightpos_z), this.intensity_r, this.intensity_g, this.intensity_b, this.ambient_r, this.ambient_g, this.ambient_b);
        }
    }
}

