/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.DataLineSet;
import quadbase.chart.FunctionLine;
import quadbase.chart.HorzVertLine;
import quadbase.chart.TrendLine;
import quadbase.chart.chart3d.ControlLine3D;
import quadbase.chart.chart3d.HorzVertLine3D;
import quadbase.chart.chart3d.TrendLine3D;
import quadbase.util.IDataLine;
import quadbase.util.IFunction;

public class DataLineSet3D
extends DataLineSet {
    private static final Logger LOGGER = Logger.getLogger(DataLineSet3D.class.getName());

    public DataLineSet3D(Chart chart) {
        super(chart);
    }

    public DataLineSet3D(Chart chart, DataLineSet set) {
        super(chart);
        Vector<DataLine> oldList = set.getDataLineList();
        int nLine = oldList.size();
        for (int i = 0; i < nLine; ++i) {
            DataLine target = oldList.elementAt(i);
            DataLine tempLine = null;
            if (target instanceof TrendLine) {
                tempLine = new TrendLine3D(chart, (TrendLine)target);
            } else if (target instanceof ControlLine) {
                tempLine = new ControlLine3D(chart, (ControlLine)target);
            } else if (target instanceof HorzVertLine) {
                tempLine = new HorzVertLine3D(chart, (HorzVertLine)target);
            } else {
                LOGGER.warning("Invalid line type, should not happen");
            }
            tempLine.setChart(chart);
            this.dataLineList.addElement(tempLine);
        }
    }

    @Override
    public final void updateDataLine(IDataLine dline) {
        super.updateDataLine(dline);
        this.chart.newSurface();
    }

    @Override
    public final void removeDataLine(IDataLine dline) {
        super.removeDataLine(dline);
        this.chart.newSurface();
    }

    public final void setdataLineList(Vector vec) {
        super.setdataLineList(vec);
        this.chart.newSurface();
    }

    @Override
    public void computeDataLines(boolean prepareLine) {
        for (int i = 0; i < this.dataLineList.size(); ++i) {
            DataLine dl = (DataLine)this.dataLineList.elementAt(i);
            dl.compute();
            if (!prepareLine || dl.invalidchart()) continue;
            dl.prepare3DLine();
        }
    }

    @Override
    public TrendLine newTrendLine(Chart chart) {
        return new TrendLine3D(chart);
    }

    @Override
    public TrendLine newTrendLine(int linetype, int coeff, String title) {
        return new TrendLine3D(this.chart, linetype, coeff, title);
    }

    @Override
    public TrendLine newTrendLine(TrendLine tline) {
        return new TrendLine3D(this.chart, tline);
    }

    @Override
    public HorzVertLine newHorzVertLine(int lineType, String title) {
        return new HorzVertLine3D(this.chart, lineType, title);
    }

    @Override
    protected HorzVertLine newHorzVertLine(HorzVertLine hline) {
        return new HorzVertLine3D(this.chart, hline);
    }

    @Override
    public ControlLine newControlLine(int lineType, String title) {
        return new ControlLine3D(this.chart, lineType, title);
    }

    @Override
    public ControlLine newControlLine(int lineType, String title, int level) {
        return new ControlLine3D(this.chart, lineType, title, level);
    }

    @Override
    protected ControlLine newControlLine(ControlLine hline) {
        return new ControlLine3D(this.chart, hline);
    }

    @Override
    public FunctionLine newFunctionLine(IFunction function, String title) {
        return new FunctionLine(this.chart, function, title);
    }

    @Override
    protected FunctionLine newFunctionLine(FunctionLine fline) {
        return new FunctionLine(this.chart, fline);
    }
}

