/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.chart.FaceData;
import quadbase.util.internal.IOUtil;

public class FaceHyperLink {
    public Vector faceDataList;
    private String xValue = null;
    private String zValue = null;
    public static String ALLPOINTS = "All";
    private String link = null;
    private String hint = null;
    private String target = null;

    public FaceHyperLink(String x, String z, String link, String target, String hint) {
        this.faceDataList = new Vector(10);
        this.xValue = x;
        this.zValue = z;
        this.link = link;
        this.target = target;
        this.hint = hint;
    }

    public FaceHyperLink(FaceHyperLink c) {
        this.faceDataList = c.faceDataList;
        this.xValue = c.xValue;
        this.zValue = c.zValue;
        this.link = c.link;
        this.target = c.target;
        this.hint = c.hint;
    }

    public void reset() {
        this.resetAllFaceData();
        this.xValue = null;
        this.zValue = null;
        this.link = null;
        this.target = null;
        this.hint = null;
    }

    public void setValues(String x, String z, String link, String target, String hint) {
        this.reset();
        this.xValue = x;
        this.zValue = z;
        this.link = link;
        this.target = target;
        this.hint = hint;
    }

    public void write(DataOutput out) throws IOException {
        this.write(out, this.xValue);
        this.write(out, this.zValue);
        this.write(out, this.link);
        this.write(out, this.target);
        this.write(out, this.hint);
    }

    private void write(DataOutput out, String value) throws IOException {
        if (value == null) {
            value = "";
        }
        IOUtil.writeString(out, value);
    }

    public static void read(DataInput in, boolean isUTF, Chart chart) throws IOException {
        String xValue = IOUtil.readString(in, isUTF);
        String zValue = IOUtil.readString(in, isUTF);
        String link = IOUtil.readString(in, isUTF);
        String target = IOUtil.readString(in, isUTF);
        String hint = IOUtil.readString(in, isUTF);
        chart.addNewSurfaceLink(link, target, hint, xValue, zValue);
    }

    public String getxValue() {
        return this.xValue;
    }

    public String getzValue() {
        return this.zValue;
    }

    public String getHyperLink() {
        return this.link;
    }

    public String getHint() {
        return this.hint;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isWithinFaceHyperLink(FaceData faceData) {
        double z;
        double x;
        if (!faceData.getHyperLink().equals(this.link)) {
            return false;
        }
        if (!faceData.getTarget().equals(this.target)) {
            return false;
        }
        if (!faceData.getHint().equals(this.hint)) {
            return false;
        }
        if (!this.xValue.equals(ALLPOINTS) && !faceData.isxWithinFaceData(x = Double.valueOf(this.xValue).doubleValue())) {
            return false;
        }
        return this.zValue.equals(ALLPOINTS) || faceData.iszWithinFaceData(z = Double.valueOf(this.zValue).doubleValue());
    }

    private void resetAllFaceData() {
        for (int i = 0; i < this.faceDataList.size(); ++i) {
            FaceData faceData = (FaceData)this.faceDataList.elementAt(i);
            if (!faceData.getHyperLink().equals(this.link) || !faceData.getTarget().equals(this.target) || !faceData.getHint().equals(this.hint)) continue;
            faceData.setHyperLink(null, null, null);
        }
        this.faceDataList.removeAllElements();
    }
}

