/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import java.util.Date;
import quadbase.chart.CGraphics;
import quadbase.chart.Grid;
import quadbase.chart.Point3D;
import quadbase.chart.chart3d.lib3d.Line3D;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;

public class Grid3D
extends Grid {
    public Line3D[] lineList;

    public Grid3D(int direction, boolean showgrid) {
        super(direction, showgrid);
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        if (this.lineList != null) {
            for (Line3D element : this.lineList) {
                element.setColor(color);
            }
        }
    }

    @Override
    public boolean select(CGraphics g, int x, int y) {
        if (!this.bshow) {
            return false;
        }
        if (this.lineList != null) {
            for (Line3D element : this.lineList) {
                if (!element.pickLine(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void set(Object sp, Point3D[] p, int xymax, int zmax) {
        this.lineList = new Line3D[2 * p.length];
        Space space = (Space)sp;
        if (this.orient == 1) {
            int j = 0;
            for (int i = 0; i < p.length; ++i) {
                int h = p[i].y;
                Vertex v1 = new Vertex(0.0f, h, 0.0f, space);
                Vertex v2 = new Vertex(0.0f, h, zmax, space);
                Vertex v3 = new Vertex(xymax, h, 0.0f, space);
                this.lineList[j++] = new Line3D(v1, v2, this.color);
                this.lineList[j++] = new Line3D(v1, v3, this.color);
            }
        } else if (this.orient == 0) {
            int j = 0;
            for (int i = 0; i < p.length; ++i) {
                int h = p[i].x;
                Vertex v1 = new Vertex(h, 0.0f, 0.0f, space);
                Vertex v2 = new Vertex(h, xymax, 0.0f, space);
                Vertex v3 = new Vertex(h, 0.0f, zmax, space);
                this.lineList[j++] = new Line3D(v1, v2, this.color);
                this.lineList[j++] = new Line3D(v1, v3, this.color);
            }
        } else {
            int j = 0;
            for (int i = 0; i < p.length; ++i) {
                int h = p[i].z;
                Vertex v1 = new Vertex(xymax, 0.0f, h, space);
                Vertex v2 = new Vertex(0.0f, 0.0f, h, space);
                Vertex v3 = new Vertex(0.0f, zmax, h, space);
                this.lineList[j++] = new Line3D(v1, v2, this.color);
                this.lineList[j++] = new Line3D(v2, v3, this.color);
            }
        }
    }

    @Override
    public void draw(CGraphics g, boolean odd, boolean skipGridOffset, int sep) {
        int i;
        g.setColor(this.color);
        if (!this.bshow || this.lineList == null) {
            return;
        }
        int n = i = odd ? 1 : 0;
        if (skipGridOffset && sep > 1) {
            i += 2 * (sep - 1);
        }
        while (i < this.lineList.length) {
            this.lineList[i].draw(g.g);
            i += 2 * sep;
        }
    }

    @Override
    public void draw(CGraphics g, int thick, boolean skipGridOffset, int step) {
    }

    @Override
    public void draw(CGraphics g, int thick, int step, int stepUnit, boolean isAscending, Date startPt, int dataType, Object[] name) {
    }

    @Override
    public void draw(CGraphics g, int thick, boolean skipGridOffset, int step, int lineStyle) {
    }

    @Override
    public void draw(CGraphics g, int thick, int lineStyle, int step, int stepUnit, boolean isAscending, Date startPt, int dataType, Object[] name) {
    }

    @Override
    public void draw(CGraphics g, int thick, boolean skipGridOffset, int step, int lineStyle, boolean useLineStyle) {
    }
}

