/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.HorzVertLine;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.util.Point_2D;

public class HorzVertLine3D
extends HorzVertLine {
    Face[] faceList;

    public HorzVertLine3D(Chart chart) {
        super(chart);
    }

    public HorzVertLine3D(Chart newChart, HorzVertLine tline) {
        super(newChart, tline);
    }

    public HorzVertLine3D(Chart chart, int linetype, String title) {
        super(chart, linetype, title);
    }

    @Override
    public final void setColor(Color color) {
        this.color = color;
        if (this.faceList != null && ((Chart3D)this.chart).space != null) {
            for (Face element : this.faceList) {
                element.setColor(((Chart3D)this.chart).space, color);
            }
        }
    }

    @Override
    public void prepare3DLine() {
        if (this.chart.mData2 == null) {
            this.useSubvalue = false;
        }
        int thick = this.getThickness();
        int pixelValue = this.getPixelValue();
        if (this.showHorzLine()) {
            this.faceList = new Face[6];
            ((Chart3D)this.chart).space.addBox(this.faceList, (float)((Chart3D)this.chart).wall_xlength, (float)(pixelValue + thick), (float)((Chart3D)this.chart).wall_zlength, 0.0f, (float)(pixelValue - thick), 0.0f, this.getColor(), true, (Object)this);
        } else if (this.showVertLine()) {
            this.faceList = new Face[6];
            ((Chart3D)this.chart).space.addBox(this.faceList, (float)(pixelValue + thick), (float)((Chart3D)this.chart).wall_ylength, (float)((Chart3D)this.chart).wall_zlength, (float)(pixelValue - thick), 0.0f, 0.0f, this.getColor(), true, (Object)this);
        }
    }

    @Override
    protected void drawLine(CGraphics g) {
        if (this.faceList != null && ((Chart3D)this.chart).drawType == 0) {
            for (Face element : this.faceList) {
                element.draw(g, 0);
            }
        }
    }

    @Override
    protected Point_2D getAbsPosition() {
        int x = 0;
        int y = 0;
        int pixelValue = this.getPixelValue();
        int thick = this.getThickness();
        if (this.showHorzLine()) {
            x = 0;
            y = pixelValue - thick;
        } else if (this.showVertLine()) {
            x = pixelValue - thick;
            y = 0;
        }
        Vertex v = new Vertex(x, y, 0.0f);
        ((Chart3D)this.chart).space.transform(v);
        x = v.screen_x;
        y = this.chart.winHeight - v.screen_y;
        return new Point_2D(x, y);
    }
}

