/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.Area;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.HiLowData;
import quadbase.chart.IHLCOChart;
import quadbase.chart.IPieChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.PieChart;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.QbPattern;
import quadbase.chart.chart2d.Area2D;
import quadbase.chart.chart3d.Area3D;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.Point3D_3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;

public class MultiDimData3D
extends MultiDimData {
    private static final Logger LOGGER = Logger.getLogger(MultiDimData3D.class.getName());
    public Vector lineFaceList;
    private Point3D_3D point_3d;
    private int labelHeight3D = 50;

    public MultiDimData3D(int lv, Chart _chart, MultiDimData p) {
        super(lv, _chart, p);
        if (this.level < this.chart.dataDim) {
            int len = this.chart.mDataLen[this.level];
            this.multiData = new MultiDimData[len];
            for (int i = 0; i < len; ++i) {
                this.multiData[i] = new MultiDimData3D(this.level + 1, this.chart, this);
            }
            this.area = new Area3D(this.multiData[0].area.areaColor);
        } else {
            this.plotData = new PlotData(this.chart);
            this.area = new Area3D();
        }
        if (this.level == this.chart.dataDim - 1) {
            this.order = new int[this.chart.mDataLen[this.level]];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
        }
        this.point = new Point3D(this.area.areaColor);
        this.flashPoint = new Point3D(this.area.areaColor);
        this.point_3d = new Point3D_3D(this.point);
    }

    private MultiDimData3D() {
    }

    @Override
    public MultiDimData copyMultiDimData() {
        MultiDimData3D newData = new MultiDimData3D();
        newData.labelHeight3D = this.labelHeight3D;
        newData.lineFaceList = this.lineFaceList;
        newData.point_3d = this.point_3d;
        return this.copyMultiDimData(newData);
    }

    @Override
    public void setColor(Color color) {
        int i;
        super.setColor(color);
        if (this.area.getFaceList() != null) {
            for (i = 0; i < 6; ++i) {
                Face temp = (Face)this.area.getFaceList(i);
                temp.setColor(((Chart3D)this.chart).space, color);
            }
            if (this.area2 != null) {
                Color darker = color.darker();
                for (int i2 = 0; i2 < 6; ++i2) {
                    Face temp = (Face)this.area2.getFaceList(i2);
                    temp.setColor(((Chart3D)this.chart).space, darker);
                }
            }
        }
        if (this.point_3d.faceList != null) {
            for (i = 0; i < 6; ++i) {
                this.point_3d.faceList[i].setColor(((Chart3D)this.chart).space, color);
            }
        }
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.setColor(color);
            }
        }
    }

    @Override
    public void setPointCoord(int x, int y, int[] loc) {
    }

    @Override
    public void setFlashPointCoord(int x, int y, int[] loc) {
    }

    @Override
    public void setPointCoord(int x, int y, int z, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setPointCoord(x, y, z, loc);
            return;
        }
        this.point.x = x;
        this.point.y = y;
        this.point.z = z;
    }

    @Override
    public void setFlashPointCoord(int x, int y, int z, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setFlashPointCoord(x, y, z, loc);
            return;
        }
        this.flashPoint.x = x;
        this.flashPoint.y = y;
        this.flashPoint.z = z;
    }

    @Override
    public void drawFace(CGraphics g) {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.drawFace(g);
            }
        }
        if (this.lineFaceList != null) {
            Space.drawFrameBox(g, this.lineFaceList);
        }
    }

    @Override
    public void drawLine(CGraphics g, Point3D p, int thickness) {
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.drawLine(g, this.point.automatic ? p : this.point, this.point.automatic ? thickness : this.lineThickness);
            }
        } else if (this.lineFaceList != null) {
            Space.drawFrameBox(g, this.lineFaceList);
            return;
        }
    }

    @Override
    public void drawLine(CGraphics g, Point3D p, int thickness, MultiDimData mdata) {
    }

    @Override
    public void prepare3DPoint(Object sp, double thick, Point3D p) {
        Space space = (Space)sp;
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.prepare3DPoint(space, thick, this.point.automatic ? p : this.point);
            }
        } else if (this.isPointVisible() && !this.plotData.isEmpty()) {
            Color orgColor;
            Color color = orgColor = this.point.automatic ? p.color : this.point.color;
            if (this.chart.flashRatio != 1.0) {
                color = new Color(orgColor.getRed(), orgColor.getGreen(), orgColor.getBlue(), (int)Math.rint(255.0 * this.chart.flashRatio));
            }
            this.point_3d.prepare3D_3D(space, color, thick, this);
        }
    }

    @Override
    public void prepare3DLine(Object sp, double thick, double height, Point3D p, boolean bvertical) {
        Space space = (Space)sp;
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.prepare3DLine(space, thick, height, this.point.automatic ? p : this.point, bvertical);
            }
        } else {
            Vertex currv = new Vertex();
            Vertex lastv = new Vertex();
            this.lineFaceList = new Vector();
            Point3D lastpoint = null;
            boolean drawPoint = false;
            double pointWidth = thick;
            if (pointWidth > height) {
                pointWidth = height;
            }
            for (int i = 0; i < this.multiData.length; ++i) {
                if (this.multiData[this.order[i]].plotData.isEmpty()) {
                    if (lastpoint != null && drawPoint) {
                        this.multiData[this.order[i - 1]].prepare3DPoint(space, pointWidth, this.point);
                        drawPoint = false;
                    }
                    lastpoint = null;
                    continue;
                }
                Point3D currpoint = this.multiData[this.order[i]].point;
                currv.x = currpoint.x;
                currv.y = currpoint.y;
                currv.z = currpoint.z;
                if (lastpoint != null) {
                    drawPoint = false;
                    if (!bvertical) {
                        space.addLine(this.lineFaceList, lastv, currv, thick, height, this.point.automatic ? p.color : this.point.color, this.multiData[this.order[i - 1]]);
                    } else {
                        space.addLine2(this.lineFaceList, lastv, currv, thick, height, this.point.automatic ? p.color : this.point.color, this.multiData[this.order[i - 1]]);
                    }
                } else if (i == this.multiData.length - 1) {
                    this.multiData[this.order[i]].prepare3DPoint(space, pointWidth, this.point);
                } else {
                    drawPoint = true;
                }
                lastpoint = currpoint;
                lastv.x = currv.x;
                lastv.y = currv.y;
                lastv.z = currv.z;
            }
        }
    }

    @Override
    public void prepare3DBox(Object sp) {
        Space space = (Space)sp;
        this.prepare3DBox(space, this.area);
    }

    @Override
    public void prepare3DPie(Object sp, double thick) {
        Space space = (Space)sp;
        this.prepare3DPie(space, thick, this.area, 0);
    }

    @Override
    public void prepare3DDoughnut(Object sp, double thick) {
        Space space = (Space)sp;
        this.prepare3DDoughnut(space, thick, this.area, 0);
    }

    @Override
    public void prepare3DPoint(Object sp, double thick) {
        Space space = (Space)sp;
        this.prepare3DPoint(space, thick, this.point);
    }

    @Override
    public void prepare3DLine(Object sp, double thick, double height, boolean bvertical) {
        Space space = (Space)sp;
        this.prepare3DLine(space, thick, height, this.point, true);
    }

    @Override
    public void prepare3DLine(Object sp, double thick, double height) {
        Space space = (Space)sp;
        this.prepare3DLine(space, thick, height, this.point, false);
    }

    @Override
    public void prepare3DArea(Object sp, double thick, int zeroAxis) {
        Space space = (Space)sp;
        this.prepare3DArea(space, thick, zeroAxis, this.area);
    }

    @Override
    public void prepare3DStackArea(Object sp, double thick, int zeroAxis) {
        Space space = (Space)sp;
        this.prepare3DStackArea(space, thick, zeroAxis, this.area);
    }

    @Override
    public void prepare3DArea(Object sp, double thick, int zeroAxis, Area parea) {
        Space space = (Space)sp;
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.prepare3DArea(space, thick, zeroAxis, this.area.automatic ? parea : this.area);
            }
        } else {
            Point3D p1 = new Point3D(0, zeroAxis, 0);
            Point3D p2 = new Point3D(0, zeroAxis, 0);
            Point3D prev = null;
            this.lineFaceList = new Vector();
            if (this.multiData.length > 0) {
                prev = this.multiData[0].point;
                p1.x = prev.x;
                p1.z = prev.z;
            }
            for (int i = 1; i < this.multiData.length; ++i) {
                Point3D curr = this.multiData[i].point;
                p2.x = curr.x;
                p2.z = curr.z;
                if (!this.multiData[i].plotData.isEmpty() && !this.multiData[i - 1].plotData.isEmpty()) {
                    space.addBox(this.lineFaceList, p1, prev, curr, p2, thick, this.area.automatic ? parea.areaColor : this.area.areaColor, this.multiData[i]);
                }
                p1.x = p2.x;
                p1.z = p2.z;
                prev = curr;
            }
        }
    }

    @Override
    public void prepare3DStackArea(Object sp, double thick, int zeroAxis, Area parea) {
        Space space = (Space)sp;
        if (this.level < this.chart.dataDim - 2) {
            for (MultiDimData element : this.multiData) {
                element.prepare3DStackArea(space, thick, zeroAxis, this.area.automatic ? parea : this.area);
            }
        } else {
            for (int i = 0; i < this.multiData.length - 1; ++i) {
                Point3D p1 = new Point3D(this.multiData[i].multiData[0].point.x, zeroAxis, this.multiData[i].multiData[0].point.z);
                Point3D p2 = new Point3D(this.multiData[i + 1].multiData[0].point.x, zeroAxis, this.multiData[i + 1].multiData[0].point.z);
                for (int j = 0; j < this.multiData[i].multiData.length; ++j) {
                    Point3D p3 = this.multiData[i].multiData[j].point;
                    Point3D p4 = this.multiData[i + 1].multiData[j].point;
                    if (!this.multiData[i].multiData[j].plotData.isEmpty() && !this.multiData[i + 1].multiData[j].plotData.isEmpty()) {
                        this.multiData[i].multiData[j].addArea(space, p1, p3, p4, p2, thick, this.area.automatic ? parea : (this.multiData[i].area.automatic ? this.area : this.multiData[i].area));
                    }
                    p1 = p3;
                    p2 = p4;
                }
            }
        }
    }

    @Override
    public void addArea(Object sp, Point3D p1, Point3D p2, Point3D p3, Point3D p4, double thick, Area parea) {
        Space space = (Space)sp;
        this.lineFaceList = new Vector();
        space.addBox(this.lineFaceList, p1, p2, p3, p4, thick, this.area.automatic ? parea.areaColor : this.area.areaColor, this);
    }

    @Override
    public void prepare3DPie(Object sp, double thick, Area parea) {
        this.prepare3DPie(sp, thick, parea, 0);
    }

    private void prepare3DPie(Object sp, double thick, Area parea, int idx) {
        if (this.chart.dataDim == 1) {
            idx = 0;
        }
        Space space = (Space)sp;
        if (this.level < this.chart.dataDim) {
            for (int i = 0; i < this.multiData.length; ++i) {
                ((MultiDimData3D)this.multiData[i]).prepare3DPie(space, thick, this.area.automatic ? parea : this.area, i);
            }
        } else {
            PieChart pchart = ((IPieChart)((Object)this.chart)).getPieChart();
            this.lineFaceList = new Vector();
            if (this.chart.mDataLen[0] == 1) {
                space.addCircle(this.lineFaceList, pchart.center[idx].x, pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], thick, this.area.automatic ? parea.areaColor : this.area.areaColor, this);
            } else {
                Color arcColor;
                Color color = arcColor = this.area.automatic ? parea.areaColor : this.area.areaColor;
                if (this.isAngleLessThanThreshold()) {
                    Color thresholdColor = this.getThresholdColor(arcColor);
                    if (this.chart.dataDim == 1) {
                        this.area.areaColor = thresholdColor;
                    }
                    arcColor = thresholdColor;
                }
                if (this.plotData.bSlice && pchart.sliceDistance != 0.0 && (!pchart.isSectorGapEnabled() || this.arcAngle.angle < 320.0)) {
                    if (!pchart.isSectorGapEnabled()) {
                        double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
                        space.addArc(this.lineFaceList, (int)((double)pchart.center[idx].x + (double)pchart.piewidth[idx] * pchart.sliceDistance * Math.cos(angle)), (int)((double)pchart.center[idx].y + (double)pchart.pieheight[idx] * pchart.sliceDistance * Math.sin(angle)), pchart.piewidth[idx], pchart.pieheight[idx], this.arcAngle.start * Math.PI / 180.0, this.arcAngle.angle * Math.PI / 180.0, thick, arcColor, this);
                    } else {
                        double d = (double)pchart.piewidth[idx] * pchart.sliceDistance / 2.0;
                        double a = d / Math.sin(this.arcAngle.angle / 2.0 * Math.PI / 180.0);
                        double rw = (double)pchart.piewidth[idx] - a * 2.0;
                        double rh = (double)pchart.pieheight[idx] - a * 2.0;
                        double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
                        double gap = Math.asin(d / 2.0 / (double)pchart.piewidth[idx] / 2.0) * 4.0 * 180.0 / Math.PI;
                        if (pchart.isExplodedAll() && pchart.isSectorAlike()) {
                            if (gap * 2.0 > this.arcAngle.angle - 2.0 && (gap = Math.floor((this.arcAngle.angle - 2.0) / 2.0)) < 0.0) {
                                gap = 0.0;
                            }
                            space.addArc(this.lineFaceList, (int)Math.rint((double)pchart.center[idx].x + a * Math.cos(angle) * 2.0), (int)Math.rint((double)pchart.center[idx].y + a * Math.sin(angle) * 2.0), (int)Math.rint(rw), (int)Math.rint(rh), this.arcAngle.start * Math.PI / 180.0, this.arcAngle.angle * Math.PI / 180.0, thick, arcColor, this);
                        } else if (a > 0.0 && rw > 0.0 && rh > 0.0) {
                            space.addArc(this.lineFaceList, (int)Math.rint(pchart.center[idx].x), (int)Math.rint(pchart.center[idx].y), pchart.piewidth[idx], pchart.pieheight[idx], (this.arcAngle.start + gap) * Math.PI / 180.0, (this.arcAngle.angle - gap * 2.0) * Math.PI / 180.0, thick, arcColor, this);
                        }
                    }
                } else {
                    space.addArc(this.lineFaceList, pchart.center[idx].x, pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], this.arcAngle.start * Math.PI / 180.0, this.arcAngle.angle * Math.PI / 180.0, thick, arcColor, this);
                }
            }
        }
    }

    private void prepare3DDoughnut(Object sp, double thick, Area parea, int idx) {
        if (this.chart.dataDim == 1) {
            idx = 0;
        }
        Space space = (Space)sp;
        if (this.level < this.chart.dataDim) {
            for (int i = 0; i < this.multiData.length; ++i) {
                ((MultiDimData3D)this.multiData[i]).prepare3DDoughnut(space, thick, this.area.automatic ? parea : this.area, i);
            }
        } else {
            PieChart pchart = ((IPieChart)((Object)this.chart)).getPieChart();
            this.lineFaceList = new Vector();
            if (this.chart.mDataLen[0] == 1) {
                space.addDoughnutCircle(this.lineFaceList, pchart.center[idx].x, pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], thick, this.area.automatic ? parea.areaColor : this.area.areaColor, this, pchart.pieThickness[idx]);
            } else {
                Color arcColor;
                Color color = arcColor = this.area.automatic ? parea.areaColor : this.area.areaColor;
                if (this.isAngleLessThanThreshold()) {
                    Color thresholdColor = this.getThresholdColor(arcColor);
                    if (this.chart.dataDim == 1) {
                        this.area.areaColor = thresholdColor;
                    }
                    arcColor = thresholdColor;
                }
                if (this.plotData.bSlice && pchart.sliceDistance != 0.0 && (!pchart.isSectorGapEnabled() || this.arcAngle.angle < 320.0)) {
                    if (!pchart.isSectorGapEnabled()) {
                        double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
                        space.addDoughnutArc(this.lineFaceList, (int)((double)pchart.center[idx].x + (double)pchart.piewidth[idx] * pchart.sliceDistance * Math.cos(angle)), (int)((double)pchart.center[idx].y + (double)pchart.pieheight[idx] * pchart.sliceDistance * Math.sin(angle)), pchart.piewidth[idx], pchart.pieheight[idx], this.arcAngle.start * Math.PI / 180.0, this.arcAngle.angle * Math.PI / 180.0, thick, arcColor, this, pchart.pieThickness[idx]);
                    } else {
                        double d = (double)pchart.piewidth[idx] * pchart.sliceDistance / 2.0;
                        double a = d / Math.sin(this.arcAngle.angle / 2.0 * Math.PI / 180.0);
                        double rw = (double)pchart.piewidth[idx] - a * 2.0;
                        double rh = (double)pchart.pieheight[idx] - a * 2.0;
                        int gap = (int)Math.rint(pchart.sliceDistance * 360.0 / 4.0);
                        if (a > 0.0 && rw > 0.0 && rh > 0.0) {
                            space.addDoughnutArc(this.lineFaceList, (int)Math.rint(pchart.center[idx].x), (int)Math.rint(pchart.center[idx].y), pchart.piewidth[idx], pchart.pieheight[idx], (this.arcAngle.start + (double)gap) * Math.PI / 180.0, (this.arcAngle.angle - (double)(gap * 2 + 1)) * Math.PI / 180.0, thick, arcColor, this, pchart.pieThickness[idx]);
                        }
                    }
                } else {
                    space.addDoughnutArc(this.lineFaceList, pchart.center[idx].x, pchart.center[idx].y, pchart.piewidth[idx], pchart.pieheight[idx], this.arcAngle.start * Math.PI / 180.0, this.arcAngle.angle * Math.PI / 180.0, thick, arcColor, this, pchart.pieThickness[idx]);
                }
            }
        }
    }

    @Override
    public void drawHLCOArea(CGraphics g, Area parea) {
        if (this.lineFaceList != null) {
            Space.drawFrameBox(g, this.lineFaceList);
        }
    }

    @Override
    public void drawPoint3D(CGraphics g, Point3D p) {
        this.point_3d.drawPt_3D(g, this.point.automatic ? p : this.point);
    }

    @Override
    public void randomColor(Point3D p) {
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.randomColor(this.point.automatic ? p : this.point);
            }
        } else {
            this.setFaceColor(this.point.automatic ? p.color : this.point.color);
            if (this.level == this.chart.dataDim - 1) {
                for (MultiDimData element : this.multiData) {
                    element.randomColor(this.point.automatic ? p : this.point);
                }
            }
        }
        if (this.point != null) {
            this.point_3d.setColor_3D(((Chart3D)this.chart).space, this.point.automatic ? p.color : this.point.color);
        }
    }

    @Override
    public void setFaceColor(Area parea) {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.setFaceColor(this.area.automatic ? parea : this.area);
            }
        } else if (!this.isAngleLessThanThreshold()) {
            this.setFaceColor(this.area.automatic ? parea.areaColor : this.area.areaColor);
        } else if (this.lineFaceList != null) {
            int size = this.lineFaceList.size();
            if (size == 0) {
                return;
            }
            Color color = ((Face)this.lineFaceList.elementAt(0)).getColor();
            Color faceColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            if (color instanceof QbPattern) {
                faceColor = new QbPattern(faceColor, ((QbPattern)color).getPatternTypeID());
            }
            this.setFaceColor(faceColor);
            if (this.chart.dataDim == 1) {
                if (this.area.automatic) {
                    parea.areaColor = faceColor;
                    this.area.areaColor = faceColor;
                } else {
                    this.area.areaColor = faceColor;
                }
            }
        }
    }

    @Override
    public void setFaceColor(Color color) {
        if (this.lineFaceList != null) {
            int size = this.lineFaceList.size();
            if (this.chart.chartType == 10 && this.chart.candleStick) {
                size = 12;
            }
            if (size > 0) {
                if (this.isAngleLessThanThreshold()) {
                    Color orgColor = ((Face)this.lineFaceList.elementAt(0)).getColor();
                    color = color instanceof QbPattern ? new QbPattern(orgColor, ((QbPattern)color).getPatternTypeID()) : new Color(orgColor.getRed(), orgColor.getGreen(), orgColor.getBlue(), orgColor.getAlpha());
                }
                for (int i = 0; i < this.lineFaceList.size(); ++i) {
                    ((Face)this.lineFaceList.elementAt(i)).setColor(((Chart3D)this.chart).space, color);
                }
            }
        }
    }

    @Override
    public void prepare3DBox(Object sp, Area parea) {
        Space space = (Space)sp;
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.prepare3DBox(space, this.area.automatic ? parea : this.area);
            }
        } else if (!this.plotData.isEmpty()) {
            if (this.chart.chartType != 10 || this.hilow == null) {
                this.area.prepare3D(space, this.area.automatic ? parea : this.area, this);
                if (this.area2 != null) {
                    this.area2.setColor(this.area.automatic ? parea.areaColor.darker() : this.area.areaColor.darker());
                    this.area2.prepare3D(space, this.area2, this);
                }
            } else {
                this.lineFaceList = new Vector();
                ((IHLCOChart)((Object)this.chart)).prepareSym(space, this.lineFaceList, this.area.automatic ? parea.areaColor : this.area.areaColor, this.area.p1.x, this.area.p2.x, this.area.p1.z, this.area.p2.z, this.hilow, this, this.chart.candleStick);
            }
        }
    }

    @Override
    public Object select(CGraphics g, int x, int y, int chartType) {
        return null;
    }

    @Override
    public Object select2(CGraphics g, int x, int y) {
        return null;
    }

    @Override
    public int selectLine(CGraphics g, int x, int y) {
        LOGGER.finest("MDD3D: selectLine");
        return -1;
    }

    @Override
    public MultiDimData selectArea(CGraphics g, int x, int y) {
        return null;
    }

    @Override
    public MultiDimData selectStackArea(CGraphics g, int x, int y) {
        return null;
    }

    @Override
    public MultiDimData selectPie(CGraphics g, int x, int y) {
        return null;
    }

    @Override
    public void prepare_stacklabel(boolean bcreate) {
    }

    @Override
    public void prepare_label(boolean bcreate) {
    }

    @Override
    public void prepare_secondary_label(boolean bcreate) {
    }

    @Override
    public void prepare_label(boolean bcreate, MultiDimData secondaryData) {
    }

    private int getStackYPos(Area area, boolean reverse) {
        int alignment = this.chart.stackLabel_Alignment;
        int areaH = Math.abs(area.p1.y - area.p2.y);
        if (areaH < this.labelHeight3D * 2) {
            alignment = 1;
        }
        return this.getYPos(area, reverse, alignment);
    }

    private int getYPos(Area area, boolean reverse) {
        return this.getYPos(area, reverse, this.chart.topLabel_Alignment);
    }

    private int getYPos(Area area, boolean reverse, int alignment) {
        if (alignment == 0 || alignment == 3) {
            return !reverse ? area.p2.y : area.p1.y;
        }
        if (alignment == 4 || alignment == 2) {
            return !reverse ? area.p1.y : area.p2.y;
        }
        return (area.p1.y + area.p2.y) / 2;
    }

    private int getStackXPos(Area area) {
        int alignment = this.chart.stackLabel_Alignment;
        if (alignment == 0 || alignment == 3) {
            return area.p1.x;
        }
        if (alignment == 4 || alignment == 2) {
            return area.p2.x;
        }
        return (area.p1.x + area.p2.x) / 2;
    }

    private boolean showStackY(Area area) {
        return Math.abs(area.p1.y - area.p2.y) >= this.labelHeight3D;
    }

    private boolean showStackX(Area area, String str) {
        int width;
        if (this.chart.cgraphics != null) {
            CString tmpString = new CString(str, this.chart.topvalueLabel_font, null, this.chart.topvalueLabel_color, 0, this.chart.topvalueLabel_angle);
            width = tmpString.getWidth(this.chart.cgraphics) * 5;
        } else {
            width = this.labelHeight3D;
        }
        return Math.abs(area.p1.x - area.p2.x) >= (width += this.chart.dataBorderThickness + 2);
    }

    private int getOffsetUp() {
        return this.getOffsetUp(this.chart.topLabel_Alignment, -1);
    }

    private int getStackOffsetUp(int pt1, int pt2) {
        return this.getOffsetUp(this.chart.stackLabel_Alignment, Math.abs(pt1 - pt2));
    }

    private int getOffsetUp(int alignment, int areaHeight) {
        int offset = this.chart.toplabel_offset3D_up;
        if (areaHeight > -1 && areaHeight < this.labelHeight3D * 2) {
            offset -= this.labelHeight3D;
        } else if (alignment == 3 || alignment == 2) {
            offset -= this.labelHeight3D * 2;
        } else if (alignment == 1) {
            offset -= this.labelHeight3D;
        }
        return offset;
    }

    private int getStackZPos(Area area) {
        return this.getZPos(area, this.chart.stackLabel_Alignment);
    }

    private int getZPos(Area area) {
        return this.getZPos(area, this.chart.topLabel_Alignment);
    }

    private int getZPos(Area area, int alignment) {
        if (alignment == 3 || alignment == 1 || alignment == 2 || alignment == 4) {
            return Math.max(area.p1.z, area.p2.z) + 10;
        }
        return (area.p1.z + area.p2.z) / 2;
    }

    private void set3DLabelHeight() {
        int h = this.getTopLabelHeight();
        if (h > 50) {
            this.labelHeight3D = h * 2;
        }
    }

    private int[] getAreaPoints(Area area) {
        int p1Y = area.p1.y;
        int p1X = area.p1.x;
        int p2Y = area.p2.y;
        int p2X = area.p2.x;
        if (this.chart.topLabel_Alignment == 2 || this.chart.topLabel_Alignment == 4) {
            if (this.chart.a_y.stepsize != null) {
                p1Y = this.chart.a_y.stepsize.zeroAxis;
                p2Y = this.chart.a_y.stepsize.zeroAxis;
            }
            if (this.chart.a_x.stepsize != null) {
                p1X = this.chart.a_x.stepsize.zeroAxis;
                p2X = this.chart.a_x.stepsize.zeroAxis;
            }
        } else if (this.chart.topLabel_Alignment == 1) {
            if (this.chart.a_y.stepsize != null) {
                p1Y = (p1Y + this.chart.a_y.stepsize.zeroAxis) / 2;
                p2Y = (p2Y + this.chart.a_y.stepsize.zeroAxis) / 2;
            }
            if (this.chart.a_x.stepsize != null) {
                p1X = (p1X + this.chart.a_x.stepsize.zeroAxis) / 2;
                p2X = (p2X + this.chart.a_x.stepsize.zeroAxis) / 2;
            }
        }
        return new int[]{p1X, p1Y, p2X, p2Y};
    }

    @Override
    public void prepare_label3D(boolean bcreate) {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.prepare_label3D(bcreate);
            }
        } else {
            int fx = 0;
            int fy = 0;
            int fz = 0;
            if (this.plotData.element != null) {
                this.set3DLabelHeight();
                int offset = this.getOffsetUp();
                int z = this.getZPos(this.area);
                Color strColor = this.chart.topvalueLabel_color;
                if (this.plotData.element instanceof HiLowData) {
                    double value;
                    double baseValue = this.chart.a_y.getAxisShift();
                    HiLowData hilow = (HiLowData)this.plotData.element;
                    int x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset3D_side;
                    int y = this.getYPos(this.area, false) + offset;
                    boolean bclose = hilow.vclose != -1.7976931348623157E308;
                    double d = value = bclose ? hilow.vclose : hilow.vhi;
                    if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addLabels(bcreate, strColor, new Point3D(x, y, z), this.chart.getFormatValue((MultiDimData)this, bclose ? hilow.vclose : hilow.vhi), 0);
                    if (!bclose) {
                        x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset3D_side;
                        y = (this.area2 == null ? this.getYPos(this.area, true) : this.getYPos(this.area2, true)) - offset;
                        value = hilow.vlow;
                        strColor = this.chart.topvalueLabel_color;
                        if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                            strColor = this.chart.topvalueNegativeLabel_color;
                        }
                        this.addLabels(bcreate, strColor, new Point3D(x, y, z), this.chart.getFormatValue((MultiDimData)this, hilow.vlow), 0);
                    }
                } else {
                    String s;
                    int y;
                    int x;
                    double baseValue = this.chart.a_y.getAxisShift();
                    int[] pts = this.getAreaPoints(this.area);
                    int p1X = pts[0];
                    int p1Y = pts[1];
                    int p2X = pts[2];
                    int p2Y = pts[3];
                    z = (this.area.p1.z + this.area.p2.z) / 2;
                    double value = this.plotData.getValue();
                    switch (this.chart.chartType) {
                        case 0: {
                            x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset3D_side;
                            if (this.chart.isLabelOnPositiveSide()) {
                                y = Math.max(p2Y, p1Y) + offset;
                            } else if (this.chart.isLabelOnNegativeSide()) {
                                y = Math.min(p2Y, p1Y) - offset;
                            } else {
                                int n = y = value >= baseValue ? Math.max(p1Y, p2Y) + offset : Math.min(p1Y, p2Y) - offset;
                            }
                            if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                                strColor = this.chart.topvalueNegativeLabel_color;
                            }
                            s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                            break;
                        }
                        case 1: {
                            value = this.plotData.getValue();
                            x = this.chart.isLabelOnPositiveSide() ? Math.max(p2X, p1X) + offset : (this.chart.isLabelOnNegativeSide() ? Math.min(p2X, p1X) - offset : (value >= baseValue ? Math.max(p1X, p2X) + offset : Math.min(p1X, p2X) - offset));
                            y = (this.area.p2.y + this.area.p1.y) / 2 + this.chart.toplabel_offset3D_side;
                            if (value < baseValue && this.chart.topvalueNegativeLabel_color != null) {
                                strColor = this.chart.topvalueNegativeLabel_color;
                            }
                            s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                            break;
                        }
                        case 11: {
                            x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel_offset3D_side;
                            z = Math.max(this.area.p1.z, this.area.p2.z) + 10;
                            y = this.chart.topLabel_Alignment == 0 ? Math.max(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset3D_up : (this.chart.topLabel_Alignment == 3 ? Math.max(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset3D_up - this.labelHeight3D * 2 : (this.chart.topLabel_Alignment == 2 ? Math.min(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset3D_up - this.labelHeight3D * 2 : (this.chart.topLabel_Alignment == 4 ? Math.min(this.area.p1.y, this.area.p2.y) + this.chart.toplabel_offset3D_up : (this.area.p1.y + this.area.p2.y) / 2 + this.chart.toplabel_offset3D_up - this.labelHeight3D)));
                            s = this.chart.getFormatPercent(this.plotData);
                            break;
                        }
                        default: {
                            x = this.point.x + this.chart.toplabel_offset3D_side;
                            y = this.chart.chartType == 2 || this.chart.chartType == 12 || this.plotData.getValue() > 0.0 ? this.point.y + this.chart.toplabel_offset3D_up : this.point.y - this.chart.toplabel_offset3D_up;
                            z = this.point.z;
                            if (this.flashPoint != null && this.chart.chartType == 7) {
                                fx = this.flashPoint.x + this.chart.toplabel_offset3D_side;
                                fy = this.plotData.getValue() > 0.0 ? this.flashPoint.y + this.chart.toplabel_offset3D_up : this.flashPoint.y - this.chart.toplabel_offset3D_up;
                                fz = this.flashPoint.z;
                            }
                            s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                            if (!(value < baseValue) || this.chart.topvalueNegativeLabel_color == null) break;
                            strColor = this.chart.topvalueNegativeLabel_color;
                        }
                    }
                    if (this.isPointVisible()) {
                        int align = this.chart.getChartType() == 1 || this.chart.getChartType() == 5 ? this.getCStringAlignForBarChart(this.chart.topLabel_Alignment, value < baseValue) : 0;
                        if (this.flashPoint != null && this.chart.chartType == 7) {
                            this.addLabels(bcreate, strColor, new Point3D(x, y, z), s, align, this, new Point3D(fx, fy, fz));
                        } else {
                            this.addLabels(bcreate, strColor, new Point3D(x, y, z), s, align);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void prepare_secondary_label3D(boolean bcreate) {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.prepare_secondary_label3D(bcreate);
            }
        } else if (this.plotData.element != null) {
            String s;
            int z;
            int y;
            int x;
            switch (this.chart.comboType) {
                case 2: {
                    double value = this.plotData.getValue();
                    double baseValue = this.chart.a_s.getAxisShift();
                    x = (this.area.p1.x + this.area.p2.x) / 2 + this.chart.toplabel2_offset3D_side;
                    y = this.chart.isLabelOnPositiveSide() ? Math.max(this.area.p2.y, this.area.p1.y) + this.chart.toplabel2_offset3D_up : (this.chart.isLabelOnNegativeSide() ? Math.min(this.area.p2.y, this.area.p1.y) - this.chart.toplabel2_offset3D_up : (value >= baseValue ? Math.max(this.area.p1.y, this.area.p2.y) + this.chart.toplabel2_offset3D_up : Math.min(this.area.p1.y, this.area.p2.y) - this.chart.toplabel2_offset3D_up));
                    z = (this.area.p1.z + this.area.p2.z) / 2;
                    s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                    break;
                }
                default: {
                    if (this.chart.chartType == 1 || this.chart.chartType == 5) {
                        x = this.plotData.getValue() > 0.0 ? this.point.x + this.chart.toplabel2_offset3D_up : this.point.x - this.chart.toplabel2_offset3D_up;
                        y = this.point.y + this.chart.toplabel2_offset3D_side;
                    } else {
                        x = this.point.x + this.chart.toplabel2_offset3D_side;
                        y = this.plotData.getValue() > 0.0 ? this.point.y + this.chart.toplabel2_offset3D_up : this.point.y - this.chart.toplabel2_offset3D_up;
                    }
                    z = this.point.z;
                    s = this.chart.getFormatValue((MultiDimData)this, this.plotData);
                }
            }
            if (this.isPointVisible()) {
                this.addLabels2(bcreate, new Point3D(x, y, z), s, 0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepare_stacklabel3D(boolean bcreate) {
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.prepare_stacklabel3D(bcreate);
            }
        } else {
            double total1 = 0.0;
            double total2 = 0.0;
            Area armax = null;
            Area armin = null;
            this.set3DLabelHeight();
            if (this.multiData != null && this.multiData.length > 0) {
                this.multiData[this.multiData.length - 1].stackTotalLabel = null;
            }
            if (this.chart.chartType == 4) {
                for (MultiDimData element : this.multiData) {
                    double d;
                    double t = element.plotData.getValue();
                    if (d >= 0.0) {
                        total1 += t;
                        armax = element.area;
                        if ((!this.chart.getStackLabelState() || !this.showStackY(armax)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                        this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D((armax.p1.x + armax.p2.x) / 2 + this.chart.toplabel_offset3D_side, this.getStackYPos(armax, false) + this.getStackOffsetUp(armax.p1.y, armax.p2.y), this.getStackZPos(armax)), t == 0.0 && element.plotData.isEmpty() ? " " : this.chart.getFormatValue((MultiDimData)this, t), 0, element, null, this.chart.getStackLabelState() && this.showStackY(armax));
                        continue;
                    }
                    total2 += t;
                    armin = element.area;
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    if ((!this.chart.getStackLabelState() || !this.showStackY(armin)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                    this.addLabels(bcreate, strColor, new Point3D((armin.p1.x + armin.p2.x) / 2 + this.chart.toplabel_offset3D_side, this.getStackYPos(armin, true) + this.getStackOffsetUp(armin.p1.y, armin.p2.y), this.getStackZPos(armin)), t == 0.0 && element.plotData.isEmpty() ? " " : this.chart.getFormatValue((MultiDimData)this, t), 0, element, null, this.chart.getStackLabelState() && this.showStackY(armin));
                }
                if (armax != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armax);
                    this.addStackTotalLabel(bcreate, this.chart.topvalueLabel_color, new Point3D((armax.p1.x + armax.p2.x) / 2 + this.chart.toplabel_offset3D_side, nArray[3] + this.getOffsetUp(), this.getZPos(armax)), this.chart.getFormatValue((MultiDimData)this, total1));
                }
                if (armin != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armin);
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addStackTotalLabel(bcreate, strColor, new Point3D((armin.p1.x + armin.p2.x) / 2 + this.chart.toplabel_offset3D_side, nArray[1] - this.getOffsetUp(), this.getZPos(armin)), this.chart.getFormatValue((MultiDimData)this, total2));
                }
            } else if (this.chart.chartType == 5) {
                for (MultiDimData element : this.multiData) {
                    double d;
                    double t = element.plotData.getValue();
                    if (d >= 0.0) {
                        String str;
                        total1 += t;
                        armax = element.area;
                        String string = str = t == 0.0 && element.plotData.isEmpty() ? " " : this.chart.getFormatValue((MultiDimData)this, t);
                        if ((!this.chart.getStackLabelState() || !this.showStackX(armax, str)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                        int align = this.getCStringAlignForBarChart(this.chart.stackLabel_Alignment, false);
                        this.addLabels(bcreate, this.chart.topvalueLabel_color, new Point3D(this.getStackXPos(armax) + this.getOffsetLeft(this.chart.stackLabel_Alignment), (armax.p2.y + armax.p1.y) / 2 + this.chart.toplabel_offset3D_side, this.getStackZPos(armax)), str, align, element, null, this.chart.getStackLabelState() && this.showStackX(armax, str));
                        continue;
                    }
                    total2 += t;
                    armin = element.area;
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    String str = this.chart.getFormatValue((MultiDimData)this, t);
                    if ((!this.chart.getStackLabelState() || !this.showStackX(armin, str)) && !(this.chart.cgraphics.g instanceof IFlashGraphics)) continue;
                    int align = this.getCStringAlignForBarChart(this.chart.stackLabel_Alignment, true);
                    this.addLabels(bcreate, strColor, new Point3D(this.getStackXPos(armin) - this.getOffsetLeft(this.chart.stackLabel_Alignment), (armin.p2.y + armin.p1.y) / 2 + this.chart.toplabel_offset3D_side, this.getStackZPos(armin)), str, align, element, null, this.chart.getStackLabelState() && this.showStackX(armin, str));
                }
                if (armax != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armax);
                    this.addStackTotalLabel(bcreate, this.chart.topvalueLabel_color, new Point3D(nArray[0] + this.getOffsetUp(), (armax.p2.y + armax.p1.y) / 2 + this.chart.toplabel_offset3D_side, this.getZPos(armax)), this.chart.getFormatValue((MultiDimData)this, total1));
                }
                if (armin != null && (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState())) {
                    int[] nArray = this.getAreaPoints(armin);
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addStackTotalLabel(bcreate, strColor, new Point3D(nArray[2] - this.getOffsetUp(), (armin.p2.y + armin.p1.y) / 2 + this.chart.toplabel_offset3D_side, this.getZPos(armin)), this.chart.getFormatValue((MultiDimData)this, total2));
                }
            } else {
                double value;
                void var10_22;
                Point3D point3D;
                Point3D pmin = point3D = this.multiData[0].point;
                total1 = this.multiData[0].plotData.getValue();
                double t = -1.7976931348623157E308;
                double t2 = Double.MAX_VALUE;
                for (int i = 1; i < this.multiData.length; ++i) {
                    double d;
                    total1 += this.multiData[i].plotData.getValue();
                    if (d > t) {
                        t = total1;
                    }
                    if (total1 < t2) {
                        t2 = total1;
                    }
                    if (this.multiData[i].point.y > var10_22.y) {
                        Point3D point3D2 = this.multiData[i].point;
                        continue;
                    }
                    if (this.multiData[i].point.y >= pmin.y) continue;
                    pmin = this.multiData[i].point;
                }
                double d = value = total1 >= 0.0 ? t : t2;
                if (value == -1.7976931348623157E308 || value == Double.MAX_VALUE) {
                    value = total1;
                }
                if (this.chart.getStackLabelState() || this.chart.cgraphics.g instanceof IFlashGraphics) {
                    int previousPt = this.chart.a_y.stepsize.zeroAxis;
                    for (MultiDimData element : this.multiData) {
                        Point3D tmp = element.point;
                        Point3D ftmp = element.flashPoint;
                        double value1 = element.plotData.getValue();
                        boolean isEmpty = element.plotData.isEmpty();
                        Color strColor = this.chart.topvalueLabel_color;
                        if (this.chart.topvalueNegativeLabel_color != null && element.plotData.getValue() < 0.0) {
                            strColor = this.chart.topvalueNegativeLabel_color;
                        }
                        armax = new Area2D();
                        armax.p2.y = previousPt;
                        armax.p1.y = tmp.y;
                        if (this.showStackY(armax)) {
                            this.addLabels(bcreate, strColor, new Point3D(tmp.x + this.chart.toplabel_offset3D_side, this.getStackYPos(armax, true) + this.getStackOffsetUp(armax.p1.y, armax.p2.y), var10_22.z), value1 == 0.0 && isEmpty ? " " : this.chart.getFormatValue((MultiDimData)this, value1), 0, element, new Point3D(ftmp.x + this.chart.toplabel_offset_side, element.plotData.getValue() >= 0.0 ? ftmp.y + this.chart.toplabel_offset_up : ftmp.y - this.chart.toplabel_offset_up, pmin.z), this.showStackY(armax));
                        }
                        previousPt = tmp.y;
                    }
                }
                if (this.chart.getStackTotalLabelState() || !this.chart.getStackLabelState()) {
                    Color strColor = this.chart.topvalueLabel_color;
                    if (this.chart.topvalueNegativeLabel_color != null && total1 < 0.0) {
                        strColor = this.chart.topvalueNegativeLabel_color;
                    }
                    this.addStackTotalLabel(bcreate, strColor, new Point3D(var10_22.x + this.chart.toplabel_offset3D_side, total1 >= 0.0 ? var10_22.y + this.chart.toplabel_offset3D_up : pmin.y - this.chart.toplabel_offset3D_up, var10_22.z), this.chart.getFormatValue((MultiDimData)this, value));
                }
            }
        }
    }
}

