/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.Line;
import quadbase.chart.Point3D;
import quadbase.chart.Ticker;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;

public class Ticker3D
extends Ticker {
    public Vertex[] vertex;
    public Vertex[] vertex2;
    Vertex[] vertexlabel;
    public Vertex[] svertex;
    public Vertex[] svertex2;

    public Ticker3D(Axis axis) {
        super(axis);
    }

    @Override
    public void modify(Object[] name, Object sp, Point3D[] p, boolean reverseSide, boolean xyzchart) {
        int i;
        Space space = (Space)sp;
        this.modify(name, p, reverseSide);
        this.xyzchart = xyzchart;
        if (this.axis.orient != 2 || xyzchart) {
            this.vertex = new Vertex[p.length];
            this.vertex2 = new Vertex[p.length];
            block8: for (i = 0; i < p.length; ++i) {
                this.vertex[i] = new Vertex(p[i].x, p[i].y, p[i].z, space);
                switch (this.axis.orient) {
                    case 1: {
                        this.vertex2[i] = new Vertex(p[i].x - 35, p[i].y, p[i].z, space);
                        continue block8;
                    }
                    case 0: 
                    case 2: {
                        this.vertex2[i] = new Vertex(p[i].x, p[i].y - 35, p[i].z, space);
                        continue block8;
                    }
                    default: {
                        this.vertex2[i] = !this.axis.reversexlabel ? new Vertex(p[i].x + 35, p[i].y, p[i].z, space) : new Vertex(p[i].x, p[i].y + 35, p[i].z, space);
                    }
                }
            }
        } else {
            this.vertex = new Vertex[p.length - 1];
            this.vertex2 = new Vertex[this.vertex.length];
            this.vertexlabel = new Vertex[p.length];
            i = 0;
            for (i = 0; i < this.vertex.length; ++i) {
                this.vertex[i] = new Vertex(p[i].x, p[i].y, (p[i].z + p[i + 1].z) / 2, space);
                this.vertex2[i] = new Vertex(p[i].x, p[i].y - 35, this.vertex[i].z, space);
                this.vertexlabel[i] = new Vertex(p[i].x, p[i].y, p[i].z, space);
            }
            this.vertexlabel[i] = new Vertex(p[i].x, p[i].y, p[i].z, space);
        }
        if (this.subTickers == null) {
            return;
        }
        int step = 17;
        if (this.axis.orient != 2 || xyzchart) {
            this.svertex = new Vertex[this.subTickers.length];
            this.svertex2 = new Vertex[this.subTickers.length];
            block10: for (int i2 = 0; i2 < this.subTickers.length; ++i2) {
                this.svertex[i2] = new Vertex(this.subTickers[i2].x, this.subTickers[i2].y, this.subTickers[i2].z, space);
                switch (this.axis.orient) {
                    case 1: {
                        this.svertex2[i2] = new Vertex(this.subTickers[i2].x - step, this.subTickers[i2].y, this.subTickers[i2].z, space);
                        continue block10;
                    }
                    case 0: 
                    case 2: {
                        this.svertex2[i2] = new Vertex(this.subTickers[i2].x, this.subTickers[i2].y - step, this.subTickers[i2].z, space);
                        continue block10;
                    }
                    default: {
                        this.svertex2[i2] = !this.axis.reversexlabel ? new Vertex(this.subTickers[i2].x + step, this.subTickers[i2].y, this.subTickers[i2].z, space) : new Vertex(this.subTickers[i2].x, this.subTickers[i2].y + step, this.subTickers[i2].z, space);
                    }
                }
            }
        } else {
            this.svertex = new Vertex[p.length - 1];
            this.svertex2 = new Vertex[this.vertex.length];
            int i3 = 0;
            for (i3 = 0; i3 < this.svertex.length; ++i3) {
                this.svertex[i3] = new Vertex(this.subTickers[i3].x, this.subTickers[i3].y, (this.subTickers[i3].z + this.subTickers[i3 + 1].z) / 2, space);
                this.svertex2[i3] = new Vertex(this.subTickers[i3].x, this.subTickers[i3].y - step, this.svertex[i3].z, space);
            }
        }
    }

    @Override
    public void modify(Object[] name, Point3D[] point, boolean _reverseSide) {
        super.modify(name, point, _reverseSide);
        this.vertex2 = null;
        this.vertex = null;
    }

    @Override
    public void copy3DptsArray(CGraphics g, Point3D[] point) {
        if (this.vertex != null) {
            int len = this.length;
            if (point.length < len) {
                len = point.length;
            }
            if (this.axis.orient != 2 || this.xyzchart) {
                if (this.vertex2.length < len) {
                    len = this.vertex2.length;
                }
            } else if (this.vertexlabel.length < len) {
                len = this.vertexlabel.length;
            }
            for (int i = 0; i < len; ++i) {
                if (this.axis.orient != 2 || this.xyzchart) {
                    point[i].x = this.vertex2[i].screen_x;
                    point[i].y = g.height - this.vertex2[i].screen_y;
                    continue;
                }
                point[i].x = this.vertexlabel[i].screen_x;
                point[i].y = g.height - this.vertexlabel[i].screen_y - 20;
            }
        }
    }

    @Override
    public final boolean select(CGraphics g, int x, int y) {
        if (!this.showline) {
            return false;
        }
        if (this.vertex != null) {
            for (int i = 0; i < this.vertex.length; ++i) {
                if (!(this.tickerInward ? Line.pickLine(this.vertex[i].screen_x, this.vertex[i].screen_y, this.calcOppositePt(this.vertex[i].screen_x, this.vertex2[i].screen_x), this.calcOppositePt(this.vertex[i].screen_y, this.vertex2[i].screen_y), x, y) : Line.pickLine(this.vertex[i].screen_x, this.vertex[i].screen_y, this.vertex2[i].screen_x, this.vertex2[i].screen_y, x, y))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void drawLine(CGraphics g, int x, int y, int i, Point3D[] point) {
        if (this.showline && this.vertex != null && i < this.vertex.length) {
            g.g.setColor(this.color);
            if (this.tickerInward) {
                g.g.drawLine(this.vertex[i].screen_x, this.vertex[i].screen_y, this.calcOppositePt(this.vertex[i].screen_x, this.vertex2[i].screen_x), this.calcOppositePt(this.vertex[i].screen_y, this.vertex2[i].screen_y));
            } else {
                g.g.drawLine(this.vertex[i].screen_x, this.vertex[i].screen_y, this.vertex2[i].screen_x, this.vertex2[i].screen_y);
            }
        }
    }

    @Override
    public void draw3DSubTickers(CGraphics g) {
        if (this.showline && this.svertex != null) {
            for (int j = 0; j < this.svertex.length; ++j) {
                if (this.tickerInward) {
                    g.g.drawLine(this.svertex[j].screen_x, this.svertex[j].screen_y, this.calcOppositePt(this.svertex[j].screen_x, this.svertex2[j].screen_x), this.calcOppositePt(this.svertex[j].screen_y, this.svertex2[j].screen_y));
                    continue;
                }
                g.g.drawLine(this.svertex[j].screen_x, this.svertex[j].screen_y, this.svertex2[j].screen_x, this.svertex2[j].screen_y);
            }
        }
    }

    @Override
    public void drawLine(CGraphics g, int x, int y, int x2, int y2) {
    }
}

