/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.QbPattern;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Shape3D;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.internal.Graphics2DTool;
import quadbase.util.internal.RenderingChart;

public class PieFace
extends Face {
    private static final Logger LOGGER = Logger.getLogger(PieFace.class.getName());
    static final double MAX_SPAN_ANGLE = 0.5235987755982988;
    static final byte NO_EDGE = 0;
    static final byte LEFT_EDGE = 1;
    static final byte RIGHT_EDGE = 2;
    static final byte BOTH_EDGE = 3;
    protected byte pieType;
    protected Shape3D shapeOpen;
    protected Shape3D shapeFill;
    protected Shape3D clipShape;

    protected PieFace(Vertex _v1, Vertex _v2, Vertex _v3, Vertex _v4, Color color, Space space, Object object) {
        super(_v1, _v2, _v3, _v4, color, space, object);
    }

    public PieFace(double cx, double cy, double z, double width, double height, double startangle, double spanangle, Color color, Space space, Object object, byte pieType) {
        super(new Vertex((float)cx, (float)cy, (float)z, space), new Vertex((float)(cx + width * Math.cos(startangle)), (float)(cy + height * Math.sin(startangle)), (float)z, space), new Vertex((float)(cx + width * Math.cos(startangle + spanangle / 2.0)), (float)(cy + height * Math.sin(startangle + spanangle / 2.0)), (float)z, space), new Vertex((float)(cx + width * Math.cos(startangle + spanangle)), (float)(cy + height * Math.sin(startangle + spanangle)), (float)z, space), color, space, object);
        if (z > 0.0) {
            Vertex tmp = this.v2;
            this.v2 = this.v4;
            this.v4 = tmp;
        }
        this.pieType = pieType;
        this.shapeOpen = Shape3D.createArc3D(space, cx, cy, z, width, height, startangle, spanangle, 0);
        this.shapeFill = Shape3D.createArc3D(space, cx, cy, z, width, height, startangle, spanangle, 2);
        this.clipShape = Shape3D.createArc3D(space, cx, cy, z, width, height, 0.0, 360.0, 2);
    }

    @Override
    public void draw(CGraphics cg, int drawType, int[] xpoints, int[] ypoints, boolean isDataPoint) {
        if (!this.bshow) {
            return;
        }
        Graphics g = cg.g;
        g.setColor(this.color.color);
        xpoints[0] = this.v1.screen_x;
        ypoints[0] = this.v1.screen_y;
        xpoints[1] = this.v2.screen_x;
        ypoints[1] = this.v2.screen_y;
        xpoints[2] = this.v3.screen_x;
        ypoints[2] = this.v3.screen_y;
        xpoints[3] = this.v4.screen_x;
        ypoints[3] = this.v4.screen_y;
        for (int i = 0; i < 4; ++i) {
            if (xpoints[i] >= -500 && ypoints[i] >= -500) continue;
            LOGGER.finest("Negative coordinates - Skipped drawing of a plane");
            return;
        }
        if (drawType != 0) {
            if (cg.g instanceof IFlashGraphics) {
                xpoints[4] = this.v1.screen_x;
                ypoints[4] = this.v1.screen_y;
            }
            if ((drawType == 3 || drawType == 4) && g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                Color c = this.originalColor.color;
                Space sp = (Space)cg.chart.getSpace();
                Color color1 = this.computeColor(this.v1, sp, c);
                Color color2 = this.computeColor(this.v2, sp, c);
                Color color3 = this.computeColor(this.v3, sp, c);
                Color color4 = this.computeColor(this.v4, sp, c);
                GradientPaint gradient = new GradientPaint(this.v2.screen_x, this.v2.screen_y, color2, this.v4.screen_x, this.v4.screen_y, color4);
                g2d.setPaint(gradient);
                Object oldValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                RenderingChart.setRenderingHint(cg.g, cg.chart.renderingKey, cg.chart.renderingValue);
                g2d.fill(this.shapeFill);
                this.drawShadeTriangle(g, this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y, this.v3.screen_x, this.v3.screen_y, color1, color2, color3);
                this.drawShadeTriangle(g, this.v1.screen_x, this.v1.screen_y, this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y, color1, color3, color4);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValue);
                g2d.setPaint(new GradientPaint(this.v1.screen_x, this.v1.screen_y, color1, this.v2.screen_x, this.v2.screen_y, color2));
                g2d.draw(new Line2D.Float(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y));
                g2d.setPaint(new GradientPaint(this.v1.screen_x, this.v1.screen_y, color1, this.v4.screen_x, this.v4.screen_y, color4));
                g2d.draw(new Line2D.Float(this.v1.screen_x, this.v1.screen_y, this.v4.screen_x, this.v4.screen_y));
                g2d.setPaint(gradient);
                this.smoothEdges(g, xpoints, ypoints, false);
            } else {
                this.fillShape(cg, xpoints, ypoints, this.color.color, isDataPoint);
                this.smoothEdges(g, xpoints, ypoints, true);
            }
            if (drawType == 2 || drawType == 4) {
                this.drawWire(cg, xpoints, ypoints, isDataPoint);
            }
        } else {
            this.drawWire(cg, xpoints, ypoints, false);
        }
    }

    @Override
    void drawWire(CGraphics cg, int[] xpoints, int[] ypoints, boolean isDataPoint) {
        if (isDataPoint) {
            cg.g.setColor(cg.chart.getDataBorderColor());
        }
        this.drawShape(cg.g, xpoints, ypoints);
    }

    private void fillShape(CGraphics cg, int[] xpoints, int[] ypoints, Color fillColor, boolean isDataPoint) {
        Graphics g = cg.g;
        Object oldValue = null;
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            oldValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (isDataPoint && fillColor instanceof QbPattern && ((QbPattern)fillColor).getPatternTypeID() != 0) {
            Graphics2DTool.fillPatternShape(g, (QbPattern)fillColor, this.shapeFill);
        } else if (cg.chart.getPrimaryDataGradientSupport().isGradientEnabled()) {
            Graphics2DTool.fillGradientShape(g, cg.chart, fillColor, this.shapeFill);
        } else if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).fill(this.shapeFill);
        } else if (g instanceof Graphics2D) {
            ((Graphics2D)g).fill(this.shapeFill);
        } else {
            g.fillPolygon(xpoints, ypoints, 4);
        }
        if (g2d != null) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValue);
        }
    }

    protected void smoothEdges(Graphics g, int[] xpoints, int[] ypoints, boolean drawEdges) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.SrcOver);
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            if (drawEdges) {
                this.drawShape(g, xpoints, ypoints);
            } else {
                g2d.draw(this.shapeOpen);
            }
            g2d.setStroke(oldStroke);
            g2d.setComposite(oldComposite);
        } else if (!(g instanceof IFlashGraphics)) {
            this.drawShape(g, xpoints, ypoints);
        }
    }

    protected void drawShape(Graphics g, int[] xpoints, int[] ypoints) {
        if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).draw(this.shapeOpen);
        } else if (g instanceof Graphics2D) {
            ((Graphics2D)g).draw(this.shapeOpen);
        } else {
            g.drawLine(xpoints[1], ypoints[1], xpoints[2], ypoints[2]);
            g.drawLine(xpoints[2], ypoints[2], xpoints[3], ypoints[3]);
        }
        this.drawEdges(g);
    }

    protected void drawEdges(Graphics g) {
        if (this.pieType == 2 || this.pieType == 3) {
            if (this.v1.z > 0.0f) {
                g.drawLine(this.v1.screen_x, this.v1.screen_y, this.v4.screen_x, this.v4.screen_y);
            } else {
                g.drawLine(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y);
            }
        }
        if (this.pieType == 1 || this.pieType == 3) {
            if (this.v1.z > 0.0f) {
                g.drawLine(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y);
            } else {
                g.drawLine(this.v1.screen_x, this.v1.screen_y, this.v4.screen_x, this.v4.screen_y);
            }
        }
    }
}

