/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import java.util.logging.Logger;
import quadbase.chart.chart3d.lib3d.ConnectNode;
import quadbase.chart.chart3d.lib3d.DList;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.FacePriority;
import quadbase.chart.chart3d.lib3d.ListNode;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vector3D;
import quadbase.chart.chart3d.lib3d.Vertex;

public class PriorityTable {
    private static final Logger LOGGER = Logger.getLogger(PriorityTable.class.getName());

    private Vertex intersectpoint(Vector3D normal, Vertex vc, Vertex v1, Vertex v2, Space space) {
        float t2 = (v2.x - v1.x) * normal.i + (v2.y - v1.y) * normal.j + (v2.z - v1.z) * normal.k;
        if ((double)t2 > -1.0E-4 && (double)t2 < 1.0E-4) {
            return null;
        }
        float t = ((vc.x - v1.x) * normal.i + (vc.y - v1.y) * normal.j + (vc.z - v1.z) * normal.k) / t2;
        return t > 0.0f && t < 1.0f ? new Vertex(v1.x + t * (v2.x - v1.x), v1.y + t * (v2.y - v1.y), v1.z + t * (v2.z - v1.z), space) : null;
    }

    private void removeFace(Face f, DList facePriority) {
        ListNode currNode = facePriority.headNode;
        while (currNode.next != null) {
            currNode = currNode.next;
            ((FacePriority)currNode.getElement()).removeFace(f);
        }
    }

    ConnectNode dynamicBuildFeudalTree(Space space, DList faceList) {
        FacePriority fp;
        if (faceList.isEmpty()) {
            return null;
        }
        ConnectNode connectNode = new ConnectNode();
        DList facePriority = new DList();
        ListNode currNode = faceList.headNode;
        ListNode fcurrNode = facePriority.headNode;
        while (currNode.next != null) {
            int pos;
            Face f;
            Vector3D nor;
            ListNode scurrNode;
            DList backVector;
            DList frontVector;
            ListNode prevNode = currNode;
            currNode = currNode.next;
            ListNode fprevNode = fcurrNode;
            if (fcurrNode.next == null) {
                fp = new FacePriority((Face)currNode.getElement());
                fp.setPriority(space, faceList);
                facePriority.add(fp);
                fcurrNode = fcurrNode.next;
            } else {
                fcurrNode = fcurrNode.next;
                fp = (FacePriority)fcurrNode.getElement();
            }
            if (!fp.cutFaces.isEmpty()) continue;
            if (fp.frontFaces.isEmpty()) {
                facePriority.remove(fprevNode);
                faceList.remove(prevNode);
                frontVector = new DList();
                frontVector.add(fp.face);
                backVector = new DList();
                scurrNode = fp.parallelFaces.headNode;
                nor = fp.face.normal;
                while (scurrNode.next != null) {
                    scurrNode = scurrNode.next;
                    f = (Face)scurrNode.getElement();
                    if (nor.i * f.normal.i + nor.j * f.normal.j + nor.k * f.normal.k > 0.0f) {
                        frontVector.add(f);
                    } else {
                        backVector.add(f);
                    }
                    pos = faceList.remove(f);
                    facePriority.remove(pos);
                    this.removeFace(f, facePriority);
                }
                this.removeFace(fp.face, facePriority);
                connectNode.addFront(frontVector);
                if (!backVector.isEmpty()) {
                    connectNode.addBack(backVector);
                }
                currNode = faceList.headNode;
                fcurrNode = facePriority.headNode;
                continue;
            }
            if (fp.backFaces.isEmpty()) {
                facePriority.remove(fprevNode);
                faceList.remove(prevNode);
                backVector = new DList();
                backVector.add(fp.face);
                frontVector = new DList();
                scurrNode = fp.parallelFaces.headNode;
                nor = fp.face.normal;
                while (scurrNode.next != null) {
                    scurrNode = scurrNode.next;
                    f = (Face)scurrNode.getElement();
                    if (nor.i * f.normal.i + nor.j * f.normal.j + nor.k * f.normal.k > 0.0f) {
                        backVector.add(f);
                    } else {
                        frontVector.add(f);
                    }
                    pos = faceList.remove(f);
                    facePriority.remove(pos);
                    this.removeFace(f, facePriority);
                }
                this.removeFace(fp.face, facePriority);
                connectNode.addBack(backVector);
                if (!frontVector.isEmpty()) {
                    connectNode.addFront(frontVector);
                }
                currNode = faceList.headNode;
                fcurrNode = facePriority.headNode;
                continue;
            }
            connectNode.addMiddle(fp.face, fp.parallelFaces);
            connectNode.splitNode.leftNode = this.dynamicBuildFeudalTree(space, fp.frontFaces);
            connectNode.splitNode.rightNode = this.dynamicBuildFeudalTree(space, fp.backFaces);
            return connectNode;
        }
        if (facePriority.isEmpty()) {
            return connectNode;
        }
        ListNode splitplane = null;
        int cutno = 0;
        int differ = 0;
        boolean findfirst = false;
        currNode = facePriority.headNode;
        while (currNode.next != null) {
            currNode = currNode.next;
            fp = (FacePriority)currNode.getElement();
            if (findfirst) {
                if (fp.cutFaces.size() >= cutno && (fp.cutFaces.size() != cutno || Math.abs(fp.frontFaces.size() - fp.backFaces.size()) >= differ)) continue;
                splitplane = currNode;
                differ = Math.abs(fp.frontFaces.size() - fp.backFaces.size());
                cutno = fp.cutFaces.size();
                continue;
            }
            splitplane = currNode;
            differ = Math.abs(fp.frontFaces.size() - fp.backFaces.size());
            cutno = fp.cutFaces.size();
            findfirst = true;
        }
        fp = (FacePriority)splitplane.getElement();
        Face cutface = fp.face;
        currNode = fp.cutFaces.headNode;
        while (currNode.next != null) {
            Face tmp3;
            Face tmp2;
            Face tmp1;
            currNode = currNode.next;
            Face cuttingface = (Face)currNode.getElement();
            Vertex cut12 = this.intersectpoint(cutface.normal, cutface.v1, cuttingface.v1, cuttingface.v2, space);
            int count = cut12 == null ? 0 : 1;
            Vertex cut23 = this.intersectpoint(cutface.normal, cutface.v1, cuttingface.v2, cuttingface.v3, space);
            if ((count += cut23 == null ? 0 : 1) < 2) {
                Face tmpFace;
                Vertex cut34 = this.intersectpoint(cutface.normal, cutface.v1, cuttingface.v3, cuttingface.v4, space);
                if ((count += cut34 == null ? 0 : 1) < 2) {
                    Vertex cut41 = this.intersectpoint(cutface.normal, cutface.v1, cuttingface.v4, cuttingface.v1, space);
                    if ((count += cut41 == null ? 0 : 1) != 2) {
                        LOGGER.finest("[PriorityTable] Numerical error !");
                        fp.frontFaces.add(cuttingface);
                        fp.backFaces.add(cuttingface);
                        continue;
                    }
                    if (cut12 != null) {
                        LOGGER.finest("case cut12 and cut41");
                        tmp1 = new Face(cut12, cut41, cuttingface.v1, cuttingface.v1, cuttingface);
                        tmp1.resetSkipLine();
                        tmp1.setSkipLine(1);
                        if (cuttingface.skipLine(1)) {
                            tmp1.setSkipLine(4);
                        }
                        if (cuttingface.skipLine(4)) {
                            tmp1.setSkipLine(2);
                        }
                        tmp2 = new Face(cut41, cut12, cuttingface.v2, cuttingface.v4, cuttingface);
                        tmp2.resetSkipLine();
                        tmp2.setSkipLine(1);
                        tmp2.setSkipLine(3);
                        if (cuttingface.skipLine(1)) {
                            tmp2.setSkipLine(2);
                        }
                        if (cuttingface.skipLine(4)) {
                            tmp2.setSkipLine(4);
                        }
                        tmp3 = new Face(cuttingface.v4, cuttingface.v2, cuttingface.v3, cuttingface.v3, cuttingface);
                        tmp3.resetSkipLine();
                        tmp3.setSkipLine(1);
                        if (cuttingface.skipLine(2)) {
                            tmp3.setSkipLine(2);
                        }
                        if (cuttingface.skipLine(3)) {
                            tmp3.setSkipLine(4);
                        }
                        if (cuttingface.v1.x * cutface.normal.i + cuttingface.v1.y * cutface.normal.j + cuttingface.v1.z * cutface.normal.k - cutface.coeff > 0.0f) {
                            fp.frontFaces.add(tmp1);
                            fp.backFaces.add(tmp2);
                            fp.backFaces.add(tmp3);
                            continue;
                        }
                        fp.backFaces.add(tmp1);
                        fp.frontFaces.add(tmp2);
                        fp.frontFaces.add(tmp3);
                        continue;
                    }
                    if (cut23 != null) {
                        Face tmp;
                        LOGGER.finest("case cut23 and cut41");
                        if (cuttingface.v1.x * cutface.normal.i + cuttingface.v1.y * cutface.normal.j + cuttingface.v1.z * cutface.normal.k - cutface.coeff > 0.0f) {
                            tmp = new Face(cuttingface.v1, cuttingface.v2, cut23, cut41, cuttingface);
                            tmp.setSkipLine(3);
                            fp.frontFaces.add(tmp);
                            tmp2 = new Face(cut23, cuttingface.v3, cuttingface.v4, cut41, cuttingface, -1);
                            tmp2.setSkipLine(4);
                            fp.backFaces.add(tmp2);
                            continue;
                        }
                        tmp = new Face(cuttingface.v1, cuttingface.v2, cut23, cut41, cuttingface);
                        tmp.setSkipLine(3);
                        fp.backFaces.add(tmp);
                        tmp2 = new Face(cut23, cuttingface.v3, cuttingface.v4, cut41, cuttingface, -1);
                        tmp2.setSkipLine(4);
                        fp.frontFaces.add(tmp2);
                        continue;
                    }
                    LOGGER.finest("case cut34 and cut41");
                    tmp1 = new Face(cut41, cut34, cuttingface.v4, cuttingface.v4, cuttingface);
                    tmp1.resetSkipLine();
                    tmp1.setSkipLine(1);
                    if (cuttingface.skipLine(3)) {
                        tmp1.setSkipLine(2);
                    }
                    if (cuttingface.skipLine(4)) {
                        tmp1.setSkipLine(4);
                    }
                    tmp2 = new Face(cut34, cut41, cuttingface.v1, cuttingface.v3, cuttingface);
                    tmp2.resetSkipLine();
                    tmp2.setSkipLine(1);
                    tmp2.setSkipLine(3);
                    if (cuttingface.skipLine(3)) {
                        tmp2.setSkipLine(4);
                    }
                    if (cuttingface.skipLine(4)) {
                        tmp2.setSkipLine(2);
                    }
                    tmp3 = new Face(cuttingface.v3, cuttingface.v1, cuttingface.v2, cuttingface.v2, cuttingface);
                    tmp3.resetSkipLine();
                    tmp3.setSkipLine(1);
                    if (cuttingface.skipLine(1)) {
                        tmp3.setSkipLine(2);
                    }
                    if (cuttingface.skipLine(2)) {
                        tmp3.setSkipLine(4);
                    }
                    if (cuttingface.v4.x * cutface.normal.i + cuttingface.v4.y * cutface.normal.j + cuttingface.v4.z * cutface.normal.k - cutface.coeff > 0.0f) {
                        fp.frontFaces.add(tmp1);
                        fp.backFaces.add(tmp2);
                        fp.backFaces.add(tmp3);
                        continue;
                    }
                    fp.backFaces.add(tmp1);
                    fp.frontFaces.add(tmp2);
                    fp.frontFaces.add(tmp3);
                    continue;
                }
                if (cut12 == null) {
                    LOGGER.finest("case cut23 and cut34");
                    tmp1 = new Face(cut34, cut23, cuttingface.v3, cuttingface.v3, cuttingface);
                    tmp1.resetSkipLine();
                    tmp1.setSkipLine(1);
                    if (cuttingface.skipLine(2)) {
                        tmp1.setSkipLine(2);
                    }
                    if (cuttingface.skipLine(3)) {
                        tmp1.setSkipLine(4);
                    }
                    Face tmp2a = new Face(cuttingface.v4, cuttingface.v2, cut23, cut34, cuttingface);
                    tmp2a.resetSkipLine();
                    tmp2a.setSkipLine(1);
                    tmp2a.setSkipLine(3);
                    if (cuttingface.skipLine(2)) {
                        tmp2a.setSkipLine(2);
                    }
                    if (cuttingface.skipLine(3)) {
                        tmp2a.setSkipLine(4);
                    }
                    Face tmp2b = new Face(cuttingface.v2, cut23, cut34, cuttingface.v4, cuttingface);
                    tmp2b.resetSkipLine();
                    tmp2b.setSkipLine(4);
                    tmp2b.setSkipLine(2);
                    if (cuttingface.skipLine(2)) {
                        tmp2b.setSkipLine(1);
                    }
                    if (cuttingface.skipLine(3)) {
                        tmp2b.setSkipLine(3);
                    }
                    Face tmp32 = new Face(cuttingface.v2, cuttingface.v4, cuttingface.v1, cuttingface.v1, cuttingface);
                    tmp32.resetSkipLine();
                    tmp32.setSkipLine(1);
                    if (cuttingface.skipLine(1)) {
                        tmp32.setSkipLine(4);
                    }
                    if (cuttingface.skipLine(4)) {
                        tmp32.setSkipLine(2);
                    }
                    if (cuttingface.v3.x * cutface.normal.i + cuttingface.v3.y * cutface.normal.j + cuttingface.v3.z * cutface.normal.k - cutface.coeff > 0.0f) {
                        fp.frontFaces.add(tmp1);
                        fp.backFaces.add(tmp2a);
                        fp.backFaces.add(tmp32);
                        continue;
                    }
                    fp.backFaces.add(tmp1);
                    fp.frontFaces.add(tmp2b);
                    fp.frontFaces.add(tmp32);
                    continue;
                }
                LOGGER.finest("case cut12 and cut34");
                if (cuttingface.v3.x * cutface.normal.i + cuttingface.v3.y * cutface.normal.j + cuttingface.v3.z * cutface.normal.k - cutface.coeff > 0.0f) {
                    tmpFace = new Face(cut12, cuttingface.v2, cuttingface.v3, cut34, cuttingface);
                    tmpFace.setSkipLine(4);
                    fp.frontFaces.add(tmpFace);
                    tmpFace = new Face(cuttingface.v1, cut12, cut34, cuttingface.v4, cuttingface);
                    tmpFace.setSkipLine(2);
                    fp.backFaces.add(tmpFace);
                    continue;
                }
                LOGGER.finest("SUB CASE 2");
                tmpFace = new Face(cut12, cuttingface.v2, cuttingface.v3, cut34, cuttingface);
                tmpFace.setSkipLine(4);
                fp.backFaces.add(tmpFace);
                Face tmpFace2 = new Face(cuttingface.v1, cut12, cut34, cuttingface.v4, cuttingface);
                tmpFace2.setSkipLine(2);
                fp.frontFaces.add(tmpFace2);
                continue;
            }
            LOGGER.finest("case cut12 and cut23");
            tmp1 = new Face(cut23, cut12, cuttingface.v2, cuttingface.v2, cuttingface);
            tmp1.resetSkipLine();
            tmp1.setSkipLine(1);
            if (cuttingface.skipLine(1)) {
                tmp1.setSkipLine(2);
            }
            if (cuttingface.skipLine(2)) {
                tmp1.setSkipLine(4);
            }
            tmp2 = new Face(cuttingface.v1, cut12, cut23, cuttingface.v3, cuttingface);
            tmp2.resetSkipLine();
            tmp2.setSkipLine(2);
            tmp2.setSkipLine(4);
            if (cuttingface.skipLine(1)) {
                tmp2.setSkipLine(1);
            }
            if (cuttingface.skipLine(2)) {
                tmp2.setSkipLine(3);
            }
            tmp3 = new Face(cuttingface.v1, cuttingface.v3, cuttingface.v4, cuttingface.v4, cuttingface);
            tmp3.resetSkipLine();
            tmp3.setSkipLine(1);
            if (cuttingface.skipLine(3)) {
                tmp3.setSkipLine(2);
            }
            if (cuttingface.skipLine(4)) {
                tmp3.setSkipLine(4);
            }
            if (cuttingface.v2.x * cutface.normal.i + cuttingface.v2.y * cutface.normal.j + cuttingface.v2.z * cutface.normal.k - cutface.coeff > 0.0f) {
                fp.frontFaces.add(tmp1);
                fp.backFaces.add(tmp2);
                fp.backFaces.add(tmp3);
                continue;
            }
            fp.backFaces.add(tmp1);
            fp.frontFaces.add(tmp2);
            fp.frontFaces.add(tmp3);
        }
        connectNode.addMiddle(fp.face, fp.parallelFaces);
        connectNode.splitNode.leftNode = this.dynamicBuildFeudalTree(space, fp.frontFaces);
        connectNode.splitNode.rightNode = this.dynamicBuildFeudalTree(space, fp.backFaces);
        return connectNode;
    }
}

