/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;

public class Shape3D
implements Shape {
    private static final double SPACE_HEIGHT = 1000.0;
    private Space space;
    private Shape shape;
    private ArrayList coords;
    private ArrayList types;
    float[] zIndexes;
    int windingRule;

    public static Shape3D createArc3D(Space space, double x, double y, double z, double w, double h, double start, double extent, int type) {
        Arc2D.Double arc = new Arc2D.Double(x - w, 1000.0 - y - h, 2.0 * w, 2.0 * h, Math.toDegrees(start), Math.toDegrees(extent), type);
        PathIterator it = arc.getPathIterator(null);
        int count = 0;
        while (!it.isDone()) {
            ++count;
            it.next();
        }
        float[] zIndexes = new float[count];
        Arrays.fill(zIndexes, (float)z);
        return new Shape3D(arc, space, zIndexes);
    }

    public static Shape3D createCircum3D(Space space, double x, double y, double z1, double z2, double w, double h, double start, double extent, boolean isFill) {
        GeneralPath path = new GeneralPath();
        Arc2D.Double arc1 = new Arc2D.Double(x - w, 1000.0 - y - h, 2.0 * w, 2.0 * h, Math.toDegrees(start + extent), -Math.toDegrees(extent), 0);
        Arc2D.Double arc2 = new Arc2D.Double(x - w, 1000.0 - y - h, 2.0 * w, 2.0 * h, Math.toDegrees(start), Math.toDegrees(extent), 0);
        if (isFill) {
            path.append(arc1, false);
            path.lineTo((float)path.getCurrentPoint().getX(), (float)path.getCurrentPoint().getY());
            path.append(arc2, true);
            path.closePath();
        } else {
            path.append(arc1, false);
            path.append(arc2, false);
        }
        return new Shape3D(path, space, new float[]{(float)z1, (float)z1, (float)z2, (float)z2});
    }

    public static Shape3D createDoughnutPie3D(Space space, double x, double y, double z, double w, double h, double start, double extent, double pieThickness, boolean isFill) {
        GeneralPath path = new GeneralPath();
        Arc2D.Double innerArc = new Arc2D.Double(x - w * pieThickness, 1000.0 - y - h * pieThickness, 2.0 * w * pieThickness, 2.0 * h * pieThickness, Math.toDegrees(start), Math.toDegrees(extent), 0);
        Arc2D.Double outerArc = new Arc2D.Double(x - w, 1000.0 - y - h, 2.0 * w, 2.0 * h, Math.toDegrees(start + extent), -Math.toDegrees(extent), 0);
        if (isFill) {
            path.append(innerArc, false);
            path.append(outerArc, true);
            path.closePath();
        } else {
            path.append(innerArc, false);
            path.append(outerArc, false);
        }
        PathIterator it = path.getPathIterator(null);
        int count = 0;
        while (!it.isDone()) {
            ++count;
            it.next();
        }
        float[] zIndexes = new float[count];
        Arrays.fill(zIndexes, (float)z);
        return new Shape3D(path, space, zIndexes);
    }

    protected Shape3D(Shape shape, Space space) {
        this(shape, space, null);
    }

    protected Shape3D(Shape shape, Space space, float[] zIndexes) {
        this.space = space;
        this.shape = shape;
        this.zIndexes = zIndexes;
        this.createControlVectors();
    }

    private void createControlVectors() {
        AffineTransform transform = AffineTransform.getScaleInstance(1.0, -1.0);
        transform.translate(0.0, -1000.0);
        PathIterator it = this.shape.getPathIterator(transform);
        this.windingRule = it.getWindingRule();
        this.types = new ArrayList();
        this.coords = new ArrayList();
        float[] af = new float[6];
        int i = 0;
        while (!it.isDone()) {
            Object[] vertex = new Vertex[3];
            Arrays.fill(vertex, null);
            int type = it.currentSegment(af);
            if (type == 0 || type == 1 || type == 2 || type == 3) {
                vertex[0] = new Vertex(af[0], af[1], this.getZIndex(i), this.space);
            }
            if (type == 2 || type == 3) {
                vertex[1] = new Vertex(af[2], af[3], this.getZIndex(i), this.space);
            }
            if (type == 3) {
                vertex[2] = new Vertex(af[4], af[5], this.getZIndex(i), this.space);
            }
            this.types.add(type);
            this.coords.add(vertex);
            it.next();
            ++i;
        }
    }

    private float getZIndex(int i) {
        if (this.zIndexes != null && i < this.zIndexes.length) {
            return this.zIndexes[i];
        }
        return 0.0f;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affinetransform) {
        return new PathIterator3D(affinetransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affinetransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affinetransform), d);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.shape.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.shape.contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.shape.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.shape.contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.shape.getBounds2D();
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.shape.intersects(x, y, w, h);
    }

    private class PathIterator3D
    implements PathIterator {
        private int index = 0;
        private AffineTransform transform;

        public PathIterator3D(AffineTransform transform) {
            this.transform = transform;
        }

        @Override
        public int currentSegment(float[] af) {
            if (this.isDone()) {
                throw new IllegalArgumentException("No more segments available");
            }
            int type = (Integer)Shape3D.this.types.get(this.index);
            Vertex[] v = (Vertex[])Shape3D.this.coords.get(this.index);
            int n = 0;
            if (type == 0 || type == 1 || type == 2 || type == 3) {
                af[0] = v[0].screen_x;
                af[1] = v[0].screen_y;
                ++n;
            }
            if (type == 2 || type == 3) {
                af[2] = v[1].screen_x;
                af[3] = v[1].screen_y;
                ++n;
            }
            if (type == 3) {
                af[4] = v[2].screen_x;
                af[5] = v[2].screen_y;
                ++n;
            }
            if (this.transform != null) {
                this.transform.transform(af, 0, af, 0, n);
            }
            return type;
        }

        @Override
        public int currentSegment(double[] ad) {
            if (this.isDone()) {
                throw new IllegalArgumentException("No more segments available");
            }
            int type = (Integer)Shape3D.this.types.get(this.index);
            Vertex[] v = (Vertex[])Shape3D.this.coords.get(this.index);
            int n = 0;
            if (type == 0 || type == 1 || type == 2 || type == 3) {
                ad[0] = v[0].screen_x;
                ad[1] = v[0].screen_y;
                ++n;
            }
            if (type == 2 || type == 3) {
                ad[2] = v[1].screen_x;
                ad[3] = v[1].screen_y;
                ++n;
            }
            if (type == 3) {
                ad[4] = v[2].screen_x;
                ad[5] = v[2].screen_y;
                ++n;
            }
            if (this.transform != null) {
                this.transform.transform(ad, 0, ad, 0, n);
            }
            return type;
        }

        @Override
        public int getWindingRule() {
            return Shape3D.this.windingRule;
        }

        @Override
        public boolean isDone() {
            return this.index >= Shape3D.this.types.size();
        }

        @Override
        public void next() {
            ++this.index;
        }
    }
}

