/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import java.awt.Color;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.Point3D;
import quadbase.chart.QbPattern;
import quadbase.chart.chart3d.lib3d.CircumFace;
import quadbase.chart.chart3d.lib3d.DList;
import quadbase.chart.chart3d.lib3d.DoughnutPieFace;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.HiddenSurface;
import quadbase.chart.chart3d.lib3d.ListNode;
import quadbase.chart.chart3d.lib3d.Matrix;
import quadbase.chart.chart3d.lib3d.PieFace;
import quadbase.chart.chart3d.lib3d.Vector3D;
import quadbase.chart.chart3d.lib3d.Vertex;

public class Space {
    private static final Logger LOGGER = Logger.getLogger(Space.class.getName());
    int xmin;
    int xmax;
    int ymin;
    int ymax;
    public Vertex eye = new Vertex();
    public Vertex center = new Vertex();
    float space_width;
    float space_height;
    float space_width2;
    float space_height2;
    float width_coeff;
    float height_coeff;
    Matrix matrix = new Matrix();
    public Vertex[] vertexList;
    public Vector3D viewVec;
    int maxvertex = 400;
    public int vertex_no = 0;
    public static final int wallThickness = 20;
    float perspective;
    public float zoomfactor;
    public float spaceScale;
    public HiddenSurface hiddenSurface;
    Vertex lightpos;
    public Vector3D lightvec;
    Vertex translate = new Vertex();
    float intensity_r;
    float intensity_g;
    float intensity_b;
    float ambient_r;
    float ambient_g;
    float ambient_b;
    public float ratio;
    public float xscale = 1.0f;
    public float yscale = 1.0f;
    public float zscale = 1.0f;
    public boolean is3DApproximationUsed = false;

    public Space(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.space_width2 = xmax - xmin;
        this.space_height2 = ymax - ymin;
        this.width_coeff = (float)(xmin + xmax) / 2.0f;
        this.height_coeff = (float)(ymin + ymax) / 2.0f;
        this.vertexList = new Vertex[this.maxvertex];
    }

    public float perspective(float degree, float ratio, float precision) {
        float t = degree != 0.0f ? (float)(2.0 * Math.tan((double)degree * Math.PI / 360.0)) : precision;
        this.zoomfactor = precision;
        this.perspective = degree;
        this.ratio = ratio;
        this.space_width = this.space_width2 / (t * ratio);
        this.space_height = this.space_height2 / -t;
        this.spaceScale = degree != 0.0f ? 0.6f * precision / t : precision;
        return this.spaceScale;
    }

    public final void resize(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.space_width2 = xmax - xmin;
        this.space_height2 = ymax - ymin;
        this.width_coeff = (float)(xmin + xmax) / 2.0f;
        this.height_coeff = (float)(ymin + ymax) / 2.0f;
        float t = this.perspective != 0.0f ? (float)(2.0 * Math.tan((double)this.perspective * Math.PI / 360.0)) : this.zoomfactor;
        this.space_width = this.space_width2 / (t * (float)(xmax - xmin) / (float)(ymax - ymin));
        this.space_height = this.space_height2 / -t;
    }

    public final void lookat(float from_x, float from_y, float from_z, float to_x, float to_y, float to_z) {
        this.eye.x = from_x;
        this.eye.y = from_y;
        this.eye.z = from_z;
        this.center.x = to_x;
        this.center.y = to_y;
        this.center.z = to_z;
        this.matrix.lookat(from_x, from_y, from_z, to_x, to_y, to_z);
        this.viewVec = new Vector3D(to_x - from_x, to_y - from_y, to_z - from_z, true);
        this.matrix.translate(this.translate);
    }

    public final void setTranslate(float x, float y, float z) {
        this.translate.x = x;
        this.translate.y = y;
        this.translate.z = z;
    }

    public final void addTranslate(float x, float y, float z) {
        this.translate.x += x;
        this.translate.y += y;
        this.translate.z += z;
    }

    public void recomputeColor() {
        if (this.hiddenSurface != null && this.hiddenSurface.faceList != null) {
            ListNode currNode = this.hiddenSurface.faceList.getHeadNode().next;
            while (currNode != null) {
                Face face = (Face)currNode.getElement();
                face.computeNormal();
                face.color.color = this.computeColor(face.normal, face.originalColor.color);
                currNode = currNode.next;
            }
        }
    }

    public void setLight(Vertex lightpos, float intensity_r, float intensity_g, float intensity_b, float ambient_r, float ambient_g, float ambient_b) {
        this.intensity_r = intensity_r;
        this.intensity_g = intensity_g;
        this.intensity_b = intensity_b;
        this.ambient_r = ambient_r;
        this.ambient_g = ambient_g;
        this.ambient_b = ambient_b;
        this.lightpos = lightpos;
        this.lightvec = new Vector3D(lightpos.x, lightpos.y, lightpos.z, true);
        this.recomputeColor();
    }

    public Color computeColor(Vector3D normal, Color faceColor) {
        float cos_angle = Math.abs(normal.i * this.lightvec.i + normal.j * this.lightvec.j + normal.k * this.lightvec.k);
        if ((double)cos_angle < 0.4) {
            cos_angle = 0.3f + (cos_angle + 1.0f) / 10.0f;
        }
        Color tempColor = new Color(Math.min((int)(this.ambient_r + this.intensity_r * (float)faceColor.getRed() * cos_angle), 255), Math.min((int)(this.ambient_g + this.intensity_g * (float)faceColor.getGreen() * cos_angle), 255), Math.min((int)(this.ambient_b + this.intensity_b * (float)faceColor.getBlue() * cos_angle), 255), faceColor.getAlpha());
        if (faceColor instanceof QbPattern && ((QbPattern)faceColor).getPatternTypeID() != 0) {
            QbPattern faceTexture = (QbPattern)faceColor;
            return new QbPattern(tempColor, faceTexture.getPatternTypeID());
        }
        return tempColor;
    }

    public void addVertex(Vertex v) {
        if (this.vertex_no >= this.maxvertex) {
            this.maxvertex *= 2;
            Vertex[] vertexList2 = new Vertex[this.maxvertex];
            System.arraycopy(this.vertexList, 0, vertexList2, 0, this.vertexList.length);
            this.vertexList = vertexList2;
        }
        this.vertexList[this.vertex_no++] = v;
    }

    public void addBox(Vector vec, float x1, float y1, float z1, float x2, float y2, float z2, Color color, boolean positive, Object object) {
        this.addBox(vec, x1, y1, z1, x2, y2, z2, color, positive, object, false);
    }

    public void addBox(Vector vec, float x1, float y1, float z1, float x2, float y2, float z2, Color color, boolean positive, Object object, boolean isFixedColor) {
        float t;
        if (x1 > x2) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (y1 > y2) {
            t = y2;
            y2 = y1;
            y1 = t;
        }
        if (z1 > z2) {
            t = z2;
            z2 = z1;
            z1 = t;
        }
        if (positive) {
            if (x1 < 0.0f) {
                x1 = 0.0f;
            }
            if (y1 < 0.0f) {
                y1 = 0.0f;
            }
            if (z1 < 0.0f) {
                z1 = 0.0f;
            }
        }
        Vertex v1 = new Vertex(x2, y2, z2, this);
        Vertex v2 = new Vertex(x2, y2, z1, this);
        Vertex v3 = new Vertex(x2, y1, z1, this);
        Vertex v4 = new Vertex(x2, y1, z2, this);
        Vertex v5 = new Vertex(x1, y2, z2, this);
        Vertex v6 = new Vertex(x1, y2, z1, this);
        Vertex v7 = new Vertex(x1, y1, z1, this);
        Vertex v8 = new Vertex(x1, y1, z2, this);
        vec.addElement(new Face(v1, v2, v3, v4, color, this, object, isFixedColor));
        vec.addElement(new Face(v4, v3, v7, v8, color, this, object, isFixedColor));
        vec.addElement(new Face(v8, v7, v6, v5, color, this, object, isFixedColor));
        vec.addElement(new Face(v1, v5, v6, v2, color, this, object, isFixedColor));
        vec.addElement(new Face(v1, v4, v8, v5, color, this, object, isFixedColor));
        vec.addElement(new Face(v3, v2, v6, v7, color, this, object, isFixedColor));
    }

    public void addBox(Face[] faceList, float x1, float y1, float z1, float x2, float y2, float z2, Color color, boolean positive, Object object) {
        float t;
        if (x1 > x2) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (y1 > y2) {
            t = y2;
            y2 = y1;
            y1 = t;
        }
        if (z1 > z2) {
            t = z2;
            z2 = z1;
            z1 = t;
        }
        if (positive) {
            if (x1 < 0.0f) {
                x1 = 0.0f;
            }
            if (y1 < 0.0f) {
                y1 = 0.0f;
            }
            if (z1 < 0.0f) {
                z1 = 0.0f;
            }
        }
        Vertex v1 = new Vertex(x2, y2, z2, this);
        Vertex v2 = new Vertex(x2, y2, z1, this);
        Vertex v3 = new Vertex(x2, y1, z1, this);
        Vertex v4 = new Vertex(x2, y1, z2, this);
        Vertex v5 = new Vertex(x1, y2, z2, this);
        Vertex v6 = new Vertex(x1, y2, z1, this);
        Vertex v7 = new Vertex(x1, y1, z1, this);
        Vertex v8 = new Vertex(x1, y1, z2, this);
        faceList[0] = new Face(v1, v2, v3, v4, color, this, object);
        faceList[1] = new Face(v4, v3, v7, v8, color, this, object);
        faceList[2] = new Face(v8, v7, v6, v5, color, this, object);
        faceList[3] = new Face(v1, v5, v6, v2, color, this, object);
        faceList[4] = new Face(v1, v4, v8, v5, color, this, object);
        faceList[5] = new Face(v3, v2, v6, v7, color, this, object);
    }

    public void addLine(Vector faceList, Vertex u1, Vertex u2, double thick, double height, Color color, Object object) {
        if ((double)u1.y > height) {
            if ((double)u2.y > height) {
                Vertex v1 = new Vertex(u1.x, (float)((double)u1.y - height), (float)((double)u1.z - thick), this);
                Vertex v2 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z - thick), this);
                Vertex v3 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z + thick), this);
                Vertex v4 = new Vertex(u1.x, (float)((double)u1.y - height), (float)((double)u1.z + thick), this);
                Vertex v5 = new Vertex(u2.x, (float)((double)u2.y - height), (float)((double)u2.z - thick), this);
                Vertex v6 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z - thick), this);
                Vertex v7 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z + thick), this);
                Vertex v8 = new Vertex(u2.x, (float)((double)u2.y - height), (float)((double)u2.z + thick), this);
                faceList.addElement(new Face(v1, v2, v3, v4, color, this, object));
                faceList.addElement(new Face(v4, v3, v7, v8, color, this, object));
                faceList.addElement(new Face(v8, v7, v6, v5, color, this, object));
                faceList.addElement(new Face(v1, v5, v6, v2, color, this, object));
                faceList.addElement(new Face(v1, v4, v8, v5, color, this, object));
                faceList.addElement(new Face(v3, v2, v6, v7, color, this, object));
            } else {
                float intercept = (float)((double)u2.x + (double)(u2.x - u1.x) * (height - (double)u2.y) / (double)(u2.y - u1.y));
                Vertex v1 = new Vertex(u2.x, 0.0f, (float)((double)u2.z - thick), this);
                Vertex v2 = new Vertex(u2.x, 0.0f, (float)((double)u2.z + thick), this);
                Vertex v3 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z - thick), this);
                Vertex v4 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z + thick), this);
                Vertex v5 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z - thick), this);
                Vertex v6 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z + thick), this);
                Vertex v7 = new Vertex(u1.x, (float)((double)u1.y - height), (float)((double)u1.z - thick), this);
                Vertex v8 = new Vertex(u1.x, (float)((double)u1.y - height), (float)((double)u1.z + thick), this);
                Vertex v9 = new Vertex(intercept, 0.0f, (float)((double)u2.z - thick), this);
                Vertex v10 = new Vertex(intercept, 0.0f, (float)((double)u2.z + thick), this);
                faceList.addElement(new Face(v2, v4, v3, v1, color, this, object));
                faceList.addElement(new Face(v4, v6, v5, v3, color, this, object));
                faceList.addElement(new Face(v5, v6, v8, v7, color, this, object));
                faceList.addElement(new Face(v1, v3, v5, v7, color, this, object));
                faceList.addElement(new Face(v6, v4, v2, v8, color, this, object));
                faceList.addElement(new Face(v7, v8, v10, v9, color, this, object));
                faceList.addElement(new Face(v10, v8, v2, v10, color, this, object));
                faceList.addElement(new Face(v9, v1, v7, v9, color, this, object));
            }
        } else if ((double)u2.y > height) {
            float intercept = (float)((double)u2.x + (double)(u2.x - u1.x) * (height - (double)u2.y) / (double)(u2.y - u1.y));
            Vertex v1 = new Vertex(u1.x, 0.0f, (float)((double)u1.z - thick), this);
            Vertex v2 = new Vertex(u1.x, 0.0f, (float)((double)u1.z + thick), this);
            Vertex v3 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z - thick), this);
            Vertex v4 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z + thick), this);
            Vertex v5 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z - thick), this);
            Vertex v6 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z + thick), this);
            Vertex v7 = new Vertex(u2.x, (float)((double)u2.y - height), (float)((double)u2.z - thick), this);
            Vertex v8 = new Vertex(u2.x, (float)((double)u2.y - height), (float)((double)u2.z + thick), this);
            Vertex v9 = new Vertex(intercept, 0.0f, (float)((double)u1.z - thick), this);
            Vertex v10 = new Vertex(intercept, 0.0f, (float)((double)u1.z + thick), this);
            faceList.addElement(new Face(v1, v3, v4, v2, color, this, object));
            faceList.addElement(new Face(v3, v5, v6, v4, color, this, object));
            faceList.addElement(new Face(v7, v8, v6, v5, color, this, object));
            faceList.addElement(new Face(v7, v5, v3, v1, color, this, object));
            faceList.addElement(new Face(v8, v2, v4, v6, color, this, object));
            faceList.addElement(new Face(v9, v10, v8, v7, color, this, object));
            faceList.addElement(new Face(v10, v2, v8, v10, color, this, object));
            faceList.addElement(new Face(v9, v7, v1, v9, color, this, object));
        } else {
            Vertex v1 = new Vertex(u1.x, 0.0f, (float)((double)u1.z - thick), this);
            Vertex v2 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z - thick), this);
            Vertex v3 = new Vertex(u1.x, (float)((double)u1.y + height), (float)((double)u1.z + thick), this);
            Vertex v4 = new Vertex(u1.x, 0.0f, (float)((double)u1.z + thick), this);
            Vertex v5 = new Vertex(u2.x, 0.0f, (float)((double)u2.z - thick), this);
            Vertex v6 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z - thick), this);
            Vertex v7 = new Vertex(u2.x, (float)((double)u2.y + height), (float)((double)u2.z + thick), this);
            Vertex v8 = new Vertex(u2.x, 0.0f, (float)((double)u2.z + thick), this);
            faceList.addElement(new Face(v1, v2, v3, v4, color, this, object));
            faceList.addElement(new Face(v4, v3, v7, v8, color, this, object));
            faceList.addElement(new Face(v8, v7, v6, v5, color, this, object));
            faceList.addElement(new Face(v1, v5, v6, v2, color, this, object));
            faceList.addElement(new Face(v1, v4, v8, v5, color, this, object));
            faceList.addElement(new Face(v3, v2, v6, v7, color, this, object));
        }
    }

    public void addLine2(Vector faceList, Vertex u1, Vertex u2, double thick, double height, Color color, Object object) {
        Vertex v1 = new Vertex((float)((double)u1.x + height), u1.y, (float)((double)u1.z - thick), this);
        Vertex v2 = new Vertex((float)((double)u1.x - height), u1.y, (float)((double)u1.z - thick), this);
        Vertex v3 = new Vertex((float)((double)u1.x - height), u1.y, (float)((double)u1.z + thick), this);
        Vertex v4 = new Vertex((float)((double)u1.x + height), u1.y, (float)((double)u1.z + thick), this);
        Vertex v5 = new Vertex((float)((double)u2.x + height), u2.y, (float)((double)u2.z - thick), this);
        Vertex v6 = new Vertex((float)((double)u2.x - height), u2.y, (float)((double)u2.z - thick), this);
        Vertex v7 = new Vertex((float)((double)u2.x - height), u2.y, (float)((double)u2.z + thick), this);
        Vertex v8 = new Vertex((float)((double)u2.x + height), u2.y, (float)((double)u2.z + thick), this);
        faceList.addElement(new Face(v1, v2, v3, v4, color, this, object));
        faceList.addElement(new Face(v4, v3, v7, v8, color, this, object));
        faceList.addElement(new Face(v8, v7, v6, v5, color, this, object));
        faceList.addElement(new Face(v1, v5, v6, v2, color, this, object));
        faceList.addElement(new Face(v1, v4, v8, v5, color, this, object));
        faceList.addElement(new Face(v3, v2, v6, v7, color, this, object));
    }

    public static final void drawFrameBox(CGraphics g, Face[] flist) {
        for (Face element : flist) {
            element.draw(g, 0);
        }
    }

    public static final void drawFrameBox(CGraphics g, Vector vec) {
        int[] xpoints = new int[5];
        int[] ypoints = new int[5];
        for (int i = 0; i < vec.size(); ++i) {
            ((Face)vec.elementAt(i)).draw(g, 0, xpoints, ypoints);
        }
    }

    public final void addBox(Vector faceList, Point3D p1, Point3D p2, Point3D p3, Point3D p4, double thick, Color color, Object object) {
        if (p1.y == p2.y && p3.y == p4.y) {
            return;
        }
        if (p2.y > p1.y) {
            if (p3.y > p4.y) {
                Vertex v1 = new Vertex(p3.x, p3.y, (float)((double)p3.z + thick), this);
                Vertex v2 = new Vertex(p3.x, p3.y, (float)((double)p3.z - thick), this);
                Vertex v3 = new Vertex(p4.x, p4.y, (float)((double)p3.z - thick), this);
                Vertex v4 = new Vertex(p4.x, p4.y, (float)((double)p3.z + thick), this);
                Vertex v5 = new Vertex(p2.x, p2.y, (float)((double)p3.z + thick), this);
                Vertex v6 = new Vertex(p2.x, p2.y, (float)((double)p3.z - thick), this);
                Vertex v7 = new Vertex(p1.x, p1.y, (float)((double)p3.z - thick), this);
                Vertex v8 = new Vertex(p1.x, p1.y, (float)((double)p3.z + thick), this);
                faceList.addElement(new Face(v1, v2, v3, v4, color, this, object));
                faceList.addElement(new Face(v4, v3, v7, v8, color, this, object));
                faceList.addElement(new Face(v8, v7, v6, v5, color, this, object));
                faceList.addElement(new Face(v1, v5, v6, v2, color, this, object));
                faceList.addElement(new Face(v1, v4, v8, v5, color, this, object));
                faceList.addElement(new Face(v3, v2, v6, v7, color, this, object));
            } else {
                Point3D intersect = Space.computeIntersect(p1, p2, p3, p4);
                Vertex v1 = new Vertex(p1.x, p1.y, (float)((double)p1.z + thick), this);
                Vertex v2 = new Vertex(p1.x, p1.y, (float)((double)p1.z - thick), this);
                Vertex v3 = new Vertex(p2.x, p2.y, (float)((double)p2.z + thick), this);
                Vertex v4 = new Vertex(p2.x, p2.y, (float)((double)p2.z - thick), this);
                Vertex v5 = new Vertex(intersect.x, intersect.y, (float)((double)intersect.z + thick), this);
                Vertex v6 = new Vertex(intersect.x, intersect.y, (float)((double)intersect.z - thick), this);
                Vertex v7 = new Vertex(p3.x, p3.y, (float)((double)p3.z + thick), this);
                Vertex v8 = new Vertex(p3.x, p3.y, (float)((double)p3.z - thick), this);
                Vertex v9 = new Vertex(p4.x, p4.y, (float)((double)p4.z + thick), this);
                Vertex v10 = new Vertex(p4.x, p4.y, (float)((double)p4.z - thick), this);
                faceList.addElement(new Face(v1, v3, v5, v5, color, this, object));
                faceList.addElement(new Face(v2, v4, v3, v1, color, this, object));
                faceList.addElement(new Face(v4, v2, v6, v6, color, this, object));
                faceList.addElement(new Face(v3, v4, v6, v5, color, this, object));
                faceList.addElement(new Face(v1, v5, v6, v2, color, this, object));
                faceList.addElement(new Face(v9, v7, v5, v5, color, this, object));
                faceList.addElement(new Face(v6, v10, v9, v5, color, this, object));
                faceList.addElement(new Face(v8, v10, v6, v6, color, this, object));
                faceList.addElement(new Face(v5, v7, v8, v6, color, this, object));
                faceList.addElement(new Face(v9, v10, v8, v7, color, this, object));
            }
        } else if (p4.y > p3.y) {
            Vertex v1 = new Vertex(p4.x, p4.y, (float)((double)p3.z + thick), this);
            Vertex v2 = new Vertex(p4.x, p4.y, (float)((double)p3.z - thick), this);
            Vertex v3 = new Vertex(p3.x, p3.y, (float)((double)p3.z - thick), this);
            Vertex v4 = new Vertex(p3.x, p3.y, (float)((double)p3.z + thick), this);
            Vertex v5 = new Vertex(p1.x, p1.y, (float)((double)p3.z + thick), this);
            Vertex v6 = new Vertex(p1.x, p1.y, (float)((double)p3.z - thick), this);
            Vertex v7 = new Vertex(p2.x, p2.y, (float)((double)p3.z - thick), this);
            Vertex v8 = new Vertex(p2.x, p2.y, (float)((double)p3.z + thick), this);
            faceList.addElement(new Face(v1, v2, v3, v4, color, this, object));
            faceList.addElement(new Face(v4, v3, v7, v8, color, this, object));
            faceList.addElement(new Face(v8, v7, v6, v5, color, this, object));
            faceList.addElement(new Face(v1, v5, v6, v2, color, this, object));
            faceList.addElement(new Face(v1, v4, v8, v5, color, this, object));
            faceList.addElement(new Face(v3, v2, v6, v7, color, this, object));
        } else {
            Point3D intersect = Space.computeIntersect(p1, p2, p3, p4);
            Vertex v1 = new Vertex(p2.x, p2.y, (float)((double)p2.z + thick), this);
            Vertex v2 = new Vertex(p2.x, p2.y, (float)((double)p2.z - thick), this);
            Vertex v3 = new Vertex(p1.x, p1.y, (float)((double)p1.z + thick), this);
            Vertex v4 = new Vertex(p1.x, p1.y, (float)((double)p1.z - thick), this);
            Vertex v5 = new Vertex(intersect.x, intersect.y, (float)((double)intersect.z + thick), this);
            Vertex v6 = new Vertex(intersect.x, intersect.y, (float)((double)intersect.z - thick), this);
            Vertex v7 = new Vertex(p4.x, p4.y, (float)((double)p4.z + thick), this);
            Vertex v8 = new Vertex(p4.x, p4.y, (float)((double)p4.z - thick), this);
            Vertex v9 = new Vertex(p3.x, p3.y, (float)((double)p3.z + thick), this);
            Vertex v10 = new Vertex(p3.x, p3.y, (float)((double)p3.z - thick), this);
            faceList.addElement(new Face(v1, v3, v5, v5, color, this, object));
            faceList.addElement(new Face(v2, v4, v3, v1, color, this, object));
            faceList.addElement(new Face(v4, v2, v6, v6, color, this, object));
            faceList.addElement(new Face(v3, v4, v6, v5, color, this, object));
            faceList.addElement(new Face(v1, v5, v6, v2, color, this, object));
            faceList.addElement(new Face(v9, v7, v5, v5, color, this, object));
            faceList.addElement(new Face(v6, v10, v9, v5, color, this, object));
            faceList.addElement(new Face(v8, v10, v6, v6, color, this, object));
            faceList.addElement(new Face(v5, v7, v8, v6, color, this, object));
            faceList.addElement(new Face(v9, v10, v8, v7, color, this, object));
        }
    }

    public void addCircle(Vector faceList, int cx, int cy, int width, int height, double thick, Color color, Object object) {
        this.addArc(faceList, cx, cy, width, height, 0.0, Math.PI * 2, thick, color, object);
    }

    public void addArc(Vector faceList, int cx, int cy, int width, int height, double startangle, double spanangle, double thick, Color color, Object object) {
        if (spanangle == 0.0) {
            return;
        }
        Vertex center1 = new Vertex(cx, cy, 0.0f, this);
        Vertex center2 = new Vertex(cx, cy, (float)thick, this);
        float startx = (float)((double)cx + (double)width * Math.cos(startangle));
        float starty = (float)((double)cy + (double)height * Math.sin(startangle));
        Vertex start1 = new Vertex(startx, starty, 0.0f, this);
        Vertex start2 = new Vertex(startx, starty, (float)thick, this);
        float endx = (float)((double)cx + (double)width * Math.cos(startangle + spanangle));
        float endy = (float)((double)cy + (double)height * Math.sin(startangle + spanangle));
        Vertex end1 = new Vertex(endx, endy, 0.0f, this);
        Vertex end2 = new Vertex(endx, endy, (float)thick, this);
        if (spanangle < Math.PI * 2) {
            faceList.addElement(new Face(center1, center2, start2, start1, color, this, object));
            faceList.addElement(new Face(center2, center1, end1, end2, color, this, object));
        }
        byte pieType = 2;
        double tempStartangle = startangle;
        for (double tempSpanangle = spanangle; tempSpanangle > 0.0; tempSpanangle -= 0.5235987755982988) {
            double extent;
            if (tempSpanangle > 0.5235987755982988) {
                extent = 0.5235987755982988;
            } else {
                extent = tempSpanangle;
                byte by = pieType = pieType == 2 ? (byte)3 : 1;
            }
            if (spanangle >= Math.PI * 2) {
                pieType = 0;
            }
            faceList.addElement(new PieFace(cx, cy, 0.0, width, height, tempStartangle, extent, color, this, object, pieType));
            faceList.addElement(new PieFace(cx, cy, thick, width, height, tempStartangle, extent, color, this, object, pieType));
            pieType = 0;
            tempStartangle += 0.5235987755982988;
        }
        int seg = (int)Math.ceil(Math.abs(40.0 * spanangle / (Math.PI * 2)));
        double extent = spanangle / (double)seg;
        CircumFace lastFace = null;
        CircumFace firstFace = null;
        for (int i = 0; i < seg; ++i) {
            double angle = extent * (double)i + startangle;
            CircumFace face = new CircumFace(cx, cy, 0.0, thick, width, height, angle, extent, color, this, object, lastFace, false);
            faceList.addElement(face);
            if (firstFace == null) {
                firstFace = face;
            }
            lastFace = face;
        }
        if (spanangle >= Math.PI * 2) {
            if (lastFace != null) {
                lastFace.nextFace = firstFace;
            }
            if (firstFace != null) {
                firstFace.previousFace = lastFace;
            }
        }
    }

    public void addDoughnutCircle(Vector faceList, int cx, int cy, int width, int height, double thick, Color color, Object object, double pieThickness) {
        this.addDoughnutArc(faceList, cx, cy, width, height, 0.0, Math.PI * 2, thick, color, object, pieThickness);
    }

    public void addDoughnutArc(Vector faceList, int cx, int cy, int width, int height, double startangle, double spanangle, double thick, Color color, Object object, double pieThickness) {
        if (spanangle == 0.0) {
            return;
        }
        pieThickness = (100.0 - pieThickness) / 100.0;
        float outerStartX = (float)((double)cx + (double)width * Math.cos(startangle));
        float outerStartY = (float)((double)cy + (double)height * Math.sin(startangle));
        Vertex outerStart1 = new Vertex(outerStartX, outerStartY, 0.0f, this);
        Vertex outerStart2 = new Vertex(outerStartX, outerStartY, (float)thick, this);
        float outerEndX = (float)((double)cx + (double)width * Math.cos(startangle + spanangle));
        float outerEndY = (float)((double)cy + (double)height * Math.sin(startangle + spanangle));
        Vertex outerEnd1 = new Vertex(outerEndX, outerEndY, 0.0f, this);
        Vertex outerEnd2 = new Vertex(outerEndX, outerEndY, (float)thick, this);
        float innerStartX = (float)((double)cx + (double)width * pieThickness * Math.cos(startangle));
        float innerStartY = (float)((double)cy + (double)height * pieThickness * Math.sin(startangle));
        Vertex innerStart1 = new Vertex(innerStartX, innerStartY, 0.0f, this);
        Vertex innerStart2 = new Vertex(innerStartX, innerStartY, (float)thick, this);
        float innerEndX = (float)((double)cx + (double)width * pieThickness * Math.cos(startangle + spanangle));
        float innerEndY = (float)((double)cy + (double)height * pieThickness * Math.sin(startangle + spanangle));
        Vertex innerEnd1 = new Vertex(innerEndX, innerEndY, 0.0f, this);
        Vertex innerEnd2 = new Vertex(innerEndX, innerEndY, (float)thick, this);
        if (spanangle < Math.PI * 2) {
            faceList.addElement(new Face(innerStart1, innerStart2, outerStart2, outerStart1, color, this, object));
            faceList.addElement(new Face(innerEnd2, innerEnd1, outerEnd1, outerEnd2, color, this, object));
        }
        byte pieType = 2;
        double tempStartangle = startangle;
        for (double tempSpanangle = spanangle; tempSpanangle > 0.0; tempSpanangle -= 0.39269908169872414) {
            double extent;
            if (tempSpanangle > 0.39269908169872414) {
                extent = 0.39269908169872414;
            } else {
                extent = tempSpanangle;
                byte by = pieType = pieType == 2 ? (byte)3 : 1;
            }
            if (spanangle >= Math.PI * 2) {
                pieType = 0;
            }
            faceList.addElement(new DoughnutPieFace(cx, cy, 0.0, width, height, tempStartangle, extent, pieThickness, color, this, object, pieType));
            faceList.addElement(new DoughnutPieFace(cx, cy, thick, width, height, tempStartangle, extent, pieThickness, color, this, object, pieType));
            pieType = 0;
            tempStartangle += 0.39269908169872414;
        }
        int seg = (int)Math.ceil(Math.abs(40.0 * spanangle / (Math.PI * 2)));
        double extent = spanangle / (double)seg;
        CircumFace firstOuterCircum = null;
        CircumFace firstInnerCircum = null;
        CircumFace lastOuterCircum = null;
        CircumFace lastInnerCircum = null;
        for (int i = 0; i < seg; ++i) {
            double angle = extent * (double)i + startangle;
            CircumFace outerCircum = new CircumFace(cx, cy, 0.0, thick, width, height, angle, extent, color, this, object, lastOuterCircum, false);
            faceList.addElement(outerCircum);
            if (firstOuterCircum == null) {
                firstOuterCircum = outerCircum;
            }
            lastOuterCircum = outerCircum;
            CircumFace innerCircum = new CircumFace(cx, cy, 0.0, thick, (double)width * pieThickness, (double)height * pieThickness, angle, extent, color, this, object, lastInnerCircum, true);
            faceList.addElement(innerCircum);
            if (firstInnerCircum == null) {
                firstInnerCircum = innerCircum;
            }
            lastInnerCircum = innerCircum;
        }
        if (spanangle >= Math.PI * 2) {
            if (firstInnerCircum != null) {
                firstInnerCircum.previousFace = lastInnerCircum;
            }
            if (lastInnerCircum != null) {
                lastInnerCircum.nextFace = firstInnerCircum;
            }
            if (firstOuterCircum != null) {
                firstOuterCircum.previousFace = lastOuterCircum;
            }
            if (lastOuterCircum != null) {
                lastOuterCircum.nextFace = firstOuterCircum;
            }
        }
    }

    private static Point3D computeIntersect(Point3D p1, Point3D p2, Point3D p3, Point3D p4) {
        double a = (double)(p3.y - p2.y) / (double)(p3.x - p2.x);
        double t = ((double)(p4.x - p2.x) * a - (double)(p4.y - p2.y)) / ((double)(p4.y - p1.y) - (double)(p4.x - p1.x) * a);
        return new Point3D((int)((double)p4.x + (double)(p4.x - p1.x) * t), (int)((double)p4.y + (double)(p4.y - p1.y) * t), p4.z);
    }

    public final void transform(Point3D p) {
        int px = p.x;
        p.x = (int)(this.space_width * ((float)px * this.matrix.xx * this.xscale + (float)p.y * this.matrix.xy * this.yscale + (float)p.z * this.matrix.xz * this.zscale + this.matrix.xo) + this.width_coeff);
        p.y = (int)(this.space_height * ((float)px * this.matrix.yx * this.xscale + (float)p.y * this.matrix.yy * this.yscale + (float)p.z * this.matrix.yz * this.zscale + this.matrix.yo) + this.height_coeff);
        p.z = 0;
    }

    public final void transform(Vertex v) {
        v.screen_x = (int)(this.space_width * (v.x * this.matrix.xx * this.xscale + v.y * this.matrix.xy * this.yscale + v.z * this.matrix.xz * this.zscale + this.matrix.xo) + this.width_coeff);
        v.screen_y = (int)(this.space_height * (v.x * this.matrix.yx * this.xscale + v.y * this.matrix.yy * this.yscale + v.z * this.matrix.yz * this.zscale + this.matrix.yo) + this.height_coeff);
    }

    public final void scale(float x, float y, float z) {
        this.xscale = x;
        this.yscale = y;
        this.zscale = z;
    }

    public void transform() {
        int i = 0;
        while (i < this.vertex_no) {
            this.transform(this.vertexList[i++]);
        }
    }

    public Vertex computeProjectVertex(Vertex v, int x, int y) {
        return this.computeProjectVertex(this.viewVec, v, x, y);
    }

    public Vertex computeProjectVertex(Vector3D nor, Vertex v, int x, int y) {
        float a1 = this.space_width * this.matrix.xx * this.xscale;
        float b1 = this.space_width * this.matrix.xy * this.yscale;
        float c1 = this.space_width * this.matrix.xz * this.zscale;
        float d1 = (float)x - this.space_width * this.matrix.xo - this.width_coeff;
        float a2 = this.space_height * this.matrix.yx * this.xscale;
        float b2 = this.space_height * this.matrix.yy * this.yscale;
        float c2 = this.space_height * this.matrix.yz * this.zscale;
        float d2 = (float)y - this.space_height * this.matrix.yo - this.height_coeff;
        float a3 = nor.i;
        float b3 = nor.j;
        float c3 = nor.k;
        float d3 = a3 * v.x + b3 * v.y + c3 * v.z;
        float delta = Matrix.determinant(a1, b1, c1, a2, b2, c2, a3, b3, c3);
        if (delta != 0.0f) {
            return new Vertex(Matrix.determinant(d1, b1, c1, d2, b2, c2, d3, b3, c3) / delta, Matrix.determinant(a1, d1, c1, a2, d2, c2, a3, d3, c3) / delta, Matrix.determinant(a1, b1, d1, a2, b2, d2, a3, b3, d3) / delta);
        }
        LOGGER.finest("numerical error ");
        switch (new Random(System.currentTimeMillis()).nextInt() % 3) {
            case 0: {
                return this.computeProjectVertex(new Vector3D(nor.i + 0.001f, nor.j, nor.k, true), v, x, y);
            }
            case 1: {
                return this.computeProjectVertex(new Vector3D(nor.i, nor.j + 0.001f, nor.k, true), v, x, y);
            }
        }
        return this.computeProjectVertex(new Vector3D(nor.i, nor.j, nor.k + 0.001f, true), v, x, y);
    }

    public DList getFaceList() {
        return this.hiddenSurface != null ? this.hiddenSurface.faceList : null;
    }

    public Vertex computeProjectVertex(Vertex v1, Vertex v2, int x, int y) {
        Vertex u1 = this.computeProjectVertex(v1, x, y);
        Vertex u2 = this.computeProjectVertex(v2, x, y);
        return new Vertex((u1.x + u2.x) / 2.0f, (u1.y + u2.y) / 2.0f, (u1.z + u2.z) / 2.0f);
    }

    public Matrix getTransformMatrix() {
        return this.matrix;
    }
}

