/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.general3d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.Grid3D;
import quadbase.common.util.internal.QbUtil;

public class AreaChart3D
extends Chart3D {
    public AreaChart3D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 7, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
    }

    public AreaChart3D(Chart _chart) {
        super(7, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        double value;
        int i;
        if (this.notEnoughData()) {
            return;
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            this.space.recomputeColor();
            return;
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] scoord = null;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        this.wall_ylength = 1000;
        this.wall_xlength = xmax = (int)((float)ymax * ratio);
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(oldymax - oldymin) / (3.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        this.findMinMaxVal();
        if (this.subvalueCol >= 0) {
            this.findMinMaxVal2();
        }
        if (this.isJoinAxis()) {
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
        }
        StepSize ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
        StepSize ystep2 = null;
        if (this.subvalueCol >= 0) {
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
        }
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        noCategory = this.mDataLen[this.dataDim - 1];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)xmax / ((double)noCategory - 1.0);
        if (this.dataDim == 1) {
            double nextx = 0.0;
            double zDelta = delta;
            this.wall_zlength = (int)(2.0 * delta);
            if (this.wall_zlength > 1000) {
                this.wall_zlength = 1000;
                zDelta = 500.0;
            }
            for (i = 0; i < noCategory; ++i) {
                loc[0] = i;
                value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_y) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                this.mData.setPointCoord((int)nextx, ystep.interpolatePixel(value), (int)zDelta, loc);
                this.mData.setFlashPointCoord((int)nextx, ystep.interpolatePixel(value / 2.0), (int)zDelta, loc);
                if (ystep2 != null) {
                    value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) : this.mData2.getValue(loc);
                    this.mData2.setPointCoord((int)nextx, ystep2.interpolatePixel(value), (int)zDelta, loc);
                    this.mData2.setFlashPointCoord((int)nextx, ystep2.interpolatePixel(value / 2.0), (int)zDelta, loc);
                }
                coord[i] = new Point3D((int)nextx, 0, this.wall_zlength);
                nextx += delta;
            }
        } else {
            double zdelta;
            int noSeries = this.mDataLen[0];
            scoord = new Point3D[noSeries];
            this.wall_zlength = (int)((double)noSeries * 1.5 * delta + 0.5 * delta);
            if (this.wall_zlength > xmax) {
                zdelta = (double)xmax / ((double)noSeries * 1.5 + 0.5);
                this.wall_zlength = xmax;
            } else {
                zdelta = delta;
            }
            double nextx = 0.0;
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                double nextz = zdelta;
                for (int j = 0; j < this.mDataLen[0]; ++j) {
                    loc[0] = j;
                    value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_y) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                    this.mData.setPointCoord((int)nextx, ystep.interpolatePixel(value), (int)nextz, loc);
                    this.mData.setFlashPointCoord((int)nextx, ystep.interpolatePixel(value / 2.0), (int)nextz, loc);
                    if (ystep2 != null) {
                        value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) : this.mData2.getValue(loc);
                        this.mData2.setPointCoord((int)nextx, ystep2.interpolatePixel(value), (int)nextz, loc);
                        this.mData2.setFlashPointCoord((int)nextx, ystep2.interpolatePixel(value / 2.0), (int)nextz, loc);
                    }
                    if (i == 0) {
                        scoord[j] = new Point3D(xmax, 0, (int)nextz);
                    }
                    nextz += 1.5 * zdelta;
                }
                coord[i] = new Point3D((int)nextx, 0, this.wall_zlength);
                nextx += delta;
            }
            delta = zdelta;
        }
        this.setAutomatic(ystep2 != null);
        this.a_y.setAxisGridY(this.space, ystep, xmax, ymax, this.wall_zlength, this.colData[this.valueCol]);
        this.a_y.setYWall(this.space, xmax, ymax, this.wall_zlength, this.wallbackground.areaColor);
        if (this.subvalueCol >= 0) {
            this.a_s.setAxisGridY(this.space, ystep2, this.wall_xlength, ymax, this.wall_zlength, this.colData[this.subvalueCol], this.wall_xlength, 0);
            this.a_s.setSWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        }
        this.a_z.setZWall(this.space, xmax, ymax, this.wall_zlength, this.wallbackground.areaColor);
        this.a_x.setXWall(this.space, xmax, ymax, this.wall_zlength, this.wallbackground.areaColor);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_x.setTicker(this.space, this.colData[colfield].getFieldName(), coord, false, this.colData[colfield]);
        Point3D[] coord2 = new Point3D[noCategory];
        for (i = 0; i < coord2.length; ++i) {
            coord2[i] = new Point3D(coord[i].x, ymin, 0);
        }
        this.a_x.grid.set(this.space, coord2, ymax, this.wall_zlength);
        if (this.dataDim == 2) {
            this.a_z.setTicker(this.space, this.colData[this.mDataMap[0]].getFieldName(), scoord, true, this.colData[this.mDataMap[0]]);
            this.a_z.showTitleTicker = true;
            Point3D[] coord3 = new Point3D[scoord.length - 1];
            for (i = 0; i < coord3.length; ++i) {
                coord3[i] = new Point3D(0, 0, (scoord[i].z + scoord[i + 1].z) / 2);
            }
            this.a_z.grid.set(this.space, coord3, this.wall_xlength, this.wall_ylength);
        } else {
            this.a_z.setTicker(this.space, xmax, this.wall_zlength);
            this.a_z.showTitleTicker = false;
            ((Grid3D)this.a_z.grid).lineList = null;
        }
        this.mData.prepare3DArea(this.space, delta * this.thickRatio / 2.0, ystep.zeroAxis);
        if (this.subvalueCol >= 0) {
            this.mData2.prepare3DLine(this.space, delta * this.thickRatio / 2.0, 30.0 * this.thickRatio);
        }
        this.prepareLabel();
        this.adjustInitScale(orgW, orgH);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw3D(g, 2);
    }

    @Override
    public boolean notEnoughData() {
        return this.nRow <= 1;
    }
}

