/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.general3d;

import java.awt.Component;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.Grid3D;
import quadbase.common.util.internal.QbUtil;

public class BarChart3D
extends Chart3D {
    public BarChart3D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 1, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
    }

    public BarChart3D(Chart _chart) {
        super(1, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        Point3D[] coord2;
        int j;
        double value;
        int t2;
        int t1;
        int i;
        int t4;
        int t3;
        if (this.notEnoughData()) {
            return;
        }
        int thick = 2;
        boolean X_int = false;
        boolean histogram = false;
        if (this.a_x.columnField != null) {
            if (this.a_x.columnField.getName().startsWith("count_")) {
                X_int = true;
                histogram = true;
            }
            if (this.a_x.columnField.getName().startsWith("probability_")) {
                histogram = true;
            }
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            this.space.recomputeColor();
            if (!histogram) {
                return;
            }
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        Point3D[] scoord = null;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        xmax = (int)((float)ymax * ratio);
        int fstep = (int)((double)(oldxmax - oldxmin) / (7.0 * (double)g.getFontMetrics(QbUtil.resizeViewerFont(this.a_x.font, this.mData.chart.isAdjustFont())).charWidth('8')));
        this.findMinMaxVal();
        if (this.subvalueCol >= 0) {
            this.findMinMaxVal2();
        }
        if (this.isJoinAxis()) {
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
        }
        StepSize xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, X_int);
        StepSize xstep2 = null;
        if (this.subvalueCol >= 0) {
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
        }
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        this.adjustSpaceView();
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)ymax / ((double)noCategory * 2.0 + 1.0);
        this.wall_xlength = 1000;
        if (this.dataDim == 1) {
            double lasty = (double)ymin + delta;
            int lastz = (int)delta;
            int nextz = (int)(delta * (double)(1 + thick));
            this.wall_ylength = ymax;
            this.wall_zlength = (int)((double)nextz + delta);
            t3 = (lastz + nextz) / 2;
            t4 = (int)((double)(nextz - lastz) / (2.0 * this.thickRatio));
            for (i = 0; i < noCategory; ++i) {
                double nexty = lasty + delta;
                loc[0] = i;
                t1 = (int)((lasty + nexty) / 2.0);
                t2 = (int)((nexty - lasty) * this.thickRatio / 2.0);
                value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_x) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                this.mData.setAreaCoord(xstep.interpolatePixel(value), xstep.zeroAxis, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                if (xstep2 != null) {
                    value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                    this.mData2.setPointCoord(xstep2.interpolatePixel(value), t1, t3, loc);
                }
                coord[i] = new Point3D(0, t1, this.wall_zlength);
                lasty = nexty + delta;
            }
        } else if (this.isDrawSeriesOnCategoryAxis()) {
            int noSeries = this.mDataLen[0];
            delta = (double)ymax / ((double)noCategory * (double)(noSeries + 1) + 1.0);
            double lasty = (double)ymin + delta;
            int lastz = (int)delta;
            int nextz = (int)(delta * (double)(1 + thick));
            this.wall_ylength = ymax;
            this.wall_zlength = (int)((double)nextz + delta);
            t3 = (lastz + nextz) / 2;
            t4 = (int)((double)(nextz - lastz) / (2.0 * this.thickRatio));
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                int tmpT1 = (int)((lasty + lasty + delta * (double)noSeries) / 2.0);
                for (j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nexty = lasty + delta;
                    t1 = (int)((lasty + nexty) / 2.0);
                    t2 = (int)((nexty - lasty) * this.thickRatio / 2.0);
                    value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_x) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                    this.mData.setAreaCoord(xstep.interpolatePixel(value), xstep.zeroAxis, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                    if (xstep2 != null) {
                        value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(xstep2.interpolatePixel(value), t1, t3, loc);
                    }
                    lasty = nexty;
                }
                coord[i] = new Point3D(0, tmpT1, this.wall_zlength);
                lasty += delta;
            }
        } else {
            int noSeries = this.mDataLen[0];
            scoord = new Point3D[noSeries];
            double temp = noSeries * (thick + 1) + 1;
            this.wall_zlength = (int)(delta * temp);
            if (this.wall_zlength < ymax) {
                this.wall_ylength = ymax;
            } else {
                delta = (double)ymax / temp;
                this.wall_zlength = ymax;
                this.wall_ylength = (int)(delta * (double)(2 * noCategory + 1));
            }
            double lasty = (double)ymin + delta;
            double stepz = delta * (double)thick;
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                double lastz = delta;
                double nexty = lasty + delta;
                t1 = (int)((lasty + nexty) / 2.0);
                t2 = (int)((nexty - lasty) * this.thickRatio / 2.0);
                for (j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nextz = lastz + stepz;
                    t3 = (int)((lastz + nextz) / 2.0);
                    t4 = (int)((nextz - lastz) / (2.0 * this.thickRatio));
                    value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_x) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                    this.mData.setAreaCoord(xstep.interpolatePixel(value), xstep.zeroAxis, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                    if (xstep2 != null) {
                        value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(xstep2.interpolatePixel(value), t1, t3, loc);
                    }
                    if (i == 0) {
                        scoord[j] = new Point3D(xmax, 0, (int)((lastz + nextz) / 2.0));
                    }
                    lastz = nextz + delta;
                }
                coord[i] = new Point3D(0, (int)((lasty + nexty) / 2.0), this.wall_zlength);
                lasty = nexty + delta;
            }
        }
        this.setAutomatic(xstep2 != null);
        this.a_x.setAxisGridX(this.space, xstep, xmax, this.wall_ylength, this.wall_zlength, this.colData[this.valueCol]);
        this.a_x.setXWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        if (this.subvalueCol >= 0) {
            this.a_s.setAxisGridX(this.space, xstep2, xmax, this.wall_ylength, this.wall_zlength, this.colData[this.subvalueCol], this.wall_ylength, 0);
            this.a_s.setSWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        }
        this.a_z.setZWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_y.setTicker(this.space, this.colData[colfield].getFieldName(), coord, false, this.colData[colfield]);
        this.a_y.setYWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        if (this.isGridAlignedWithTicker()) {
            coord2 = new Point3D[noCategory];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(0, coord[i].y, 0);
            }
            this.a_y.grid.set(this.space, coord2, xmax, this.wall_zlength);
        } else {
            coord2 = new Point3D[noCategory - 1];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(0, (coord[i].y + coord[i + 1].y) / 2, 0);
            }
            this.a_y.grid.set(this.space, coord2, xmax, this.wall_zlength);
        }
        if (this.dataDim == 2 && !this.isDrawSeriesOnCategoryAxis()) {
            this.a_z.setTicker(this.space, this.colData[this.mDataMap[0]].getFieldName(), scoord, true, this.colData[this.mDataMap[0]]);
            this.a_z.showTitleTicker = true;
            Point3D[] coord3 = new Point3D[scoord.length - 1];
            for (i = 0; i < coord3.length; ++i) {
                coord3[i] = new Point3D(0, 0, (scoord[i].z + scoord[i + 1].z) / 2);
            }
            this.a_z.grid.set(this.space, coord3, xmax, this.wall_ylength);
        } else {
            this.a_z.setTicker(this.space, xmax, this.wall_zlength);
            this.a_z.showTitleTicker = false;
            ((Grid3D)this.a_z.grid).lineList = null;
        }
        this.mData.prepare3DBox(this.space);
        this.prepareLabel();
        if (this.subvalueCol >= 0) {
            this.mData2.prepare3DLine(this.space, delta * this.thickRatio, 30.0 * this.thickRatio, true);
        }
        this.adjustInitScale(orgW, orgH);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw3D(g, 1);
    }
}

