/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.general3d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Coordinate;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.Grid3D;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.RenderingChart;

public class ScatterChart3D
extends Chart3D {
    public ScatterChart3D(Component component, ColData[] colData) {
        block12: {
            block10: {
                block13: {
                    block11: {
                        super(component, 2, colData);
                        this.showPoint = true;
                        this.mDataMap[0] = this.nCol;
                        if (this.nint + this.nreal + this.ndatetime < 1) {
                            throw nonumericError;
                        }
                        this.dataDim = 1;
                        if (this.nint + this.nreal + this.ndatetime != 1) break block10;
                        if (this.nint <= 0) break block11;
                        this.mDataMap[0] = this.mDataMap[1] = this.nintcol[0];
                        this.coordCol[0] = this.coordCol[1] = this.nintcol[0];
                        break block12;
                    }
                    if (this.nreal <= 0) break block13;
                    this.mDataMap[0] = this.mDataMap[1] = this.nrealcol[0];
                    this.coordCol[0] = this.coordCol[1] = this.nrealcol[0];
                    break block12;
                }
                if (this.ndatetime <= 0) break block12;
                this.mDataMap[0] = this.mDataMap[1] = this.ndatetimecol[0];
                this.coordCol[0] = this.coordCol[1] = this.ndatetimecol[0];
                break block12;
            }
            int nrealCt = 0;
            int ntimeCt = 0;
            int nintCt = 0;
            int coordCt = 2;
            if (!this.is2DChart && this.nint + this.nreal + this.ndatetime > 2) {
                coordCt = 3;
            }
            int i = 0;
            if (this.nint + this.nreal == 1) {
                this.coordCol[i++] = this.ndatetimecol[ntimeCt++];
            }
            while (i < coordCt) {
                if (this.nreal > nrealCt) {
                    this.coordCol[i] = this.nrealcol[nrealCt++];
                } else if (this.nint > nintCt) {
                    this.coordCol[i] = this.nintcol[nintCt++];
                } else if (this.ndatetime > ntimeCt) {
                    this.coordCol[i] = this.ndatetimecol[ntimeCt++];
                }
                ++i;
            }
        }
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        if (!this.is2DChart) {
            this.bcoordCol[2] = true;
        }
        this.makeTable();
        this.setDateTimeAxes();
    }

    public ScatterChart3D(Chart _chart) {
        super(2, _chart);
        this.showPoint = true;
        if (!this.bcoordCol[0]) {
            this.coordCol[0] = this.valueCol;
            if (this.nreal + this.nint < 2) {
                this.coordCol[1] = this.valueCol;
            } else {
                this.addNewColumnFromDataMapping = true;
                this.coordCol[1] = this.nreal > 0 ? (this.nrealcol[0] != this.valueCol ? this.nrealcol[0] : this.nintcol[0]) : (this.nintcol[0] != this.valueCol ? this.nintcol[0] : this.nintcol[1]);
            }
            this.bcoordCol[1] = true;
            this.bcoordCol[0] = true;
            this.bcoordCol[2] = false;
            this.dataDim = 1;
            this.mDataMap[0] = this.nCol;
        } else {
            if (!this.is2DChart && !this.bcoordCol[2]) {
                this.bcoordCol[2] = false;
            }
            if (_chart.chartType == 2) {
                this.dataDim = _chart.dataDim;
            } else {
                this.dataDim = 1;
                this.mDataMap[0] = this.nCol;
            }
        }
        this.copyTable(_chart);
        this.setDateTimeAxes();
    }

    private void setDateTimeAxes() {
        this.labelDateTime[0] = DataType.isDateTime(this.colData[this.coordCol[0]].axisType);
        this.labelDateTime[1] = DataType.isDateTime(this.colData[this.coordCol[1]].axisType);
        this.labelDateTime[2] = DataType.isDateTime(this.colData[this.coordCol[2]].axisType);
        this.a_x.displayLabelAsDate = this.labelDateTime[0];
        this.a_y.displayLabelAsDate = this.labelDateTime[1];
        this.a_z.displayLabelAsDate = this.labelDateTime[2];
        this.a_x.setTimeChart(true);
        this.a_y.setTimeChart(true);
        this.a_z.setTimeChart(true);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            return;
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        this.wall_ylength = 1000;
        this.wall_xlength = xmax = (int)((float)ymax * ratio);
        this.wall_zlength = this.bcoordCol[2] ? this.wall_xlength : 3 * this.getScatterCubeWidth();
        this.findMinMaxCoord();
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        StepSize ystep = new StepSize(this.a_y, ymax, ymin, this.maxCoord.y, this.minCoord.y, (int)((double)(oldymax - oldymin) / (3.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent()))), this.getCoorddec(this.coordCol[1]), DataType.isDateTime(this.colData[this.coordCol[1]].axisType));
        int rowno = (int)((double)(oldxmax - oldxmin) / (7.0 * (double)g.getFontMetrics(QbUtil.resizeViewerFont(this.a_x.font, this.mData.chart.isAdjustFont())).charWidth('8')));
        StepSize xstep = new StepSize(this.a_x, xmax, xmin, this.maxCoord.x, this.minCoord.x, rowno, this.getCoorddec(this.coordCol[0]), DataType.isDateTime(this.colData[this.coordCol[0]].axisType));
        StepSize zstep = new StepSize(this.a_z, xmax, xmin, this.maxCoord.z, this.minCoord.z, rowno, this.bcoordCol[2] ? this.getCoorddec(this.coordCol[2]) : 1, DataType.isDateTime(this.colData[this.coordCol[2]].axisType));
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        if (this.dataDim == 1) {
            for (int i = 0; i < noCategory; ++i) {
                loc[0] = i;
                this.setPointCoord(xstep, ystep, zstep, loc);
                this.mData.multiData[i].point.automatic = true;
            }
        } else {
            int noSeries = this.mDataLen[0];
            for (int i = 0; i < noSeries; ++i) {
                loc[0] = i;
                this.mData.multiData[i].point.automatic = false;
                for (int j = 0; j < noCategory; ++j) {
                    loc[1] = j;
                    this.setPointCoord(xstep, ystep, zstep, loc);
                    this.mData.multiData[i].multiData[j].point.automatic = true;
                }
            }
        }
        this.a_x.setAxisGridX(this.space, xstep, xmax, ymax, this.wall_zlength, this.colData[this.coordCol[0]]);
        this.a_x.setXWall(this.space, this.wall_xlength, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        this.a_y.setAxisGridY(this.space, ystep, xmax, ymax, this.wall_zlength, this.colData[this.coordCol[1]]);
        this.a_y.setYWall(this.space, this.wall_xlength, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        this.a_z.setAxisGridZ(this.space, zstep, xmax, ymax, this.wall_zlength, this.bcoordCol[2] ? this.colData[this.coordCol[2]] : null);
        this.a_z.setZWall(this.space, this.wall_xlength, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        this.mData.prepare3DPoint(this.space, (double)this.getScatterCubeWidth() * this.thickRatio / 2.0);
        this.prepareLabel();
        this.adjustInitScale(orgW, orgH);
    }

    private void setPointCoord(StepSize xstep, StepSize ystep, StepSize zstep, int[] loc) {
        Coordinate coord = (Coordinate)this.mData.getElement(loc);
        int zdistance = (int)((double)this.getScatterCubeWidth() * 1.5);
        if (coord == null) {
            return;
        }
        double x = coord.x;
        double y = coord.y;
        if (this.flashRatio != 1.0) {
            double avgX = (xstep.maxvalue - xstep.minvalue) / 2.0;
            double avgY = (ystep.maxvalue - ystep.minvalue) / 2.0;
            x = (coord.x - avgX) * this.flashRatio + avgX;
            y = (coord.y - avgY) * this.flashRatio + avgY;
        }
        if (this.bcoordCol[2]) {
            double z = coord.z;
            this.mData.setPointCoord(xstep.interpolatePixel(x), ystep.interpolatePixel(y), zstep.interpolatePixel(z), loc);
        } else {
            this.mData.setPointCoord(xstep.interpolatePixel(x), ystep.interpolatePixel(y), zdistance, loc);
        }
    }

    @Override
    public void draw(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.hiddenSurface.reset();
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.draw_INTERNAL(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.draw_INTERNAL(g);
        }
    }

    private void draw_INTERNAL(CGraphics g) {
        if (!this.bcoordCol[2]) {
            this.a_z.showTitleTicker = false;
            ((Grid3D)this.a_z.grid).lineList = null;
        } else {
            this.a_z.showTitleTicker = true;
        }
        g.chart = this;
        if (this.drawType != 0 || this.hiddenSurface.treeRoot != null) {
            this.hiddenSurface.draw(g, this.space);
        } else {
            this.space.transform();
            this.mData.drawPoint(g);
            this.drawAllAxis(g);
            this.dataLineSet.drawDataLineList();
        }
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
    }
}

