/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.general3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Coordinate;
import quadbase.chart.FaceData;
import quadbase.chart.IOUtil2;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.ColorSpectrumUtil;
import quadbase.chart.chart3d.FaceHyperLink;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.HyperLink;
import quadbase.util.internal.RenderingChart;

public class SurfaceChart3D
extends Chart3D {
    double[] xColumnValue;
    double[] zColumnValue;
    double[] xUniqueValue;
    double[] zUniqueValue;
    int nXfield;
    int nZfield;
    int colDataSize;
    int[] xPixelValueArray;
    int[] zPixelValueArray;
    int[][] yPixelValueArray;
    Coordinate[][] chartCoordinate;
    static final int CUBEWIDTH = 30;
    int[] coordColSave;
    boolean verified = false;
    Vector faceList;
    public FaceData[][] faceDataList;

    public SurfaceChart3D(Component component, ColData[] colData) {
        super(component, 12, colData);
        if (this.nint + this.nreal < 3) {
            throw nonumericError;
        }
        int[] coordColOrder = new int[]{0, 2, 1};
        int mapIndex = 0;
        for (int i = 0; i < this.nCol; ++i) {
            if (!DataType.isNumeric(colData[i].dataType)) continue;
            this.coordCol[coordColOrder[mapIndex++]] = i;
            if (mapIndex == 3) break;
        }
        this.bcoordCol[2] = true;
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        this.dataDim = 1;
        this.makeTable();
        this.verifyColData();
        this.enableTypeMenu = false;
        this.enableDimMenu = false;
    }

    public SurfaceChart3D(Chart _chart) {
        super(12, _chart);
        this.mDataMap[0] = this.nCol;
        if (this.nint + this.nreal < 3) {
            throw nonumericError;
        }
        if (_chart.chartType == 12) {
            for (int i = 0; i < 3; ++i) {
                this.coordCol[i] = _chart.coordCol[i];
            }
        } else {
            int[] coordColOrder = new int[]{0, 2, 1};
            int mapIndex = 0;
            for (int i = 0; i < this.nCol; ++i) {
                if (!DataType.isNumeric(this.colData[i].dataType)) continue;
                this.coordCol[coordColOrder[mapIndex++]] = i;
                if (mapIndex != 3) {
                    continue;
                }
                break;
            }
        }
        this.bcoordCol[2] = true;
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        this.dataDim = 1;
        this.copyTable(_chart);
        this.verifyColData();
        this.enableTypeMenu = false;
        this.enableDimMenu = false;
    }

    private void setVerified(boolean value) {
        if (value) {
            if (this.coordColSave == null) {
                this.coordColSave = new int[3];
            }
            this.coordColSave[0] = this.coordCol[0];
            this.coordColSave[1] = this.coordCol[1];
            this.coordColSave[2] = this.coordCol[2];
            this.verified = true;
        } else {
            this.verified = false;
        }
    }

    private boolean isVerified() {
        if (!this.verified) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.coordColSave[i] == this.coordCol[i]) continue;
            return false;
        }
        return true;
    }

    private void verifyColData() {
        int i;
        if (this.isVerified()) {
            return;
        }
        this.setVerified(true);
        if (this.dataDim != 1) {
            throw new IllegalArgumentException("SurfaceChart: data dimension must be 1");
        }
        int[] cmap = this.getCoordMap();
        ColData xAxisColumn = this.colData[cmap[0]];
        xAxisColumn.retrieveField();
        Object[] xAxisOrder = xAxisColumn.getSortOrder(true);
        this.nXfield = xAxisOrder.length;
        ColData zAxisColumn = this.colData[cmap[2]];
        zAxisColumn.retrieveField();
        Object[] zAxisOrder = zAxisColumn.getSortOrder(true);
        this.nZfield = zAxisOrder.length;
        int nColData = this.colData.length;
        int correctRowSize = this.nXfield * this.nZfield;
        for (i = 0; i < nColData; ++i) {
            if (this.colData[i].getSize() == correctRowSize) continue;
            throw new IllegalArgumentException("SurfaceChart: Data on the XZ plane (base plane) must be in a matrix form.  No missing data.");
        }
        this.chartCoordinate = new Coordinate[this.nXfield][this.nZfield];
        this.faceDataList = new FaceData[this.nXfield - 1][this.nZfield - 1];
        this.yPixelValueArray = new int[this.nXfield][this.nZfield];
        this.colDataSize = this.colData[0].getSize();
        this.xColumnValue = new double[this.colDataSize];
        for (i = 0; i < this.colDataSize; ++i) {
            this.xColumnValue[i] = IOUtil2.getValue(xAxisColumn.getDataSet().elementAt(i));
        }
        this.xPixelValueArray = new int[this.nXfield];
        this.xUniqueValue = new double[this.nXfield];
        for (i = 0; i < this.nXfield; ++i) {
            this.xUniqueValue[i] = IOUtil2.getValue(xAxisOrder[i]);
        }
        this.zColumnValue = new double[this.colDataSize];
        for (i = 0; i < this.colDataSize; ++i) {
            this.zColumnValue[i] = IOUtil2.getValue(zAxisColumn.getDataSet().elementAt(i));
        }
        this.zPixelValueArray = new int[this.nZfield];
        this.zUniqueValue = new double[this.nZfield];
        for (i = 0; i < this.nZfield; ++i) {
            this.zUniqueValue[i] = IOUtil2.getValue(zAxisOrder[i]);
        }
    }

    private void addToXZPlaneArray(Coordinate coord, int xPixelValue, int yPixelValue, int zPixelValue) {
        double x = coord.getx();
        double z = coord.getz();
        for (int i = 0; i < this.colDataSize; ++i) {
            if (this.xColumnValue[i] != x || this.zColumnValue[i] != z) continue;
            for (int j = 0; j < this.nXfield; ++j) {
                if (this.xUniqueValue[j] != x) continue;
                for (int k = 0; k < this.nZfield; ++k) {
                    if (this.zUniqueValue[k] != z) continue;
                    this.xPixelValueArray[j] = xPixelValue;
                    this.yPixelValueArray[j][k] = yPixelValue;
                    this.zPixelValueArray[k] = zPixelValue;
                    this.chartCoordinate[j][k] = coord;
                    return;
                }
            }
        }
    }

    public double[] getxUniqueValue() {
        return this.xUniqueValue;
    }

    public double[] getzUniqueValue() {
        return this.zUniqueValue;
    }

    public FaceData[][] getFaceDataList() {
        return this.faceDataList;
    }

    private void addFace(Color color, StepSize ystep) {
        this.faceList = new Vector();
        for (int i = 0; i < this.nXfield - 1; ++i) {
            for (int j = 0; j < this.nZfield - 1; ++j) {
                FaceData faceData;
                Vertex v1 = new Vertex(this.xPixelValueArray[i], this.yPixelValueArray[i][j], this.zPixelValueArray[j], this.space);
                Vertex v2 = new Vertex(this.xPixelValueArray[i + 1], this.yPixelValueArray[i + 1][j], this.zPixelValueArray[j], this.space);
                Vertex v3 = new Vertex(this.xPixelValueArray[i + 1], this.yPixelValueArray[i + 1][j + 1], this.zPixelValueArray[j + 1], this.space);
                Vertex v4 = new Vertex(this.xPixelValueArray[i], this.yPixelValueArray[i][j + 1], this.zPixelValueArray[j + 1], this.space);
                this.faceDataList[i][j] = faceData = new FaceData(this.chartCoordinate[i][j], this.chartCoordinate[i + 1][j], this.chartCoordinate[i + 1][j + 1], this.chartCoordinate[i][j + 1], this);
                if (this.colorSpectrum == null) {
                    this.faceList.addElement(new Face(v1, v2, v3, v4, color, this.space, faceData));
                    continue;
                }
                new ColorSpectrumUtil(this.space, this.colorSpectrum, ystep).addFace(this.faceList, v1, v2, v3, v4, faceData);
            }
        }
        int linkCount = this.surfaceHyperLinkList.size();
        for (int i = 0; i < linkCount; ++i) {
            FaceHyperLink currentLink = (FaceHyperLink)this.surfaceHyperLinkList.elementAt(i);
            this.setSurfaceLink(currentLink, currentLink.getHyperLink(), currentLink.getTarget(), currentLink.getHint(), currentLink.getxValue(), currentLink.getzValue(), -1, -1);
        }
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            return;
        }
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        this.wall_ylength = 1000;
        this.wall_zlength = this.wall_xlength = (xmax = (int)((float)ymax * ratio));
        this.findMinMaxCoord();
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        StepSize ystep = new StepSize(this.a_y, ymax, ymin, this.maxCoord.y, this.minCoord.y, (int)((double)(oldymax - oldymin) / (3.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent()))), this.getCoorddec(this.coordCol[1]));
        int rowno = (int)((double)(oldxmax - oldxmin) / (7.0 * (double)g.getFontMetrics(QbUtil.resizeViewerFont(this.a_x.font, this.mData.chart.isAdjustFont())).charWidth('8')));
        StepSize xstep = new StepSize(this.a_x, xmax, xmin, this.maxCoord.x, this.minCoord.x, rowno, this.getCoorddec(this.coordCol[0]));
        StepSize zstep = new StepSize(this.a_z, xmax, xmin, this.maxCoord.z, this.minCoord.z, rowno, this.getCoorddec(this.coordCol[2]));
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        this.verifyColData();
        for (int i = 0; i < noCategory; ++i) {
            loc[0] = i;
            Coordinate coord = (Coordinate)this.mData.getElement(loc);
            if (coord == null) continue;
            int x = xstep.interpolatePixel(coord.x);
            int y = ystep.interpolatePixel(coord.y);
            int z = zstep.interpolatePixel(coord.z);
            this.addToXZPlaneArray(coord, x, y, z);
            this.mData.setPointCoord(x, y, z, loc);
            this.mData.multiData[i].point.automatic = true;
        }
        this.a_x.setAxisGridX(this.space, xstep, xmax, ymax, this.wall_zlength, this.colData[this.coordCol[0]]);
        this.a_x.setXWall(this.space, this.wall_xlength, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        this.a_y.setAxisGridY(this.space, ystep, xmax, ymax, this.wall_zlength, this.colData[this.coordCol[1]]);
        this.a_y.setYWall(this.space, this.wall_xlength, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        this.a_z.setAxisGridZ(this.space, zstep, xmax, ymax, this.wall_zlength, this.bcoordCol[2] ? this.colData[this.coordCol[2]] : null);
        this.a_z.setZWall(this.space, this.wall_xlength, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        this.addFace(this.get3DSurfaceColor(), ystep);
        if (this.showPoint) {
            this.mData.prepare3DPoint(this.space, 30.0 * this.thickRatio / 2.0);
        }
        this.prepareLabel();
    }

    @Override
    public void draw(CGraphics g) {
        this.a_z.showTitleTicker = true;
        g.chart = this;
        if (this.drawType != 0 || this.hiddenSurface.treeRoot != null) {
            this.hiddenSurface.draw(g, this.space);
        } else {
            this.space.transform();
            Space.drawFrameBox(g, this.faceList);
            if (this.showPoint) {
                this.mData.drawPoint(g);
            }
            this.drawAllAxis(g);
            this.dataLineSet.drawDataLineList();
        }
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
    }

    @Override
    public void set3DSurfaceColor(Color color) {
        this.surfaceColor = color;
        if (this.faceList != null) {
            int nFace = this.faceList.size();
            for (int i = 0; i < nFace; ++i) {
                ((Face)this.faceList.elementAt(i)).setColor(this.space, color);
            }
        }
    }

    @Override
    public Object setSurfaceLink(Object faceHyperLink, String link, String target, String hint, String xChoice, String zChoice, int x, int z) {
        if (link == null || link.trim().equals("")) {
            return null;
        }
        int xCount = this.nXfield - 1;
        int zCount = this.nZfield - 1;
        FaceHyperLink currentLink = (FaceHyperLink)faceHyperLink;
        if (currentLink == null) {
            currentLink = new FaceHyperLink(xChoice, zChoice, link, target, hint);
            this.surfaceHyperLinkList.addElement(currentLink);
        } else {
            currentLink.setValues(xChoice, zChoice, link, target, hint);
        }
        if (xChoice.equals(FaceHyperLink.ALLPOINTS) && zChoice.equals(FaceHyperLink.ALLPOINTS)) {
            for (int i = 0; i < xCount; ++i) {
                for (int j = 0; j < zCount; ++j) {
                    this.faceDataList[i][j].setHyperLink(link, hint, target);
                    currentLink.faceDataList.addElement(this.faceDataList[i][j]);
                }
            }
        } else if (zChoice.equals(FaceHyperLink.ALLPOINTS)) {
            if (x < 0 || x >= this.nXfield) {
                double temp = Double.valueOf(xChoice);
                for (int i = 0; i < this.nXfield; ++i) {
                    if (this.xUniqueValue[i] != temp) continue;
                    x = i;
                    break;
                }
            }
            for (int j = 0; j < zCount; ++j) {
                int i = x;
                if (i >= 0 && i < xCount) {
                    this.faceDataList[i][j].setHyperLink(link, hint, target);
                    currentLink.faceDataList.addElement(this.faceDataList[i][j]);
                }
                if ((i = x - 1) < 0 || i >= xCount) continue;
                this.faceDataList[i][j].setHyperLink(link, hint, target);
                currentLink.faceDataList.addElement(this.faceDataList[i][j]);
            }
        } else if (xChoice.equals(FaceHyperLink.ALLPOINTS)) {
            if (z < 0 || z >= this.nZfield) {
                double temp = Double.valueOf(zChoice);
                for (int i = 0; i < this.nZfield; ++i) {
                    if (this.zUniqueValue[i] != temp) continue;
                    z = i;
                    break;
                }
            }
            for (int i = 0; i < xCount; ++i) {
                int j = z;
                if (j >= 0 && j < zCount) {
                    this.faceDataList[i][j].setHyperLink(link, hint, target);
                    currentLink.faceDataList.addElement(this.faceDataList[i][j]);
                }
                if ((j = z - 1) < 0 || j >= zCount) continue;
                this.faceDataList[i][j].setHyperLink(link, hint, target);
                currentLink.faceDataList.addElement(this.faceDataList[i][j]);
            }
        } else {
            int i;
            double temp;
            if (x < 0 || x >= this.nXfield) {
                temp = Double.valueOf(xChoice);
                for (i = 0; i < this.nXfield; ++i) {
                    if (this.xUniqueValue[i] != temp) continue;
                    x = i;
                    break;
                }
            }
            if (z < 0 || z >= this.nZfield) {
                temp = Double.valueOf(zChoice);
                for (i = 0; i < this.nZfield; ++i) {
                    if (this.zUniqueValue[i] != temp) continue;
                    z = i;
                    break;
                }
            }
            int i2 = x - 1;
            int j = z - 1;
            if (i2 >= 0 && i2 < xCount && j >= 0 && j < zCount) {
                this.faceDataList[i2][j].setHyperLink(link, hint, target);
                currentLink.faceDataList.addElement(this.faceDataList[i2][j]);
            }
            i2 = x - 1;
            j = z;
            if (i2 >= 0 && i2 < xCount && j >= 0 && j < zCount) {
                this.faceDataList[i2][j].setHyperLink(link, hint, target);
                currentLink.faceDataList.addElement(this.faceDataList[i2][j]);
            }
            i2 = x;
            j = z - 1;
            if (i2 >= 0 && i2 < xCount && j >= 0 && j < zCount) {
                this.faceDataList[i2][j].setHyperLink(link, hint, target);
                currentLink.faceDataList.addElement(this.faceDataList[i2][j]);
            }
            i2 = x;
            j = z;
            if (i2 >= 0 && i2 < xCount && j >= 0 && j < zCount) {
                this.faceDataList[i2][j].setHyperLink(link, hint, target);
                currentLink.faceDataList.addElement(this.faceDataList[i2][j]);
            }
        }
        return currentLink;
    }

    @Override
    public void removeSurfaceLink(Object faceHyperLink) {
        if (faceHyperLink == null) {
            return;
        }
        FaceHyperLink currentLink = (FaceHyperLink)faceHyperLink;
        currentLink.reset();
        this.surfaceHyperLinkList.removeElement(currentLink);
    }

    @Override
    public void removeAllSurfaceLink() {
        int linkCount = this.surfaceHyperLinkList.size();
        for (int i = 0; i < linkCount; ++i) {
            this.removeSurfaceLink(this.surfaceHyperLinkList.firstElement());
        }
    }

    @Override
    public Object findSurfaceLink(HyperLink link) {
        int sz = this.surfaceHyperLinkList.size();
        for (int i = 0; i < sz; ++i) {
            FaceHyperLink hlink = (FaceHyperLink)this.surfaceHyperLinkList.elementAt(i);
            if (!hlink.getxValue().equals(link.xValue) || !hlink.getzValue().equals(link.zValue) || !hlink.getHyperLink().equals(link.link) || !hlink.getHint().equals(link.hint) || !hlink.getTarget().equals(link.target)) continue;
            return hlink;
        }
        return null;
    }

    @Override
    public HyperLink closestMatch(HyperLink link) {
        FaceHyperLink hlink;
        int sz = this.surfaceHyperLinkList.size();
        int maxMark = 0;
        int index = -1;
        for (int i = 0; i < sz; ++i) {
            int mark;
            hlink = (FaceHyperLink)this.surfaceHyperLinkList.elementAt(i);
            if (hlink.getxValue().equals(link.xValue)) {
                mark = 250;
            } else {
                if (!hlink.getxValue().equals(FaceHyperLink.ALLPOINTS) || link.xValue.equals(FaceHyperLink.ALLPOINTS)) continue;
                mark = 25;
            }
            if (hlink.getzValue().equals(link.zValue)) {
                mark += 200;
            } else {
                if (!hlink.getzValue().equals(FaceHyperLink.ALLPOINTS) || link.zValue.equals(FaceHyperLink.ALLPOINTS)) continue;
                mark += 20;
            }
            if (mark < maxMark || hlink.getHyperLink().trim().equals("")) continue;
            maxMark = mark;
            index = i;
        }
        if (index >= 0) {
            hlink = (FaceHyperLink)this.surfaceHyperLinkList.elementAt(index);
            HyperLink hyperLink = new HyperLink();
            hyperLink.xValue = hlink.getxValue();
            hyperLink.zValue = hlink.getzValue();
            hyperLink.target = hlink.getTarget();
            hyperLink.link = hlink.getHyperLink();
            hyperLink.hint = hlink.getHint();
            return hyperLink;
        }
        return null;
    }

    @Override
    public String[] getSurfaceHyperLinkInString(int i) {
        String[] tmp = new String[]{((FaceHyperLink)this.surfaceHyperLinkList.elementAt(i)).getxValue(), ((FaceHyperLink)this.surfaceHyperLinkList.elementAt(i)).getzValue(), ((FaceHyperLink)this.surfaceHyperLinkList.elementAt(i)).getHyperLink(), ((FaceHyperLink)this.surfaceHyperLinkList.elementAt(i)).getTarget(), ((FaceHyperLink)this.surfaceHyperLinkList.elementAt(i)).getHint()};
        for (int j = 0; j < 5; ++j) {
            if (tmp[j] != null) continue;
            tmp[j] = "";
        }
        return tmp;
    }

    @Override
    public void writeSurfaceHyperLinkList(DataOutput out) throws IOException {
        int linkCount = this.surfaceHyperLinkList.size();
        out.writeInt(linkCount);
        for (int i = 0; i < linkCount; ++i) {
            ((FaceHyperLink)this.surfaceHyperLinkList.elementAt(i)).write(out);
        }
    }

    @Override
    public void readSurfaceHyperLinkList(DataInput in, boolean isUTF) throws IOException {
        int linkCount = in.readInt();
        for (int i = 0; i < linkCount; ++i) {
            FaceHyperLink.read(in, isUTF, this);
        }
    }
}

