/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.stack3d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Grid3D;
import quadbase.chart.chart3d.types3d.stack3d.StackChart3D;
import quadbase.common.util.internal.QbUtil;

public class StackAreaChart3D
extends StackChart3D {
    public StackAreaChart3D(Component component, ColData[] colData) {
        super(component, 8, colData);
    }

    public StackAreaChart3D(Chart _chart) {
        super(8, _chart);
        this.newSurface();
        if (_chart.chartType == 7 && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            for (int i = 2; i < this.nCol; ++i) {
                this.bmDataMap[i] = false;
            }
            this.dataDim = 2;
            this.copyTable(_chart);
        }
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        int j;
        double sum;
        int i;
        if (this.notEnoughData()) {
            return;
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            this.space.recomputeColor();
            return;
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        Axis a_x = this.axis[0];
        Axis a_y = this.axis[1];
        Axis a_z = this.axis[2];
        Axis a_s = this.axis[3];
        Point3D[] scoord = null;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        this.wall_ylength = 1000;
        this.wall_xlength = xmax = (int)((float)ymax * ratio);
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(oldymax - oldymin) / (3.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        this.findMinMaxCumSum();
        if (this.subvalueCol >= 0) {
            this.findMinMaxVal2();
        }
        if (this.isJoinAxis()) {
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
        }
        StepSize ystep = new StepSize(a_y, ymax, 0, this.maxvalue, this.minvalue, fstep, this.getVdec());
        ystep.zeroAxis = ystep.interpolatePixel(0.0);
        StepSize ystep2 = null;
        if (this.subvalueCol >= 0) {
            ystep2 = new StepSize(a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
        }
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        int noCategory = this.mDataLen[this.dataDim - 2];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)xmax / ((double)noCategory - 1.0);
        if (this.dataDim == 2) {
            double nextx = 0.0;
            this.wall_zlength = (int)(2.0 * delta);
            for (i = 0; i < noCategory; ++i) {
                loc[0] = i;
                sum = 0.0;
                for (j = 0; j < this.mDataLen[1]; ++j) {
                    loc[1] = j;
                    sum += this.mData.getValue(loc) * this.flashRatio;
                    if (this.isDataLimitAtAxisScale()) {
                        if (sum > a_y.maxScale) {
                            sum = a_y.maxScale;
                        } else if (sum < a_y.minScale) {
                            sum = a_y.minScale;
                        }
                    }
                    this.mData.setPointCoord((int)nextx, ystep.interpolatePixel(sum), (int)delta, loc);
                    this.mData.setFlashPointCoord((int)nextx, ystep.interpolatePixel(sum - this.mData.getValue(loc) / 2.0), (int)delta, loc);
                    if (ystep2 == null) continue;
                    double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, a_s) : this.mData2.getValue(loc) * this.flashRatio;
                    this.mData2.setPointCoord((int)nextx, ystep2.interpolatePixel(value), (int)delta, loc);
                }
                coord[i] = new Point3D((int)nextx, 0, this.wall_zlength);
                nextx += delta;
            }
        } else {
            double zdelta;
            int noSeries = this.mDataLen[0];
            scoord = new Point3D[noSeries];
            this.wall_zlength = (int)((double)noSeries * 1.5 * delta + 0.5 * delta);
            if (this.wall_zlength > xmax) {
                zdelta = (double)xmax / ((double)noSeries * 1.5 + 0.5);
                this.wall_zlength = xmax;
            } else {
                zdelta = delta;
            }
            double nextx = 0.0;
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                double nextz = zdelta;
                for (j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    sum = 0.0;
                    for (int k = 0; k < this.mDataLen[2]; ++k) {
                        loc[2] = k;
                        sum += this.mData.getValue(loc) * this.flashRatio;
                        if (this.isDataLimitAtAxisScale()) {
                            if (sum > a_y.maxScale) {
                                sum = a_y.maxScale;
                            } else if (sum < a_y.minScale) {
                                sum = a_y.minScale;
                            }
                        }
                        this.mData.setPointCoord((int)nextx, ystep.interpolatePixel(sum), (int)nextz, loc);
                        this.mData.setFlashPointCoord((int)nextx, ystep.interpolatePixel(sum - this.mData.getValue(loc)), (int)nextz, loc);
                        if (ystep2 == null) continue;
                        double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, a_s) : this.mData2.getValue(loc);
                        this.mData2.setPointCoord((int)nextx, ystep2.interpolatePixel(value), (int)nextz, loc);
                    }
                    if (i == 0) {
                        scoord[j] = new Point3D(xmax, 0, (int)nextz);
                    }
                    nextz += 1.5 * zdelta;
                }
                coord[i] = new Point3D((int)nextx, 0, this.wall_zlength);
                nextx += delta;
            }
            delta = zdelta;
        }
        a_y.setAxisGridY(this.space, ystep, xmax, ymax, this.wall_zlength, this.colData[this.valueCol]);
        a_y.setYWall(this.space, xmax, ymax, this.wall_zlength, this.wallbackground.areaColor);
        if (this.subvalueCol >= 0) {
            a_s.setAxisGridY(this.space, ystep2, this.wall_xlength, ymax, this.wall_zlength, this.colData[this.subvalueCol], this.wall_xlength, 0);
            a_s.setSWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        }
        a_z.setZWall(this.space, xmax, ymax, this.wall_zlength, this.wallbackground.areaColor);
        a_x.setXWall(this.space, xmax, ymax, this.wall_zlength, this.wallbackground.areaColor);
        int colfield = this.mDataMap[this.dataDim - 2];
        a_x.setTicker(this.space, this.colData[colfield].getFieldName(), coord, false, this.colData[colfield]);
        Point3D[] coord2 = new Point3D[noCategory];
        for (i = 0; i < coord2.length; ++i) {
            coord2[i] = new Point3D(coord[i].x, 0, 0);
        }
        a_x.grid.set(this.space, coord2, ymax, this.wall_zlength);
        a_s.grid.set(this.space, coord, ymax, this.wall_zlength);
        if (this.dataDim == 3) {
            a_z.setTicker(this.space, this.colData[this.mDataMap[0]].getFieldName(), scoord, true, this.colData[this.mDataMap[0]]);
            a_z.showTitleTicker = true;
            Point3D[] coord3 = new Point3D[scoord.length - 1];
            for (i = 0; i < coord3.length; ++i) {
                coord3[i] = new Point3D(0, 0, (scoord[i].z + scoord[i + 1].z) / 2);
            }
            a_z.grid.set(this.space, coord3, this.wall_xlength, this.wall_ylength);
        } else {
            a_z.setTicker(this.space, xmax, this.wall_zlength);
            a_z.showTitleTicker = false;
            ((Grid3D)a_z.grid).lineList = null;
        }
        this.syncColor();
        this.mData.prepare3DStackArea(this.space, delta * this.thickRatio / 2.0, ystep.zeroAxis);
        if (this.subvalueCol >= 0) {
            this.prepare3DLine(this.space, this.mData2, (int)(delta * this.thickRatio) / 2, (int)(30.0 * this.thickRatio), false);
        }
        this.prepareLabel();
        this.adjustInitScale(orgW, orgH);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw3D(g, 2);
    }

    @Override
    public boolean notEnoughData() {
        int noCat = this.mDataLen[this.dataDim - 2];
        if (noCat <= 1) {
            return true;
        }
        return this.nRow <= 1;
    }
}

