/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.stack3d;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.MultiDimData3D;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.internal.RenderingChart;

public abstract class StackChart3D
extends Chart3D {
    private static final Logger LOGGER = Logger.getLogger(StackChart3D.class.getName());

    public StackChart3D(Component component, int chartType, ColData[] colData) {
        this(component, chartType, colData, null);
    }

    public StackChart3D(Component component, int chartType, ColData[] colData, boolean[] usedColumns) {
        super(component, chartType, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint < 1) {
                throw notenoughError;
            }
            if (this.nint + this.nreal + this.ntime < 3) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 1 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.mDataMap[1] = this.nintcol[iindex++];
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[1] = this.nstringcol[0];
            if (this.nstring == 1) {
                if (this.nint + this.nreal + this.ntime < 2) {
                    throw nonumericError;
                }
                int rindex = 0;
                int iindex = 0;
                this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
                this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
            } else {
                this.mDataMap[0] = this.nstringcol[1];
                if (this.nint + this.nreal + this.ntime < 1) {
                    throw nonumericError;
                }
                this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
            }
        }
        this.dataDim = 2;
        this.bvalueCol = true;
        this.makeTable();
        this.newSurface();
    }

    public StackChart3D(int chartType, Chart _chart) {
        super(chartType, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.dataDim < 3) {
            if (_chart.dataDim == 2) {
                if (_chart.isStackType() && _chart.dataDim == 2) {
                    if (chartType == _chart.chartType) {
                        this.mDataMap[0] = _chart.mDataMap[0];
                        this.mDataMap[1] = _chart.mDataMap[1];
                    } else {
                        this.mDataMap[0] = _chart.mDataMap[1];
                        this.mDataMap[1] = _chart.mDataMap[0];
                    }
                    for (int i = 2; i < this.nCol; ++i) {
                        this.bmDataMap[i] = false;
                    }
                    this.dataDim = 2;
                } else {
                    if (!this.is2DChart && chartType == 8 && _chart.is2DChart && _chart.chartType == 8 && this.bmDataMap[2]) {
                        int t = this.mDataMap[2];
                        this.mDataMap[2] = this.mDataMap[1];
                        this.mDataMap[1] = this.mDataMap[0];
                        this.mDataMap[0] = t;
                    }
                    this.dataDim = this.bmDataMap[2] ? 3 : 2;
                }
            } else {
                this.dataDim = 2;
                this.bmDataMap[2] = false;
                if (!this.bmDataMap[1]) {
                    if (this.nstring == 0) {
                        if (this.nint + this.nreal < 2) {
                            throw notenoughError;
                        }
                        this.mDataMap[1] = this.nintcol[0] == this.mDataMap[0] && this.nint > 1 ? this.nintcol[1] : this.nintcol[0];
                        this.addNewColumnFromDataMapping = true;
                        this.bmDataMap[1] = true;
                    } else if (this.nstring == 1) {
                        if (this.mDataMap[0] != this.nstringcol[0]) {
                            this.mDataMap[1] = this.nstringcol[0];
                            this.bmDataMap[1] = true;
                        } else {
                            if (this.nint + this.nreal == 0) {
                                throw notenoughError;
                            }
                            this.mDataMap[1] = this.nint > 0 ? this.nintcol[0] : this.nstringcol[0];
                            this.addNewColumnFromDataMapping = true;
                            this.bmDataMap[1] = true;
                        }
                    } else {
                        this.mDataMap[1] = this.mDataMap[0] == this.nstringcol[0] ? this.nstringcol[1] : this.nstringcol[0];
                        this.addNewColumnFromDataMapping = true;
                        this.bmDataMap[1] = true;
                    }
                } else if (_chart.isCircularChart()) {
                    this.mDataMap[0] = _chart.mDataMap[1];
                    this.mDataMap[1] = _chart.mDataMap[0];
                }
            }
        } else {
            this.dataDim = 3;
        }
        this.checkSpecialColumn(2);
        this.copyTable(_chart);
        this.newSurface();
    }

    public void prepare3DLine(Object sp, MultiDimData data, int thick, int height, boolean bvertical) {
        Space space = (Space)sp;
        Point3D lastpoint = null;
        Vertex currv = new Vertex();
        Vertex lastv = new Vertex();
        if (this.dataDim == 2) {
            for (int i = 0; i < this.mDataLen[1]; ++i) {
                Color c = data.multiData[0].multiData[i].area.areaColor;
                lastpoint = null;
                for (int j = 0; j < this.mDataLen[0]; ++j) {
                    MultiDimData a = data.multiData[j].multiData[i];
                    if (a.plotData.isEmpty()) {
                        lastpoint = null;
                        continue;
                    }
                    Point3D currpoint = a.point;
                    currv.x = currpoint.x;
                    currv.y = currpoint.y;
                    currv.z = currpoint.z;
                    if (lastpoint != null) {
                        ((MultiDimData3D)a).lineFaceList = new Vector();
                        if (!bvertical) {
                            space.addLine(((MultiDimData3D)a).lineFaceList, lastv, currv, thick, height, c, a);
                        } else {
                            space.addLine2(((MultiDimData3D)a).lineFaceList, lastv, currv, thick, height, c, a);
                        }
                    }
                    lastpoint = currpoint;
                    lastv.x = lastpoint.x;
                    lastv.y = lastpoint.y;
                    lastv.z = lastpoint.z;
                }
            }
        } else {
            for (int i = 0; i < this.mDataLen[0]; ++i) {
                for (int j = 0; j < this.mDataLen[2]; ++j) {
                    Color c = data.multiData[i].multiData[0].multiData[j].area.areaColor;
                    lastpoint = null;
                    for (int k = 0; k < this.mDataLen[1]; ++k) {
                        MultiDimData a = data.multiData[i].multiData[k].multiData[j];
                        if (a.plotData.isEmpty()) {
                            lastpoint = null;
                            continue;
                        }
                        Point3D currpoint = a.point;
                        currv.x = currpoint.x;
                        currv.y = currpoint.y;
                        currv.z = currpoint.z;
                        if (lastpoint != null) {
                            ((MultiDimData3D)a).lineFaceList = new Vector();
                            if (!bvertical) {
                                space.addLine(((MultiDimData3D)a).lineFaceList, lastv, currv, thick, height, c, a);
                            } else {
                                space.addLine2(((MultiDimData3D)a).lineFaceList, lastv, currv, thick, height, c, a);
                            }
                        }
                        lastpoint = currpoint;
                        lastv.x = lastpoint.x;
                        lastv.y = lastpoint.y;
                        lastv.z = lastpoint.z;
                    }
                }
            }
        }
    }

    @Override
    public void draw(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.hiddenSurface.reset();
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.draw_INTERNAL(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.draw_INTERNAL(g);
        }
    }

    private void draw_INTERNAL(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        this.axis[0].drawGrid(g);
        this.axis[1].drawGrid(g);
        this.mData.drawArea(g);
        if (this.showLine || this.showLine2 || this.showPoint || this.showPoint2) {
            LOGGER.fine("StackChart3D:  draw");
        }
        this.dataLineSet.drawDataLineList();
        this.border.draw(g);
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.axis[0].draw(g);
        this.axis[1].draw(g);
        if (this.subvalueCol >= 0) {
            this.axis[3].draw(g);
        }
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
    }
}

