/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.stack3d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Grid3D;
import quadbase.chart.chart3d.types3d.stack3d.StackChart3D;
import quadbase.common.util.internal.QbUtil;

public class StackColChart3D
extends StackChart3D {
    public StackColChart3D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 4, colData, usedColumns);
    }

    public StackColChart3D(Chart _chart) {
        super(4, _chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        Point3D[] coord2;
        double nextx;
        double lastx;
        int noSeries;
        int currenty;
        double t;
        int t4;
        int t3;
        int j;
        int t2;
        int t1;
        int lasty1;
        int lasty2;
        double sum1;
        double sum2;
        int i;
        if (this.notEnoughData()) {
            return;
        }
        int thick = 2;
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            this.space.recomputeColor();
            return;
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        if (this.a_y.getMaxScale() < 0.0) {
            this.a_y.setMaxScale(0.0);
        }
        if (this.a_y.getMinScale() > 0.0) {
            this.a_y.setMinScale(0.0);
        }
        Point3D[] scoord = null;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        this.wall_ylength = 1000;
        xmax = (int)((float)ymax * ratio);
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(oldymax - oldymin) / (3.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        this.findMinMaxSum();
        if (this.subvalueCol >= 0) {
            this.findMinMaxVal2();
        }
        if (this.isJoinAxis()) {
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
        }
        StepSize ystep = new StepSize(this.a_y, ymax, 0, this.maxvalue, this.minvalue, fstep, this.getVdec());
        ystep.zeroAxis = ystep.interpolatePixel(0.0);
        StepSize ystep2 = null;
        if (this.subvalueCol >= 0) {
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
        }
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        int noCategory = this.mDataLen[this.dataDim - 2];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)xmax / ((double)noCategory * 2.0 + 1.0);
        if (this.dataDim == 2) {
            int lastz = (int)delta;
            int nextz = (int)(delta * (double)(1 + thick));
            double lastx2 = delta;
            this.wall_xlength = xmax;
            this.wall_zlength = (int)((double)nextz + delta);
            for (i = 0; i < noCategory; ++i) {
                loc[0] = i;
                sum2 = 0.0;
                sum1 = 0.0;
                lasty1 = lasty2 = ystep.zeroAxis;
                double nextx2 = lastx2 + delta;
                t1 = (int)((lastx2 + nextx2) / 2.0);
                t2 = (int)((nextx2 - lastx2) * this.thickRatio / 2.0);
                for (j = 0; j < this.mDataLen[1]; ++j) {
                    double d;
                    loc[1] = j;
                    t3 = (lastz + nextz) / 2;
                    t4 = (int)((double)(nextz - lastz) / (2.0 * this.thickRatio));
                    t = this.mData.getValue(loc) * this.flashRatio;
                    if (d >= 0.0) {
                        sum1 += t;
                        if (this.isDataLimitAtAxisScale() && sum1 > this.a_y.maxScale) {
                            sum1 = this.a_y.maxScale;
                        }
                        currenty = ystep.interpolatePixel(sum1);
                        this.mData.setAreaCoord(t1 - t2, t1 + t2, currenty, lasty1, t3 - t4, t3 + t4, loc);
                        lasty1 = currenty;
                    } else {
                        sum2 += t;
                        if (this.isDataLimitAtAxisScale() && sum2 < this.a_y.minScale) {
                            sum2 = this.a_y.minScale;
                        }
                        currenty = ystep.interpolatePixel(sum2);
                        this.mData.setAreaCoord(t1 - t2, t1 + t2, currenty, lasty2, t3 - t4, t3 + t4, loc);
                        lasty2 = currenty;
                    }
                    if (ystep2 == null) continue;
                    double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                    this.mData2.setPointCoord(t1, ystep2.interpolatePixel(value), t3, loc);
                }
                coord[i] = new Point3D(t1, 0, this.wall_zlength);
                lastx2 = nextx2 + delta;
            }
        } else if (this.isDrawSeriesOnCategoryAxis()) {
            noSeries = this.mDataLen[0];
            delta = (double)xmax / ((double)noCategory * (double)(noSeries + 1) + 1.0);
            int lastz = (int)delta;
            int nextz = (int)(delta * (double)(1 + thick));
            lastx = delta;
            this.wall_xlength = xmax;
            this.wall_zlength = (int)((double)nextz + delta);
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                int tmpT1 = (int)((lastx + lastx + delta * (double)noSeries) / 2.0);
                for (j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    sum2 = 0.0;
                    sum1 = 0.0;
                    lasty1 = lasty2 = ystep.zeroAxis;
                    nextx = lastx + delta;
                    t1 = (int)((lastx + nextx) / 2.0);
                    t2 = (int)((nextx - lastx) * this.thickRatio / 2.0);
                    for (int k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t3 = (lastz + nextz) / 2;
                        t4 = (int)((double)(nextz - lastz) / (2.0 * this.thickRatio));
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d >= 0.0) {
                            sum1 += t;
                            if (this.isDataLimitAtAxisScale() && sum1 > this.a_y.maxScale) {
                                sum1 = this.a_y.maxScale;
                            }
                            currenty = ystep.interpolatePixel(sum1);
                            this.mData.setAreaCoord(t1 - t2, t1 + t2, currenty, lasty1, t3 - t4, t3 + t4, loc);
                            lasty1 = currenty;
                        } else {
                            sum2 += t;
                            if (this.isDataLimitAtAxisScale() && sum2 < this.a_y.minScale) {
                                sum2 = this.a_y.minScale;
                            }
                            currenty = ystep.interpolatePixel(sum2);
                            this.mData.setAreaCoord(t1 - t2, t1 + t2, currenty, lasty2, t3 - t4, t3 + t4, loc);
                            lasty2 = currenty;
                        }
                        if (ystep2 == null) continue;
                        double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(t1, ystep2.interpolatePixel(value), t3, loc);
                    }
                    lastx = nextx;
                }
                coord[i] = new Point3D(tmpT1, 0, this.wall_zlength);
                lastx += delta;
            }
        } else {
            noSeries = this.mDataLen[0];
            scoord = new Point3D[noSeries];
            double temp = noSeries * (thick + 1) + 1;
            this.wall_zlength = (int)(delta * temp);
            if (this.wall_zlength < xmax) {
                this.wall_xlength = xmax;
            } else {
                delta = (double)xmax / temp;
                this.wall_zlength = xmax;
                this.wall_xlength = (int)(delta * (double)(2 * noCategory + 1));
            }
            lastx = delta;
            double stepz = delta * (double)thick;
            for (i = 0; i < noCategory; ++i) {
                nextx = lastx + delta;
                loc[1] = i;
                double lastz = delta;
                t1 = (int)((lastx + nextx) / 2.0);
                t2 = (int)((nextx - lastx) * this.thickRatio / 2.0);
                for (j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nextz = lastz + stepz;
                    lasty1 = lasty2 = ystep.zeroAxis;
                    sum2 = 0.0;
                    sum1 = 0.0;
                    t3 = (int)((lastz + nextz) / 2.0);
                    t4 = (int)((nextz - lastz) / (2.0 * this.thickRatio));
                    for (int k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d >= 0.0) {
                            sum1 += t;
                            if (this.isDataLimitAtAxisScale() && sum1 > this.a_y.maxScale) {
                                sum1 = this.a_y.maxScale;
                            }
                            currenty = ystep.interpolatePixel(sum1);
                            this.mData.setAreaCoord(t1 - t2, t1 + t2, currenty, lasty1, t3 - t4, t3 + t4, loc);
                            lasty1 = currenty;
                        } else {
                            sum2 += t;
                            if (this.isDataLimitAtAxisScale() && sum2 < this.a_y.minScale) {
                                sum2 = this.a_y.minScale;
                            }
                            currenty = ystep.interpolatePixel(sum2);
                            this.mData.setAreaCoord(t1 - t2, t1 + t2, currenty, lasty2, t3 - t4, t3 + t4, loc);
                            lasty2 = currenty;
                        }
                        if (ystep2 == null) continue;
                        double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(t1, ystep2.interpolatePixel(value), t3, loc);
                    }
                    if (i == 0) {
                        scoord[j] = new Point3D(this.wall_xlength, 0, t3);
                    }
                    lastz = nextz + delta;
                }
                coord[i] = new Point3D(t1, 0, this.wall_zlength);
                lastx = nextx + delta;
            }
        }
        this.a_y.setAxisGridY(this.space, ystep, this.wall_xlength, ymax, this.wall_zlength, this.colData[this.valueCol]);
        if (this.subvalueCol >= 0) {
            this.a_s.setAxisGridY(this.space, ystep2, this.wall_xlength, ymax, this.wall_zlength, this.colData[this.subvalueCol], this.wall_xlength, 0);
            this.a_s.setSWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        }
        this.a_y.setYWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        this.a_z.setZWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        this.a_x.setXWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        int colfield = this.mDataMap[this.dataDim - 2];
        this.a_x.setTicker(this.space, this.colData[colfield].getFieldName(), coord, false, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            coord2 = new Point3D[noCategory];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(coord[i].x, 0, 0);
            }
            this.a_x.grid.set(this.space, coord2, ymax, this.wall_zlength);
        } else {
            coord2 = new Point3D[noCategory - 1];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D((coord[i].x + coord[i + 1].x) / 2, 0, 0);
            }
            this.a_x.grid.set(this.space, coord2, ymax, this.wall_zlength);
        }
        if (this.dataDim == 3 && !this.isDrawSeriesOnCategoryAxis()) {
            this.a_z.setTicker(this.space, this.colData[this.mDataMap[0]].getFieldName(), scoord, true, this.colData[this.mDataMap[0]]);
            this.a_z.showTitleTicker = true;
            Point3D[] coord3 = new Point3D[scoord.length - 1];
            for (i = 0; i < coord3.length; ++i) {
                coord3[i] = new Point3D(0, 0, (scoord[i].z + scoord[i + 1].z) / 2);
            }
            this.a_z.grid.set(this.space, coord3, this.wall_xlength, this.wall_ylength);
        } else {
            this.a_z.setTicker(this.space, this.wall_xlength, this.wall_zlength);
            this.a_z.showTitleTicker = false;
            ((Grid3D)this.a_z.grid).lineList = null;
        }
        this.syncColor();
        this.mData.prepare3DBox(this.space);
        if (this.subvalueCol >= 0) {
            this.prepare3DLine(this.space, this.mData2, (int)(delta * this.thickRatio), (int)(30.0 * this.thickRatio), false);
        }
        if (this.cgraphics == null) {
            this.cgraphics = g;
        }
        this.prepareLabel();
        this.adjustInitScale(orgW, orgH);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw3D(g, 1);
    }
}

