/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.xml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CAnnotation;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DataAttribute;
import quadbase.chart.DrillDownNode;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.PieChart;
import quadbase.chart.Point3D;
import quadbase.chart.QbPattern;
import quadbase.chart.SaveChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.ColorSpectrum;
import quadbase.util.ControlRange;
import quadbase.util.DateTimeFormat;
import quadbase.util.HyperLink;
import quadbase.util.IAnnotation;
import quadbase.util.IFormat;
import quadbase.util.IQueryInParam;
import quadbase.util.LocaleDateTimeFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.LogicalFormat;
import quadbase.util.NumericFormat;
import quadbase.util.Point_2D;
import quadbase.util.Point_3D;
import quadbase.util.PolyLine;
import quadbase.util.internal.QbUtil;

public class SaveChartToXML
extends SaveChart {
    private static final Logger LOGGER = Logger.getLogger(SaveChartToXML.class.getName());
    Writer out;
    int index = -1;
    String chartFile;
    static final String[] SCROLLOPTION = new String[]{"AsNeed", "Always", "Never"};
    static final String[] BUBBLEDRAWMODE = new String[]{"Draw_Frame", "Fill_Bubble"};
    static final String[] SHAPE = new String[]{"Cross", "Circle", "Square", "Triangle", "Plus", "Star", "Line", "NoSymbol", "InverseTriangle", "Diamond"};
    static final String[] DIRECTION = new String[]{"Horz", "Rotate", "Rotate"};
    static final String[] PLACEMENT = new String[]{"Center", "North", "East", "South", "West", "Northeast", "Southeast", "Southwest", "Northwest"};
    static final String[] CURRENCYPOS = new String[]{"BeforeNumber", "AfterNegativeSign", "AfterNumber", "AfterNumberAndNegativeSign"};
    static final String[] NEGATIVEPOS = new String[]{"BeforeCurrencySign", "AfterCurrencySign", "AfterNumber"};
    static final String[] YEARSYMBOL = new String[]{"YEAR_1999", "YEAR_99"};
    static final String[] MONTHSYMBOL = new String[]{"MONTH_INT", "MONTH_SHORT_STRING", "MONTH_LONG_STRING"};
    static final String[] ORDERSYMBOL = new String[]{"MDY", "DMY", "YMD"};
    static final String[] LOGICALFORMAT = new String[]{"T_F", "TRUE_FALSE", "YES_NO", "Y_N", "ONE_ZERO"};
    static final String[] LOCALENUMERICFORMAT = new String[]{"CURRENCY", "NUMBER", "PERCENT"};
    static final String[] LOCALEDATETIMEFORMAT = new String[]{"DATE", "TIME", "DATETIME"};
    static final String[] SORTORDER = new String[]{"NONE", "ASCENDING", "DESCENDING", "SEC_ASCENDING", "SEC_DESCENDING"};
    private final String STATE = "state";
    public static final String PERCENTAGE = "PERCENTAGE";
    public static final String DRAW_LINES_IN_DATASOURCE_ORDER = "DRAW_LINES_IN_DATASOURCE_ORDER";
    public static final String DRAW_CONNECT_LINE_ARROWS = "DRAW_CONNECT_LINE_ARROWS";

    public SaveChartToXML(Chart chart) {
        super(chart);
    }

    public void saveToOutputStream(OutputStream sout, String chartName) throws IOException {
        this.chartFile = chartName;
        this.out = new BufferedWriter(new OutputStreamWriter(sout, ServerMessage.xmlEncoding));
        this.saveToDataOutput();
        this.out.flush();
        this.out.close();
    }

    private void tab() throws IOException {
        for (int i = 0; i < this.index; ++i) {
            this.out.write("  ");
        }
    }

    private void printElt(String elt, Font f) throws IOException {
        this.openElt(elt);
        this.printElt("Name", f.getName());
        this.printElt("Style", f.getStyle());
        this.printElt("Size", f.getSize());
        this.closeElt(elt);
    }

    private void printElt(String elt, Area area) throws IOException {
        this.openElt(elt);
        this.printElt("Color", area.areaColor);
        this.printElt("DrawBorder", area.drawBorder);
        this.printElt("DrawArea", area.drawArea);
        this.printElt("Automatic", area.automatic);
        this.printElt("PointA", area.p1);
        this.printElt("PointB", area.p2);
        this.printElt("IsGradientEnabled", area.isGradientEnabled());
        this.printElt("Is3DShadingEnabled", area.is3DShadingEnabled());
        this.printElt("GradientStartX", area.getGradientStartX());
        this.printElt("GradientStartY", area.getGradientStartY());
        this.printElt("GradientEndX", area.getGradientEndX());
        this.printElt("GradientEndY", area.getGradientEndY());
        if (area.getGradientDesColor() != null) {
            this.printElt("GradientDesColor", area.getGradientDesColor());
        }
        this.printElt("GradientShade", area.getGradientShade());
        this.printElt("GradientCyclic", area.isGradientCyclic());
        this.closeElt(elt);
    }

    private void printAnnotation(CAnnotation anno) throws IOException {
        this.openElt("Annotation");
        this.printElt("ReferenceToChart", anno.getReferenceObject() != null);
        String[] text = anno.getValues();
        String orgStr = "";
        if (text != null) {
            for (int i = 0; i < text.length; ++i) {
                orgStr = i != 0 ? orgStr + "\n" + text[i] : text[i];
            }
        }
        this.printElt("Text", orgStr);
        this.printElt("Visible", anno.isVisible());
        this.printElt("X_Pos", anno.getRelativePosition().x);
        this.printElt("Y_Pos", anno.getRelativePosition().y);
        this.printElt("Font", anno.getFont());
        this.printElt("Angle", anno.getAngle());
        this.printElt("Color", anno.getfontColor());
        this.printElt("Background", anno.getBackground());
        this.printElt("Border", anno.getBorder());
        this.printElt("Appearance", anno.getAppearance());
        this.printElt("Depth", anno.getDepth());
        this.closeElt("Annotation");
    }

    private void printElt(String elt, HyperLink link) throws IOException {
        this.openElt(elt);
        this.printElt("Series", link.series);
        this.printElt("Category", link.category);
        this.printElt("Sumby", link.sumBy);
        this.printElt("Link", link.link);
        this.printElt("Target", link.target);
        this.printElt("Hint", link.hint == null ? "" : link.hint);
        this.closeElt(elt);
    }

    private void printElt(String elt, ControlRange range) throws IOException {
        this.openElt(elt);
        this.printElt("StartScale", range.getStartScale());
        this.printElt("EndScale", range.getEndScale());
        this.printElt("StartScale2", range.getStartScale2());
        this.printElt("EndScale2", range.getEndScale2());
        this.printElt("IsScale1Enabled", range.isScale1Enabled());
        this.printElt("IsScale2Enabled", range.isScale2Enabled());
        this.printElt("Color", range.getColor());
        this.printElt("TitleInLegend", range.getTitle());
        this.printElt("ShowTitleInLegend", range.isShowInLegend());
        this.printElt("Thickness", range.getThickness());
        this.printElt("Offset", range.getOffset());
        this.printElt("CenterX", range.getCenter().x);
        this.printElt("CenterY", range.getCenter().y);
        this.printElt("DrawBorder", range.isDrawBorder());
        this.printElt("Appearance", range.getAppearance());
        this.printElt("Depth", range.getDepth());
        this.printElt("Vertical", range.getDirection() == 1);
        this.printElt("IsOverlapAreaHighlighted", range.isOverlapAreaHighlighted());
        this.printElt("IsGradientEnabled", range.isGradientEnabled());
        this.printElt("Is3DShadingEnabled", range.is3DShadingEnabled());
        this.printElt("GradientStartX", range.getGradientStartX());
        this.printElt("GradientStartY", range.getGradientStartY());
        this.printElt("GradientEndX", range.getGradientEndX());
        this.printElt("GradientEndY", range.getGradientEndY());
        if (range.getGradientDesColor() != null) {
            this.printElt("GradientDesColor", range.getGradientDesColor());
        }
        this.printElt("GradientShade", range.getGradientShade());
        this.printElt("GradientCyclic", range.isGradientCyclic());
        this.printElt(PERCENTAGE, range.isPercentage());
        this.closeElt(elt);
    }

    private void printElt(String elt, ColorSpectrum spec) throws IOException {
        this.openElt(elt);
        double[] value = spec.getValue();
        Color[] color = spec.getColor();
        int size = value == null ? 0 : value.length;
        this.printElt("CountSpectrumSeparator", size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.openElt("SpectrumSeparator");
                this.printElt("ColorBefore", color[i]);
                this.printElt("SeparatorValue", value[i]);
                this.closeElt("SpectrumSeparator");
            }
        }
        this.printElt("ColorAfter", color[size]);
        this.closeElt(elt);
    }

    private void saveColData(String tag, ColData[] colData) throws IOException {
        int val = 0;
        if (colData.length > 0) {
            val = colData[0].getSize();
        }
        this.saveColData(tag, colData, val);
    }

    private void saveColData(String tag, ColData[] colData, int size) throws IOException {
        int cSize = colData.length;
        if (cSize > 0) {
            String[] attr = new String[]{"qbCount"};
            String[] vals = new String[]{cSize + ""};
            this.openElt(tag, attr, vals);
            for (int i = 0; i < cSize; ++i) {
                this.printElt("ColData", this.chart.colData[i], size);
            }
            this.closeElt(tag);
        }
    }

    private void printElt(String elt, ColData cd, int dsize) throws IOException {
        int i;
        String[] vals;
        String[] attr;
        int size;
        this.openElt(elt);
        cd.saveXML(this.out, dsize);
        this.printElt("LabelStepInterval", cd.sepSize);
        this.printElt("GridStepInterval", cd.tickerSepSize);
        this.printElt("LabelIntervalUnit", cd.sepUnit);
        this.printElt("MaxNumOfTickerAndLabel", cd.maxNumOfTickerAndLabel);
        if (cd.startingDate != null) {
            this.printElt("StartDate", cd.startingDate.getTime());
        }
        if (cd.endingDate != null) {
            this.printElt("EndDate", cd.endingDate.getTime());
        }
        this.printElt("Ascending", cd.isAscending);
        if (cd.dataFormat != null) {
            this.writeDataFormat(cd.dataFormat);
        }
        int n = size = cd.hideLegend == null ? 0 : cd.hideLegend.length;
        if (size > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{size + ""};
            this.openElt("DataAttrList", attr, vals);
            for (i = 0; i < size; ++i) {
                this.openElt("DataAttr");
                this.printElt("HideLegend", cd.hideLegend[i]);
                this.printElt("HideData", cd.hideData[i]);
                this.closeElt("DataAttr");
            }
            this.closeElt("DataAttrList");
        }
        int n2 = size = cd.getFieldType() == null ? 0 : cd.getFieldType().length;
        if (size > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{size + ""};
            this.openElt("OverlayDataAttrList", attr, vals);
            for (i = 0; i < size; ++i) {
                this.openElt("OverlayDataAttr");
                if (cd.getFieldType()[i] < 0) {
                    this.printElt("LayerType", null, "state", "Invisible");
                } else {
                    this.printElt("LayerType", null, "state", Chart.CHARTTYPENAME[cd.getFieldType()[i]]);
                }
                this.printElt("AxisPosition", cd.getAxisPosition()[i]);
                this.closeElt("OverlayDataAttr");
            }
            this.closeElt("OverlayDataAttrList");
        }
        int n3 = size = cd.getHandLength() == null ? 0 : cd.getHandLength().length;
        if (size > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{size + ""};
            this.openElt("DialDataAttrList", attr, vals);
            for (i = 0; i < size; ++i) {
                this.openElt("DialDataAttr");
                this.printElt("NeedleLength", cd.getHandLength()[i]);
                this.closeElt("DialDataAttr");
            }
            this.closeElt("DialDataAttrList");
        }
        this.closeElt(elt);
    }

    private void printElt(String elt, PolyLine line) throws IOException {
        this.openElt(elt);
        int size = line.getPoints().size();
        if (size > 0) {
            String[] attr = new String[]{"qbCount"};
            String[] vals = new String[]{size + ""};
            if (line.getPoints().elementAt(0) instanceof Point_2D) {
                this.openElt("Point_2DList", attr, vals);
                for (int i = 0; i < size; ++i) {
                    this.printElt("Point_2D", (Point_2D)line.getPoints().elementAt(i));
                }
                this.closeElt("Point_2DList");
            } else {
                this.openElt("Point_3DList", attr, vals);
                for (int i = 0; i < size; ++i) {
                    this.printElt("Point_3D", (Point_3D)line.getPoints().elementAt(i));
                }
                this.closeElt("Point_3DList");
            }
        }
        this.printElt("Color", line.getColor());
        this.printElt("Thickness", line.getThickness());
        this.printElt("LineStyle", line.getLineStyle());
        this.printElt("FillArea", line.isFillArea());
        this.printElt("DrawStartArrow", line.isFillArea());
        this.printElt("DrawEndArrow", line.isFillArea());
        this.closeElt(elt);
    }

    private void printElt(String elt, Point3D pt) throws IOException {
        this.openElt(elt);
        this.printElt("X_Coord", pt.x);
        this.printElt("Y_Coord", pt.y);
        this.printElt("Z_Coord", pt.z);
        this.printElt("Shape", null, "state", SHAPE[pt.shape % 256]);
        this.printElt("Color", pt.color);
        this.printElt("Automatic", pt.automatic);
        this.closeElt(elt);
    }

    private void printElt(String elt, Point_3D pt) throws IOException {
        this.openElt(elt);
        this.printElt("X_Coord", pt.getX());
        this.printElt("Y_Coord", pt.getY());
        this.printElt("Z_Coord", pt.getZ());
        this.closeElt(elt);
    }

    private void printElt(String elt, Point_2D pt) throws IOException {
        this.openElt(elt);
        this.printElt("X_Coord", pt.getX());
        this.printElt("Y_Coord", pt.getY());
        this.closeElt(elt);
    }

    private void printElt(String elt, CString str) throws IOException {
        this.openElt(elt);
        this.printElt("Text", str.str);
        this.printElt("Font", str.font);
        this.printElt("Point3D", str.pos);
        this.printElt("Color", str.color);
        this.printElt("Direction", null, "state", DIRECTION[str.direction]);
        this.printElt("Angle", str.angle);
        this.printElt("Visible", str.bshow);
        this.printElt("Placement", null, "state", PLACEMENT[str.placement]);
        this.printElt("Automatic", str.automatic);
        this.closeElt(elt);
    }

    private void printElt(String elt, Color color) throws IOException {
        this.openElt(elt);
        this.printElt("R", color.getRed());
        this.printElt("G", color.getGreen());
        this.printElt("B", color.getBlue());
        this.closeElt(elt);
    }

    private void printElt(String elt, Dimension d) throws IOException {
        this.openElt(elt);
        this.printElt("Width", d.width);
        this.printElt("Height", d.height);
        this.closeElt(elt);
    }

    private void printElt(String elt, String obj) throws IOException {
        ++this.index;
        this.tab();
        if (obj == null || obj.equals("")) {
            this.out.write("<" + elt + "/>\n");
        } else {
            this.out.write("<" + elt + "><![CDATA[" + obj + "]]></" + elt + ">\n");
        }
        --this.index;
    }

    private void printElt(String elt, boolean obj) throws IOException {
        this.printElt(elt, (String)null, "state", obj + "");
    }

    private void printElt(String elt, int obj) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt + ">" + obj + "</" + elt + ">\n");
        --this.index;
    }

    private void printElt(String elt, double obj) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt + ">" + obj + "</" + elt + ">\n");
        --this.index;
    }

    private void printElt(String elt, float obj) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt + ">" + obj + "</" + elt + ">\n");
        --this.index;
    }

    private void printElt(String elt, long obj) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt + ">" + obj + "</" + elt + ">\n");
        --this.index;
    }

    private void printElt(String elt, String obj, String attr, String val) throws IOException {
        this.printElt(elt, obj, new String[]{attr}, new String[]{val});
    }

    private void printElt(String elt, String obj, String[] attr, String[] vals) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt);
        if (attr != null) {
            for (int i = 0; i < attr.length; ++i) {
                this.out.write(" " + attr[i] + "=\"" + vals[i] + "\"");
            }
        }
        this.out.write(">");
        if (obj != null && !obj.equals("")) {
            this.out.write("<![CDATA[" + obj + "]]>");
        }
        this.out.write("</" + elt + ">\n");
        --this.index;
    }

    private void openElt(String elt) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt + ">\n");
    }

    private void openElt(String elt, String[] attr, String[] vals) throws IOException {
        ++this.index;
        this.tab();
        this.out.write("<" + elt);
        if (attr != null) {
            for (int i = 0; i < attr.length; ++i) {
                this.out.write(" " + attr[i] + "=\"" + vals[i] + "\"");
            }
        }
        this.out.write(">\n");
    }

    private void closeElt(String elt) throws IOException {
        this.tab();
        this.out.write("</" + elt + ">\n");
        --this.index;
    }

    private String printArrayIndex(boolean[] array) {
        if (array == null) {
            return "";
        }
        String tmp = "";
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            tmp = tmp.equals("") ? tmp + i : tmp + " " + i;
        }
        return tmp;
    }

    private void saveToDataOutput() throws IOException {
        this.out.write("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>\n");
        this.openElt("EspressChartAttr", null, null);
        this.saveData();
        this.closeElt("EspressChartAttr");
    }

    private void saveData() throws IOException {
        int vsize;
        Vector<IAnnotation> annoList;
        int asize;
        int csize;
        int hsize;
        int cSize;
        int pSize;
        int i;
        this.printElt("ChartLocation", this.chartFile);
        this.saveTree(this.drillDownNode);
        this.writeDataSource();
        this.printElt("ParameterPrompt", this.chart.isPrevParamPrompt());
        String[] attr = new String[]{"type", "is2DimChart", "comboType"};
        String[] vals = new String[]{Chart.CHARTTYPENAME[this.chart.getChartType()], this.chart.is2DimChart() + "", Chart.COMBOTYPENAME[this.chart.getComboType()]};
        this.printElt("ChartType", (String)null, attr, vals);
        this.printElt("DrawNullColumn", this.chart.isDrawNullColumn());
        this.printElt("NullColumnName", this.chart.getNullColumnName());
        this.printElt("CanvasSize", this.chart.getSize());
        this.printElt("ScrollBarOption", (String)null, "option", SCROLLOPTION[this.chart.getScrollBarOption()]);
        this.printElt("AdjustViewerFont", this.chart.isAdjustFont());
        this.printElt("PopupMenuEnabled", this.chart.isPopupMenuEnabled());
        this.printElt("DimMenuEnabled", this.chart.isDimMenuEnabled());
        this.printElt("TypeMenuEnabled", this.chart.isTypeMenuEnabled());
        this.printElt("Title", this.chart.mainTitle);
        switch (this.chart.getChartType()) {
            case 6: 
            case 20: {
                int i2;
                PieChart pieChart = ((IPieChart)((Object)this.chart)).getPieChart();
                this.openElt("PieAttr");
                this.printElt("ConcentricDoughnut", pieChart.concentricDoughnut);
                this.printElt("PieSectors", pieChart.pieSectors);
                this.printElt("FontDistance", pieChart.fontdistance);
                this.printElt("SliceDistance", pieChart.sliceDistance);
                this.printElt("InitAngle", pieChart.initangle);
                this.printElt("LabelFont", pieChart.pieLabelFont);
                this.printElt("ValueFont", pieChart.pieValueFont);
                this.printElt("PercentFont", pieChart.piePercentFont);
                this.printElt("LabelColor", pieChart.pieLabelColor);
                this.printElt("ValueColor", pieChart.pieValueColor);
                this.printElt("PercentColor", pieChart.piePercentColor);
                this.printElt("LabelAngle", pieChart.pieLabelAngle);
                this.printElt("ValueAngle", pieChart.pieValueAngle);
                this.printElt("PercentAngle", pieChart.piePercentAngle);
                this.printElt("ShowLabel", this.chart.getLabelState());
                this.printElt("ShowValue", this.chart.getValueState());
                this.printElt("ShowPercent", this.chart.getPercentState());
                this.printElt("ShowPercentInLegend", pieChart.smartlabel);
                this.printElt("ShowValueInLegend", pieChart.valInLegend);
                this.printElt("SectorGapEnabled", pieChart.isSectorGapEnabled());
                this.printElt("PieExtendLine", pieChart.pieExtendLine);
                this.printElt("PieLabelAtTheSide", pieChart.labelAtTheSide);
                this.printElt("PieWithSeries", this.chart.dataDim == 2);
                this.printElt("CategoryLabelDistance", pieChart.catLabelDistance);
                this.printElt("CategoryLabelFont", pieChart.catLabelFont);
                this.printElt("CategoryLabelColor", pieChart.catLabelColor);
                this.printElt("CategoryLabelAngle", pieChart.catLabelAngle);
                this.printElt("CategoryLabelState", pieChart.showCategory);
                this.printElt("BestFit", pieChart.isBestFit());
                this.printElt("DrawLinearly", pieChart.isDrawLinearly());
                this.printElt("PiePerRow", pieChart.piePerRow);
                this.printElt("GapRatioBetweenPies", pieChart.getGapRatioBetweenPies());
                int pieCt = pieChart.pieLabel.length;
                int psize = 0;
                if (pieCt > 0) {
                    psize = pieChart.pieLabel[0].length;
                }
                if (psize > 0) {
                    attr = new String[]{"pieCount", "qbCount"};
                    vals = new String[]{pieCt + "", psize + ""};
                    this.openElt("PieLabelList", attr, vals);
                    for (int j = 0; j < pieCt; ++j) {
                        for (i2 = 0; i2 < psize; ++i2) {
                            this.openElt("PieLabel");
                            this.printElt("LabelX", pieChart.pieLabel[j][i2].xoffset);
                            this.printElt("LabelY", pieChart.pieLabel[j][i2].yoffset);
                            this.printElt("ValueX", pieChart.pieValue[j][i2].xoffset);
                            this.printElt("ValueY", pieChart.pieValue[j][i2].yoffset);
                            this.printElt("PercentX", pieChart.piePercent[j][i2].xoffset);
                            this.printElt("PercentY", pieChart.piePercent[j][i2].yoffset);
                            this.closeElt("PieLabel");
                        }
                    }
                    this.closeElt("PieLabelList");
                }
                this.closeElt("PieAttr");
                break;
            }
            case 12: {
                int i2;
                this.openElt("SurfaceAttr");
                this.printElt("Color", this.chart.get3DSurfaceColor());
                int ssize = this.chart.getSurfaceHyperLinkList().size();
                if (ssize > 0) {
                    attr = new String[]{"qbCount"};
                    vals = new String[]{ssize + ""};
                    this.openElt("SurfaceHyperLinkList", attr, vals);
                    for (i2 = 0; i2 < ssize; ++i2) {
                        this.openElt("SurfaceHyperLink");
                        String[] tmp = this.chart.getSurfaceHyperLinkInString(i2);
                        this.printElt("ValueX", tmp[0]);
                        this.printElt("ValueZ", tmp[1]);
                        this.printElt("Link", tmp[2]);
                        this.printElt("Target", tmp[3]);
                        this.printElt("Hint", tmp[4]);
                        this.closeElt("SurfaceHyperLink");
                    }
                    this.closeElt("SurfaceHyperLinkList");
                }
                this.closeElt("SurfaceAttr");
                break;
            }
            case 13: {
                this.openElt("BubbleAttr");
                this.printElt("BubbleDrawMode", null, "state", BUBBLEDRAWMODE[this.chart.bubbleDrawMode]);
                this.printElt("AxisUnitToRadiusRatio", this.chart.axisUnitToRadiusRatio);
                this.closeElt("BubbleAttr");
                break;
            }
            case 3: {
                this.openElt("LineAttr");
                this.printElt("StepLineState", this.chart.getStepLineState());
                this.printElt("StepLineRatio", this.chart.getStepLineRatio());
                this.printElt("PlotSecDataWithPriAxis", this.chart.isShowDoubleValueForLine());
                this.printElt("SetPointsUniform", this.chart.isSyncPointColorForLine());
                if (this.chart.isShowDropBarForLine()) {
                    this.openElt("DropBar");
                    this.printElt("Visible", this.chart.isShowDropBarForLine());
                    this.printElt("DrawBorder", this.chart.getDropBarBorderState());
                    this.printElt("UpBarColor", this.chart.getDropBarColor());
                    this.printElt("DownBarColor", this.chart.getDropBarColor2());
                    this.printElt("SeriesA", this.chart.getDropBarSeries1());
                    this.printElt("SeriesB", this.chart.getDropBarSeries2());
                    this.closeElt("DropBar");
                }
                this.printElt("Vertical", this.chart.getLayout() == 1);
                this.closeElt("LineAttr");
                break;
            }
            case 16: {
                this.openElt("RadarAttr");
                this.saveLabelOffset("LabelOffsetList", this.chart);
                this.closeElt("RadarAttr");
                break;
            }
            case 19: {
                this.openElt("PolarAttr");
                this.printElt("SectorCount", this.chart.getNoSectionForPolar());
                this.printElt("StartAngle", this.chart.getStartAngleForPolar());
                this.printElt("IsRadian", this.chart.isRadianForPolar());
                this.printElt("IsClockwise", this.chart.isClockWiseForPolar());
                this.saveLabelOffset("LabelOffsetList", this.chart);
                this.closeElt("PolarAttr");
                break;
            }
            case 17: {
                this.openElt("DialAttr");
                this.saveLabelOffset("LabelOffsetList", this.chart);
                this.printElt("StartAngle", this.chart.getStartAngleForDial());
                this.printElt("EndAngle", this.chart.getEndAngleForDial());
                this.printElt("RadiusForInternalDial", this.chart.getRadiusForInternalDial());
                this.printElt("CenterColor", this.chart.getCenterColorForDial());
                this.printElt("FullCircle", this.chart.isDrawFullCircleForDial());
                this.printElt("SubTickerLength", this.chart.getSubTickerLength());
                this.printElt("TickerLength", this.chart.getTickerLength());
                this.printElt("Is3DShadowForTickerOn", this.chart.is3DShadowForTickerOn());
                this.printElt("SubTickerCount", this.chart.getSubTickerCount());
                this.printElt("SubTickerThickness", this.chart.getSubTickerThickness());
                this.printElt("IsPointerUsed", this.chart.isPointerUsed());
                this.printElt("NeedleStyle", this.chart.getNeedleOption());
                this.closeElt("DialAttr");
                break;
            }
            case 15: {
                this.openElt("BoxAttr");
                this.printElt("Vertical", this.chart.getLayout() == 1);
                this.closeElt("BoxAttr");
                break;
            }
            case 18: {
                this.openElt("GanttAttr");
                this.printElt("DisplayInTime", this.chart.isLabelDateTimeDisplay(0));
                this.printElt("DisplayByWeek", this.chart.isDisplayByWeek(0));
                this.closeElt("GanttAttr");
                break;
            }
            case 2: {
                this.openElt("ScatterAttr");
                this.printElt("DisplayXAxisInTime", this.chart.isLabelDateTimeDisplay(0));
                this.printElt("DisplayYAxisInTime", this.chart.isLabelDateTimeDisplay(1));
                this.printElt("DisplayZAxisInTime", this.chart.isLabelDateTimeDisplay(2));
                this.printElt("DisplayXAxisByWeek", this.chart.isDisplayByWeek(0));
                this.printElt("DisplayYAxisByWeek", this.chart.isDisplayByWeek(1));
                this.printElt("DisplayZAxisByWeek", this.chart.isDisplayByWeek(2));
                this.printElt(DRAW_LINES_IN_DATASOURCE_ORDER, this.chart.isLineInOriginalOrder());
                this.printElt(DRAW_CONNECT_LINE_ARROWS, this.chart.isDrawConnectLineArrows());
                this.closeElt("ScatterAttr");
            }
        }
        if (!this.chart.isCircularChart()) {
            this.openElt("AxisAttr");
            this.printElt("Color", this.chart.getAxisColor());
            this.printElt("Thickness", this.chart.axisThickness);
            this.printElt("ShowArrow", this.chart.getArrowState());
            this.printElt("XAxisLabelRow", this.chart.get_xlabelrow());
            this.printElt("SwapAxis", this.chart.isSwapAxis());
            this.printElt("JoinAxis", this.chart.isJoinAxis());
            this.printElt("SynchronizeRadarAxes", this.chart.isSynchronizeRadarAxis());
            this.printElt("DrawCircularGrid", this.chart.isDrawCircularGrid());
            if (this.chart.getAreaCutOffPoint() != null) {
                this.printElt("AreaCutOffPoint", this.chart.getAreaCutOffPoint());
            }
            this.printElt("AlignGridWithTicker", this.chart.isGridAlignedWithTicker());
            this.printElt("GridInFront", this.chart.isGridInFront());
            String[] axisType = new String[]{"X", "Y", "Z", "S"};
            for (i = 0; i < 4; ++i) {
                this.openElt("Axis_" + axisType[i]);
                Axis ax = this.chart.axis[i];
                this.printElt("Visible", this.chart.getAxisState(i));
                this.printElt("Title", ax.title);
                this.openElt("Grid");
                this.printElt("Visible", this.chart.getGridState(i));
                this.printElt("Color", this.chart.getGridColor(i));
                this.printElt("Thickness", this.chart.getGridThickness(i));
                this.printElt("LineStyle", this.chart.getGridLineStyle(i));
                this.closeElt("Grid");
                this.printElt("LogScale", ax.logScale);
                this.printElt("ShowLogValue", ax.isShowLogValue());
                this.printElt("LogBase", ax.getBaseForLog());
                this.printElt("ShowLogSubTickers", ax.isShowSubTickers());
                this.printElt("AutoScale", ax.autoscale);
                this.printElt("AutoOrigin", ax.autoOrigin);
                this.printElt("AxisPadding", ax.addAxisPadding);
                this.printElt("LabelOutsidePlotArea", ax.isLabelOutsidePlotArea());
                this.printElt("MaxScale", ax.maxScale);
                this.printElt("MinScale", ax.minScale);
                this.printElt("StepScale", ax.stepScale);
                this.printElt("StepScaleMonth", ax.stepScaleMonth);
                if (ax.ticker != null) {
                    this.openElt("Ticker");
                    this.printElt("ShowLabel", this.chart.getTickerLabelState(i));
                    this.printElt("Color", this.chart.getTickerColor(i));
                    this.printElt("LabelColor", this.chart.getLabelColor(i));
                    this.printElt("Font", this.chart.getTickerFont(i));
                    this.printElt("Angle", this.chart.getTickerAngle(i));
                    this.printElt("Visible", ax.ticker.showline);
                    this.printElt("Inward", ax.ticker.tickerInward);
                    this.printElt("RadarXOffset", ax.ticker.radarXOffset);
                    this.printElt("RadarYOffset", ax.ticker.radarYOffset);
                    String[] tmp = ax.ticker.getTickerLabels();
                    if (tmp != null && tmp.length > 0) {
                        attr = new String[]{"qbCount"};
                        vals = new String[]{tmp.length + ""};
                        this.openElt("LabelSubstitutionList", attr, vals);
                        for (String element : tmp) {
                            this.printElt("LabelSubstitution", element);
                        }
                        this.closeElt("LabelSubstitutionList");
                    }
                    this.closeElt("Ticker");
                }
                this.closeElt("Axis_" + axisType[i]);
            }
            this.closeElt("AxisAttr");
        }
        this.saveLegend("Legend", this.chart.legend);
        this.saveLegend("SecLegend", this.chart.legend2);
        this.openElt("TopLabel");
        if (this.chart.getTopValueState()) {
            this.openElt("PrimaryTopLabel");
            this.printElt("Visible", this.chart.getTopValueState());
            this.printElt("Font", this.chart.topvalueLabel_font);
            this.printElt("Color", this.chart.topvalueLabel_color);
            if (this.chart.topvalueNegativeLabel_color != null) {
                this.printElt("ColorForNegativeValue", this.chart.topvalueNegativeLabel_color);
            }
            this.printElt("Angle", this.chart.topvalueLabel_angle);
            this.printElt("Alignment", this.chart.topLabel_Alignment);
            this.closeElt("PrimaryTopLabel");
        }
        if (this.chart.getTopValueState2()) {
            this.openElt("SecondaryTopLabel");
            this.printElt("Visible", this.chart.getTopValueState2());
            this.printElt("Font", this.chart.topvalueLabel2_font);
            this.printElt("Color", this.chart.topvalueLabel2_color);
            this.printElt("Angle", this.chart.topvalueLabel2_angle);
            this.closeElt("SecondaryTopLabel");
        }
        this.printElt("LabelOnPositiveSide", this.chart.isLabelOnPositiveSide());
        this.printElt("LabelOnNegativeSide", this.chart.isLabelOnNegativeSide());
        this.printElt("ShowSeriesInTopLabel", this.chart.isShowSeriesInTopLabel());
        this.printElt("ShowStackLabel", this.chart.getStackLabelState());
        this.printElt("ShowStackTotalLabel", this.chart.getStackTotalLabelState());
        this.printElt("ShowStackLabelAlignment", this.chart.stackLabel_Alignment);
        this.closeElt("TopLabel");
        this.openElt("Position");
        this.printElt("Legend_X", this.chart.legend_XProp);
        this.printElt("Legend_Y", this.chart.legend_YProp);
        this.printElt("SecLegend_X", this.chart.legend2_XProp);
        this.printElt("SecLegend_Y", this.chart.legend2_YProp);
        this.printElt("Title_X", this.chart.title_XProp);
        this.printElt("Title_Y", this.chart.title_YProp);
        this.printElt("Chart_X", this.chart.chart_XProp);
        this.printElt("Chart_Y", this.chart.chart_YProp);
        this.printElt("Chart_Width", this.chart.chart_widthProp);
        this.printElt("Chart_Height", this.chart.chart_heightProp);
        this.closeElt("Position");
        this.printElt("PlotAreaBackground", this.chart.getBackground());
        this.printElt("PlotAreaBorder", this.chart.getBorder());
        this.printElt("DeskTopArea", this.chart.getDesktopArea());
        this.printElt("BorderThickness", this.chart.getBorderThickness());
        this.printElt("ShowArea", this.chart.getAreaState());
        this.printElt("ShowPoint", this.chart.getPointState());
        this.printElt("ShowPointBorder", this.chart.isDrawPointBorder());
        this.printElt("BlackPointBorderColor", this.chart.getDrawPointBorderColor().getRGB() == Color.black.getRGB());
        this.printElt("ShowLine", this.chart.getLineState());
        this.printElt("ShowSecPoint", this.chart.getPointState2());
        this.printElt("ShowSecPointBorder", this.chart.isDrawPointBorder2());
        this.printElt("SecBlackPointBorderColor", this.chart.getDrawPointBorderColor2().getRGB() == Color.black.getRGB());
        this.printElt("ShowSecLine", this.chart.getLineState2());
        this.printElt("AntiAliasEnabled", this.chart.isAntiAliasEnabled());
        this.printElt("AntiAliasChartOnly", this.chart.setAntiAliasForChartOnly);
        this.printElt("ShowShadowOnLine", this.chart.isShowShadowOnLine());
        this.printElt("showShadowOnPoint", this.chart.isShowShadowOnPoint());
        this.printElt("Translucent", this.chart.isTranslucent());
        this.printElt("TranslucentValue", this.chart.getTranslucentValue());
        this.printElt("Java2DRotateText", this.chart.isJ2DRotateEnabled());
        this.printElt("DisableJava2DForStraightText", this.chart.isDisableJava2DForStraightText());
        this.printElt("IsGradientEnabled", this.chart.getPrimaryDataGradientSupport().isGradientEnabled());
        this.printElt("Is3DShadingEnabled", this.chart.getPrimaryDataGradientSupport().is3DShadingEnabled());
        this.printElt("IsApplyGradientToChartDataOnly", this.chart.getPrimaryDataGradientSupport().isApplyGradientToChartDataOnly());
        this.printElt("GradientStartX", this.chart.getPrimaryDataGradientSupport().getGradientStartX());
        this.printElt("GradientStartY", this.chart.getPrimaryDataGradientSupport().getGradientStartY());
        this.printElt("GradientEndX", this.chart.getPrimaryDataGradientSupport().getGradientEndX());
        this.printElt("GradientEndY", this.chart.getPrimaryDataGradientSupport().getGradientEndY());
        if (this.chart.getPrimaryDataGradientSupport().getGradientDesColor() != null) {
            this.printElt("GradientDesColor", this.chart.getPrimaryDataGradientSupport().getGradientDesColor());
        }
        this.printElt("GradientShade", this.chart.getPrimaryDataGradientSupport().getGradientShade());
        this.printElt("GradientCyclic", this.chart.getPrimaryDataGradientSupport().isGradientCyclic());
        this.printElt("IsGradientEnabledForSecondaryData", this.chart.getSecondaryDataGradientSupport().isGradientEnabled());
        this.printElt("Is3DShadingEnabledForSecondaryData", this.chart.getSecondaryDataGradientSupport().is3DShadingEnabled());
        this.printElt("GradientStartXForSecondaryData", this.chart.getSecondaryDataGradientSupport().getGradientStartX());
        this.printElt("GradientStartYForSecondaryData", this.chart.getSecondaryDataGradientSupport().getGradientStartY());
        this.printElt("GradientEndXForSecondaryData", this.chart.getSecondaryDataGradientSupport().getGradientEndX());
        this.printElt("GradientEndYForSecondaryData", this.chart.getSecondaryDataGradientSupport().getGradientEndY());
        if (this.chart.getSecondaryDataGradientSupport().getGradientDesColor() != null) {
            this.printElt("GradientDesColorForSecondaryData", this.chart.getSecondaryDataGradientSupport().getGradientDesColor());
        }
        this.printElt("GradientShadeForSecondaryData", this.chart.getSecondaryDataGradientSupport().getGradientShade());
        this.printElt("GradientCyclicForSecondaryData", this.chart.getSecondaryDataGradientSupport().isGradientCyclic());
        this.printElt("MaxDisplayCharactersForText", this.chart.getCutOffThresholdForText());
        this.printElt("GIFBackgroundTransparent", this.chart.isBackgroundTransparent());
        this.printElt("DrawDataBorder", this.chart.getDataBorder());
        this.printElt("DrawBlackBorderForWhiteArea", this.chart.isDrawBorderForWhiteArea());
        this.printElt("DrawDataColor", this.chart.getDataBorderColor());
        this.printElt("DrawDataThickness", this.chart.getDataBorderThickness());
        this.printElt("BarWidthRatio", this.chart.getBarwidthRatio());
        this.printElt("ShowNullDataLine", this.chart.getNullDataLine());
        this.printElt("ApplyLineStyleToNullData", this.chart.isApplyLineStyleToNullData());
        this.printElt("ShowNullInScatter", this.chart.isShowNullInScatter());
        this.printElt("ShowNullDataAsZero", this.chart.isNullDataAsZero());
        this.printElt("CandleStick", this.chart.getCandleStick());
        this.printElt("LineXOffset", this.chart.get_xshift());
        this.printElt("EndToEnd", this.chart.showOffsetTicker());
        this.printElt("FormatHintData", this.chart.getFormatHint());
        this.printElt("FlashHintFont", this.chart.flashHintFont);
        this.printElt("FlashHintFontColor", this.chart.flashHintFontColor);
        this.printElt("FlashHintBgColor", this.chart.flashHintBgColor);
        this.printElt("FlashHintBorderColor", this.chart.flashHintBorderColor);
        if (!this.chart.is2DChart) {
            this.openElt("Set3DAttr");
            this.printElt("AutoRotate", this.chart.isAutoRotate());
            this.printElt("ThickRatio", this.chart.getThickRatio());
            this.printElt("WallBackground", this.chart.getWallBackground());
            this.printElt("ShowWallFrame", this.chart.getWallFrameState());
            this.printElt("Set3DDrawType", this.chart.get3DDrawType());
            this.printElt("ZoomFactor", this.chart.getZoomfactor());
            this.printElt("AnimateSpeed", this.chart.getAnimateSpeed());
            this.printElt("Is3DApproximationUsed", this.chart.is3DApproximationUsed);
            this.printElt("ApproximationThreshold", this.chart.approximationThreshold);
            this.printElt("DrawSeriesOnCategoryAxis", this.chart.isDrawSeriesOnCategoryAxis());
            this.openElt("ViewDirection");
            float[] view = this.chart.getViewPoint();
            this.openElt("From");
            this.printElt("ValueX", view[0]);
            this.printElt("ValueY", view[1]);
            this.printElt("ValueZ", view[2]);
            this.closeElt("From");
            this.openElt("To");
            this.printElt("ValueX", view[3]);
            this.printElt("ValueY", view[4]);
            this.printElt("ValueZ", view[5]);
            this.closeElt("To");
            this.closeElt("ViewDirection");
            this.openElt("ViewTranslation");
            view = this.chart.getViewTranslate();
            this.printElt("ValueX", view[0]);
            this.printElt("ValueY", view[1]);
            this.printElt("ValueZ", view[2]);
            this.closeElt("ViewTranslation");
            this.openElt("LightPosition");
            view = this.chart.getLightPos();
            this.printElt("ValueX", view[0]);
            this.printElt("ValueY", view[1]);
            this.printElt("ValueZ", view[2]);
            this.closeElt("LightPosition");
            this.openElt("Ambient");
            view = this.chart.getAmbient();
            this.printElt("ValueX", view[0]);
            this.printElt("ValueY", view[1]);
            this.printElt("ValueZ", view[2]);
            this.closeElt("Ambient");
            this.openElt("Intensity");
            view = this.chart.getIntensity();
            this.printElt("ValueX", view[0]);
            this.printElt("ValueY", view[1]);
            this.printElt("ValueZ", view[2]);
            this.closeElt("Intensity");
            this.openElt("Scale3D");
            this.printElt("ValueX", this.chart.getX_scale());
            this.printElt("ValueY", this.chart.getY_scale());
            this.printElt("ValueZ", this.chart.getZ_scale());
            this.closeElt("Scale3D");
            this.closeElt("Set3DAttr");
        }
        this.saveDataAttribute(new DataAttribute(this.chart.mData, false, this.chart.is2DChart, this.chart.chartType, true, this.chart.isUniqueColorForCol()), "DataAttribute");
        if (this.chart.mData2 != null) {
            this.saveDataAttribute(new DataAttribute(this.chart.mData2, true, this.chart.mData2.chart.is2DChart, this.chart.mData2.chart.chartType, true, false), "SecDataAttribute");
        }
        this.printElt("TopNValue", this.chart.maxDataLen);
        this.printElt("RefreshInterval", this.chart.refreshInterval);
        this.printElt("DisableSchedule", this.chart.disableSchedule);
        if (this.chart.showbackgroundImage) {
            this.openElt("BackgroundImage");
            this.printElt("Url", this.chart.getBackgroundImage().getUrl().toString());
            this.printElt("RelativeUrl", this.chart.getBackgroundImage().getRelativeUrl());
            this.printElt("Option", this.chart.getBackgroundImage().getOption());
            this.closeElt("BackgroundImage");
        }
        if ((pSize = this.chart.lineList.size()) > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{pSize + ""};
            this.openElt("FloatingLineList", attr, vals);
            for (int i3 = 0; i3 < pSize; ++i3) {
                this.printElt("FloatingLine", this.chart.lineList.elementAt(i3));
            }
            this.closeElt("FloatingLineList");
        }
        if ((cSize = this.chart.colData.length) > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{cSize + ""};
            this.openElt("ColDataList", attr, vals);
            for (i = 0; i < cSize; ++i) {
                this.printElt("ColData", this.chart.colData[i], this.chart.colData[i].getSize());
            }
            this.closeElt("ColDataList");
        }
        if (this.chart.secData != null) {
            this.openElt("SecondaryAxisFormat");
            this.printElt("LabelStepInterval", this.chart.secData.sepSize);
            this.printElt("GridStepInterval", this.chart.secData.tickerSepSize);
            this.printElt("MaxNumOfTickerAndLabel", this.chart.secData.maxNumOfTickerAndLabel);
            this.writeDataFormat(this.chart.secData.dataFormat);
            this.closeElt("SecondaryAxisFormat");
        }
        if ((hsize = this.chart.hyperlinkList.size()) > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{hsize + ""};
            this.openElt("HyperLinkList", attr, vals);
            for (int i4 = 0; i4 < hsize; ++i4) {
                this.printElt("HyperLink", this.chart.hyperlinkList.elementAt(i4));
            }
            this.closeElt("HyperLinkList");
        }
        if ((csize = this.chart.getControlRangeList().size()) > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{csize + ""};
            this.openElt("ControlRangeList", attr, vals);
            for (int i5 = 0; i5 < csize; ++i5) {
                this.printElt("ControlRange", this.chart.getControlRangeList().elementAt(i5));
            }
            this.closeElt("ControlRangeList");
        }
        int n = asize = (annoList = this.chart.annotationSet.getAnnotationList()) == null ? 0 : annoList.size();
        if (asize > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{asize + ""};
            this.openElt("AnnotationList", attr, vals);
            for (int i6 = 0; i6 < asize; ++i6) {
                this.printAnnotation((CAnnotation)annoList.elementAt(i6));
            }
            this.closeElt("AnnotationList");
        }
        if ((vsize = this.chart.valueTable.countUniqueKeys()) > 0) {
            attr = new String[]{"qbCount"};
            vals = new String[]{vsize + ""};
            Enumeration<String> key = this.chart.valueTable.getUniqueKeyList();
            Enumeration<String> value = this.chart.valueTable.getUniqueElementList();
            this.openElt("ValueSubstitutionList", attr, vals);
            while (key.hasMoreElements()) {
                this.openElt("ValueSubstitution");
                this.printElt("OriginalValue", key.nextElement());
                this.printElt("SubstitutedValue", value.nextElement());
                this.closeElt("ValueSubstitution");
            }
            this.closeElt("ValueSubstitutionList");
        }
        if (this.chart.getColorSpectrum() != null) {
            this.printElt("ColorSpectrum", this.chart.getColorSpectrum());
        }
        this.printElt("ValueOrder", SORTORDER[this.chart.getSortValue()]);
        this.writeDrillDownNodes(this.chart.currentNode);
    }

    private void saveLabelOffset(String elt, Chart chart) throws IOException {
        int size = chart.countLabelOffset();
        if (size > 0) {
            String[] attr = new String[]{"qbCount"};
            String[] vals = new String[]{size + ""};
            this.openElt(elt, attr, vals);
            for (int i = 0; i < size; ++i) {
                this.printElt("LabelOffset", chart.getLabelOffset(i));
            }
            this.closeElt(elt);
        }
    }

    private void saveLegend(String elt, Legend legend) throws IOException {
        this.openElt(elt);
        this.printElt("Font", legend.getFont());
        this.printElt("Angle", legend.getAngle());
        this.printElt("PointSizeRatio", legend.getPointSizeRatio());
        this.printElt("FontColor", legend.getfontColor());
        this.printElt("Background", legend.getBackground());
        this.printElt("Border", legend.getBorder());
        this.printElt("Appearance", legend.getBackground().appearance);
        this.printElt("Depth", legend.getBackground().depth);
        this.printElt("Vertical", legend.isVertical());
        this.printElt("Layout", legend.getLayout());
        this.printElt("Fixed_Column", legend.getFixedColumnCount());
        this.printElt("Visible", legend.showLegend);
        this.printElt("OneLegend", legend.useOneLegendSet);
        this.printElt("Reverse", legend.reverse);
        this.printElt("DrawSymbol", legend.areSymbolsDrawn());
        this.closeElt(elt);
    }

    private void saveDataAttribute(DataAttribute dataAttr, String elt) throws IOException {
        this.openElt(elt);
        this.openElt("RootDataAttr");
        this.printElt("Color", dataAttr.rootPointColor);
        this.printElt("Shape", null, "state", SHAPE[dataAttr.rootPointShape % 256]);
        this.printElt("LineStyle", dataAttr.rootPointShape / 256);
        this.printElt("Size", dataAttr.rootPointSize);
        this.printElt("LineThickness", dataAttr.rootLineThickness);
        this.closeElt("RootDataAttr");
        int dsize = dataAttr.dataColor.length;
        if (dsize > 0) {
            String[] attr = new String[]{"qbCount"};
            String[] vals = new String[]{dsize + ""};
            this.openElt("DataColumnAttrList", attr, vals);
            for (int i = 0; i < dsize; ++i) {
                this.openElt("DataColumnAttr");
                this.printElt("Color", dataAttr.dataColor[i]);
                int patternID = 0;
                if (dataAttr.dataColor[i] instanceof QbPattern) {
                    patternID = ((QbPattern)dataAttr.dataColor[i]).getPatternTypeID();
                }
                this.printElt("PatternID", patternID);
                this.printElt("Shape", null, "state", SHAPE[dataAttr.dataShape[i] % 256]);
                this.printElt("LineStyle", dataAttr.dataShape[i] / 256);
                this.printElt("Size", dataAttr.dataSize[i]);
                this.printElt("LineThickness", dataAttr.lineThickness[i]);
                this.printElt("Name", dataAttr.name[i]);
                if (dataAttr.slice != null) {
                    this.printElt("SliceExplode", dataAttr.slice[i]);
                }
                this.closeElt("DataColumnAttr");
            }
            this.closeElt("DataColumnAttrList");
        }
        this.closeElt(elt);
    }

    private void writeDataFormat(IFormat dataFormat) throws IOException {
        if (dataFormat instanceof NumericFormat) {
            this.writeNumericFormat((NumericFormat)dataFormat);
        } else if (dataFormat instanceof DateTimeFormat) {
            this.writeDateTimeFormat((DateTimeFormat)dataFormat);
        } else if (dataFormat instanceof LogicalFormat) {
            this.writeLogicalFormat((LogicalFormat)dataFormat);
        } else if (dataFormat instanceof LocaleNumericFormat) {
            this.writeLocaleNumericFormat((LocaleNumericFormat)dataFormat);
        } else if (dataFormat instanceof LocaleDateTimeFormat) {
            this.writeLocaleDateTimeFormat((LocaleDateTimeFormat)dataFormat);
        }
    }

    private void writeNumericFormat(NumericFormat nf) throws IOException {
        this.openElt("NumericFormat");
        this.printElt("CurrencySymbol", nf.currencySymbol);
        this.printElt("OneSymPerPage", nf.oneSymPerPage);
        this.printElt("CurrencyPosition", null, "state", CURRENCYPOS[nf.currencyPos]);
        this.printElt("Decimal", nf.decimal);
        this.printElt("Rounding", nf.rounding);
        this.printElt("NegativePosition", null, "state", NEGATIVEPOS[nf.negative]);
        this.printElt("DecimalSeparator", nf.decimalSep);
        this.printElt("ThousandSeparator", nf.thousandSep);
        this.printElt("LeadingZero", nf.leadingZero);
        this.printElt("SciExp", nf.sciExp);
        this.closeElt("NumericFormat");
    }

    private void writeDateTimeFormat(DateTimeFormat dt) throws IOException {
        this.openElt("DateTimeFormat");
        this.printElt("YearSymbol", null, "state", YEARSYMBOL[dt.yearSymbol]);
        this.printElt("MonthSymbol", null, "state", MONTHSYMBOL[dt.monthSymbol]);
        this.printElt("OrderSymbol", null, "state", ORDERSYMBOL[dt.orderSymbol]);
        this.printElt("DateSeparator1", dt.separator1);
        this.printElt("DateSeparator2", dt.separator2);
        this.printElt("Hour24", dt.hour24);
        this.printElt("ShowMinute", dt.showMinute);
        this.printElt("ShowSecond", dt.showSecond);
        this.printElt("HourMinuteSeparator", dt.hourMinuteSep);
        this.printElt("MinuteSecondSeparator", dt.minuteSecondSep);
        this.printElt("NanoDecimal", dt.nanoDecimal);
        this.printElt("TimeBeforeDate", dt.timeBeforeDate);
        this.printElt("TimeDateSeparator", dt.timeDateSep);
        this.printElt("HideDate", dt.hidedate);
        this.printElt("HideMonth", dt.hidemonth);
        this.printElt("HideYear", dt.hideyear);
        this.printElt("HideTimestampTime", dt.hideTimestampTime);
        this.printElt("FixDigitLength", dt.fixDigitLen);
        this.closeElt("DateTimeFormat");
    }

    private void writeLogicalFormat(LogicalFormat dataFormat) throws IOException {
        this.openElt("LogicalFormat");
        this.printElt("LogicalType", null, "state", LOGICALFORMAT[dataFormat.getformat()]);
        this.closeElt("LogicalFormat");
    }

    private void writeLocaleNumericFormat(LocaleNumericFormat lnf) throws IOException {
        this.openElt("LocaleNumericFormat");
        this.printElt("LocaleNumericType", null, "state", LOCALENUMERICFORMAT[lnf.getInstanceType()]);
        NumberFormat nf = lnf.getNumberFormat();
        this.printElt("MaximumFractionDigits", nf.getMaximumFractionDigits());
        this.printElt("MaximumIntegerDigits", nf.getMaximumIntegerDigits());
        this.printElt("MinimumFractionDigits", nf.getMinimumFractionDigits());
        this.printElt("MinimumIntegerDigits", nf.getMinimumIntegerDigits());
        this.printElt("GroupingUsed", nf.isGroupingUsed());
        this.printElt("ParseIntegerOnly", nf.isParseIntegerOnly());
        this.closeElt("LocaleNumericFormat");
    }

    private void writeLocaleDateTimeFormat(LocaleDateTimeFormat ldtf) throws IOException {
        this.openElt("LocaleDateTimeFormat");
        this.printElt("LocaleDateTimeType", null, "state", LOCALEDATETIMEFORMAT[ldtf.getInstanceType()]);
        this.printElt("DateStyle", ldtf.getDateStyle());
        this.printElt("TimeStyle", ldtf.getTimeStyle());
        this.closeElt("LocaleDateTimeFormat");
    }

    private void writeDataSource() throws IOException {
        int sourceData;
        int n = sourceData = this.chart.getOriginalSourceData() > 0 ? this.chart.getOriginalSourceData() : this.chart.sourceData;
        if (sourceData != 0) {
            this.saveColData("DATABACKUP", this.chart.colData, 10);
        }
        int dbCT = 1;
        if (sourceData == 3) {
            dbCT = this.chart.sourceList.length;
        }
        this.printElt("DATASOURCECOUNT", dbCT);
        if (sourceData == 1) {
            boolean hasQueryFilename;
            this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"database"});
            DBInfoBasic dbInfo = this.chart.dbInfo;
            new DBInfoBasic(dbInfo).writeXML(this.out);
            boolean bl = hasQueryFilename = this.chart.queryFilename != null && !this.chart.queryFilename.equals("");
            if (hasQueryFilename) {
                this.printElt("QUERYFILE", this.chart.queryFilename);
            } else {
                boolean failed = true;
                ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                OutputStreamWriter dout = new OutputStreamWriter((OutputStream)bytestream, ServerMessage.xmlEncoding);
                if (dbInfo instanceof IQueryFileInfo) {
                    try {
                        IQueryInParam[] params = QbUtil.getInParam(dbInfo);
                        if (params != null) {
                            for (IQueryInParam param : params) {
                                QueryInParam currP = null;
                                boolean multiValue = false;
                                if (param instanceof IQueryMultiValueInParam) {
                                    multiValue = true;
                                    currP = new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)param), dbInfo.getQuery());
                                } else {
                                    currP = new QueryInParam(param, dbInfo.getQuery());
                                }
                                if (this.drillDownNode == null) {
                                    currP.setDefaultValue(param.getValue());
                                    if (multiValue) {
                                        ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)((Object)param)).getValues());
                                    } else {
                                        currP.setValue(param.getValue());
                                    }
                                }
                                currP.writeXML(dout);
                            }
                            dout.flush();
                            dout.close();
                            failed = false;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to write query parameters", ex);
                    }
                }
                if (!failed) {
                    this.out.write(bytestream.toString(ServerMessage.xmlEncoding));
                }
            }
            this.closeElt("DATASOURCE");
        } else if (sourceData == 2) {
            this.printElt("DATASOURCE", this.chart.sourceFile, new String[]{"Type"}, new String[]{"file"});
        } else if (sourceData == 4) {
            this.printElt("DATASOURCE", this.chart.sourceFile, new String[]{"Type"}, new String[]{"xml"});
        } else if (sourceData == 6) {
            boolean state = sourceData == 6 && this.chart.dbInfo != null && this.chart.dbInfo instanceof QueryClassFileInfo;
            this.printElt("DATASOURCE", this.chart.sourceFile, new String[]{"Type", "isParameterized"}, new String[]{"class", state + ""});
        } else if (sourceData == 7) {
            XMLFileQueryInfo xmlFileQueryInfo;
            this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"xmlfilequery"});
            XMLFileQueryInfo temp = xmlFileQueryInfo = this.chart.xmlFileQueryInfo;
            if (this.chart.dbInfo instanceof QueryXMLFileInfo) {
                QueryInParam[] params = xmlFileQueryInfo.getInSet().getParameter();
                QueryInParam[] temp_params = new QueryInParam[params.length];
                for (int i = 0; i < params.length; ++i) {
                    QueryInParam currP = null;
                    boolean multiValue = false;
                    if (params[i] instanceof IQueryMultiValueInParam) {
                        multiValue = true;
                        currP = new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)params[i]), xmlFileQueryInfo.getCondition());
                    } else {
                        currP = new QueryInParam(params[i], xmlFileQueryInfo.getCondition());
                    }
                    if (this.drillDownNode == null) {
                        currP.setDefaultValue(params[i].getValue());
                        if (multiValue) {
                            ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)((Object)params[i])).getValues());
                        } else {
                            currP.setValue(params[i].getValue());
                        }
                    }
                    temp_params[i] = currP;
                }
                temp = new XMLFileQueryInfo(xmlFileQueryInfo.getFileName(), xmlFileQueryInfo.getFieldInfo(), xmlFileQueryInfo.getCondition(), xmlFileQueryInfo.getConditionInfo(), xmlFileQueryInfo.getDTDName(), xmlFileQueryInfo.isVerify(), new QueryInParamSet(temp_params));
            }
            temp.writeXML(this.out);
            this.printElt("ISPARAMQUERY", this.chart.dbInfo instanceof QueryXMLFileInfo);
            this.closeElt("DATASOURCE");
        } else if (sourceData == 5) {
            int i;
            Object[] vals = this.chart.selectedMethodParamVal;
            int valSize = vals.length;
            Hashtable<String, String> env = this.chart.environment;
            int envsize = 0;
            if (env != null) {
                envsize = env.size();
            }
            Object[] envKeys = new Object[envsize];
            String[] envValues = new String[envsize];
            if (env != null) {
                Enumeration<String> e = env.keys();
                int index = 0;
                while (e.hasMoreElements()) {
                    envKeys[index] = e.nextElement();
                    ++index;
                }
            }
            for (int i2 = 0; i2 < envsize; ++i2) {
                envValues[i2] = env.get(envKeys[i2]);
            }
            String[] attrs = new String[6 + valSize * 2 + envsize * 2 + 1];
            String[] paramValues = new String[6 + valSize * 2 + envsize * 2 + 1];
            attrs[0] = "Type";
            attrs[1] = "jndiName";
            attrs[2] = "homeName";
            attrs[3] = "remoteName";
            attrs[4] = "selectedMethodName";
            attrs[5] = "paramSize";
            for (i = 6; i < 6 + valSize; ++i) {
                attrs[i] = "paramValType_" + (i - 5);
            }
            for (i = 6 + valSize; i < 6 + valSize * 2; ++i) {
                attrs[i] = "paramValValue_" + (i - 5 - valSize);
            }
            for (i = 6 + valSize * 2; i < 6 + valSize * 2 + envsize; ++i) {
                attrs[i] = "envKey_" + (i - 5 - valSize * 2);
            }
            for (i = 6 + valSize * 2 + envsize; i < 6 + valSize * 2 + envsize * 2; ++i) {
                attrs[i] = "envValue_" + (i - 5 - valSize * 2 - envsize);
            }
            attrs[6 + valSize * 2 + envsize * 2] = "envsize";
            paramValues[0] = "ejb";
            paramValues[1] = this.chart.jndiName;
            paramValues[2] = this.chart.homeName;
            paramValues[3] = this.chart.remoteName;
            paramValues[4] = this.chart.selectedMethodName;
            paramValues[5] = Integer.valueOf(valSize).toString();
            for (i = 6; i < 6 + valSize; ++i) {
                paramValues[i] = vals[i - 6].getClass().getName();
            }
            for (i = 6 + valSize; i < 6 + valSize * 2; ++i) {
                paramValues[i] = vals[i - 6 - valSize].toString();
            }
            for (i = 6 + valSize * 2; i < 6 + valSize * 2 + envsize; ++i) {
                paramValues[i] = (String)envKeys[i - 6 - valSize * 2];
            }
            for (i = 6 + valSize * 2 + envsize; i < 6 + valSize * 2 + envsize * 2; ++i) {
                paramValues[i] = envValues[i - 6 - valSize * 2 - envsize];
            }
            paramValues[6 + valSize * 2 + envsize * 2] = Integer.valueOf(envsize).toString();
            this.openElt("DATASOURCE", attrs, paramValues);
            this.closeElt("DATASOURCE");
        } else if (sourceData == 10) {
            String[] attrs = new String[]{"MondrianConnectionString", "MDXQuery", "XmlaURI", "XmlaDataSource", "XmlaCatalog", "InputMethod"};
            String[] paramValues = new String[]{this.chart.mondrianConnectionString, this.chart.MDXQuery, this.chart.xmlaURI, this.chart.xmlaDataSource, this.chart.xmlaCatalog, this.chart.inputMethod + ""};
            this.openElt("DATASOURCE", attrs, paramValues);
            this.closeElt("DATASOURCE");
        } else if (sourceData == 12) {
            this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"soap"});
            this.chart.soapInfo.writeXML(this.out);
            this.closeElt("DATASOURCE");
        } else if (sourceData == 11) {
            this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"salesforce"});
            this.chart.sfQueryInfo.writeXML(this.out);
            this.closeElt("DATASOURCE");
        } else if (sourceData == 13) {
            this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"excel"});
            this.chart.excelInfo.writeXML(this.out);
            this.closeElt("DATASOURCE");
        } else if (sourceData == 3) {
            for (int i = 0; i < this.chart.sourceList.length; ++i) {
                Object[] vals;
                Object temp = this.chart.sourceList[i];
                if (temp instanceof DBInfoBasic) {
                    this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"database"});
                    ((DBInfoBasic)temp).writeXML(this.out);
                    this.closeElt("DATASOURCE");
                } else if (this.chart.sourceType[i] == 4) {
                    this.printElt("DATASOURCE", (String)temp, new String[]{"Type"}, new String[]{"xml"});
                } else if (this.chart.sourceType[i] == 6) {
                    this.printElt("DATASOURCE", (String)temp, new String[]{"Type"}, new String[]{"class"});
                } else if (this.chart.sourceType[i] == 7) {
                    this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"xmlfilequery"});
                    XMLFileQueryInfo info = (XMLFileQueryInfo)temp;
                    info.writeXML(this.out);
                    this.closeElt("DATASOURCE");
                } else if (this.chart.sourceType[i] == 5) {
                    int k;
                    EJBInfo ejbInfo = (EJBInfo)temp;
                    vals = ejbInfo.getSelectedMethodParamVal();
                    int valSize = vals.length;
                    Hashtable<String, String> env = ejbInfo.getEnvironment();
                    int envsize = 0;
                    if (env != null) {
                        envsize = env.size();
                    }
                    Object[] envKeys = new Object[envsize];
                    String[] envValues = new String[envsize];
                    if (env != null) {
                        Enumeration<String> e = env.keys();
                        int index = 0;
                        while (e.hasMoreElements()) {
                            envKeys[index] = e.nextElement();
                            ++index;
                        }
                    }
                    for (int k2 = 0; k2 < envsize; ++k2) {
                        envValues[k2] = env.get(envKeys[k2]);
                    }
                    String[] attrs = new String[6 + valSize * 2 + envsize * 2 + 1];
                    String[] paramValues = new String[6 + valSize * 2 + envsize * 2 + 1];
                    attrs[0] = "Type";
                    attrs[1] = "jndiName";
                    attrs[2] = "homeName";
                    attrs[3] = "remoteName";
                    attrs[4] = "selectedMethodName";
                    attrs[5] = "paramSize";
                    for (k = 6; k < 6 + valSize; ++k) {
                        attrs[k] = "paramValType_" + (k - 5);
                    }
                    for (k = 6 + valSize; k < 6 + valSize * 2; ++k) {
                        attrs[k] = "paramValValue_" + (k - 5 - valSize);
                    }
                    for (k = 6 + valSize * 2; k < 6 + valSize * 2 + envsize; ++k) {
                        attrs[k] = "envKey_" + (k - 5 - valSize * 2);
                    }
                    for (k = 6 + valSize * 2 + envsize; k < 6 + valSize * 2 + envsize * 2; ++k) {
                        attrs[k] = "envValue_" + (k - 5 - valSize * 2 - envsize);
                    }
                    attrs[6 + valSize * 2 + envsize * 2] = "envsize";
                    paramValues[0] = "ejb";
                    paramValues[1] = ejbInfo.getJNDIName();
                    paramValues[2] = ejbInfo.getHomeName();
                    paramValues[3] = ejbInfo.getRemoteName();
                    paramValues[4] = ejbInfo.getSelectedMethodName();
                    paramValues[5] = Integer.valueOf(valSize).toString();
                    for (k = 6; k < 6 + valSize; ++k) {
                        paramValues[k] = vals[k - 6].getClass().getName();
                    }
                    for (k = 6 + valSize; k < 6 + valSize * 2; ++k) {
                        paramValues[k] = vals[k - 6 - valSize].toString();
                    }
                    for (k = 6 + valSize * 2; k < 6 + valSize * 2 + envsize; ++k) {
                        paramValues[k] = (String)envKeys[k - 6 - valSize * 2];
                    }
                    for (k = 6 + valSize * 2 + envsize; k < 6 + valSize * 2 + envsize * 2; ++k) {
                        paramValues[k] = envValues[k - 6 - valSize * 2 - envsize];
                    }
                    paramValues[6 + valSize * 2 + envsize * 2] = Integer.valueOf(envsize).toString();
                    this.openElt("DATASOURCE", attrs, paramValues);
                    this.closeElt("DATASOURCE");
                } else {
                    this.printElt("DATASOURCE", (String)temp, new String[]{"Type"}, new String[]{"file"});
                }
                String[] attr = new String[]{"transpose", "transposeColumn"};
                vals = new String[]{this.chart.doTranspose[i] + "", this.printArrayIndex((boolean[])this.chart.transposeColList[i])};
                this.openElt("MULTI_TRANSPOSE", attr, (String[])vals);
                this.closeElt("MULTI_TRANSPOSE");
            }
        } else if (sourceData == 0) {
            this.openElt("DATASOURCE", new String[]{"Type"}, new String[]{"none"});
            if (this.chart.originalColDataFromMemSource != null) {
                this.saveColData("COLDATALIST", this.chart.originalColDataFromMemSource);
            }
            this.closeElt("DATASOURCE");
        }
        String[] attr = new String[]{"transpose", "transposeColumn"};
        String[] vals = new String[]{this.chart.isTransposed + "", this.printArrayIndex(this.chart.transposeCol)};
        this.openElt("TRANSPOSE", attr, vals);
        this.closeElt("TRANSPOSE");
    }

    private void saveTree(DrillDownNode node) throws IOException {
        if (node == null) {
            return;
        }
        this.openElt("DRILLDOWNTREE", null, null);
        this.saveTreeNode(node, true);
        this.closeElt("DRILLDOWNTREE");
    }

    private void saveTreeNode(DrillDownNode node, boolean saveChildren) throws IOException {
        int[] mapping;
        this.openElt("DRILLDOWNNODE", new String[]{"Name", "Filename"}, new String[]{node.getName(), node.getFileName()});
        for (int element : mapping = node.getColumnMapping()) {
            this.printElt("MAPPING", element);
        }
        if (saveChildren) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.saveTreeNode(node.getChildAt(i), true);
            }
        }
        this.closeElt("DRILLDOWNNODE");
    }

    private void writeDrillDownNodes(DrillDownNode node) throws IOException {
        if (node != null) {
            this.openElt("CHILD_DRILLDOWNNODES");
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.saveTreeNode(node.getChildAt(i), false);
            }
            this.closeElt("CHILD_DRILLDOWNNODES");
        }
    }
}

