/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import quadbase.chartviewer.OurButton;
import quadbase.chartviewer.OurChoice;
import quadbase.chartviewer.OurMessageDialog;
import quadbase.chartviewer.OurTextField;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.OurPanel;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;

public class EnterInParamPanel
extends OurPanel
implements ActionListener {
    QueryFileInfo fileInfo;
    QueryInParam[] parameter;
    int nParam;
    boolean showOKbutton;
    boolean showCancelButton;
    JButton[] allButton;
    JButton[] noneButton;
    private transient ActionListener listener;
    OurButton resetButton;
    OurButton okButton;
    OurButton cancelButton;
    OurChoice[] choiceArray;
    OurTextField[] textArray;
    List[] listArray;

    public EnterInParamPanel(QueryFileInfo fileInfo, boolean showOKbutton) {
        this(fileInfo, showOKbutton, false);
    }

    public EnterInParamPanel(QueryFileInfo fileInfo, boolean showOKbutton, boolean showCancelButton) {
        this.fileInfo = fileInfo;
        this.parameter = fileInfo.getInSet().getParameter();
        this.nParam = this.parameter.length;
        this.showOKbutton = showOKbutton;
        this.showCancelButton = showCancelButton;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        OurPanel paramPanel = new OurPanel(gbl);
        gbc.anchor = 17;
        this.choiceArray = new OurChoice[this.nParam];
        this.textArray = new OurTextField[this.nParam];
        this.listArray = new List[this.nParam];
        this.allButton = new JButton[this.nParam];
        this.noneButton = new JButton[this.nParam];
        int gridy = 0;
        for (int i = 0; i < this.nParam; ++i) {
            Component comp;
            QueryInParam currParam = this.parameter[i];
            Label labelComp = new Label(currParam.getPromptName());
            if (currParam.getSelectionChoices() != null) {
                boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
                Component[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    gbc.gridx = 2;
                    gbc.gridy = gridy++;
                    gbc.fill = 2;
                    gbc.anchor = 22;
                    gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    gbc.weightx = 0.5;
                    gbc.weighty = 0.0;
                    gbc.gridwidth = 1;
                    gbl.setConstraints(selectionPanel, gbc);
                    paramPanel.add(selectionPanel);
                }
                comp = this.createComponent(isMultiValue, currParam.getSelectionChoices(), array, i);
            } else if (currParam.isMapToColumn()) {
                Vector<Object> distinctValue = new Vector();
                try {
                    distinctValue = QueryParser.getDistinctValues(fileInfo, currParam.getTableName(), currParam.getColumnName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
                Component[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    gbc.gridx = 2;
                    gbc.gridy = gridy++;
                    gbc.fill = 2;
                    gbc.anchor = 22;
                    gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    gbc.weightx = 0.5;
                    gbc.weighty = 0.0;
                    gbc.gridwidth = 1;
                    gbl.setConstraints(selectionPanel, gbc);
                    paramPanel.add(selectionPanel);
                }
                comp = this.createComponent(isMultiValue, distinctValue, array, i);
            } else {
                this.textArray[i] = new OurTextField("To be filled in", 20);
                comp = this.textArray[i];
            }
            gbc.gridy = gridy++;
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbl.setConstraints(labelComp, gbc);
            paramPanel.add(labelComp);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 2;
            gbl.setConstraints(comp, gbc);
            paramPanel.add(comp);
        }
        this.resetPanel();
        this.add("North", paramPanel);
        OurPanel buttonPanel = new OurPanel(new FlowLayout(2));
        this.resetButton = new OurButton("Reset");
        buttonPanel.add(this.resetButton);
        this.resetButton.addActionListener(this);
        if (showOKbutton) {
            this.okButton = new OurButton("OK");
            buttonPanel.add(this.okButton);
            this.okButton.addActionListener(this);
        }
        if (showCancelButton) {
            this.cancelButton = new OurButton("Cancel");
            buttonPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
        }
        this.add("South", buttonPanel);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension superSize = super.getPreferredSize();
        return new Dimension(Math.max(200, superSize.width), Math.max(90, superSize.height + 30));
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    public QueryInParam[] getInParamValue() {
        return this.parameter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.resetButton) {
            this.resetPanel();
        } else if (source == this.okButton) {
            if (this.areAllValid()) {
                this.fireEvent(this, 0, e.getActionCommand());
            } else {
                this.showError();
            }
        } else if (source == this.cancelButton) {
            this.fireEvent(this, 0, e.getActionCommand());
        }
        for (int i = 0; i < this.allButton.length; ++i) {
            int j;
            int cnt;
            if (source == this.allButton[i]) {
                cnt = this.listArray[i].getItemCount();
                for (j = 0; j < cnt; ++j) {
                    this.listArray[i].select(j);
                }
                continue;
            }
            if (source != this.noneButton[i]) continue;
            cnt = this.listArray[i].getItemCount();
            for (j = 0; j < cnt; ++j) {
                this.listArray[i].deselect(j);
            }
        }
    }

    @Override
    public void setEnabled(boolean state) {
        this.resetButton.setEnabled(state);
        if (this.okButton != null) {
            this.okButton.setEnabled(state);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(state);
        }
        if (state) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public QueryInParam[] getQueryInParam() {
        if (this.areAllValid()) {
            return this.parameter;
        }
        this.showError();
        return null;
    }

    private void resetPanel() {
        for (int i = 0; i < this.nParam; ++i) {
            QueryInParam currParam = this.parameter[i];
            if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null) {
                int j;
                String defaultString;
                if (currParam instanceof QueryMultiValueInParam) {
                    defaultString = currParam.getDefaultValue(this.fileInfo).toString();
                    for (j = 0; j < this.listArray[i].getItemCount(); ++j) {
                        if (defaultString.equals(this.listArray[i].getItem(j))) {
                            this.listArray[i].select(j);
                            this.listArray[i].makeVisible(j);
                            continue;
                        }
                        this.listArray[i].deselect(j);
                    }
                } else {
                    defaultString = currParam.getDefaultValue(this.fileInfo).toString();
                    for (j = 0; j < this.choiceArray[i].getItemCount(); ++j) {
                        if (!defaultString.equals(this.choiceArray[i].getItem(j))) continue;
                        this.choiceArray[i].select(j);
                    }
                }
            } else {
                Object defaultValue = currParam.getDefaultValue(this.fileInfo);
                if (defaultValue == null || defaultValue.toString().equals("[null]") || defaultValue.toString().equals("")) {
                    this.textArray[i].setText("To be filled in");
                } else {
                    this.textArray[i].setText(defaultValue.toString());
                }
            }
            currParam.setValue(null);
            if (currParam instanceof QueryMultiValueInParam) {
                ((QueryMultiValueInParam)currParam).setValues(null);
            }
            if (this.textArray[i] != null && this.textArray[i].getText().equals("To be filled in")) {
                this.textArray[i].selectAll();
            }
            if (i != 0) continue;
            if (this.textArray[i] != null) {
                this.textArray[i].requestFocusInWindow();
                continue;
            }
            if (this.choiceArray[i] != null) {
                this.choiceArray[i].requestFocusInWindow();
                continue;
            }
            if (this.listArray[i] == null) continue;
            this.listArray[i].requestFocusInWindow();
        }
    }

    private boolean areAllValid() {
        boolean flag = true;
        for (int i = 0; i < this.nParam; ++i) {
            if (this.makeQueryInParam(i)) continue;
            flag = false;
        }
        return flag;
    }

    private boolean makeQueryInParam(int index) {
        QueryInParam currParam = this.parameter[index];
        String[] valueString = new String[1];
        boolean multiValue = false;
        if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null) {
            if (currParam instanceof QueryMultiValueInParam) {
                multiValue = true;
                valueString = this.listArray[index].getSelectedItems();
            } else {
                valueString[0] = this.choiceArray[index].getSelectedIndex() >= 0 ? this.choiceArray[index].getItem(this.choiceArray[index].getSelectedIndex()) : null;
            }
        } else {
            valueString[0] = this.textArray[index].getText();
            if (currParam instanceof QueryMultiValueInParam) {
                multiValue = true;
                valueString = this.readMultiValues(valueString[0]);
            }
        }
        Vector<Object> valueObject = new Vector<Object>();
        try {
            for (String element : valueString) {
                valueObject.addElement(DataType.createObject(element, DataType.mapType(currParam.getSqlType()), currParam.getDateFormat()));
            }
        }
        catch (Exception ex) {
            if (multiValue) {
                ((QueryMultiValueInParam)currParam).setValues(null);
            } else {
                currParam.setValue(null);
            }
            return false;
        }
        if (multiValue) {
            if (valueObject.size() == 0) {
                valueObject = null;
            }
            ((QueryMultiValueInParam)currParam).setValues(valueObject);
            if (currParam.isMapToColumn()) {
                if (this.listArray[index] != null && this.listArray[index].getItemCount() == valueObject.size()) {
                    ((QueryMultiValueInParam)currParam).setValue("SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                } else {
                    ((QueryMultiValueInParam)currParam).setValue("NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                }
            }
        } else {
            currParam.setValue(valueObject.elementAt(0));
        }
        return true;
    }

    private void showError() {
        String paramString = "";
        for (int i = 0; i < this.nParam; ++i) {
            QueryInParam currParam = this.parameter[i];
            if (currParam.getValue() != null) continue;
            paramString = paramString + "Type of " + currParam.getPromptName() + " should be " + DataType.getTypeName(currParam.getSqlType()) + " \n   ";
        }
        String message = "Parameter value doesn't match its data type: \n \n   " + paramString;
        OurMessageDialog.showError(this, true, message);
    }

    protected final void fireEvent(Component c, int id, String cmd) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(c, id, cmd));
        }
    }

    private String[] readMultiValues(String valueString) {
        if (valueString == null) {
            return null;
        }
        try {
            Vector<String> vect = new Vector<String>();
            StreamTokenizer st = new StreamTokenizer(new StringReader(valueString));
            int ttype = st.nextToken();
            while (ttype != -1) {
                if (ttype == -2) {
                    vect.addElement(st.nval + "");
                } else if (st.sval != null) {
                    vect.addElement(st.sval);
                }
                ttype = st.nextToken();
            }
            if (vect.size() == 0) {
                return null;
            }
            String[] ret = new String[vect.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (String)vect.elementAt(i);
            }
            return ret;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Component createComponent(boolean isMultiValue, Vector values, Object[] array, int index) {
        if (isMultiValue) {
            List list = new List(5, true);
            if (values != null) {
                for (int j = 0; j < values.size(); ++j) {
                    if (values.elementAt(j) == null) continue;
                    list.add(values.elementAt(j).toString());
                }
            }
            array[index] = list;
            return list;
        }
        OurChoice choice = new OurChoice();
        if (values != null) {
            for (int j = 0; j < values.size(); ++j) {
                if (values.elementAt(j) == null) continue;
                choice.add(values.elementAt(j).toString());
            }
        }
        array[index] = choice;
        return choice;
    }

    private OurPanel makeSelectionPanel(int paramIndex) {
        OurPanel selectionPanel = new OurPanel(new FlowLayout(2));
        String allStr = ServerMessage.imagesPath + "selectAll.png";
        String noneStr = ServerMessage.imagesPath + "unselectAll.png";
        this.allButton[paramIndex] = new JButton(IOUtil.getImageIcon(allStr));
        selectionPanel.add(this.allButton[paramIndex]);
        this.noneButton[paramIndex] = new JButton(IOUtil.getImageIcon(noneStr));
        selectionPanel.add(this.noneButton[paramIndex]);
        this.allButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.allButton[paramIndex].setContentAreaFilled(false);
        this.allButton[paramIndex].addActionListener(this);
        this.noneButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.noneButton[paramIndex].setContentAreaFilled(false);
        this.noneButton[paramIndex].addActionListener(this);
        selectionPanel.add(this.allButton[paramIndex]);
        selectionPanel.add(this.noneButton[paramIndex]);
        return selectionPanel;
    }
}

