/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.chartviewer.ViewerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.util.internal.IOUtil;

public class ParamServer {
    public static final int UPDATE_RECORD = 1;
    public static final int INSERT_RECORD = 2;
    public static final int DELETE_RECORD = 3;
    public static final int GET_RECORD = 4;
    public static final int GET_RECORDNO = 5;
    public static final int GET_RECORD_DATATYPE = 6;
    public static final int REPAINT = 0;
    public static final int OK = 0;
    public static final int ERROR = 1;
    DataInputStream in;
    DataOutputStream out;
    int[] dtype;

    public ParamServer(DataInputStream in, DataOutputStream out) throws IOException {
        this.in = in;
        this.out = out;
        this.dtype = this.getDataType();
    }

    public int updateRecord(String[] rec, int recordNo) throws IOException {
        Object[] newrec = this.convertRecord(rec);
        if (newrec == null) {
            return 1;
        }
        this.out.writeInt(1);
        this.out.writeInt(recordNo);
        return this.writerecord(newrec);
    }

    public int updateRecord(Object[] rec, int recordNo) throws IOException {
        if (!this.checkRecord(rec)) {
            return 1;
        }
        this.out.writeInt(1);
        this.out.writeInt(recordNo);
        return this.writerecord(rec);
    }

    public int addRecord(String[] rec) throws IOException {
        Object[] newrec = this.convertRecord(rec);
        if (newrec == null) {
            return 1;
        }
        this.out.writeInt(2);
        return this.writerecord(newrec);
    }

    public int addRecord(Object[] rec) throws IOException {
        if (!this.checkRecord(rec)) {
            return 1;
        }
        this.out.writeInt(2);
        return this.writerecord(rec);
    }

    public int deleteRecord(int recordNo) throws IOException {
        this.out.writeInt(3);
        this.out.writeInt(recordNo);
        return this.in.readInt();
    }

    public void repaint() throws IOException {
        this.out.writeInt(0);
        this.in.readInt();
    }

    public boolean checkRecord(Object[] rec) {
        if (rec == null) {
            return false;
        }
        if (rec.length != this.dtype.length) {
            System.out.println("Record size must equal to " + this.dtype.length);
            return false;
        }
        for (int j = 0; j < rec.length; ++j) {
            if (DataType.match(this.dtype[j], rec[j])) continue;
            System.out.println("Record type of field " + j + " must equal to " + DataType.getTypeName(this.dtype[j]));
            return false;
        }
        return true;
    }

    int writerecord(Object[] rec) throws IOException {
        for (Object element : rec) {
            DataType.write(this.out, element);
        }
        return this.in.readInt();
    }

    public int getRecordNo() throws IOException {
        this.out.writeInt(5);
        return this.in.readInt();
    }

    public int[] getDataType() throws IOException {
        this.out.writeInt(6);
        return IOUtil.readInts(this.in, this.in.readInt());
    }

    public int getRecordSize() {
        return this.dtype.length;
    }

    public Object[] getRecord(int recordNo) throws IOException {
        this.out.writeInt(4);
        this.out.writeInt(recordNo);
        return this.in.readBoolean() ? ViewerMessage.readRecord(this.in, this.dtype) : null;
    }

    public Object[] convertRecord(String[] rec) {
        if (rec == null) {
            return null;
        }
        if (rec.length != this.dtype.length) {
            System.out.println("Record size must equal to " + this.getRecordSize());
            return null;
        }
        Object[] newrecord = new Object[this.dtype.length];
        for (int j = 0; j < rec.length; ++j) {
            try {
                newrecord[j] = DataType.createObject(rec[j], DataType.mapType(this.dtype[j]));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Can't convert " + rec[j] + " to type " + DataType.getTypeName(this.dtype[j]) + " in field " + j);
                return null;
            }
        }
        return newrecord;
    }
}

