/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chartviewer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import quadbase.chart.Chart;
import quadbase.chartviewer.Viewer3DPanel;
import quadbase.chartviewer.ViewerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.util.internal.IOUtil;

public class ParamThread
extends Thread {
    Socket socket;
    Viewer3DPanel viewPanel;
    boolean pleasestop = false;

    public ParamThread(Socket socket, Viewer3DPanel viewPanel) {
        this.socket = socket;
        this.viewPanel = viewPanel;
    }

    public void pleaseStop() {
        this.pleasestop = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DataOutputStream out;
        DataInputStream in;
        Chart chart = this.viewPanel.chart;
        try {
            in = new DataInputStream(this.socket.getInputStream());
            out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException ex) {
            System.out.println("Fail to get input stream : " + ex.toString());
            return;
        }
        ViewerMessage message = new ViewerMessage();
        try {
            block24: while (!this.pleasestop) {
                message.readMessage(in, chart.getRecordDataType());
                switch (message.command) {
                    case 1: {
                        try {
                            chart.setRecord(message.record, message.recordno);
                        }
                        catch (IllegalArgumentException ex) {
                            out.writeInt(1);
                            continue block24;
                        }
                        out.writeInt(0);
                        continue block24;
                    }
                    case 2: {
                        chart.addRecord(message.record);
                        out.writeInt(0);
                        continue block24;
                    }
                    case 3: {
                        if (chart.removeRecord(message.recordno)) {
                            out.writeInt(0);
                            continue block24;
                        }
                        out.writeInt(1);
                        continue block24;
                    }
                    case 0: {
                        this.viewPanel.setrepaint(chart);
                        this.viewPanel.repaint();
                        out.writeInt(0);
                        continue block24;
                    }
                    case 6: {
                        int[] dtype = chart.getRecordDataType();
                        out.writeInt(dtype.length);
                        IOUtil.writeInts(out, dtype, dtype.length);
                        continue block24;
                    }
                    case 5: {
                        out.writeInt(chart.getDataRowSize());
                        continue block24;
                    }
                    case 4: {
                        Object[] rec = chart.getRecord(message.recordno);
                        if (rec != null) {
                            out.writeBoolean(true);
                            Object[] objectArray = rec;
                            int n = objectArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block24;
                                Object element = objectArray[n2];
                                DataType.write(out, element);
                                ++n2;
                            }
                        }
                        out.writeBoolean(false);
                        continue block24;
                    }
                }
            }
            return;
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            return;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

