/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

public class Arc {
    public int x;
    public int y;
    public int w;
    public int h;
    public int startangle;
    public int angle;
    public int arcLen;

    public Arc(int x, int y, int w, int h, int startangle, int angle) {
        this(x, y, w, h, startangle, angle, 100);
    }

    public Arc(int x, int y, int w, int h, int startangle, int angle, int arcLen) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.startangle = startangle;
        this.angle = angle;
        this.arcLen = arcLen;
    }

    public void translate(int xOffset, int yOffset) {
        this.x += xOffset;
        this.y += yOffset;
    }

    public boolean contains(int selx, int sely) {
        if (this.arcLen == 100) {
            return this.fullArcContains(selx, sely);
        }
        if (!this.fullArcContains(selx, sely)) {
            return false;
        }
        Arc innerArc = new Arc(this.x, this.y, this.w * (100 - this.arcLen) / 100, this.h * (100 - this.arcLen) / 100, this.startangle, this.angle);
        return !innerArc.fullArcContains(selx, sely);
    }

    private boolean fullArcContains(int selx, int sely) {
        double d;
        int cx = this.x;
        int cy = this.y;
        int w = this.w;
        int h = this.h;
        int endangle = this.startangle + this.angle;
        if ((double)((cx - selx) * (cx - selx)) / ((double)(w /= 2) * (double)w) + (double)((cy - sely) * (cy - sely)) / ((double)(h /= 2) * (double)h) > 1.0) {
            return false;
        }
        if (endangle - this.startangle >= 360) {
            return true;
        }
        double angle = Math.atan2(cy - sely, selx - cx);
        if (d < 0.0) {
            angle += Math.PI * 2;
        }
        angle *= 57.29577951308232;
        this.startangle %= 360;
        if (this.startangle > (endangle %= 360)) {
            endangle += 360;
        }
        if (angle >= (double)this.startangle && angle <= (double)endangle) {
            return true;
        }
        return (angle += 360.0) >= (double)this.startangle && angle <= (double)endangle;
    }
}

