/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import quadbase.common.awt.QbCalendar;

public class DayChooser
extends Panel
implements ActionListener {
    private Button[] days;
    private Button selectedDay;
    private int day;
    private Color oldDayBackground;
    private String[] dayNames;
    private Calendar calendar;
    private Calendar today;
    private Locale locale;
    private boolean initialized = false;
    private QbCalendar qbCalendar;

    public DayChooser(QbCalendar qbCalendar) {
        this.qbCalendar = qbCalendar;
        this.locale = Locale.getDefault();
        this.days = new Button[49];
        this.selectedDay = null;
        Calendar calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)calendar.clone();
        this.setLayout(new GridLayout(7, 7));
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 7; ++x) {
                int index = x + 7 * y;
                if (y == 0) {
                    this.days[index] = new Button(){

                        @Override
                        public void addMouseListener(MouseListener l) {
                        }
                    };
                    this.days[index].setBackground(new Color(200, 200, 255));
                } else {
                    this.days[index] = new Button("x");
                    this.days[index].addActionListener(this);
                }
                this.add(this.days[index]);
            }
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.initialized = true;
    }

    protected void init() {
        this.calendar = Calendar.getInstance(this.locale);
        int firstDayOfWeek = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int day = firstDayOfWeek;
        for (int i = 0; i < 7; ++i) {
            this.days[i].setLabel(this.dayNames[day]);
            if (day == 1) {
                this.days[i].setForeground(Color.red);
            } else {
                this.days[i].setForeground(Color.blue);
            }
            if (day < 7) {
                ++day;
                continue;
            }
            day -= 6;
        }
        this.oldDayBackground = Color.white;
        this.drawDays();
    }

    protected void drawDays() {
        int i;
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        int firstDayOfWeek = tmpCalendar.getFirstDayOfWeek();
        tmpCalendar.set(5, 1);
        int firstDay = tmpCalendar.get(7) - firstDayOfWeek;
        if (firstDay < 0) {
            firstDay += 7;
        }
        for (i = 0; i < firstDay; ++i) {
            this.days[i + 7].setVisible(false);
            this.days[i + 7].setLabel("");
        }
        tmpCalendar.add(2, 1);
        Date firstDayInNextMonth = tmpCalendar.getTime();
        tmpCalendar.add(2, -1);
        Date day = tmpCalendar.getTime();
        int n = 0;
        Color foreground = this.getForeground();
        while (day.before(firstDayInNextMonth)) {
            this.days[i + n + 7].setLabel(Integer.toString(n + 1));
            this.days[i + n + 7].setVisible(true);
            if (tmpCalendar.get(6) == this.today.get(6) && tmpCalendar.get(1) == this.today.get(1)) {
                this.days[i + n + 7].setForeground(Color.red);
            } else {
                this.days[i + n + 7].setForeground(foreground);
            }
            if (n + 1 == this.day) {
                this.days[i + n + 7].setBackground(Color.gray);
                this.selectedDay = this.days[i + n + 7];
            } else {
                this.days[i + n + 7].setBackground(this.oldDayBackground);
            }
            ++n;
            tmpCalendar.add(5, 1);
            day = tmpCalendar.getTime();
        }
        for (int k = n + i + 7; k < 49; ++k) {
            this.days[k].setVisible(false);
            this.days[k].setLabel("");
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            this.locale = l;
            this.init();
        }
    }

    public void setDay(int d) {
        if (d < 1) {
            d = 1;
        }
        Calendar tmpCalendar = (Calendar)this.calendar.clone();
        tmpCalendar.set(5, 1);
        tmpCalendar.add(2, 1);
        tmpCalendar.add(5, -1);
        int maxDaysInMonth = tmpCalendar.get(5);
        if (d > maxDaysInMonth) {
            d = maxDaysInMonth;
        }
        this.day = d;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackground);
            this.selectedDay.repaint();
        }
        for (int i = 7; i < 49; ++i) {
            if (!this.days[i].getLabel().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[i];
            this.selectedDay.setBackground(Color.gray);
            break;
        }
        this.qbCalendar.setDay(this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int month) {
        this.calendar.set(2, month);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
        this.drawDays();
    }

    public void setCalendar(Calendar c) {
        this.calendar = c;
        this.drawDays();
    }

    @Override
    public void setFont(Font font) {
        if (this.days != null) {
            for (int i = 0; i < 49; ++i) {
                this.days[i].setFont(font);
            }
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.days != null) {
            for (int i = 7; i < 49; ++i) {
                this.days[i].setForeground(fg);
            }
            this.drawDays();
        }
    }

    @Override
    public String getName() {
        return "DayChooser";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Button button = (Button)e.getSource();
        int day = Integer.valueOf(button.getLabel());
        this.setDay(day);
    }
}

