/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import quadbase.common.awt.DayChooser;
import quadbase.common.awt.QbCalendar;

public class MonthChooser
extends Choice
implements ItemListener {
    private Locale locale;
    private int month;
    private DayChooser dayChooser;
    private boolean initialized = false;
    private QbCalendar qbCalendar;

    public MonthChooser(QbCalendar qbCalendar) {
        this.qbCalendar = qbCalendar;
        this.addItemListener(this);
        this.dayChooser = null;
        this.locale = Locale.getDefault();
        this.initNames();
        this.setMonth(Calendar.getInstance().get(2));
        this.initialized = true;
    }

    public void initNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] monthNames = dateFormatSymbols.getMonths();
        if (this.getItemCount() == 12) {
            this.removeAll();
        }
        for (int i = 0; i < 12; ++i) {
            this.addItem(monthNames[i]);
        }
        this.select(this.month);
    }

    @Override
    public void itemStateChanged(ItemEvent iEvt) {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            this.setMonth(index, false);
        }
    }

    private void setMonth(int newMonth, boolean select) {
        this.month = newMonth;
        if (select) {
            this.select(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.qbCalendar.setMonth(this.month);
    }

    public void setMonth(int newMonth) {
        this.setMonth(newMonth, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(DayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            this.locale = l;
            this.initNames();
        }
    }
}

