/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import quadbase.common.awt.DayChooser;
import quadbase.common.awt.MonthChooser;
import quadbase.common.awt.YearChooser;

public class QbCalendar
extends Panel
implements PropertyChangeListener {
    private YearChooser yearChooser = null;
    private MonthChooser monthChooser = null;
    private DayChooser dayChooser = null;
    private Calendar calendar;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public QbCalendar() {
        this.calendar = Calendar.getInstance();
        this.setLayout(new BorderLayout());
        Panel myPanel = new Panel();
        myPanel.setLayout(new GridLayout(1, 2));
        this.monthChooser = new MonthChooser(this);
        myPanel.add(this.monthChooser);
        this.yearChooser = new YearChooser(this);
        myPanel.add(this.yearChooser);
        this.dayChooser = new DayChooser(this);
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener(this);
        this.add((Component)myPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        this.initialized = true;
    }

    private void setCalendar(Calendar c, boolean update) {
        Calendar oldCalendar = this.calendar;
        this.calendar = c;
        if (update) {
            this.dayChooser.setDay(c.get(5));
            this.monthChooser.setMonth(c.get(2));
            this.yearChooser.setYear(c.get(1));
            this.dayChooser.setYear(c.get(1));
        }
        this.firePropertyChange("calendar", oldCalendar, this.calendar);
    }

    public void setCalendar(Calendar c) {
        this.setCalendar(c, true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            Locale oldLocale = this.locale;
            this.locale = l;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.firePropertyChange("locale", oldLocale, this.locale);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(fg);
            this.monthChooser.setForeground(fg);
            this.yearChooser.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(bg);
        }
    }

    void setDay(int newValue) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            c.set(5, newValue);
            this.setCalendar(c, false);
        }
    }

    void setMonth(int newValue) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            c.set(2, newValue);
            this.setCalendar(c, false);
        }
    }

    void setYear(int newValue) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            c.set(1, newValue);
            this.setCalendar(c, false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            if (evt.getPropertyName().equals("day")) {
                c.set(5, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("month")) {
                c.set(2, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("year")) {
                c.set(1, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            }
        }
    }

    @Override
    public String getName() {
        return "QbCalendar";
    }

    public static void main(String[] s) {
        Frame frame = new Frame("Calendar");
        frame.add(new QbCalendar());
        frame.pack();
        frame.setVisible(true);
    }
}

