/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import quadbase.awt.SpinBox;
import quadbase.common.awt.DayChooser;
import quadbase.common.awt.QbCalendar;

public class YearChooser
extends SpinBox
implements ActionListener {
    private DayChooser dayChooser;
    private int year;
    private QbCalendar qbCalendar;
    private boolean inAction = false;

    public YearChooser(QbCalendar qbCalendar) {
        super(Calendar.getInstance().getMinimum(1), Calendar.getInstance().getMaximum(1));
        this.qbCalendar = qbCalendar;
        this.dayChooser = null;
        this.addActionListener(this);
        this.setValue(Calendar.getInstance().get(1));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.inAction) {
            return;
        }
        this.inAction = true;
        super.actionPerformed(e);
        int year = super.getValue();
        if (this.dayChooser != null) {
            this.dayChooser.setYear(year);
        }
        this.qbCalendar.setYear(year);
        this.inAction = false;
    }

    public void setYear(int y) {
        super.setValue(y);
    }

    public int getYear() {
        return this.year;
    }

    public void setDayChooser(DayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }
}

