/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.pak.PakFile;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;

public class FileInfo {
    String absolutePath = null;
    boolean isFileExisted = false;
    boolean isValidFile = true;
    boolean isDirectory = false;
    long lastModifiedTime = 0L;
    String file;
    String[] roots;
    public boolean isPageViewer = false;
    byte[] data = null;

    public FileInfo(String fileName) {
        this.file = fileName;
    }

    public String getPath() {
        return this.file;
    }

    public String getAbsolutePath() throws Exception {
        if (this.absolutePath == null) {
            this.getFromServer();
        }
        return this.absolutePath;
    }

    public long lastModified() throws Exception {
        if (this.absolutePath == null) {
            this.getFromServer();
        }
        return this.lastModifiedTime;
    }

    public boolean isDirectory() throws Exception {
        if (this.file.startsWith("http://") || this.file.startsWith("https://") || this.file.startsWith("file://")) {
            return false;
        }
        if (this.absolutePath == null) {
            this.getFromServer();
        }
        return this.isDirectory;
    }

    public boolean exists() throws Exception {
        if (this.file.startsWith("http://") || this.file.startsWith("https://") || this.file.startsWith("file://")) {
            try {
                new URL(this.file).openConnection().getInputStream();
                return true;
            }
            catch (Exception ex) {
                try {
                    DataInputStream in = new ReadDataFile().getInputStream(this.file);
                    in.close();
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.file.startsWith("zip:")) {
            PakFile pakFile = new PakFile(this.file);
            return pakFile.exists();
        }
        if (this.absolutePath == null) {
            this.getFromServer();
        }
        return this.isFileExisted;
    }

    public boolean isValidFile() throws Exception {
        if (this.absolutePath == null) {
            this.getFromServer();
        }
        return this.isValidFile;
    }

    public String[] listRoots() throws Exception {
        if (this.roots == null) {
            this.getRootsFromServer();
        }
        return this.roots;
    }

    public byte[] getData() throws Exception {
        if (this.data == null) {
            this.getFromServer(true);
        }
        return this.data;
    }

    private void getFromServer() throws Exception {
        this.getFromServer(false);
    }

    private void getFromServer(boolean getData) throws Exception {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            this.file = ServerMessage.getPath(this.file);
            File tmp = new File(this.file);
            this.absolutePath = tmp.getAbsolutePath();
            this.isDirectory = tmp.isDirectory();
            this.isFileExisted = tmp.exists();
            this.lastModifiedTime = tmp.lastModified();
            try {
                tmp.getCanonicalPath();
                this.isValidFile = true;
            }
            catch (IOException ex) {
                this.isValidFile = false;
            }
            if (getData) {
                try {
                    File pic = new File(this.absolutePath);
                    long length = pic.length();
                    this.data = new byte[(int)length];
                    FileInputStream picIn = new FileInputStream(pic);
                    picIn.read(this.data);
                    picIn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        this.file = this.file.replace('\\', '/');
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        int slaveType = 29370;
        if (this.isPageViewer) {
            slaveType = 29371;
        }
        dout.writeShort(slaveType);
        IOUtil.writeString(dout, this.file);
        dout.writeBoolean(getData);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            this.isValidFile = dstream.readBoolean();
            this.absolutePath = IOUtil.readString(dstream, true);
            this.isDirectory = dstream.readBoolean();
            this.isFileExisted = dstream.readBoolean();
            this.lastModifiedTime = dstream.readLong();
            if (getData) {
                this.data = new byte[dstream.readInt()];
                dstream.read(this.data);
            }
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    private void getRootsFromServer() throws Exception {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            File[] tmp = File.listRoots();
            String[] roots = new String[tmp.length];
            for (int i = 0; i < roots.length; ++i) {
                roots[i] = tmp[i].getAbsolutePath();
            }
            return;
        }
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(29399);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int size = dstream.readInt();
            this.roots = new String[size];
            for (int i = 0; i < size; ++i) {
                this.roots[i] = IOUtil.readString(dstream, true);
            }
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }
}

