/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.client.RequestFailedException;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;

public class MessageSender {
    private ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
    private DataOutputStream dout = new DataOutputStream(this.bstream);

    public MessageSender(int messageType) throws IOException {
        this.dout.writeShort(messageType);
    }

    public DataOutputStream getDataOutput() {
        return this.dout;
    }

    public DataInputStream sendAndReceive() throws IOException, RequestFailedException {
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            byte[] array = this.bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            if (socket != null) {
                socket.close();
            }
            throw new IOException("Failed to contact EspressManager at " + ServerMessage.getServerInfo() + " " + ex.getMessage());
        }
        DataInputStream instream = new DataInputStream(socket.getInputStream());
        int code = instream.readInt();
        if (code != 0) {
            String msg = IOUtil.readString(instream);
            instream.close();
            throw new RequestFailedException(msg);
        }
        return instream;
    }
}

