/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;

public class ReadDBFirstValue {
    public static Object getFirstValue(DBInfoBasic dbInfo, String tableName, String columnName) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBFirstValue.sendMessage(socket, dbInfo, tableName, columnName);
        return ReadDBFirstValue.receiveReply(socket);
    }

    private static void sendMessage(IConnection socket, DBInfoBasic dbInfo, String tableName, String columnName) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(15765);
        dbInfo.write(dout);
        IOUtil.writeString(dout, Coder.encode(tableName));
        IOUtil.writeString(dout, Coder.encode(columnName));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static Object receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int sqlType = dstream.readInt();
            Object value = DataType.read(dstream, sqlType, ServerMessage.getVersion(), true);
            dstream.close();
            socket.close();
            return value;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }
}

