/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.AvailColumn;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;

public class ReadDBparamMeta {
    public static Vector getMeta(IDatabaseInfo dbInfo, String paramName) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBparamMeta.sendMessage(socket, dbInfo, paramName);
        return ReadDBparamMeta.receiveReply(socket);
    }

    public static Vector getMeta(IJNDIDatabaseInfo dbInfo, String paramName) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBparamMeta.sendMessage(socket, dbInfo, paramName);
        return ReadDBparamMeta.receiveReply(socket);
    }

    private static void sendMessage(IConnection socket, IDatabaseInfo dbInfo, String paramName) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(18657);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeString(dout, Coder.encode(paramName));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static void sendMessage(IConnection socket, IJNDIDatabaseInfo dbInfo, String paramName) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(18657);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeString(dout, Coder.encode(paramName));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static Vector receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int nAvailColumn = dstream.readInt();
            Vector<AvailColumn> output = new Vector<AvailColumn>();
            for (int i = 0; i < nAvailColumn; ++i) {
                AvailColumn value = AvailColumn.read(dstream);
                output.addElement(value);
            }
            dstream.close();
            socket.close();
            return output;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }
}

