/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.sf.jsqlparser.JSQLParserException;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.allparser.DisableParamExpressionsParser;
import quadbase.common.paramquery.allparser.ReplaceBetweenParser;
import quadbase.common.util.IDBConnection;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbConnection;
import quadbase.common.util.internal.QbJNDIConnection;
import quadbase.querybuilder.query.QueryBuilder;
import quadbase.util.internal.SortObject;
import quadbase.util.internal.StringCompare;

public class ReadDatabase {
    private static final Logger LOGGER = Logger.getLogger(ReadDatabase.class.getName());
    private String driver;
    private String url;
    private String userName;
    private String password;
    private boolean useJNDIDataSource = false;
    private String JNDIName;
    private Hashtable<String, String> env;
    private Connection connection;
    private DatabaseMetaData metaData;
    private String productName;
    private String query = "";
    private ResultSet rs;
    private int curRow = 0;
    private int totalRows = -1;
    private int totalCols = -1;
    private Vector data;
    private IDBConnection iconn;
    private QueryInParamSet inParamSet = null;
    private boolean usingPrivateConnection = false;
    private String version;
    private boolean cancelRunningQuery;

    public ReadDatabase(String url, String driver, String userName, String password) throws Exception {
        this.driver = driver;
        this.url = url;
        this.userName = userName;
        this.password = password;
        if (!ServerMessage.useServer) {
            this.connect();
        }
    }

    public ReadDatabase(String JNDIName, Hashtable<String, String> env) throws Exception {
        this.useJNDIDataSource = true;
        this.JNDIName = JNDIName;
        this.env = env;
        if (!ServerMessage.useServer) {
            this.connect(false);
        }
    }

    public ReadDatabase(IDBConnection iconn) {
        this.iconn = iconn;
    }

    public ReadDatabase(Connection conn) throws SQLException {
        this.connection = conn;
        this.metaData = this.connection.getMetaData();
    }

    public void finalize() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.connection != null && this.usingPrivateConnection) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void connect() throws ClassNotFoundException, SQLException, NamingException {
        this.connect(this.url.toUpperCase().indexOf("ORACLE") != -1);
    }

    private synchronized void connect(boolean isOracle) throws ClassNotFoundException, SQLException, NamingException {
        if (this.useJNDIDataSource) {
            try {
                InitialContext ctx = this.env == null || this.env.size() == 0 ? new InitialContext() : new InitialContext(this.env);
                DataSource ds = (DataSource)ctx.lookup(this.JNDIName);
                this.connection = new QbJNDIConnection(ds.getConnection());
            }
            catch (NamingException ex) {
                ex.printStackTrace();
                throw ex;
            }
        } else if (isOracle) {
            Properties info = new Properties();
            info.put("user", this.userName);
            info.put("password", this.password);
            info.put("restrictGetTables", "true");
            this.connection = new QbConnection(this.driver, this.url, info);
        } else {
            this.connection = new QbConnection(this.driver, this.url, this.userName, this.password);
        }
        this.metaData = this.connection.getMetaData();
        this.usingPrivateConnection = true;
    }

    private void write(DataOutput dout) throws IOException {
        dout.writeBoolean(this.useJNDIDataSource);
        if (this.useJNDIDataSource) {
            IOUtil.writeString(dout, Coder.encode(this.JNDIName));
            dout.writeInt(this.env.size());
            Enumeration<String> name = this.env.keys();
            while (name.hasMoreElements()) {
                String key = name.nextElement();
                IOUtil.writeString(dout, Coder.encode(key));
                IOUtil.writeString(dout, Coder.encode(this.env.get(key)));
            }
        } else {
            IOUtil.writeString(dout, Coder.encode(this.url));
            IOUtil.writeString(dout, Coder.encode(this.driver));
            IOUtil.writeString(dout, Coder.encode(this.userName));
            IOUtil.writeString(dout, Coder.encode(this.password));
        }
    }

    public synchronized String getProductName() throws Exception {
        if (this.productName != null) {
            return this.productName;
        }
        if (this.iconn != null) {
            this.productName = this.iconn.getDatabaseProductName();
            return this.productName;
        }
        if (!ServerMessage.useServer) {
            this.productName = this.metaData.getDatabaseProductName();
            return this.productName;
        }
        this.productName = this.getString(28321);
        return this.productName;
    }

    private synchronized String getString(int slaveID) throws Exception {
        String tmp = null;
        IConnection socket = null;
        DataInputStream din = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(slaveID);
            this.write(out);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(din, true));
            }
            tmp = IOUtil.readString(din, true);
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                CloseUtils.close(din);
                CloseUtils.close(socket);
                throw throwable;
            }
        }
        CloseUtils.close(din);
        CloseUtils.close(socket);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector getTableList(String[] type, int nameFormat) throws Exception {
        Vector<String> table = new Vector<String>();
        if (!ServerMessage.useServer || this.iconn != null) {
            Vector<String> dbType3;
            this.getProductName();
            if (this.productName.equalsIgnoreCase("MYSQL") && nameFormat == 1 && this.metaData != null) {
                if (this.metaData.getConnection().getCatalog() != "") {
                    ResultSet cateRS = this.metaData.getTables(this.metaData.getConnection().getCatalog(), null, null, type);
                    while (cateRS.next()) {
                        table.add("`" + this.metaData.getConnection().getCatalog() + "`.`" + cateRS.getString(3) + "`");
                    }
                } else {
                    Vector<String> catelogList = new Vector<String>();
                    ResultSet metaRS = this.metaData.getCatalogs();
                    while (metaRS.next()) {
                        catelogList.add(metaRS.getString(1));
                    }
                    for (int i = 0; i < catelogList.size(); ++i) {
                        String catelogName = (String)catelogList.elementAt(i);
                        ResultSet cateRS = this.metaData.getTables(catelogName, null, null, type);
                        while (cateRS.next()) {
                            table.add("`" + catelogName + "`.`" + cateRS.getString(3) + "`");
                        }
                    }
                }
                return ReadDatabase.sortStr(table);
            }
            if (this.productName.equalsIgnoreCase("ORACLE") && this.connection != null) {
                Vector p22;
                String owner = "OWNER";
                String listTable = "ALL_OBJECTS";
                if (nameFormat == 0) {
                    owner = "''";
                    listTable = "USER_OBJECTS";
                }
                String query = "SELECT '', " + owner + ", OBJECT_NAME FROM " + listTable + " WHERE (";
                for (String element : type) {
                    query = query + "OBJECT_TYPE = '" + element + "'";
                    query = query + " OR ";
                }
                query = query.substring(0, query.length() - 4) + ")";
                Statement stat = null;
                ResultSet rs = null;
                try {
                    stat = this.connection.createStatement();
                    rs = stat.executeQuery(query);
                    while (rs.next()) {
                        String p22 = rs.getString(2);
                        String p3 = rs.getString(3);
                        if (nameFormat > 0 && p22 != null) {
                            p3 = p22 + "." + p3;
                        }
                        table.addElement(p3);
                    }
                    p22 = ReadDatabase.sortStr(table);
                }
                catch (Throwable throwable) {
                    CloseUtils.close(rs);
                    CloseUtils.close(stat);
                    throw throwable;
                }
                CloseUtils.close(rs);
                CloseUtils.close(stat);
                return p22;
            }
            if (this.productName.toUpperCase().equals("MICROSOFT SQL SERVER") && this.connection != null) {
                if (this.version == null || this.version.equals("")) {
                    String strToGetVersion = "SELECT @@VERSION";
                    Statement stat = this.connection.createStatement();
                    this.rs = stat.executeQuery(strToGetVersion);
                    String rs_str = "";
                    while (this.rs.next()) {
                        rs_str = this.rs.getString(1);
                    }
                    this.version = rs_str.substring(20).trim().substring(0, 4);
                }
                String owner = "SCHEMA_NAME(schema_id)";
                if (nameFormat == 0) {
                    owner = "''";
                }
                String listTable = "SYS.ALL_OBJECTS";
                String name = "Name";
                if (this.version.equals("2000")) {
                    owner = "sysusers.name";
                    if (nameFormat == 0) {
                        owner = "''";
                    }
                    listTable = "SYSOBJECTS INNER JOIN sysusers ON sysobjects.uid = sysusers.uid";
                    name = "SYSOBJECTS.Name";
                }
                ArrayList<String> types = new ArrayList<String>();
                if (Arrays.asList(type).contains("SYNONYM")) {
                    types.add("SN");
                }
                types.add("U");
                types.add("V");
                String query = "SELECT '', " + owner + ", " + name + " FROM " + listTable + " WHERE (";
                for (String element : types) {
                    query = query + "TYPE = '" + element + "'";
                    query = query + " OR ";
                }
                query = query.substring(0, query.length() - 4) + ")";
                Statement stat = this.connection.createStatement();
                this.rs = stat.executeQuery(query);
                int dbType2 = QueryBuilder.mapDatabaseType((String)this.productName);
                while (this.rs.next()) {
                    String p2 = QueryBuilder.formatField((int)dbType2, (String)this.rs.getString(2));
                    String p3 = QueryBuilder.formatField((int)dbType2, (String)this.rs.getString(3));
                    if (nameFormat > 0 && p2 != null) {
                        p3 = p2 + "." + p3;
                    }
                    table.addElement(p3);
                }
                return ReadDatabase.sortStr(table);
            }
            ResultSet rs = null;
            try {
                block42: {
                    if (this.iconn != null) {
                        rs = this.iconn.getTables(null, null, null, type);
                    } else {
                        try {
                            rs = this.metaData.getTables(null, null, null, type);
                        }
                        catch (Exception e) {
                            if (!e.getClass().getName().equals("com.mysql.jdbc.CommunicationsException")) {
                                throw e;
                            }
                            if (!(this.connection instanceof QbConnection)) break block42;
                            QbConnection qbc = (QbConnection)this.connection;
                            qbc.setBadConnection();
                            qbc.init();
                            this.metaData = qbc.getMetaData();
                            rs = this.metaData.getTables(null, null, null, type);
                        }
                    }
                }
                if (rs != null) {
                    while (rs.next()) {
                        int dbType3 = QueryBuilder.mapDatabaseType((String)this.productName);
                        String p1 = QueryBuilder.formatField((int)dbType3, (String)rs.getString(1));
                        String p2 = QueryBuilder.formatField((int)dbType3, (String)rs.getString(2));
                        String p3 = QueryBuilder.formatField((int)dbType3, (String)rs.getString(3));
                        if (this.productName.equalsIgnoreCase("Advantage Database Server") && (p3.toLowerCase().endsWith(".adt") || p3.toLowerCase().endsWith(".dbf"))) {
                            p3 = p3.substring(0, p3.length() - 4);
                        }
                        if (nameFormat > 0 && p2 != null) {
                            p3 = p2 + "." + p3;
                            if (nameFormat > 1 && p1 != null) {
                                p3 = p1 + "." + p3;
                            }
                        }
                        table.addElement(p3);
                    }
                }
                dbType3 = table;
            }
            catch (Throwable throwable) {
                CloseUtils.close(rs);
                throw throwable;
            }
            CloseUtils.close(rs);
            return dbType3;
        }
        IConnection socket = null;
        DataInputStream din = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(28771);
            this.write(out);
            out.writeInt(type.length);
            for (String element : type) {
                IOUtil.writeString(out, element);
            }
            out.writeBoolean(false);
            out.writeInt(nameFormat);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(din, true));
            }
            int len = din.readInt();
            for (int i = 0; i < len; ++i) {
                table.addElement(IOUtil.readString(din, true));
            }
        }
        catch (Throwable throwable) {
            CloseUtils.close(din);
            CloseUtils.close(socket);
            throw throwable;
        }
        CloseUtils.close(din);
        CloseUtils.close(socket);
        return table;
    }

    public static Vector sortStr(Vector list) {
        Object[] sorted = SortObject.sort(ReadDatabase.convertToString(list), true);
        Vector<Object> result = new Vector<Object>();
        for (Object element : sorted) {
            result.add(element);
        }
        return result;
    }

    private static StringCompare[] convertToString(Vector list) {
        StringCompare[] sc = new StringCompare[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            sc[i] = new StringCompare((String)list.get(i));
        }
        return sc;
    }

    public synchronized Object[][] getTableInfo(String tableName) throws Exception {
        return this.getTableInfo(tableName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[][] getTableInfo(String tableName, boolean isQuery) throws Exception {
        Object[][] objectArray;
        ResultSet rs;
        Statement stmt;
        CallableStatement callstmt;
        PreparedStatement ps;
        DataInputStream din;
        IConnection socket;
        block35: {
            String query;
            socket = null;
            din = null;
            ps = null;
            callstmt = null;
            stmt = null;
            rs = null;
            if (ServerMessage.useServer && this.iconn == null) break block35;
            this.getProductName();
            ResultSetMetaData rsMetaData = null;
            if (this.iconn == null) {
                try {
                    stmt = this.connection.createStatement(1003, 1007);
                    stmt.setFetchSize(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (stmt == null) {
                    stmt = this.connection.createStatement();
                }
            }
            if (isQuery) {
                query = tableName;
                query = QueryParser.removeComments(query);
                query = query.replaceAll("\\r\\n|\\r|\\n", " ");
                String newquery = this.addWhereClause(query);
                try {
                    if (this.productName.toLowerCase().indexOf("mysql") >= 0 && query.toLowerCase().indexOf(" limit ") < 0) {
                        newquery = newquery + " LIMIT 0, 1";
                        query = query + " LIMIT 0, 1";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (QueryParser.isOracleStoredProcedure(this.productName, query) && !QueryParser.hasParameters(query)) {
                    callstmt = this.connection.prepareCall(query);
                    callstmt.execute();
                    rs = callstmt.getResultSet();
                } else {
                    try {
                        rs = this.iconn != null ? this.iconn.executeQuery(newquery) : this.getFirstResultSet(stmt, newquery);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (rs == null) {
                        query = QueryParser.removeComments(query);
                        String queryWithoutParams = query.replaceAll(":\\p{Alpha}(\\w)*\\b", "''");
                        if (this.productName.toLowerCase().contains("mongodb")) {
                            queryWithoutParams = queryWithoutParams.replaceAll("(?i)cast\\([^\\)]*\\)", "null");
                        }
                        rs = this.iconn != null ? this.iconn.executeQuery(queryWithoutParams) : this.getFirstResultSet(stmt, queryWithoutParams);
                    }
                }
            } else {
                if (tableName.toUpperCase().startsWith("(SELECT")) {
                    tableName = tableName + " TMP_TBL";
                }
                query = "SELECT * FROM " + tableName + " WHERE 1=2";
                if (this.productName.toLowerCase().contains("mongodb") || this.productName.toLowerCase().contains("sqlite") || this.productName.toLowerCase().contains("cassandra")) {
                    query = "SELECT * FROM " + tableName;
                }
                try {
                    query = QueryParser.removeComments(query);
                    query = query.replaceAll("\\r\\n|\\r|\\n", " ");
                    if (this.productName.toLowerCase().indexOf("mysql") >= 0 && query.toLowerCase().indexOf(" limit ") < 0) {
                        query = query + " LIMIT 0, 1";
                    }
                }
                catch (Exception newquery) {
                    // empty catch block
                }
                if (this.iconn != null) {
                    rs = this.iconn.executeQuery(query);
                } else {
                    try {
                        ps = this.connection.prepareStatement(query);
                        rsMetaData = ps.getMetaData();
                    }
                    catch (SQLException newquery) {
                        // empty catch block
                    }
                    if (stmt != null && (rsMetaData == null || rsMetaData.getColumnType(1) == 0)) {
                        rs = stmt.executeQuery(query);
                    }
                }
            }
            if (rs != null) {
                rsMetaData = rs.getMetaData();
            }
            Object[][] column = new Object[rsMetaData.getColumnCount()][3];
            boolean isHSQL = this.productName.toUpperCase().contains("HSQL");
            boolean isJTDS = this.metaData != null && this.metaData.getDriverName().toUpperCase().contains("JTDS");
            boolean isHive = this.productName.toUpperCase().contains("HIVE");
            int expCounter = 0;
            for (int i = 1; i <= column.length; ++i) {
                String columnName = rsMetaData.getColumnLabel(i);
                if (isHive && columnName != null) {
                    columnName = columnName.replaceAll(".*\\.", "");
                }
                column[i - 1][0] = columnName;
                if (isHSQL && column[i - 1][0].equals("")) {
                    column[i - 1][0] = "Expression_" + expCounter;
                    ++expCounter;
                }
                if (isJTDS && rsMetaData.getColumnType(i) == 12 && rsMetaData.getColumnDisplaySize(i) == 10) {
                    column[i - 1][1] = 91;
                    column[i - 1][2] = "date";
                    continue;
                }
                column[i - 1][1] = rsMetaData.getColumnType(i);
                column[i - 1][2] = rsMetaData.getColumnTypeName(i);
            }
            Object[][] objectArray2 = column;
            CloseUtils.close(ps);
            CloseUtils.close(rs);
            CloseUtils.close(callstmt);
            CloseUtils.close(stmt);
            CloseUtils.close(din);
            CloseUtils.close(socket);
            return objectArray2;
        }
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(28232);
            this.write(out);
            IOUtil.writeString(out, tableName);
            out.writeBoolean(isQuery);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(din, true));
            }
            Object[][] column = new Object[din.readInt()][3];
            for (int i = 0; i < column.length; ++i) {
                column[i][0] = IOUtil.readString(din, true);
                column[i][1] = din.readInt();
                column[i][2] = IOUtil.readString(din, true);
            }
            objectArray = column;
        }
        catch (Throwable throwable) {
            CloseUtils.close(ps);
            CloseUtils.close(rs);
            CloseUtils.close(callstmt);
            CloseUtils.close(stmt);
            CloseUtils.close(din);
            CloseUtils.close(socket);
            throw throwable;
        }
        CloseUtils.close(ps);
        CloseUtils.close(rs);
        CloseUtils.close(callstmt);
        CloseUtils.close(stmt);
        CloseUtils.close(din);
        CloseUtils.close(socket);
        return objectArray;
    }

    private ResultSet getFirstResultSet(Statement stmt, String query) throws SQLException {
        boolean isResult = stmt.execute(query);
        while (!isResult) {
            if (stmt.getUpdateCount() == -1) {
                stmt.close();
                throw new SQLException("No result set returned !");
            }
            isResult = stmt.getMoreResults();
        }
        return stmt.getResultSet();
    }

    public String addQuotes(String tableOrColumnName) throws Exception {
        String product = this.getProductName().toUpperCase();
        if (product.equals("ORACLE") || product.equals("MICROSOFT SQL SERVER") || product.equals("DB2") || product.equals("POSTGRESQL")) {
            return '\"' + tableOrColumnName + '\"';
        }
        if (product.equals("MYSQL")) {
            return '`' + tableOrColumnName + '`';
        }
        if (product.equals("ACCESS")) {
            return '[' + tableOrColumnName + ']';
        }
        if (tableOrColumnName.contains(" ")) {
            return '\"' + tableOrColumnName + '\"';
        }
        return tableOrColumnName;
    }

    private Vector getValues(int startIndex, int displayRow) throws SQLException {
        this.retrieveData(startIndex, displayRow);
        if (displayRow < 0) {
            displayRow = this.data.size() - (startIndex >= 0 ? startIndex : 0);
        }
        if (startIndex >= 0) {
            if (displayRow < 0) {
                displayRow = this.data.size() - startIndex;
            } else {
                int endIndex = startIndex + displayRow;
                displayRow = this.data.size() < endIndex ? this.data.size() - startIndex : displayRow;
            }
        } else if (displayRow < 0) {
            displayRow = this.data.size();
            startIndex = 0;
        } else {
            int tmp = this.data.size() % displayRow;
            if (tmp != 0) {
                displayRow = tmp;
            }
            startIndex = this.data.size() - displayRow;
        }
        Vector modelData = new Vector(displayRow);
        int endIndex = startIndex + displayRow;
        for (int i = startIndex; i < this.data.size() && i < endIndex; ++i) {
            modelData.addElement(this.data.elementAt(i));
        }
        return modelData;
    }

    private synchronized void retrieveData(int startIndex, int displayRow) throws SQLException {
        boolean getAllData;
        int endIndex = startIndex + displayRow;
        boolean bl = getAllData = (startIndex < 0 || displayRow < 0) && this.totalRows == -1;
        while ((this.curRow < endIndex || getAllData) && !this.isLastPage(startIndex, displayRow)) {
            if (!this.rs.next()) {
                this.totalRows = this.curRow;
                return;
            }
            Vector<Object> rowVec = new Vector<Object>();
            for (int i = 1; i <= this.totalCols; ++i) {
                rowVec.addElement(this.rs.getObject(i));
            }
            this.data.addElement(rowVec);
            ++this.curRow;
        }
    }

    public int getRowCount() {
        return this.totalRows;
    }

    public boolean isLastPage(int startIndex, int displayRow) {
        if (this.totalRows == -1) {
            return false;
        }
        return this.totalRows - startIndex <= displayRow;
    }

    public synchronized Vector excuteQuery(String query, int startIndex, int displayRow) throws Exception {
        return this.executeQuery(query, null, startIndex, displayRow, -1);
    }

    public synchronized Vector executeQuery(String query, int startIndex, int displayRow, int timeout) throws Exception {
        return this.executeQuery(query, null, startIndex, displayRow, timeout);
    }

    public synchronized Future<Vector> executeQueryAsync(final String query, final QueryInParamSet inSet, final int startIndex, final int displayRow, final int timeout) {
        return Executors.newSingleThreadExecutor().submit(new Callable<Vector>(){

            @Override
            public Vector call() throws Exception {
                return ReadDatabase.this.executeQuery(query, inSet, startIndex, displayRow, timeout);
            }
        });
    }

    public synchronized Vector executeQuery(String query, QueryInParamSet inSet, int startIndex, int displayRow, int timeout) throws Exception {
        LOGGER.finest(Thread.currentThread().getName() + " executeQuery");
        this.cancelRunningQuery = false;
        Vector vec = new Vector();
        if (inSet != null) {
            QueryInParam[] inParam;
            for (QueryInParam element : inParam = inSet.getParameter()) {
                if (!(element instanceof QueryMultiValueInParam ? ((QueryMultiValueInParam)element).getValues() == null : element.getValue() == null)) continue;
                throw new Exception("Invalid parameter values for parameter \"" + element.getParamName() + "\"");
            }
        }
        if (!ServerMessage.useServer || this.iconn != null) {
            Statement stmt = null;
            if (!this.query.equals(query) || this.inParamSet == null && inSet != null || this.inParamSet != null && inSet == null || this.inParamSet != null && inSet != null && !this.inParamSet.equals(inSet)) {
                try {
                    this.query = query;
                    this.inParamSet = inSet != null ? (QueryInParamSet)inSet.clone() : null;
                    if (this.iconn != null) {
                        this.rs = this.iconn.executeQuery(query);
                    } else if (QueryParser.isOracleStoredProcedure(this.connection.getMetaData().getDatabaseProductName(), query)) {
                        if (this.inParamSet != null) {
                            query = this.inParamSet.convertToJDBCquery(query);
                        }
                        CallableStatement callstmt = this.connection.prepareCall(query);
                        if (this.inParamSet != null) {
                            this.inParamSet.setStmtValue(callstmt);
                        }
                        try {
                            if (timeout > 0) {
                                callstmt.setQueryTimeout(timeout);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        callstmt.execute();
                        this.rs = callstmt.getResultSet();
                    } else if (this.inParamSet == null) {
                        stmt = this.connection.createStatement();
                        try {
                            if (timeout > 0) {
                                stmt.setQueryTimeout(timeout);
                            }
                        }
                        catch (SQLException callstmt) {
                            // empty catch block
                        }
                        this.rs = stmt.executeQuery(query);
                    } else {
                        query = this.inParamSet.convertToJDBCquery(query);
                        PreparedStatement pStmt = this.connection.prepareStatement(query);
                        stmt = pStmt;
                        this.inParamSet.setStmtValue(pStmt);
                        try {
                            if (timeout > 0) {
                                stmt.setQueryTimeout(timeout);
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.rs = pStmt.executeQuery();
                    }
                    this.totalCols = this.rs.getMetaData().getColumnCount();
                    this.data = new Vector();
                    this.curRow = 0;
                    this.totalRows = -1;
                }
                catch (SQLException ex) {
                    this.query = "";
                    this.inParamSet = null;
                    throw ex;
                }
            }
            Vector ret = this.getValues(startIndex, displayRow);
            return ret;
        }
        IConnection socket = null;
        try {
            Object obj;
            int j;
            Vector<Object> colV;
            int i;
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(28928);
            this.write(out);
            IOUtil.writeLongString(out, query);
            out.writeInt(startIndex);
            out.writeInt(displayRow);
            out.writeInt(timeout);
            if (inSet == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                inSet.write(out);
            }
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            while (code == 8) {
                code = din.readInt();
                if (!this.cancelRunningQuery) continue;
                LOGGER.finest(Thread.currentThread().getName() + " cancelQuery");
                Vector vector = vec;
                return vector;
            }
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + "\n" + IOUtil.readString(din, true));
            }
            int nRow = din.readInt();
            int nCol = din.readInt();
            for (i = 0; i < nRow - 3; ++i) {
                colV = new Vector<Object>(nCol);
                for (j = 0; j < nCol; ++j) {
                    obj = DataType.read(IOUtil.readLongString(din));
                    if (obj == null) {
                        obj = "";
                    }
                    colV.addElement(obj);
                }
                vec.addElement(colV);
            }
            this.totalRows = din.readInt();
            for (i = 0; i < 3; ++i) {
                colV = new Vector(nCol);
                for (j = 0; j < nCol; ++j) {
                    if (i == 1) {
                        obj = din.readInt();
                        if (obj == null) {
                            obj = -1;
                        }
                    } else {
                        obj = IOUtil.readString(din, true);
                        if (obj == null) {
                            obj = "";
                        }
                    }
                    colV.addElement(obj);
                }
                vec.addElement(colV);
            }
            din.close();
        }
        catch (Error err) {
            throw new Exception(err);
        }
        finally {
            CloseUtils.close(socket);
        }
        return vec;
    }

    public Vector getDefaultFunctions() throws Exception {
        Vector defaultFunctions = new Vector();
        StringTokenizer tokenizer = new StringTokenizer(this.getNumericFunctions(), ",");
        Vector<String> num = new Vector<String>();
        num.addElement("Numerics Functions");
        while (tokenizer.hasMoreTokens()) {
            num.addElement(tokenizer.nextToken() + "( )");
        }
        defaultFunctions.addElement(num);
        tokenizer = new StringTokenizer(this.getStringFunctions(), ",");
        Vector<String> str = new Vector<String>();
        str.addElement("String Functions");
        while (tokenizer.hasMoreTokens()) {
            str.addElement(tokenizer.nextToken() + "( )");
        }
        defaultFunctions.addElement(str);
        tokenizer = new StringTokenizer(this.getTimeDateFunctions(), ",");
        Vector<String> timeDate = new Vector<String>();
        timeDate.addElement("TimeDate Functions");
        while (tokenizer.hasMoreTokens()) {
            timeDate.addElement(tokenizer.nextToken() + "( )");
        }
        defaultFunctions.addElement(timeDate);
        tokenizer = new StringTokenizer(this.getSystemFunctions(), ",");
        Vector<String> sys = new Vector<String>();
        sys.addElement("System Functions");
        while (tokenizer.hasMoreTokens()) {
            sys.addElement(tokenizer.nextToken() + "( )");
        }
        defaultFunctions.addElement(sys);
        return defaultFunctions;
    }

    public String getNumericFunctions() throws Exception {
        if (this.iconn != null) {
            return this.iconn.getNumericFunctions();
        }
        if (!ServerMessage.useServer) {
            return this.metaData.getNumericFunctions();
        }
        return this.getString(28762);
    }

    public String getStringFunctions() throws Exception {
        if (this.iconn != null) {
            return this.iconn.getStringFunctions();
        }
        if (!ServerMessage.useServer) {
            return this.metaData.getStringFunctions();
        }
        return this.getString(28356);
    }

    public String getTimeDateFunctions() throws Exception {
        if (this.iconn != null) {
            return this.iconn.getTimeDateFunctions();
        }
        if (!ServerMessage.useServer) {
            return this.metaData.getTimeDateFunctions();
        }
        return this.getString(28963);
    }

    public String getSystemFunctions() throws Exception {
        if (this.iconn != null) {
            return this.iconn.getSystemFunctions();
        }
        if (!ServerMessage.useServer) {
            return this.metaData.getSystemFunctions();
        }
        return this.getString(28648);
    }

    public synchronized DataInputStream getTableListStream(String[] type, int nameFormat) throws Exception {
        if (!ServerMessage.useServer || this.iconn != null) {
            StreamResult t;
            OutputStream outstream;
            ResultSet rs;
            block41: {
                String listTable;
                String owner;
                this.getProductName();
                if (this.productName.equalsIgnoreCase("MYSQL") && nameFormat == 1 && this.metaData != null) {
                    ByteArrayInputStream instream = null;
                    try {
                        ByteArrayOutputStream outstream2 = new ByteArrayOutputStream();
                        StreamResult t2 = new StreamResult(this.metaData, type, outstream2, nameFormat);
                        t2.start();
                        t2.join();
                        outstream2.flush();
                        instream = new ByteArrayInputStream(outstream2.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return new DataInputStream(instream);
                }
                rs = null;
                if (this.productName.equalsIgnoreCase("ORACLE") && this.connection != null) {
                    owner = "OWNER";
                    listTable = "ALL_OBJECTS";
                    if (nameFormat == 0) {
                        owner = "''";
                        listTable = "USER_OBJECTS";
                    }
                    String query = "SELECT '', " + owner + ", OBJECT_NAME FROM " + listTable + " WHERE (";
                    for (String element : type) {
                        query = query + "OBJECT_TYPE = '" + element + "'";
                        query = query + " OR ";
                    }
                    query = query.substring(0, query.length() - 4) + ")";
                    Statement stat = this.connection.createStatement();
                    rs = stat.executeQuery(query);
                } else if (this.productName.toUpperCase().equals("MICROSOFT SQL SERVER") && this.connection != null) {
                    if (this.version == null || this.version.equals("")) {
                        String strToGetVersion = "SELECT @@VERSION";
                        Statement stat = this.connection.createStatement();
                        rs = stat.executeQuery(strToGetVersion);
                        String rs_str = "";
                        while (rs.next()) {
                            rs_str = rs.getString(1);
                        }
                        this.version = rs_str.substring(20).trim().substring(0, 4);
                    }
                    owner = "SCHEMA_NAME(schema_id)";
                    if (nameFormat == 0) {
                        owner = "''";
                    }
                    listTable = "SYS.ALL_OBJECTS";
                    String name = "Name";
                    if (this.version.equals("2000")) {
                        owner = "sysusers.name";
                        if (nameFormat == 0) {
                            owner = "''";
                        }
                        listTable = "SYSOBJECTS INNER JOIN sysusers ON sysobjects.uid = sysusers.uid";
                        name = "SYSOBJECTS.Name";
                    }
                    ArrayList<String> types = new ArrayList<String>();
                    if (Arrays.asList(type).contains("SYNONYM")) {
                        types.add("U");
                        types.add("SN");
                    } else {
                        types.add("V");
                    }
                    String query = "SELECT '', " + owner + ", " + name + " FROM " + listTable + " WHERE (";
                    for (String element : types) {
                        query = query + "TYPE = '" + element + "'";
                        query = query + " OR ";
                    }
                    query = query.substring(0, query.length() - 4) + ")";
                    Statement stat = this.connection.createStatement();
                    rs = stat.executeQuery(query);
                } else if (this.iconn != null) {
                    rs = this.iconn.getTables(null, null, null, type);
                } else {
                    try {
                        rs = this.metaData.getTables(null, null, null, type);
                    }
                    catch (Exception e) {
                        if (!e.getClass().getName().equals("com.mysql.jdbc.CommunicationsException")) {
                            throw e;
                        }
                        if (!(this.connection instanceof QbConnection)) break block41;
                        QbConnection qbc = (QbConnection)this.connection;
                        qbc.setBadConnection();
                        qbc.init();
                        this.metaData = qbc.getMetaData();
                        rs = this.metaData.getTables(null, null, null, type);
                    }
                }
            }
            InputStream instream = null;
            int maxStatements = 1;
            if (this.metaData != null) {
                try {
                    maxStatements = this.metaData.getMaxStatements();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.FINEST, "Cannot get maxStatements.", e);
                }
            }
            if (this.iconn != null || maxStatements == 1) {
                try {
                    outstream = new ByteArrayOutputStream();
                    t = new StreamResult(rs, outstream, nameFormat);
                    t.start();
                    t.join();
                    outstream.flush();
                    instream = new ByteArrayInputStream(((ByteArrayOutputStream)outstream).toByteArray());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                outstream = new PipedOutputStream();
                instream = new PipedInputStream((PipedOutputStream)outstream);
                t = new StreamResult(rs, outstream, nameFormat);
                t.start();
            }
            return new DataInputStream(instream);
        }
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(28771);
            this.write(out);
            out.writeInt(type.length);
            for (String element : type) {
                IOUtil.writeString(out, element);
            }
            out.writeBoolean(true);
            out.writeInt(nameFormat);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            if (code != 0) {
                String err = IOUtil.readString(din, true);
                try {
                    din.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new Exception(err);
            }
            return din;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    public Vector getKeyConstraints(int tableFormat, String tableName) throws Exception {
        if (tableName.startsWith("`")) {
            tableName = tableName.replaceAll("`", "");
        }
        Vector<Vector> vect = new Vector<Vector>();
        if (!ServerMessage.useServer || this.iconn != null) {
            try {
                StringTokenizer nameParts = new StringTokenizer(tableName, ".");
                int partCount = nameParts.countTokens();
                ResultSet frs = null;
                ResultSet prs = null;
                DatabaseMetaData md = this.connection.getMetaData();
                if (partCount == 1) {
                    frs = md.getImportedKeys(null, null, tableName);
                    prs = md.getExportedKeys(null, null, tableName);
                } else if (partCount == 2) {
                    String schema = nameParts.nextToken();
                    String table = nameParts.nextToken();
                    frs = md.getImportedKeys(null, schema, table);
                    prs = md.getExportedKeys(null, schema, table);
                } else {
                    String catalog = nameParts.nextToken();
                    String schema = nameParts.nextToken();
                    String table = nameParts.nextToken();
                    frs = md.getImportedKeys(catalog, schema, table);
                    prs = md.getExportedKeys(catalog, schema, table);
                }
                while (frs.next()) {
                    vect.add(this.getRecord(frs, tableFormat));
                }
                while (prs.next()) {
                    vect.add(this.getRecord(prs, tableFormat));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return vect;
        }
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(28950);
            this.write(out);
            out.writeInt(tableFormat);
            IOUtil.writeString(out, tableName);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            if (code != 0) {
                String err = IOUtil.readString(din, true);
                try {
                    din.close();
                }
                catch (Exception table) {
                    // empty catch block
                }
                throw new Exception(err);
            }
            int size = din.readInt();
            Vector foreignKeys = new Vector();
            for (int i = 0; i < size; ++i) {
                Vector<String> v = new Vector<String>();
                String fkTableName = IOUtil.readString(din, true);
                String fkColumnName = IOUtil.readString(din, true);
                String pkTableName = IOUtil.readString(din, true);
                String pkColumnName = IOUtil.readString(din, true);
                v.add(fkTableName);
                v.add(fkColumnName);
                v.add(pkTableName);
                v.add(pkColumnName);
                foreignKeys.add(v);
            }
            return foreignKeys;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    private Vector getRecord(ResultSet rs, int tableFormat) throws Exception {
        Vector<String> keyRecord = new Vector<String>();
        String fkTable = "";
        String pkTable = "";
        if (tableFormat == 2) {
            String pkcat;
            String fkcat = rs.getString("FKTABLE_CAT");
            if (fkcat != null) {
                fkTable = fkTable + fkcat + ".";
            }
            if ((pkcat = rs.getString("PKTABLE_CAT")) != null) {
                pkTable = pkTable + pkcat + ".";
            }
        }
        if (tableFormat >= 1) {
            String pksch;
            String fksch = rs.getString("FKTABLE_SCHEM");
            if (fksch != null) {
                fkTable = fkTable + fksch + ".";
            }
            if ((pksch = rs.getString("PKTABLE_SCHEM")) != null) {
                pkTable = pkTable + pksch + ".";
            }
        }
        fkTable = fkTable + rs.getString("FKTABLE_NAME");
        pkTable = pkTable + rs.getString("PKTABLE_NAME");
        keyRecord.add(fkTable);
        keyRecord.add(rs.getString("FKCOLUMN_NAME"));
        keyRecord.add(pkTable);
        keyRecord.add(rs.getString("PKCOLUMN_NAME"));
        return keyRecord;
    }

    private String addWhereClause(String query) {
        if (query == null) {
            return null;
        }
        int from = query.toLowerCase().indexOf("from");
        if (from > 0) {
            if (query.toLowerCase().indexOf("where", from) > 0) {
                int where = query.toLowerCase().indexOf("where", from);
                String condition = query.substring(where + 5);
                if (condition.indexOf(58) < 0) {
                    if (this.productName.toLowerCase().indexOf("mongodb") >= 0) {
                        return query.substring(0, where) + "Where" + condition;
                    }
                    return query.substring(0, where) + "Where 1=2 AND" + condition;
                }
                try {
                    query = QueryParser.removeComments(query);
                    String newQuery = query.replaceAll(":\\p{Alpha}(\\w)*\\b", "?P?A?R?A?M?");
                    newQuery = new ReplaceBetweenParser(newQuery).getModifiedQuery();
                    DisableParamExpressionsParser replaceParamParser = new DisableParamExpressionsParser(newQuery);
                    newQuery = replaceParamParser.getModifiedQuery();
                    return newQuery;
                }
                catch (JSQLParserException jsqlpe) {
                    LOGGER.log(Level.FINE, "Disable Param Expressions Parser - cannot remove parameters", jsqlpe);
                    query = QueryParser.removeComments(query);
                    query = query.replaceAll(":\\p{Alpha}(\\w)*\\b", "''");
                    String str = query.substring(0, where) + "Where 1=2";
                    if (this.productName.toLowerCase().indexOf("mongodb") >= 0) {
                        str = query.substring(0, where);
                    }
                    if (query.toLowerCase().indexOf("group by", where) > 0) {
                        int group = query.toLowerCase().indexOf("group by", from);
                        return str + " Group By" + query.substring(group + 8);
                    }
                    if (query.endsWith(";")) {
                        return str + ";";
                    }
                    return str;
                }
            }
            if (query.toLowerCase().indexOf("group by", from) > 0) {
                int group = query.toLowerCase().indexOf("group by", from);
                if (this.productName.toLowerCase().indexOf("mongodb") >= 0) {
                    return query.substring(0, group) + "Group By" + query.substring(group + 8);
                }
                return query.substring(0, group) + "Where 1=2 Group By" + query.substring(group + 8);
            }
            if (query.toLowerCase().indexOf("order by", from) > 0) {
                int order = query.toLowerCase().indexOf("order by", from);
                if (this.productName.toLowerCase().indexOf("mongodb") >= 0) {
                    return query.substring(0, order) + "Order By" + query.substring(order + 8);
                }
                return query.substring(0, order) + "Where 1=2 Order By" + query.substring(order + 8);
            }
            if (this.productName.toLowerCase().indexOf("mongodb") >= 0) {
                return query;
            }
            return query + " Where 1=2";
        }
        return query;
    }

    public boolean checkDB2Views() {
        if (this.connection instanceof QbConnection) {
            return ((QbConnection)this.connection).checkDB2Views();
        }
        return true;
    }

    public void cancelRunningQuery() {
        this.cancelRunningQuery = true;
    }

    private class StreamResult
    extends Thread {
        private DatabaseMetaData dbmd;
        private String[] type;
        private OutputStream outstream;
        private ResultSet resultset;
        private int format = 0;

        public StreamResult(ResultSet r, OutputStream s, int f) {
            this.resultset = r;
            this.outstream = s;
            this.format = f == 1 || f == 2 ? f : 0;
        }

        public StreamResult(DatabaseMetaData dbMeta, String[] tableType, OutputStream s, int format) {
            this.dbmd = dbMeta;
            this.outstream = s;
            this.format = format == 1 || format == 2 ? format : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.resultset == null && this.dbmd == null || this.outstream == null) {
                return;
            }
            int count = 0;
            DataOutputStream out = new DataOutputStream(this.outstream);
            try {
                if (this.dbmd != null) {
                    if (ReadDatabase.this.metaData.getConnection().getCatalog() != "") {
                        ResultSet cateRS = ReadDatabase.this.metaData.getTables(ReadDatabase.this.metaData.getConnection().getCatalog(), null, null, this.type);
                        while (cateRS.next()) {
                            IOUtil.writeString(out, "`" + ReadDatabase.this.metaData.getConnection().getCatalog() + "`.`" + cateRS.getString(3) + "`");
                        }
                    } else {
                        Vector<String> catelogList = new Vector<String>();
                        ResultSet metaRS = ReadDatabase.this.metaData.getCatalogs();
                        while (metaRS.next()) {
                            catelogList.add(metaRS.getString(1));
                        }
                        for (int i = 0; i < catelogList.size(); ++i) {
                            String catelogName = (String)catelogList.elementAt(i);
                            ResultSet cateRS = ReadDatabase.this.metaData.getTables(catelogName, null, null, this.type);
                            while (cateRS.next()) {
                                IOUtil.writeString(out, "`" + catelogName + "`.`" + cateRS.getString(3) + "`");
                            }
                        }
                    }
                } else {
                    while (this.resultset.next()) {
                        ++count;
                        String p1 = this.resultset.getString(1);
                        String p2 = this.resultset.getString(2);
                        String p3 = this.resultset.getString(3);
                        if (ReadDatabase.this.productName.equalsIgnoreCase("Advantage Database Server") && (p3.toLowerCase().endsWith(".adt") || p3.toLowerCase().endsWith(".dbf"))) {
                            p3 = p3.substring(0, p3.length() - 4);
                        }
                        int dbType = QueryBuilder.mapDatabaseType((String)ReadDatabase.this.productName);
                        p1 = QueryBuilder.formatField((int)dbType, (String)p1);
                        p2 = QueryBuilder.formatField((int)dbType, (String)p2);
                        p3 = QueryBuilder.formatField((int)dbType, (String)p3);
                        if (this.format > 0 && p2 != null) {
                            p3 = p2 + "." + p3;
                            if (this.format > 1 && p1 != null) {
                                p3 = p1 + "." + p3;
                            }
                        }
                        IOUtil.writeString(out, p3);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    this.resultset.close();
                    this.outstream.close();
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

