/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.AvailColumn;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.IOUtil;

public class ReadSFparamMeta {
    public static Vector getMeta(SalesForceQueryFileInfo sfQueryInfo, String paramName) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadSFparamMeta.sendMessage(socket, sfQueryInfo, paramName);
        return ReadSFparamMeta.receiveReply(socket);
    }

    private static void sendMessage(IConnection socket, SalesForceQueryFileInfo sfQueryInfo, String paramName) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(11003);
        sfQueryInfo.write(dout);
        IOUtil.writeStr(dout, sfQueryInfo.getServerUrl());
        IOUtil.writeStr(dout, sfQueryInfo.getSessionId());
        IOUtil.writeString(dout, paramName);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static Vector receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int nAvailColumn = dstream.readInt();
            Vector<AvailColumn> output = new Vector<AvailColumn>();
            for (int i = 0; i < nAvailColumn; ++i) {
                AvailColumn value = AvailColumn.read(dstream);
                output.addElement(value);
            }
            dstream.close();
            socket.close();
            return output;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }
}

