/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.formula;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import quadbase.common.formula.DateFormulaParser;
import quadbase.common.formula.Operand;
import quadbase.common.formula.ParseException;
import quadbase.common.util.internal.IOUtil;

public class Formula
extends Operand {
    String name;
    String text;
    Operand formula;

    public Formula() {
    }

    public Formula(String name) {
        this.name = name;
    }

    public Formula(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Operand getFormula() {
        return this.formula;
    }

    public void setFormula(Operand op) {
        this.formula = op;
    }

    @Override
    public Object getValue() throws Exception {
        if (this.formula != null) {
            Object object = this.formula.getValue();
            this.dataType = this.formula.getDataType();
            return object;
        }
        if (this.text != null) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                this.formula = parser.parse();
                Object obj = this.formula.getValue();
                this.dataType = this.formula.getDataType();
                return obj;
            }
            catch (Exception e) {
                this.dataType = 1;
                return this.text;
            }
        }
        return null;
    }

    public boolean equals(Formula f) {
        if (this.text == null) {
            return f.getText() == null;
        }
        return this.text.equals(f.getText());
    }

    public void write(DataOutput out) throws IOException {
        IOUtil.writeStr(out, this.text);
    }

    public void read(DataInput in) throws IOException {
        this.text = IOUtil.readStr(in);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
        try {
            this.formula = parser.parse();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return this.text;
    }

    @Override
    public int getDataType() {
        if (this.dataType == -1) {
            try {
                this.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dataType;
    }
}

