/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.HttpsIO;

public class HttpConnection
implements IConnection {
    URL url;
    URLConnection conn;
    int port;
    Vector hostName;
    InetAddress addr;
    boolean bConnected = false;
    InputStream in = null;
    OutputStream out = null;

    public HttpConnection(String url) throws IOException {
        this(new URL(url));
    }

    public HttpConnection(URL url) throws IOException {
        this.url = url;
        this.init();
    }

    public HttpConnection(String host, int port) throws IOException {
        this.url = new URL("http", host, port, "/");
        this.port = port;
        this.init();
    }

    public HttpConnection(InetAddress host, int port) throws IOException {
        this.port = port;
        this.url = new URL("http", host.getHostAddress(), port, "/");
        this.addr = host;
        this.init();
    }

    public HttpConnection(InetAddress host, int port, Vector hostName) throws IOException {
        this.port = port;
        this.hostName = hostName;
        this.url = new URL("http", host.getHostAddress(), port, "/");
        this.addr = host;
        this.init();
    }

    private void tryHostName(int i) throws IOException {
        if (this.hostName == null) {
            return;
        }
        this.url = new URL("http", (String)this.hostName.elementAt(i), this.port, "/");
        this.init();
    }

    private void init() throws IOException {
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            try {
                this.conn = HttpsIO.openHttpsConnection(this.url);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Cannot open HTTPS connection.\n" + e.getMessage());
            }
        } else {
            this.conn = this.url.openConnection();
        }
        if (this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).setRequestMethod("POST");
        }
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("Content-type", "application/octet-stream");
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = this.conn.getInputStream();
        }
        return this.in;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        block8: {
            try {
                if (!this.bConnected) {
                    this.conn.connect();
                    this.bConnected = true;
                }
            }
            catch (Exception ex) {
                if (this.hostName == null) {
                    throw new IOException(ex.toString());
                }
                for (int i = 0; i < this.hostName.size(); ++i) {
                    try {
                        if (this.bConnected) break;
                        this.tryHostName(i);
                        this.conn.connect();
                        this.bConnected = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (this.bConnected) break block8;
                throw new IOException(ex.toString());
            }
        }
        if (this.out == null) {
            this.out = this.conn.getOutputStream();
        }
        return this.out;
    }

    @Override
    public void close() throws IOException {
        if (this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).disconnect();
        }
    }

    @Override
    public String getPeerAddress() {
        if (this.addr != null) {
            return this.addr.getHostAddress();
        }
        return "";
    }

    @Override
    public String getPeerHost() {
        return this.url.getHost();
    }

    @Override
    public void setContentLength(int i) {
        this.conn.setRequestProperty("Content-length", String.valueOf(i));
    }
}

