/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.IOUtil;

public class ServletConnection
implements IConnection {
    URL url;
    URLConnection conn;
    int port;
    Vector hostName;
    InetAddress addr;
    String userName = null;
    String clientAddress = null;
    OutputStream out = null;
    InputStream in;

    public ServletConnection(String url) throws IOException {
        this(new URL(url));
    }

    public ServletConnection(URL url) throws IOException {
        this.url = url;
        this.init();
    }

    public ServletConnection(String host, int port) throws IOException {
        this.url = new URL("http", host, port, "/");
        this.port = port;
        this.init();
    }

    public ServletConnection(String host, int port, String clientAddr) throws IOException {
        this.url = new URL("http", host, port, "/");
        this.port = port;
        this.clientAddress = clientAddr;
        this.init();
    }

    public ServletConnection(InetAddress host, int port) throws IOException {
        this.port = port;
        this.url = new URL("http", host.getHostAddress(), port, "/");
        this.addr = host;
        this.init();
    }

    public ServletConnection(InetAddress host, int port, Vector hostName) throws IOException {
        this.port = port;
        this.hostName = hostName;
        this.url = new URL("http", host.getHostAddress(), port, "/");
        this.addr = host;
        this.init();
    }

    private void init() throws IOException {
        this.url = new URL(this.url, ServerMessage.getServletContext() + "/ESMMessageServlet");
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            try {
                this.conn = HttpsIO.openHttpsConnection(this.url);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Cannot open HTTPS connection.\n" + e.getMessage());
            }
        } else {
            this.conn = this.url.openConnection();
        }
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("Content-type", "application/octet-stream");
        if (ServerMessage.getExtraHeaderName() != null && ServerMessage.getExtraHeaderValue() != null) {
            this.conn.setRequestProperty(ServerMessage.getExtraHeaderName(), ServerMessage.getExtraHeaderValue());
        }
        this.userName = ServerMessage.getOrgUserName();
        if (this.clientAddress == null) {
            this.clientAddress = ServletConnection.getHostAddress();
            if (ServerMessage.getOrgUserToken() != null) {
                this.clientAddress = this.clientAddress + "?OrgUserName=" + this.userName + "&OrgUserToken=" + ServerMessage.getOrgUserToken();
            }
        }
        this.out = this.conn.getOutputStream();
        DataOutputStream dout = new DataOutputStream(this.out);
        IOUtil.writeString(dout, this.userName);
        IOUtil.writeString(dout, this.clientAddress);
    }

    public static final String getHostAddress() {
        String ipaddress = null;
        try {
            ipaddress = InetAddress.getLocalHost().getHostAddress();
            if (ipaddress != null) {
                return ipaddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ipaddress = InetAddress.getLocalHost().getHostAddress();
            if (ipaddress != null) {
                return ipaddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setUserName(String uName) {
        this.userName = uName;
    }

    public void setClientAddress(String address) {
        this.clientAddress = address;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        try {
            this.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.connect();
        this.in = this.conn.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(this.in);
        return bis;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        CloseUtils.close(this.in);
        if (this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).disconnect();
        }
    }

    @Override
    public String getPeerAddress() {
        if (this.addr != null) {
            return this.addr.getHostAddress();
        }
        if (this.url != null) {
            this.url.toString();
        }
        return "";
    }

    @Override
    public String getPeerHost() {
        return this.url.getHost();
    }

    @Override
    public void setContentLength(int i) {
    }
}

